/******************************************************************************/
/**
* \file    vd_rvc_tclGraphics_DynGuideline_Config.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    :
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/

#ifndef _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_CONFIG_H_
#define _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_CONFIG_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#ifndef    VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define OSAL_S_IMPORT_INTERFACE_GENERIC
   #include "osal_if.h"
#endif

#ifndef    _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_TYPES_H_
   #include "vd_rvc_tclGraphics_DynGuideline_Types.h"
#endif

/*******************************************************************************
                        Defines
*******************************************************************************/
  
// values for the possible tire angle reference points
#define TIRE_ANGLE_REFERS_TO_AXLE_CENTER   0
#define TIRE_ANGLE_REFERS_TO_OUTER_TIRE    1
#define TIRE_ANGLE_REFERS_TO_INNER_TIRE    2

// curve indices for the RGB colors array in the configuration
#define DYN_GUIDELINE_COLORIDX_STAT_NEAR   0
#define DYN_GUIDELINE_COLORIDX_STAT_MID    1
#define DYN_GUIDELINE_COLORIDX_STAT_FAR    2
#define DYN_GUIDELINE_COLORIDX_STAT_CENT   3
#define DYN_GUIDELINE_COLORIDX_DYN         4

// curve indices for the line width array in the configuration
#define DYN_GUIDELINE_LWIDTH_IDX_STAT      0
#define DYN_GUIDELINE_LWIDTH_IDX_DYN       1
#define DYN_GUIDELINE_LWIDTH_IDX_CENT      2


/*******************************************************************************
                        Class declarations
*******************************************************************************/

class vd_rvc_tclGraphics_DynGuideline_Config
{
   public:
      // constructor / desctructor
      vd_rvc_tclGraphics_DynGuideline_Config(tVoid);
      ~vd_rvc_tclGraphics_DynGuideline_Config();
      // config and tuning string evaluators
      static tBool bEvalConfigString(const vd_rvc_tstKdsVehicleConfig * pstKdsVehConfig, vd_rvc_tstVehicleParams * pstVehParams);
      static tBool bEvalCalibString (const tU8 * pu8CalibString,                         vd_rvc_tstVehicleParams * pstVehParams);
      static tBool bSetPredefConfig (const char * sPredefCfgName,                        vd_rvc_tstVehicleParams * pstVehParams);
      // used for configuration adjustment screen support:
      static tBool bFinalizeVehicleConfig(vd_rvc_tstVehicleParams * pstVehParams);

      // debug output
      static tVoid vDebugVehicleParams(const vd_rvc_tstVehicleParams * pstVehParams, tBool bValid);
      static tVoid vDebugTuningParams (const vd_rvc_tstVehicleParams * pstVehParams, tBool bValid);
      
   private:
      // sub-evaluators
      static tVoid vEvalLineWidthParams   (vd_rvc_tstLineWidthDef   * pstLineWdthDef);
      static tVoid vEvalTuningOffsetParams(vd_rvc_tstTuneOffsParams * pstTuningOffs,  const tU8 * pu8ConfigBytes, tBool bInvertSignOfDx);
};

#endif
