/******************************************************************************/
/**
* \file    vd_rvc_tclGraphics_DynGuideline_Cameras.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2014 Robert Bosch GmbH, Hildesheim
* \remark  Author    :
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/

#ifndef _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_CAMERAS_H_
#define _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_CAMERAS_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#ifndef    VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define OSAL_S_IMPORT_INTERFACE_GENERIC
   #include "osal_if.h"
#endif


/*******************************************************************************
                        Defines
*******************************************************************************/

#define NUM_ARRAY_ELEMENTS(x)  (sizeof(x)/sizeof((x)[0]))

// #define DYNGL_SUPPORT_CAM_SONY2400_NISSAN_V109
// #define DYNGL_SUPPORT_CAM_MVC_SEMCO


/*******************************************************************************
                        Types and data
*******************************************************************************/

enum vd_rvc_tenCameraKdsId
{
   // named symbols for the camera ID values which are stored in KDS
   VD_RVC_CAMERA_KDS_ID_SONY_2400S_NISSAN     = 0,  // vFOV = 92
   VD_RVC_CAMERA_KDS_ID_SONY_2200S            = 1,
   VD_RVC_CAMERA_KDS_ID_PANASONIC             = 2,
   VD_RVC_CAMERA_KDS_ID_SONY_2400S_RENAULT    = 3,
   VD_RVC_CAMERA_KDS_ID_SEMCO_LOGO            = 4,
   VD_RVC_CAMERA_KDS_ID_SEMCO_GENERIC_VFOV109 = 5,
   VD_RVC_CAMERA_KDS_ID_SEMCO_L47             = 6,
   VD_RVC_CAMERA_KDS_ID_SONY_2500S            = 7,
   VD_RVC_CAMERA_KDS_ID_WHETRON               = 8,
   VD_RVC_CAMERA_KDS_ID_CLARION               = 9,  // completely unknown so far, only that this ID got mentioned in the Diag spec ...
   #ifdef DYNGL_SUPPORT_CAM_MVC_SEMCO
   VD_RVC_CAMERA_KDS_ID_MVC_SEMCO             = 10,
   #endif
   
   #ifdef DYNGL_SUPPORT_CAM_SONY2400_NISSAN_V109
   VD_RVC_CAMERA_KDS_ID_SONY_2400S_NISSAN_VFOV109 = 100, // vFOV = 109 , used (so far) only in H60A; ID value is currently only a placeholder
   #endif
   
   // special case: camera with EOL configurable parameters
   VD_RVC_CAMERA_KDS_ID_EOL_CONFIGURABLE      = 200,
   // other IDs for internal purposes
   VD_RVC_CAMERA_KDS_ID_DUMMY_CAMERA          = 254,
   VD_RVC_CAMERA_KDS_ID_NONE                  = 255
};


struct vd_rvc_tstCameraParams
{
   // focal length (in mm) of the lens
   tDouble dFocLen;

   // linear size (in mm) of the whole (used part) of the camera sensor
   tDouble dSensorXsize;
   tDouble dSensorYsize;   

   // offset (in m) of the optical axis relative to the center of the (used part) of the camera sensor (normally (0,0))
   tDouble dOptAxisXoffs;  // positive values = right of sensor center if looking at sensor from behind
   tDouble dOptAxisYoffs;  // positive values = below sensor center if looking at sensor from behind
   
   // flag to indicate whether or not this is a default/dummy configuration (<=> drawing of warning indicators)
   tBool   bIsADummyCamera;
};


class vd_rvc_tclCamera
{
   private:
      // camera ID value as stored in KDS
      vd_rvc_tenCameraKdsId          m_enKdsId;
      const vd_rvc_tstCameraParams * m_pstCamParams;
   
   public:
      vd_rvc_tclCamera(tVoid)                                                                       : m_enKdsId(VD_RVC_CAMERA_KDS_ID_NONE), m_pstCamParams(NULL)         {}
      vd_rvc_tclCamera(vd_rvc_tenCameraKdsId enKdsId, const vd_rvc_tstCameraParams * pstCamParams)  : m_enKdsId(enKdsId),                   m_pstCamParams(pstCamParams) {}
      virtual ~vd_rvc_tclCamera() { m_pstCamParams = NULL; }
      
      tVoid                          vSetKdsId(vd_rvc_tenCameraKdsId enKdsId)                     { m_enKdsId = enKdsId; }
      vd_rvc_tenCameraKdsId          enGetKdsId(tVoid) const                                      { return m_enKdsId; }
      
      tVoid                          vSetCameraParams(const vd_rvc_tstCameraParams *pstCamParams) { m_pstCamParams = pstCamParams; }
      const vd_rvc_tstCameraParams * pstGetCameraParams(tVoid) const                              { return m_pstCamParams; }

      tBool                          bIsADummyCamera(tVoid) const                                 { return (m_pstCamParams) ? m_pstCamParams->bIsADummyCamera : true; }
      tBool                          bCamParamsValid(tVoid) const;
      
      virtual tDouble dGetMaxRNormSquare(tVoid) const                         = 0;
      virtual tDouble dCalcRadialDistortionFactor(tDouble dRNormSquare) const = 0;
};


class vd_rvc_tclCameraCollection
{
   private:
      static const vd_rvc_tclCamera * const m_apoSelectableCameras[];
      static const tU32                     m_u32NumSelectableCameras;
      
   public:
      // no non-static members => (currently) no contructor / destructor needed
      
      static const vd_rvc_tclCamera * poSelectCamera(tU8 u8CameraType);
      static const vd_rvc_tclCamera * poGetDummyCamera(tVoid);

      static tBool                    bSetParamsOfConfigurableCamera(const tU8 * pu8EolCfgString);
};



#endif
