/******************************************************************************/
/**
* \file    vd_rvc_tclGraphics_DynGuideline_CamPoint.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2014 Robert Bosch GmbH, Hildesheim
* \remark  Author    :
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/

#ifndef _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_CAMPOINT_H_
#define _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_CAMPOINT_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#ifndef    VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_OSAL_IF_IMPORTED
   #define OSAL_S_IMPORT_INTERFACE_GENERIC
   #include "osal_if.h"
#endif

#ifndef    _VD_RVC_TCL_GRAPHICS_DYNGUIDELINE_UTIL_H_
   #include "vd_rvc_tclGraphics_DynGuideline_Util.h"
#endif
   
/*******************************************************************************
                        Defines 
*******************************************************************************/

// readable/searchable names for the most common values of the parameter dTuneSide of method vSetGroundCoords() (though any value in the range -1...+1 is allowed)
#define DYN_GUIDELINE_TUNE_SIDE_LEFT   (+1.0)
#define DYN_GUIDELINE_TUNE_SIDE_CENT   ( 0.0)
#define DYN_GUIDELINE_TUNE_SIDE_RIGHT  (-1.0)
#define DYN_GUIDELINE_TUNE_SIDE_NONE   (1E10)  // means: "don't tune coordinates"

/*******************************************************************************
                        Class declaration
*******************************************************************************/

/*** forward declarations ***/

struct vd_rvc_tstVehicleParams;
struct vd_rvc_tstCaptureAreaParams;
struct vd_rvc_tstImageAreaParams;
class  vd_rvc_tclCamera;


/*** actual class declaration ***/

class vd_rvc_tclCamPoint
{
   /********** properties **********/
   
   private:
      static const vd_rvc_tclCamera * m_poCamera;
      static vd_rvc_t3Vector          m_tCamMountOffs;
      static tDouble                  m_dCamYaw;
      static tDouble                  m_dCamPitch;
      static tDouble                  m_dCamRoll;
      static vd_rvc_tcl3x3Matrix      m_oGrnd2CamTransform;
      static vd_rvc_t2Vector          m_tCamOptAxisOffs;
      static vd_rvc_tcl2x2Matrix      m_oCamCoo2VideoPixScale;
      static vd_rvc_t2Vector          m_tVideoCaptureCenterOffs;
      static vd_rvc_tcl2x2Matrix      m_oVideoPix2ImgPixScale;
      static tDouble                  m_dMaxR2norm;
      static vd_rvc_t2Vector          m_tOutImgCenter;
   
   public:
      
      // coordinates in ground coordinate system (cm)
      vd_rvc_t3Vector   m_tGroundCoo;
      
      // "raw" coordinates in camera coordinate system (cm)
      vd_rvc_t3Vector   m_tRawCamCoo;
      
      // radial distortion (and optical axis offset) corrected sensor coordinates (mm)
      vd_rvc_t2Vector   m_tSensCoo;
      
      // unclipped image coordinates (pix)
      vd_rvc_t2IntVect  m_tRawImgCoo;
      tBool             m_bRawImgCooValid;
      
      // clipped image coordinates == plot coordinates (pix)
      vd_rvc_t2IntVect  m_tPlotCoo;

   /********** methods **********/
   
      vd_rvc_tclCamPoint(tVoid);
      ~vd_rvc_tclCamPoint();
      
      static tVoid vSetConfig(const vd_rvc_tstVehicleParams   * ptVehParams, const vd_rvc_tstCaptureAreaParams * ptCaptureParams,
                              const vd_rvc_tstImageAreaParams * ptImgParams, const vd_rvc_tclCamera * poCamera);
      static tVoid vSetCamTuningAngles(tDouble dCamTuneYaw, tDouble dCamTunePitch, tDouble dCamTuneRoll);
      
      tVoid        vSetGroundCoords(const vd_rvc_t3Vector & oGrndCoo  , tDouble dTuneSide);
      inline tVoid vSetGroundCoords(const vd_rvc_t2Vector & oGrndXyCoo, tDouble dTuneSide) { vSetGroundCoords(vd_rvc_t3Vector(oGrndXyCoo), dTuneSide); }
      inline tVoid vSetGroundCoords(tDouble dX, tDouble dY, tDouble dZ, tDouble dTuneSide) { vSetGroundCoords(vd_rvc_t3Vector(dX,dY,dZ)  , dTuneSide); }
      
      tBool bEnsureMinimumYgroundOnWholePathTo(vd_rvc_tclCamPoint * poEnd, tDouble dYMin);
      tBool bCalcPlotCooForPathTo(vd_rvc_tclCamPoint * poEnd);
      
   private:
      tVoid vSetCamCoords(tDouble dX, tDouble dY, tDouble dZ);
      tVoid vShiftToYgroundAlongPathTo(vd_rvc_tclCamPoint * poEnd, tDouble dYdest);
      tBool bEnsurePositiveZcamOnWholePathTo(vd_rvc_tclCamPoint * poEnd);
      tVoid vShiftToPositiveZcamAlongPathTo(vd_rvc_tclCamPoint * poEnd);
      tVoid vCalcRawImgCoords(tVoid);
};


#endif
