/******************************************************************************/
/**
* \file    dispvidctrl_tclPersistentData.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_PERSISTENT_DATA_H_
#define _DISPVIDCTRL_TCL_PERSISTENT_DATA_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_AppMain.h"

#include "dispvidmgr_dp_if.h"
/*******************************************************************************
                        Defines
*******************************************************************************/
//typedef struct
//{
//   tU32
//   tU32
//   tU32
//   tU32
//}TPersistentData_VideoSettings_Night;

class TDisplayWindowLayout
{
public:
   tU16 u16xOffset;
   tU16 u16yOffset;
   tU16 u16Width;
   tU16 u16Height;

   TDisplayWindowLayout& operator= (const TDisplayWindowLayout& obj) {
      if (&obj != this) {
         u16xOffset = obj.u16xOffset;
         u16yOffset = obj.u16yOffset;
         u16Width   = obj.u16Width;
         u16Height  = obj.u16Height;
      }
      return *this;
   }
};

typedef struct 
{
   tBool bScalingActive;
   tBool bCroppingActive;
   TDisplayWindowLayout tVideoSource;
   TDisplayWindowLayout tVideoDestination;
   TDisplayWindowLayout tVideoSettingsSource;
   TDisplayWindowLayout tVideoSettingsDestination;
} stVideoResizeParameters;

extern stVideoResizeParameters mapCameraTypeVideoParam[IDX_MAX];
extern stVideoResizeParameters mapCameraTypeGraphicParam[IDX_MAX];

/*******************************************************************************
   Class
*******************************************************************************/
class I_dispvidctrl_tclVideoPlayer;
class dispvidctrl_tclPersistentData : public dispvidctrl_tclBaseIf
{
   private: 
      TEarlyNorConfiguration _tEarlyNor;
      tBool m_bValueChanged;
      TEarlyNorForceConfiguration _tEarlyNorForce;
      tBool m_bForceValueChanged;
      
      tU8 m_u8VideoResizeParamIndex;
      
      tU8   u8GetVideoParamIndex(const TConfiguration* pStConfigurationValues);

      I_dispvidctrl_tclVideoPlayer* m_poClient_VideoPlayer;
      
   public:

      dispvidctrl_tclPersistentData(const dispvidctrl_tclAppMain* poMainAppl);
      virtual ~dispvidctrl_tclPersistentData();

      virtual const tChar* getName() const { return ""; };
      virtual const tChar* getIfName() const { return "dispvidctrl_tclPersistentData"; };

      virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
      virtual tVoid vHandleTraceMessage(const tUChar* puchData);
      virtual tVoid vGetReferences();
      virtual tVoid vStartCommunication();
      virtual tVoid vTraceInfo();
      virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);

      tVoid vUpdateConfiguration(const TConfiguration* pStConfigurationValues);

      tBool bSetEarlyNorConfigurationPersistent(tVoid);

      tVoid vSet_BlackLevel_Day(tU32 u32NewValue);
      tVoid vSet_BlackLevel_Night(tU32 u32NewValue);
      tVoid vSet_Brightness_Day(tU32 u32NewValue);
      tVoid vSet_Brightness_Night(tU32 u32NewValue);
      tVoid vSet_Colour_Day(tU32 u32NewValue);
      tVoid vSet_Colour_Night(tU32 u32NewValue);
      tVoid vSet_Contrast_Day(tU32 u32NewValue);
      tVoid vSet_Contrast_Night(tU32 u32NewValue);
      tVoid vSet_Hue_Day(tU32 u32NewValue);
      tVoid vSet_Hue_Night(tU32 u32NewValue);
      tVoid vSet_BacklightDimming_Day(tU32 u32NewValue);
      tVoid vSet_BacklightDimming_Night(tU32 u32NewValue);

      tVoid vSet_SPMAutoMode(tU32 u32NewValue);
      tVoid vSet_RVCLowSpeedThreshold(tU32 u32NewValue);
      tVoid vSet_RVCHighSpeedThreshold(tU32 u32NewValue);
      tVoid vSet_RVCReverseOffGuardTime(tU32 u32NewValue);
      tVoid vSet_WarningTextLanguage(tU32 u32NewValue);
      tVoid vSet_WarningTextVisibility(tU32 u32NewValue);
      tVoid vSet_WarningTextBackground(tU32 u32NewValue);
      tVoid vSet_GuidelineCameraType(tU32 u32NewValue); // RVCLensParameterSet
      tVoid vSet_GuidelineVehicleParameter(const tU8* GuidelineVehicleParameter);  //array with 80 bytes
      tVoid vSet_GuideLineVisibilityMode(tU32 u32NewValue);
      tVoid vSet_CameraSystemType(tU32 u32NewValue); // RVC, AVM ...
      tVoid vSet_Language_Avm(tU32 u32NewValue);
      tVoid vSet_Brand(tU32 u32NewValue);
      tVoid vSet_VehicleType(tU16 u16NewValue);
      tVoid vSet_OpeningAnimation(tU32 u32NewValue);
      tVoid vSet_DisplayAspectRatio(tU32 u32NewValue);
      tVoid vSet_DestinationRegion(tU32 u32NewValue);
      tVoid vSet_CameraConnectionType(tU32 u32NewValue);
      tVoid vSet_SteeringPosition(tU32 u32NewValue);
      tVoid vSet_GuidelineVisibility(tBool bNewValue);
      tVoid vSet_CameraWidth(tU16 u16NewValue);
      tVoid vSet_CameraHeight(tU16 u16NewValue);
      tVoid vSet_CameraXOffset(tU16 u16NewValue);
      tVoid vSet_CameraYOffset(tU16 u16NewValue);
      tVoid vSet_DisplayType(tU8 u8NewValue);
      tVoid vSet_Display1Width(tU16 u16NewValue);
      tVoid vSet_Display1Height(tU16 u16NewValue);
      tVoid vSet_Display1XOffset(tU16 u16NewValue);
      tVoid vSet_Display1YOffset(tU16 u16NewValue);
      tVoid vSet_Display2Width(tU16 u16NewValue);
      tVoid vSet_Display2Height(tU16 u16NewValue);
      tVoid vSet_Display2XOffset(tU16 u16NewValue);
      tVoid vSet_Display2YOffset(tU16 u16NewValue);
      tVoid vSet_DisplayOrientation(tU8 u8NewValue);
      tVoid vSet_VCANDiversity(tU8 u8NewValue);
      tVoid vSet_CameraImageMirror(tU8 u8NewValue);
      tVoid vSet_WelcomeSequence(tU8 u8NewValue);
      tVoid vSet_Resolution(const tU8* u8NewValue);
      tVoid vSet_DisplayOrder(const tU8* u8NewValue);
      tVoid vSet_FlushDesignConfigFile(const tU8* u8NewValue);
      tVoid vSet_Cropping_Up(tU8 u8NewValue);
      tVoid vSet_Cropping_Down(tU8 u8NewValue);
      tVoid vSet_Cropping_Left(tU8 u8NewValue);
      tVoid vSet_Cropping_Right(tU8 u8NewValue);
      tVoid vSet_Cropping_Set(tBool bNewValue);
      tVoid vSet_SourceWidth(tU16& u16Value);
      tVoid vSet_SourceHeight(tU16& u16Value);
      tVoid vSet_SourceXOffset(tU16& u16Value);
      tVoid vSet_SourceYOffset(tU16& u16Value);
      tVoid vSet_DestinationWidth(tU16& u16Value);
      tVoid vSet_DestinationHeight(tU16& u16Value);
      tVoid vSet_DestinationXOffset(tU16& u16Value);
      tVoid vSet_DestinationYOffset(tU16& u16Value);

      //tVoid vSet_VideoSettings_Night(const TPersistentData_VideoSettings_Night* pStPersistenData_VideoSettings_Night);
      //tVoid vSet_VideoSettings_Day(const TPersistentData_VideoSettings_Day* pStPersistenData_VideoSettings_Day);

      tBool bGetPersistent_BlackLevel_Day(tU32& u32Value) const;
      tBool bGetPersistent_BlackLevel_Night(tU32& u32Value) const;
      tBool bGetPersistent_Brightness_Day(tU32& u32Value) const;
      tBool bGetPersistent_Brightness_Night(tU32& u32Value) const;
      tBool bGetPersistent_Colour_Day(tU32& u32Value) const;
      tBool bGetPersistent_Colour_Night(tU32& u32Value) const;
      tBool bGetPersistent_Contrast_Day(tU32& u32Value) const;
      tBool bGetPersistent_Contrast_Night(tU32& u32Value) const;
      tBool bGetPersistent_Hue_Day(tU32& u32Value) const;
      tBool bGetPersistent_Hue_Night(tU32& u32Value) const;
      tBool bGetPersistent_BacklightDimming_Day(tU32& u32Value) const;
      tBool bGetPersistent_BacklightDimming_Night(tU32& u32Value) const;

      tBool bGetPersistent_SPMAutoMode(tU32& u32Value) const;
      tBool bGetPersistent_RVCLowSpeedThreshold(tU32& u32Value) const;
      tBool bGetPersistent_RVCHighSpeedThreshold(tU32& u32Value) const;
      tBool bGetPersistent_RVCReverseOffGuardTime(tU32& u32Value) const;
      tBool bGetPersistent_WarningTextLanguage(tU32& u32Value) const;
      tBool bGetPersistent_WarningTextVisibility(tU32& u32Value) const;
      tBool bGetPersistent_WarningTextBackground(tU32& u32Value) const;
      tBool bGetPersistent_GuidelineCameraType(tU32& u32Value) const; // RVCLensParameterSet
      tBool bGetPersistent_GuidelineVehicleParameter(tU8* GuidelineVehicleParameter) const;  //array with 80 bytes
      tBool bGetPersistent_GuideLineVisibilityMode(tU32& u32Value) const;
      tBool bGetPersistent_CameraSystemType(tU32& u32Value) const; // RVC, AVM ...
      tBool bGetPersistent_Language_Avm(tU32& u32Value) const;
      tBool bGetPersistent_Brand(tU32& u32Value) const;
      tBool bGetPersistent_VehicleType(tU16& u16Value) const;
      tBool bGetPersistent_OpeningAnimation(tU32& u32Value) const;
      tBool bGetPersistent_DisplayAspectRatio(tU32& u32Value) const;
      tBool bGetPersistent_DestinationRegion(tU32& u32Value) const;
      tBool bGetPersistent_CameraConnectionType(tU32& u32Value) const;
      tBool bGetPersistent_SteeringPosition(tU32& u32Value) const;
      tBool bGetPersistent_CameraWidth(tU16& u16Value) const;
      tBool bGetPersistent_CameraHeight(tU16& u16Value) const;
      tBool bGetPersistent_CameraXOffset(tU16& u16Value) const;
      tBool bGetPersistent_CameraYOffset(tU16& u16Value) const;
      tBool bGetPersistent_DisplayType(tU8& u8Value) const;
      tBool bGetPersistent_Display1Width(tU16& u16Value) const;
      tBool bGetPersistent_Display1Height(tU16& u16Value) const;
      tBool bGetPersistent_Display1XOffset(tU16& u16Value) const;
      tBool bGetPersistent_Display1YOffset(tU16& u16Value) const;
      tBool bGetPersistent_Display2Width(tU16& u16Value) const;
      tBool bGetPersistent_Display2Height(tU16& u16Value) const;
      tBool bGetPersistent_Display2XOffset(tU16& u16Value) const;
      tBool bGetPersistent_Display2YOffset(tU16& u16Value) const;
      tBool bGetPersistent_DisplayOrientation(tU8& u8Value) const;
      
      tBool bGetPersistent_SourceWidth(tU16& u16Value) const;
      tBool bGetPersistent_SourceHeight(tU16& u16Value) const;
      tBool bGetPersistent_SourceXOffset(tU16& u16Value) const;
      tBool bGetPersistent_SourceYOffset(tU16& u16Value) const;
      tBool bGetPersistent_DestinationWidth(tU16& u16Value) const;
      tBool bGetPersistent_DestinationHeight(tU16& u16Value) const;
      tBool bGetPersistent_DestinationXOffset(tU16& u16Value) const;
      tBool bGetPersistent_DestinationYOffset(tU16& u16Value) const;
      
      tBool bGetPersistent_VCANDiversity(tU8& u8Value) const;
      tBool bGetPersistent_CameraImageMirror(tU8& u8Value) const;
      tBool bGetPersistent_WelcomeSequence(tU8& u8Value) const;
      tBool bGetPersistent_Resolution(tU8* Resolution) const;
      tBool bGetPersistent_DisplayOrder(tU8* DisplayOrder) const;
      tBool bGetPersistent_FlushDesignConfigFile(tU8* FlushDesignConfigFile) const;
      tBool bGetPersistent_Cropping_Up(tU8& u8Value) const;
      tBool bGetPersistent_Cropping_Down(tU8& u8Value) const;
      tBool bGetPersistent_Cropping_Left(tU8& u8Value) const;
      tBool bGetPersistent_Cropping_Right(tU8& u8Value) const;
      tBool bGetPersistent_Cropping_Set(tU8& u8Value) const;
      
      tBool bGet_VideoResizeIndex(tU8& u8Value) const;
};

#endif

