/******************************************************************************/
/**
* \file    dispvidctrl_tclPersistentData.cpp
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/

/*******************************************************************************
                        Includes
*******************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_drvass_video_if.h"

#include "I_dispvidctrl_tclVideoPlayer.h"
#include "dispvidctrl_tclPersistentData.h"
#include "dispvidctrl_datapool.h"
#include "VD_EARLYNorData.h"
#include "I_dispvidctrl_tclVideoPlayer.h"

#include "pdd.h"
#include "pdd_config_nor_user.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_tclPersistentData.cpp.trc.h"
#endif


/*******************************************************************************
                        Defines
*******************************************************************************/
#define PORTRAIT_BEGIN IDX_PORTRAIT_RVC

stVideoResizeParameters mapCameraTypeVideoParam[] =

#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI

   {
   //                                       Main Full Screen Video                                          Settings Screen Video
   //                          Source Rectangle                 Destination Rectangle              Source Rectangle          Destination Rectangle
   // Scaling   Cropping    x      y    width    height       x     y   width   height         x     y  width   height        x     y  width   height
                                                                                         
      {FALSE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_LANDSCAPE_RVC
      { TRUE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_LANDSCAPE_AVM_ENTRY
      {FALSE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_LANDSCAPE_AVM_PHASE3
      {FALSE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_LANDSCAPE_MVC
      {FALSE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_LANDSCAPE_RVC_RENAULT
      {FALSE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_LANDSCAPE_RVC_RENAULT_UPA
      {FALSE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_LANDSCAPE_RVC_RENAULT_UPA_HFP
      {FALSE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_LANDSCAPE_AVM_ENTRY_RENAULT
      {FALSE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_LANDSCAPE_AVM_ENTRY_RENAULT_UPA
      {FALSE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_LANDSCAPE_AVM_ENTRY_RENAULT_UPA_HFP

      { TRUE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_PORTRAIT_RVC
      {FALSE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_PORTRAIT_AVM_ENTRY
      {FALSE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_PORTRAIT_AVM_PHASE3
      {FALSE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_PORTRAIT_MVC
      { TRUE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_PORTRAIT_RVC_RENAULT
      { TRUE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_PORTRAIT_RVC_RENAULT_UPA
      { TRUE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_PORTRAIT_RVC_RENAULT_UPA_HFP
      {FALSE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_PORTRAIT_AVM_ENTRY_RENAULT
      {FALSE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }, // IDX_PORTRAIT_AVM_ENTRY_RENAULT_UPA
      {FALSE,     FALSE,  { 0,     0,   1280,     768 },  {   0,    0,  1280,      768 },  {   0,    0,  1280,     768 },  {  0,    0,   1280,    768} }  // IDX_PORTRAIT_AVM_ENTRY_RENAULT_UPA_HFP
   };

#else // Other than PIVI

   {
   //                                       Main Full Screen Video                                         Settings Screen Video
   //                          Source Rectangle               Destination Rectangle              Source Rectangle            Destination Rectangle
   // Scaling   Cropping     x      y    width    height     x     y   width     height        x     y  width   height        x     y  width   height

   #if defined (VARIANT_S_FTR_ENABLE_AIVI_SCOPE1)
      {FALSE,     FALSE,  {  0,     0,    800,     480 }, {  0,    0,   800,        480 },  {  0,    0,   800,     480 }, {   0,    0,    800,    480} }, // IDX_LANDSCAPE_RVC
   #else
      { TRUE,     FALSE,  {  0,     0,    800,     480 }, {  0,    0,   800,        480 },  {  0,    0,   800,     480 }, {   0,    0,    800,    480} }, // IDX_LANDSCAPE_RVC
   #endif
      { TRUE,     FALSE,  { 20,     0,    755,     475 }, {  0,    0,   800,        480 },  {  0,    0,   800,     480 }, {   0,    0,    800,    480} }, // IDX_LANDSCAPE_AVM_ENTRY
      {FALSE,     FALSE,  {  0,     0,    800,     480 }, {  0,    0,   800,        480 },  {  0,    0,   800,     480 }, {   0,    0,    800,    480} }, // IDX_LANDSCAPE_AVM_PHASE3
      { TRUE,     FALSE,  {  0,     0,    800,     480 }, { 90,    0,   710,        480 },  {  0,    0,  2110,     800 }, { 489,   80,    800,    480} }, // IDX_LANDSCAPE_MVC
      { TRUE,     FALSE,  {  0,     0,    720,     480 }, {  0,    0,   800,        402 },  {  0,    0,  2110,     800 }, { 489,   80,    800,    480} }, // IDX_LANDSCAPE_RVC_RENAULT
      { TRUE,     FALSE,  {  0,     0,    720,     480 }, {  0,    0,   600,        480 },  {  0,    0,  2110,     800 }, { 489,   80,    800,    480} }, // IDX_LANDSCAPE_RVC_RENAULT_UPA
      { TRUE,     FALSE,  {  0,     0,    720,     480 }, { 76,   57,   518,        345 },  {  0,    0,  2110,     800 }, { 489,   80,    800,    480} }, // IDX_LANDSCAPE_RVC_RENAULT_UPA_HFP
      { TRUE,     FALSE,  {  0,     0,    720,     480 }, {  0,    0,   800,        402 },  {  0,    0,  2110,     800 }, { 489,   80,    800,    480} }, // IDX_LANDSCAPE_AVM_ENTRY_RENAULT
      { TRUE,      TRUE,  {  0,     0,    720,     480 }, {  0,    0,   600,        480 },  {  0,    0,  2110,     800 }, { 489,   80,    800,    480} }, // IDX_LANDSCAPE_AVM_ENTRY_RENAULT_UPA
      { TRUE,      TRUE,  {  0,     0,    720,     480 }, { 76,   57,   518,        345 },  {  0,    0,  2110,     800 }, { 489,   80,    800,    480} }, // IDX_LANDSCAPE_AVM_ENTRY_RENAULT_UPA_HFP
                                                                                               
      { TRUE,     FALSE,  {  0,     0,    800,     480 }, {  0,    0,   820,       1024 },  {  0,    0,   820,    1024 }, {   0,    0,    800,    480} }, // IDX_PORTRAIT_RVC
      { TRUE,     FALSE,  {  0,     0,    800,     480 }, {  0,    0,   820,       1024 },  {  0,    0,   820,    1024 }, {   0,    0,    800,    480} }, // IDX_PORTRAIT_AVM_ENTRY
      { TRUE,     FALSE,  {  0,     0,    800,     480 }, {  0,    0,   820,       1024 },  {  0,    0,   820,    1024 }, {   0,    0,    800,    480} }, // IDX_PORTRAIT_AVM_PHASE3
      { TRUE,     FALSE,  {  0,     0,    800,     480 }, {  0,    0,   800,        480 },  {  0,    0,   820,    1024 }, {  30,  136,    760,    461} }, // IDX_PORTRAIT_MVC
      { TRUE,     FALSE,  {  0,     0,    720,     480 }, {  0,  335,   820,        514 },  {  0,    0,   820,    1024 }, {  30,  136,    760,    461} }, // IDX_PORTRAIT_RVC_RENAULT
      { TRUE,     FALSE,  {  0,     0,    720,     480 }, {  0,  335,   820,        514 },  {  0,    0,   820,    1024 }, {  30,  136,    760,    461} }, // IDX_PORTRAIT_RVC_RENAULT_UPA
      { TRUE,     FALSE,  {  0,     0,    720,     480 }, {  0,  335,   820,        514 },  {  0,    0,   820,    1024 }, {  30,  136,    760,    461} }, // IDX_PORTRAIT_RVC_RENAULT_UPA_HFP
      { TRUE,     FALSE,  {  0,     0,    720,     480 }, { 10,  205,   800,        489 },  {  0,    0,   820,    1024 }, {  30,  136,    760,    461} }, // IDX_PORTRAIT_AVM_ENTRY_RENAULT
      { TRUE,      TRUE,  {  0,     0,    720,     480 }, { 10,  205,   522,        489 },  {  0,    0,   820,    1024 }, {  30,  136,    760,    461} }, // IDX_PORTRAIT_AVM_ENTRY_RENAULT_UPA
      { TRUE,      TRUE,  {  0,     0,    720,     480 }, {  0,  335,   820,        514 },  {  0,    0,   820,    1024 }, {  30,  136,    760,    461} }  // IDX_PORTRAIT_AVM_ENTRY_RENAULT_UPA_HFP
   };

#endif

stVideoResizeParameters mapCameraTypeGraphicParam[] =

#ifdef VARIANT_S_FTR_ENABLE_AIVI_NPIVI

   {
   //                                       Main Full Screen Graphics                                        Settings Screen Graphics
   //                          Source Rectangle            Destination Rectangle                     Source Rectangle            Destination Rectangle
   // Scaling   Cropping     x      y    width   height       x     y   width  height         x     y  width   height        x     y  width   height
                                                                                       
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_LANDSCAPE_RVC
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_LANDSCAPE_AVM_ENTRY
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_LANDSCAPE_AVM_PHASE3
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_LANDSCAPE_MVC
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_LANDSCAPE_RVC_RENAULT
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_LANDSCAPE_RVC_RENAULT_UPA
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_LANDSCAPE_RVC_RENAULT_UPA_HFP
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_LANDSCAPE_AVM_ENTRY_RENAULT
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_LANDSCAPE_AVM_ENTRY_RENAULT_UPA
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_LANDSCAPE_AVM_ENTRY_RENAULT_UPA_HFP
                                                                              
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_PORTRAIT_RVC
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_PORTRAIT_AVM_ENTRY
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_PORTRAIT_AVM_PHASE3
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_PORTRAIT_MVC
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_PORTRAIT_RVC_RENAULT
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_PORTRAIT_RVC_RENAULT_UPA
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_PORTRAIT_RVC_RENAULT_UPA_HFP
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_PORTRAIT_AVM_ENTRY_RENAULT
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }, // IDX_PORTRAIT_AVM_ENTRY_RENAULT_UPA
      { TRUE,     FALSE,  {  0,     0,   1280,    768 }, {    0,    0,  1280,     768 },  {   0,    0,  1280,     768 }, {   0,    0,   1280,    768} }  // IDX_PORTRAIT_AVM_ENTRY_RENAULT_UPA_HFP
   };

#else // Other than PIVI

   {
   //                                       Main Full Screen Graphics                                       Settings Screen Graphics
   //                          Source Rectangle                  Destination Rectangle              Source Rectangle            Destination Rectangle
   // Scaling   Cropping    x      y    width    height        x     y   width   height         x     y  width   height       x     y  width   height

   #if defined (VARIANT_S_FTR_ENABLE_AIVI_SCOPE1)
      {FALSE,     FALSE,  {  0,     0,    800,     480 },  {   0,    0,   800,      480 },  {   0,    0,   800,     480 }, {   0,    0,    800,    480} }, // IDX_LANDSCAPE_RVC
   #else
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {   0,    0,   800,      480 },  {   0,    0,   800,     480 }, {   0,    0,    800,    480} }, // IDX_LANDSCAPE_RVC
   #endif
      { TRUE,     FALSE,  { 20,     0,    755,     475 },  {   0,    0,   800,      480 },  {   0,    0,   800,     480 }, {   0,    0,    800,    480} }, // IDX_LANDSCAPE_AVM_ENTRY
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {   0,    0,   800,      480 },  {   0,    0,   800,     480 }, {   0,    0,    800,    480} }, // IDX_LANDSCAPE_AVM_PHASE3
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {  90,    0,   710,      480 },  {   0,    0,   800,     480 }, { 489,   80,    302,    276} }, // IDX_LANDSCAPE_MVC
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {   0,    0,   800,      458 },  {   0,    0,   800,     480 }, { 489,   80,    302,    276} }, // IDX_LANDSCAPE_RVC_RENAULT
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {   0,    0,   600,      480 },  {   0,    0,   800,     480 }, { 489,   80,    302,    276} }, // IDX_LANDSCAPE_RVC_RENAULT_UPA
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {  76,   57,   518,      401 },  {   0,    0,   800,     480 }, { 489,   80,    302,    276} }, // IDX_LANDSCAPE_RVC_RENAULT_UPA_HFP
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {   0,    0,   800,      480 },  {   0,    0,   800,     480 }, { 489,   80,    302,    276} }, // IDX_LANDSCAPE_AVM_ENTRY_RENAULT
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {   0,    0,   600,      480 },  {   0,    0,   800,     480 }, { 489,   80,    302,    276} }, // IDX_LANDSCAPE_AVM_ENTRY_RENAULT_UPA
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {  76,   57,   518,      401 },  {   0,    0,   800,     480 }, { 489,   80,    302,    276} }, // IDX_LANDSCAPE_AVM_ENTRY_RENAULT_UPA_HFP

      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {   0,    0,   820,     1024 },  {   0,    0,   800,    1024 }, {   0,    0,    800,    480} }, // IDX_PORTRAIT_RVC
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {   0,    0,   820,     1024 },  {   0,    0,   800,    1024 }, {   0,    0,    800,    480} }, // IDX_PORTRAIT_AVM_ENTRY
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {   0,    0,   820,     1024 },  {   0,    0,   800,    1024 }, {   0,    0,    800,    480} }, // IDX_PORTRAIT_AVM_PHASE3
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {   0,    0,   820,     1024 },  {   0,    0,   800,    1024 }, {  30,   136,   760,    461} }, // IDX_PORTRAIT_MVC
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {   0,  335,   820,      514 },  {   0,    0,   800,    1024 }, {  30,   136,   760,    461} }, // IDX_PORTRAIT_RVC_RENAULT
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {   0,  335,   820,      514 },  {   0,    0,   800,    1024 }, {  30,   136,   760,    461} }, // IDX_PORTRAIT_RVC_RENAULT_UPA
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {   0,  335,   820,      514 },  {   0,    0,   800,    1024 }, {  30,   136,   760,    461} }, // IDX_PORTRAIT_RVC_RENAULT_UPA_HFP
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {  10,  205,   800,      489 },  {   0,    0,   800,    1024 }, {  30,   136,   760,    461} }, // IDX_PORTRAIT_AVM_ENTRY_RENAULT
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {  10,  205,   522,      489 },  {   0,    0,   800,    1024 }, {  30,   136,   760,    461} }, // IDX_PORTRAIT_AVM_ENTRY_RENAULT_UPA
      { TRUE,     FALSE,  {  0,     0,    800,     480 },  {   0,  335,   820,      514 },  {   0,    0,   800,    1024 }, {  30,   136,   760,    461} }  // IDX_PORTRAIT_AVM_ENTRY_RENAULT_UPA_HFP
   };

#endif

/******************************************************************************/
/* FUNCTION     dispvidctrl_tclPersistentData()                               */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       pointer to main application, tcom server name
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclPersistentData::dispvidctrl_tclPersistentData(const dispvidctrl_tclAppMain* poMainAppl)
: dispvidctrl_tclBaseIf(poMainAppl)
, m_bValueChanged(FALSE)
, m_bForceValueChanged(FALSE)
, m_u8VideoResizeParamIndex(IDX_LANDSCAPE_RVC)
{
   ETG_TRACE_USR4(("dispvidctrl_tclPersistentData() entered."));

   TEarlyConfiguration tEarlyConfig;
   _cpoMain->vGetEarlyConfig(tEarlyConfig); //Get pointer to data read on early start

   _tEarlyNor = tEarlyConfig.tEarlyNor;
   _tEarlyNorForce = tEarlyConfig.tEarlyNorForce;
   m_poClient_VideoPlayer = 0;
}

/******************************************************************************/
/* FUNCTION     ~dispvidctrl_tclPersistentData                                */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclPersistentData::~dispvidctrl_tclPersistentData(tVoid)
{
   ETG_TRACE_USR4(("~dispvidctrl_tclPersistentData() entered."));
   m_poClient_VideoPlayer = 0;
}

/******************************************************************************/
/* FUNCTION     vGetReferences                                                */
/******************************************************************************/
/**
*  \brief       Function to get all reference needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclPersistentData::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclPersistentData::vGetReferences() entered."));

   m_poClient_VideoPlayer = dynamic_cast<I_dispvidctrl_tclVideoPlayer*>(_cpoMain->getHandler("I_dispvidctrl_tclVideoPlayer"));
   DISPVIDCTRL_NULL_POINTER_CHECK(m_poClient_VideoPlayer);
}

/******************************************************************************/
/* FUNCTION     vStartCommunication                                           */
/******************************************************************************/
/**
*  \brief       Function to start all dynamic objects e.g. threads, ...
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclPersistentData::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("dispvidctrl_tclPersistentData::vStartCommunication() entered."));
}

/******************************************************************************/
/* FUNCTION     vGetConfiguration                                             */
/******************************************************************************/
/**
*  \brief       To get the configuration data updates
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclPersistentData::vGetConfiguration(const TConfiguration* pStConfigurationValues)
{
   // In case an update of the data pool data via diagnosis did fail for any reason we try to synchronise (update)
   // the early configuration data of the data-pool with configuration data we got from KDS.
   vUpdateConfiguration(pStConfigurationValues);
}

/******************************************************************************/
/* FUNCTION     vUpdateConfiguration                                          */
/******************************************************************************/
/**
*  \brief       update datapool configuration entries according to KDS configuration
*
*  \param       pointer to structire with KDS configuration values
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclPersistentData::vUpdateConfiguration(const TConfiguration* pStConfigurationValues)
{
   ETG_TRACE_USR4(("dispvidctrl_tclPersistentData::vUpdateConfiguration() entered."));

 // note: A specific update of the _tEarlyNorForce element or "vSet_..." function call must be done only once.
 //       Otherwhise it might happen that we write the datapool on every startup.

   m_u8VideoResizeParamIndex = u8GetVideoParamIndex(pStConfigurationValues);
   
   vSet_CameraWidth((tU16) DISPVIDCTRL_VIDEO__CAMERAWIDTH);
   vSet_CameraHeight((tU16) DISPVIDCTRL_VIDEO__CAMERAHEIGHT);
   vSet_CameraXOffset((tU16) DISPVIDCTRL_VIDEO__CAMERAXOFFSET);
   vSet_CameraYOffset((tU16) DISPVIDCTRL_VIDEO__CAMERAYOFFSET);
  
   if ( pStConfigurationValues->u8DisplayOrientation == 1 ) // Portrait
   {
      if(m_u8VideoResizeParamIndex < IDX_MAX)
      {
	     m_u8VideoResizeParamIndex += PORTRAIT_BEGIN;
      }
      vSet_Display1XOffset((tU16) DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY1XOFFSET);
      vSet_Display1YOffset((tU16) DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY1YOFFSET);
      vSet_Display2XOffset((tU16) DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY2XOFFSET);
      vSet_Display2YOffset((tU16) DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY2YOFFSET);
   }
   else // Landscape
   {
      vSet_Display1XOffset((tU16) DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1XOFFSET);
      vSet_Display1YOffset((tU16) DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1YOFFSET);
      vSet_Display2XOffset((tU16) DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY2XOFFSET);
      vSet_Display2YOffset((tU16) DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY2YOFFSET);
   }
   
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData::vUpdateConfiguration m_u8VideoResizeParamIndex %u", ETG_CENUM(enVideoParamMapIndex, m_u8VideoResizeParamIndex)));
   
   switch (m_u8VideoResizeParamIndex)
   {
      case IDX_LANDSCAPE_RVC:
      case IDX_PORTRAIT_RVC:
         {
            vSet_CameraSystemType((tU32) CAMERA_TYPE_RVC);
            vSet_WarningTextVisibility((tU32) DISPVIDCTRL_VIDEO__WARNINGTEXT_VISIBLE);
            vSet_GuidelineVisibility(TRUE);
            if (pStConfigurationValues->bAnticipatoryLine == TRUE)
            {
               vSet_GuideLineVisibilityMode((tU32) GUIDELINE_DRAW_DYNAMIC | GUIDELINE_DRAW_STATIC_SIDE);
            }
            else
            {
               vSet_GuideLineVisibilityMode((tU32) GUIDELINE_DRAW_STATIC_SIDE);
            }
         }
         break;

      case IDX_LANDSCAPE_RVC_RENAULT:
      case IDX_PORTRAIT_RVC_RENAULT:
         {
            vSet_CameraSystemType((tU32) CAMERA_TYPE_RVC_RENAULT);
            vSet_WarningTextVisibility((tU32) DISPVIDCTRL_VIDEO__WARNINGTEXT_VISIBLE);
            vSet_GuidelineVisibility(TRUE);
            vSet_GuideLineVisibilityMode((tU32) GUIDELINE_DRAW_DYNAMIC | GUIDELINE_DRAW_STATIC_SIDE);
         }
         break;
      
      case IDX_LANDSCAPE_AVM_ENTRY:
      case IDX_PORTRAIT_AVM_ENTRY:
         {
            vSet_GuidelineVisibility(FALSE);
            vSet_GuideLineVisibilityMode((tU32) GUIDELINE_DRAW_NONE);
            
            if (pStConfigurationValues->bAvmType_Fap)
            {
               vSet_WarningTextVisibility((tU32) DISPVIDCTRL_VIDEO__WARNINGTEXT_NOT_VISIBLE);
               vSet_CameraSystemType((tU32) CAMERA_TYPE_AVM_FAP);
            }
            else if (pStConfigurationValues->bAvmType_Ipa)
            {
               vSet_WarningTextVisibility((tU32) DISPVIDCTRL_VIDEO__WARNINGTEXT_VISIBLE);
               vSet_CameraSystemType((tU32) CAMERA_TYPE_AVM_IPA);
            }
            else 
            {
               vSet_WarningTextVisibility((tU32) DISPVIDCTRL_VIDEO__WARNINGTEXT_NOT_VISIBLE);
               vSet_CameraSystemType((tU32) CAMERA_TYPE_AVM_ENTRY);
            }
         }
         break;
         
      case IDX_LANDSCAPE_AVM_ENTRY_RENAULT:
      case IDX_PORTRAIT_AVM_ENTRY_RENAULT:
         {
            vSet_CameraSystemType((tU32) CAMERA_TYPE_AVM_ENTRY_RENAULT);
            vSet_WarningTextVisibility((tU32) DISPVIDCTRL_VIDEO__WARNINGTEXT_VISIBLE);
            vSet_GuidelineVisibility(FALSE);
            vSet_GuideLineVisibilityMode((tU32) GUIDELINE_DRAW_NONE);
         }
         break;

      case IDX_LANDSCAPE_AVM_PHASE3:
      case IDX_PORTRAIT_AVM_PHASE3:
         {
            vSet_CameraSystemType((tU32) CAMERA_TYPE_AVM_PHASE3);
            vSet_WarningTextVisibility((tU32) DISPVIDCTRL_VIDEO__WARNINGTEXT_VISIBLE);
            vSet_GuidelineVisibility(FALSE);
            vSet_GuideLineVisibilityMode((tU32) GUIDELINE_DRAW_NONE);
         }
         break;
         
      case IDX_LANDSCAPE_MVC:
      case IDX_PORTRAIT_MVC:
         {
            vSet_CameraSystemType((tU32) CAMERA_TYPE_MVC);
            vSet_WarningTextVisibility((tU32) DISPVIDCTRL_VIDEO__WARNINGTEXT_VISIBLE);
            vSet_GuidelineVisibility(TRUE);

            //Setting the persistent data based on the previous value [NCG3D-77436]
            tU32 u32GuideVisibilitylineMode = 0;
            (tVoid) bGetPersistent_GuideLineVisibilityMode(u32GuideVisibilitylineMode);
            ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData()::vUpdateConfiguration u32GuideVisibilitylineMode = %d", u32GuideVisibilitylineMode));

            if (((u32GuideVisibilitylineMode) & ((tU32) GUIDELINE_DRAW_STATIC_SIDE)) == (tU32) GUIDELINE_DRAW_STATIC_SIDE)
            {
                vSet_GuideLineVisibilityMode((tU32) GUIDELINE_DRAW_STATIC_SIDE);
            }
            else
            {
                vSet_GuideLineVisibilityMode((tU32) GUIDELINE_DRAW_NONE);
            }

            //At startup, persistent value was always set to static, even though if it was disabled previously.
            //vSet_GuideLineVisibilityMode((tU32) GUIDELINE_DRAW_STATIC_SIDE);
         }
         break;

      
      default:
         {
            vSet_CameraSystemType((tU32) CAMERA_TYPE_NONE);
            vSet_WarningTextVisibility((tU32) DISPVIDCTRL_VIDEO__WARNINGTEXT_NOT_VISIBLE);
            vSet_GuidelineVisibility(FALSE);
            vSet_GuideLineVisibilityMode((tU32) GUIDELINE_DRAW_NONE);
         }
         break;
   }
   
   if ( m_u8VideoResizeParamIndex < IDX_MAX )
   {
      vSet_SourceXOffset(mapCameraTypeVideoParam[m_u8VideoResizeParamIndex].tVideoSource.u16xOffset);
      vSet_SourceYOffset(mapCameraTypeVideoParam[m_u8VideoResizeParamIndex].tVideoSource.u16yOffset);
      vSet_SourceHeight(mapCameraTypeVideoParam[m_u8VideoResizeParamIndex].tVideoSource.u16Height);
      vSet_SourceWidth(mapCameraTypeVideoParam[m_u8VideoResizeParamIndex].tVideoSource.u16Width);

      // if LHD use the video resize parameters as it is 
      tU16 u16CalculatedXOffset = mapCameraTypeVideoParam[m_u8VideoResizeParamIndex].tVideoDestination.u16xOffset;
      // horizontal mirroring of the video window
      // only the x-offset needs to be adapted according to the LHD layout
      if ( FALSE == pStConfigurationValues->bLeftHandSteeringPosition ) // RHD
      {
         // horizontal mirroring of the video window
         // only the x-offset needs to be adapted according to the LHD layout
         u16CalculatedXOffset = DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1WIDTH - ( u16CalculatedXOffset + mapCameraTypeVideoParam[m_u8VideoResizeParamIndex].tVideoDestination.u16Width );
      }
      
      vSet_DestinationXOffset(u16CalculatedXOffset);

      vSet_DestinationWidth(mapCameraTypeVideoParam[m_u8VideoResizeParamIndex].tVideoDestination.u16Width);
      vSet_DestinationHeight(mapCameraTypeVideoParam[m_u8VideoResizeParamIndex].tVideoDestination.u16Height);
      vSet_DestinationYOffset(mapCameraTypeVideoParam[m_u8VideoResizeParamIndex].tVideoDestination.u16yOffset);

      // scaling
      if (_tEarlyNorForce.bVideoScalingSet != mapCameraTypeVideoParam[m_u8VideoResizeParamIndex].bScalingActive)
      {
         _tEarlyNorForce.bVideoScalingSet = mapCameraTypeVideoParam[m_u8VideoResizeParamIndex].bScalingActive;
         m_bForceValueChanged = TRUE;
      }
   }
   
   vSet_WarningTextBackground((tU32) pStConfigurationValues->bBlackWarningTextBackground);
   vSet_GuidelineCameraType((tU32) pStConfigurationValues->u8RvcLensParameterSet);
   vSet_GuidelineVehicleParameter(pStConfigurationValues->VehicleParameter);

   vSet_RVCLowSpeedThreshold((tU32) DEFAULT_RVCLOWSPEEDTHRESHOLD);
   vSet_RVCHighSpeedThreshold((tU32) DEFAULT_RVCHIGHSPEEDTHRESHOLD);
   vSet_RVCReverseOffGuardTime((tU32) 0);
   vSet_SPMAutoMode((tU32) DEFAULT_SPMAUTOMODE);

   vSet_Brand((tU32) pStConfigurationValues->u8Brand);
   vSet_VehicleType(pStConfigurationValues->u16VehicleType);
   vSet_OpeningAnimation((tU32) pStConfigurationValues->u8OpeningAnimation);
   vSet_DisplayAspectRatio((tU32) pStConfigurationValues->u8DisplayAspectRatio);
   vSet_DestinationRegion((tU32) pStConfigurationValues->u16DestinationRegion);
   vSet_SteeringPosition((tU32) pStConfigurationValues->bLeftHandSteeringPosition);

   vSet_CameraConnectionType((tU32) pStConfigurationValues->u8CameraConnectionType);
   
   #if defined KDS_FINALLY_CONTAINS_RELIABLE_DISPLAY_RESOLUTION_VALUES  // unfortunately currently not the case :-( - some devices have it, others not, again others have wrong values, ...
   vSet_Display1Width((tU16) pStConfigurationValues->u32DisplayResolutionWidth);
   vSet_Display1Height((tU16) pStConfigurationValues->u32DisplayResolutionHeight);
   vSet_Display2Width((tU16) pStConfigurationValues->u32DisplayTwoResolutionWidth);
   vSet_Display2Height((tU16) pStConfigurationValues->u32DisplayTwoResolutionHeight);
   #else                                                                // ... so until that topic is finally settled, we keep using the good 'ole hardcoded values:
   if ( pStConfigurationValues->u8DisplayOrientation == 1 ) {  // Portrait
      vSet_Display1Width ((tU16) DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY1WIDTH );
      vSet_Display1Height((tU16) DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY1HEIGHT);
      vSet_Display2Width ((tU16) DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY2WIDTH );
      vSet_Display2Height((tU16) DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY2HEIGHT);
   } else {  // Landscape
      vSet_Display1Width ((tU16) DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1WIDTH );
      vSet_Display1Height((tU16) DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1HEIGHT);
      vSet_Display2Width ((tU16) DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY2WIDTH );
      vSet_Display2Height((tU16) DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY2HEIGHT);
   }
   #endif
   vSet_DisplayOrientation((tU8) pStConfigurationValues->u8DisplayOrientation);
   vSet_DisplayType((tU8) pStConfigurationValues->u8DisplayType);
   
   vSet_VCANDiversity((tU8) pStConfigurationValues->u8VCANDiversity);
   vSet_CameraImageMirror((tU8) pStConfigurationValues->u8CameraImageMirror);
   vSet_WelcomeSequence((tU8) pStConfigurationValues->u8WelcomeSequence);
   vSet_Resolution(pStConfigurationValues->Resolution);
   
   // Read DisplayOrder and FlushDesignConfigFile from PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGLAYERMANAGER
   tU8 aU8DisplayOrder[4];
   tU8 aU8FlushDesignConfigFile[64];
   
   // Set default values
   aU8DisplayOrder[0] = 1;
   aU8DisplayOrder[1] = 2;
   aU8DisplayOrder[2] = 3;
   aU8DisplayOrder[3] = 0;
   aU8FlushDesignConfigFile[0] = '\0';

   //Get settings data from NOR data
   int s32StreamLength = 800;

   bool bSuccess = true;

   //Allocate buffer
   unsigned char* pu8DataStreamBuffer = (unsigned char*) malloc((unsigned int)s32StreamLength);
   tU8            Vu8Info             = PDD_READ_INFO_NORMAL_FILE;
   int s32Result = pdd_read_datastream_early_from_nor((const char*)PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGLAYERMANAGER, pu8DataStreamBuffer, s32StreamLength, 1, &Vu8Info);
   if (s32Result > 0) {
      if (pdd_helper_get_element_from_stream((const char *)"TrDisplayOrder",pu8DataStreamBuffer,(size_t)s32Result, (void*) &aU8DisplayOrder, 4, 0)==0) { //lint !e605
         ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData()::vUpdateConfiguration - TrDisplayOrder READ FROM NOR %d, %d, %d, %d", aU8DisplayOrder[0], aU8DisplayOrder[1], aU8DisplayOrder[2], aU8DisplayOrder[3]));
		 vSet_DisplayOrder(aU8DisplayOrder);
      }
      else {
         ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData()::vUpdateConfiguration - READ FROM NOR Failure"));
      }
      if (pdd_helper_get_element_from_stream((const char *)"TrFlushDesignConfigFile",pu8DataStreamBuffer,(size_t)s32Result, (void*) &aU8FlushDesignConfigFile, 64, 0)==0) { //lint !e605
         ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData()::vUpdateConfiguration - TrFlushDesignConfigFile READ FROM NOR %d", aU8FlushDesignConfigFile[0]));
		 vSet_FlushDesignConfigFile(aU8FlushDesignConfigFile);
      }
      else {
         ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData()::vUpdateConfiguration - TrFlushDesignConfigFile READ FROM NOR Failure"));
      }
   }
   else {
      ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData()::vUpdateConfiguration - pdd_read_datastream_early_from_nor Failure %d", s32Result));
   }

   if(m_poClient_VideoPlayer != 0)
   {
      if(m_poClient_VideoPlayer->bCroppingParametersInRange((tU8) pStConfigurationValues->u8CropUp,
                                                            (tU8) pStConfigurationValues->u8CropDown,
                                                            (tU8) pStConfigurationValues->u8CropLeft,
                                                            (tU8) pStConfigurationValues->u8CropRight) == true)
      {
         vSet_Cropping_Up((tU8) pStConfigurationValues->u8CropUp);
         vSet_Cropping_Down((tU8) pStConfigurationValues->u8CropDown);
         vSet_Cropping_Left((tU8) pStConfigurationValues->u8CropLeft);
         vSet_Cropping_Right((tU8) pStConfigurationValues->u8CropRight);
         vSet_Cropping_Set(true);
      }
      else
      {
         vSet_Cropping_Up((tU8) 0);
         vSet_Cropping_Down((tU8) 0);
         vSet_Cropping_Left((tU8) 0);
         vSet_Cropping_Right((tU8) 0);
         vSet_Cropping_Set(false);
      }
   }

   (tVoid) bSetEarlyNorConfigurationPersistent();
}

/******************************************************************************/
/* FUNCTION     u8GetVideoParamIndex                                          */
/******************************************************************************/
/**
*  \brief       Handle worker events.
*
*  \param       message pointer
*  \return      none
*/
/******************************************************************************/
tU8 dispvidctrl_tclPersistentData::u8GetVideoParamIndex(const TConfiguration* pStConfigurationValues)
{
   tU8 u8VideoResizeParamIndex = IDX_MAX;

   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData()::u8GetVideoParamIndex Camera Type Configured is :%d", ETG_CENUM(enCameraSystemType, pStConfigurationValues->u8CameraSystemType)));
   
   if ( NULL != pStConfigurationValues )
   {
      if(pStConfigurationValues->u8CameraSystemType != CAMERA_TYPE_NONE)
      {
	     // Rvc Mode
         if (pStConfigurationValues->bRvcMode)
         {
            if (pStConfigurationValues->bRvcType_Renault)
            {
               u8VideoResizeParamIndex = IDX_LANDSCAPE_RVC_RENAULT;
            }
            else
            {
               u8VideoResizeParamIndex = IDX_LANDSCAPE_RVC;
            }
         }

         // AVM (Entry, AVM+IPA, AVM+FAP)
         else if (pStConfigurationValues->bAvmMode)
         {
            // Renault Avm ?
            if (pStConfigurationValues->bAvmType_Renault)
            {
               u8VideoResizeParamIndex = IDX_LANDSCAPE_AVM_ENTRY_RENAULT;
            }
            else
            {
               u8VideoResizeParamIndex = IDX_LANDSCAPE_AVM_ENTRY;
            }
         }

         // MVC Mode
         else if (pStConfigurationValues->bMvcMode)
         {
            u8VideoResizeParamIndex = IDX_LANDSCAPE_MVC;
         }
      
         // AvmType_Phase3
         else if (pStConfigurationValues->bAvmType_Phase3)
         {
            u8VideoResizeParamIndex = IDX_LANDSCAPE_AVM_PHASE3;
         }

         else
         {
            u8VideoResizeParamIndex = IDX_LANDSCAPE_RVC;
         }
      }
      else
      {
    	  ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData()::u8GetVideoParamIndex u8VideoResizeParamIndex is :%d", ETG_CENUM(enVideoParamMapIndex, u8VideoResizeParamIndex)));
      }
   }
   
   return u8VideoResizeParamIndex;
}

/******************************************************************************/
/* FUNCTION     vHandleMessage(TMsg* pMsg)                                    */
/******************************************************************************/
/**
*  \brief       Handle worker events.
*
*  \param       message pointer
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclPersistentData::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("dispvidctrl_tclPersistentData::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));

}

/******************************************************************************/
/* FUNCTION     vHandleTraceMessage                                           */
/******************************************************************************/
/**
*  \brief       handle TTFis commands
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclPersistentData::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);

   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("dispvidctrl_tclPersistentData::vHandleTraceMessage(): trace command %d", u32MsgCode ));


}

/******************************************************************************/
/* FUNCTION     vTraceInfo()                                                  */
/******************************************************************************/
/**
*  \brief       trace information
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclPersistentData::vTraceInfo()
{
   TEarlyConfiguration tEarlyConfig;
   _cpoMain->vGetEarlyConfig(tEarlyConfig); //Get pointer to data read on early start
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() read on startup from NOR"));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32SpmAutoMode ................[%d]", tEarlyConfig.tEarlyNor.u32SpmAutoMode));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcColourDay ...............[%d]", tEarlyConfig.tEarlyNor.u32RvcColourDay));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcContrastDay .............[%d]", tEarlyConfig.tEarlyNor.u32RvcContrastDay));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcBrightnessDay ...........[%d]", tEarlyConfig.tEarlyNor.u32RvcBrightnessDay));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcHueDay ..................[%d]", tEarlyConfig.tEarlyNor.u32RvcHueDay));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcBlackLevelDay ...........[%d]", tEarlyConfig.tEarlyNor.u32RvcBlackLevelDay));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcColourNight .............[%d]", tEarlyConfig.tEarlyNor.u32RvcColourNight));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcContrastNight ...........[%d]", tEarlyConfig.tEarlyNor.u32RvcContrastNight));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcBrightnessNight .........[%d]", tEarlyConfig.tEarlyNor.u32RvcBrightnessNight));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcHueNight ................[%d]", tEarlyConfig.tEarlyNor.u32RvcHueNight));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcBlackLevelNight .........[%d]", tEarlyConfig.tEarlyNor.u32RvcBlackLevelNight));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcLowSpeedThreshold .......[%d]", tEarlyConfig.tEarlyNorForce.u32RvcLowSpeedThreshold));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcHighSpeedThreshold ......[%d]", tEarlyConfig.tEarlyNorForce.u32RvcHighSpeedThreshold));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcReverseOffGuardTime .....[%d]", tEarlyConfig.tEarlyNorForce.u32RvcReverseOffGuardTime));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32GuidelineWarningLanguage ...[%d]", tEarlyConfig.tEarlyNor.u32SpmAutoMode));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32GuidelineVisibilityMode ....[%d]", tEarlyConfig.tEarlyNor.u32GuidelineVisibilityMode));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32GuidelineVisibility ........[%d]", tEarlyConfig.tEarlyNorForce.bGuidelineVisibility));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32GuidelineCameraType ........[%d]", tEarlyConfig.tEarlyNorForce.u32GuidelineCameraType));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32GuidelineCameraSystemType ..[%d]", ETG_CENUM(enCameraSystemType, tEarlyConfig.tEarlyNorForce.u32GuidelineCameraSystemType)));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32GuidelineBlackWarningTextBackground [%d]", tEarlyConfig.tEarlyNorForce.u32GuidelineBlackWarningTextBackground));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32GuidelineWarningText .......[%d]", tEarlyConfig.tEarlyNorForce.u32GuidelineWarningText));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() vehicle para byte 0: ..........[0x%02X]", tEarlyConfig.tEarlyNorForce.au8GuidelineVehicleParameter[0]));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8AvmLanguage .................[%d]", tEarlyConfig.tEarlyNor.u8AvmLanguage));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoSourceRectangle_X .....[%d]", tEarlyConfig.tEarlyNorForce.u16VideoSourceRectangle_X));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoSourceRectangle_Y .....[%d]", tEarlyConfig.tEarlyNorForce.u16VideoSourceRectangle_Y));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoSourceRectangle_Width .[%d]", tEarlyConfig.tEarlyNorForce.u16VideoSourceRectangle_Width));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoSourceRectangle_Height [%d]", tEarlyConfig.tEarlyNorForce.u16VideoSourceRectangle_Height));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoDestinationRectangle_X.[%d]", tEarlyConfig.tEarlyNorForce.u16VideoDestinationRectangle_X));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoDestinationRectangle_Y.[%d]", tEarlyConfig.tEarlyNorForce.u16VideoDestinationRectangle_Y));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoDestinationRectangle_Width .[%d]", tEarlyConfig.tEarlyNorForce.u16VideoDestinationRectangle_Width));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoDestinationRectangle_Height [%d]", tEarlyConfig.tEarlyNorForce.u16VideoDestinationRectangle_Height));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoCropping_Up ...........[%d]", tEarlyConfig.tEarlyNorForce.u16VideoCropping_Up));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoCropping_Down .........[%d]", tEarlyConfig.tEarlyNorForce.u16VideoCropping_Down));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoCropping_Left .........[%d]", tEarlyConfig.tEarlyNorForce.u16VideoCropping_Left));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoCropping_Rght .........[%d]", tEarlyConfig.tEarlyNorForce.u16VideoCropping_Right));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() bVideoScalingSet ..............[%d]", tEarlyConfig.tEarlyNorForce.bVideoScalingSet));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() bVideoCroppingSet .............[%d]", tEarlyConfig.tEarlyNorForce.bVideoCroppingSet));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8EarlyBrand ..................[%d]", tEarlyConfig.tEarlyNorForce.u8EarlyBrand));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VehicleType.................[0x%04X]", tEarlyConfig.tEarlyNorForce.u16VehicleType));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8EarlyOpeningAnimation .......[%d]", tEarlyConfig.tEarlyNorForce.u8EarlyOpeningAnimation));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8EarlyDisplayAspectRatio .....[%d]", tEarlyConfig.tEarlyNorForce.u8EarlyDisplayAspectRatio));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16DestinationRegion ..........[%d]", tEarlyConfig.tEarlyNorForce.u16EarlyDestinationRegion));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() bLeftHandSteeringPosition .....[%d]", tEarlyConfig.tEarlyNorForce.bLeftHandSteeringPosition));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8CameraConnectionType ........[%d]", tEarlyConfig.tEarlyNorForce.u8CameraConnectionType));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16CameraWidth ................[%d]", tEarlyConfig.tEarlyNorForce.u16CameraWidth));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16CameraHeight ...............[%d]", tEarlyConfig.tEarlyNorForce.u16CameraHeight));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16CameraXOffset ..............[%d]", tEarlyConfig.tEarlyNorForce.u16CameraXOffset));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16CameraYOffset ..............[%d]", tEarlyConfig.tEarlyNorForce.u16CameraYOffset));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8DisplayType .................[%d]", tEarlyConfig.tEarlyNorForce.u8DisplayType));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display1Width ..............[%d]", tEarlyConfig.tEarlyNorForce.u16Display1Width));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display1Height .............[%d]", tEarlyConfig.tEarlyNorForce.u16Display1Height));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display1XOffset ............[%d]", tEarlyConfig.tEarlyNorForce.u16Display1XOffset));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display1YOffset ............[%d]", tEarlyConfig.tEarlyNorForce.u16Display1YOffset));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display2Width ..............[%d]", tEarlyConfig.tEarlyNorForce.u16Display2Width));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display2Height .............[%d]", tEarlyConfig.tEarlyNorForce.u16Display2Height));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display2XOffset ............[%d]", tEarlyConfig.tEarlyNorForce.u16Display2XOffset));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display2YOffset ............[%d]", tEarlyConfig.tEarlyNorForce.u16Display2YOffset));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8DisplayOrientation ..........[%d]", tEarlyConfig.tEarlyNorForce.u8EarlyDisplayOrientation));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8VCANDiversity ...............[%d]", tEarlyConfig.tEarlyNorForce.u8VCANDiversity));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8CameraImageMirror ...........[%d]", tEarlyConfig.tEarlyNorForce.u8CameraImageMirror));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8EarlyWelcomeSequence ........[%d]", tEarlyConfig.tEarlyNorForce.u8EarlyWelcomeSequence));
   //updated values during start-up and later
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() updated values during start-up and later"));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32SpmAutoMode ................[%d]", _tEarlyNor.u32SpmAutoMode));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcColourDay ...............[%d]", _tEarlyNor.u32RvcColourDay));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcContrastDay .............[%d]", _tEarlyNor.u32RvcContrastDay));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcBrightnessDay ...........[%d]", _tEarlyNor.u32RvcBrightnessDay));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcHueDay ..................[%d]", _tEarlyNor.u32RvcHueDay));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcBlackLevelDay ...........[%d]", _tEarlyNor.u32RvcBlackLevelDay));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcColourNight .............[%d]", _tEarlyNor.u32RvcColourNight));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcContrastNight ...........[%d]", _tEarlyNor.u32RvcContrastNight));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcBrightnessNight .........[%d]", _tEarlyNor.u32RvcBrightnessNight));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcHueNight ................[%d]", _tEarlyNor.u32RvcHueNight));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcBlackLevelNight .........[%d]", _tEarlyNor.u32RvcBlackLevelNight));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcLowSpeedThreshold .......[%d]", _tEarlyNorForce.u32RvcLowSpeedThreshold));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcHighSpeedThreshold ......[%d]", _tEarlyNorForce.u32RvcHighSpeedThreshold));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32RvcReverseOffGuardTime .....[%d]", _tEarlyNorForce.u32RvcReverseOffGuardTime));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32GuidelineWarningLanguage ...[%d]", _tEarlyNor.u32SpmAutoMode));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32GuidelineWarningText .......[%d]", _tEarlyNorForce.u32GuidelineWarningText));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32GuidelineVisibilityMode.....[%d]", _tEarlyNor.u32GuidelineVisibilityMode));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32GuidelineVisibility ........[%d]", _tEarlyNorForce.bGuidelineVisibility));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32GuidelineCameraType ........[%d]", _tEarlyNorForce.u32GuidelineCameraType));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32GuidelineCameraSystemType ..[%d]", ETG_CENUM(enCameraSystemType, _tEarlyNorForce.u32GuidelineCameraSystemType)));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u32GuidelineBlackWarningTextBackground [%d]", _tEarlyNorForce.u32GuidelineBlackWarningTextBackground));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() vehicle para byte 0: ..........[0x%02X]", _tEarlyNorForce.au8GuidelineVehicleParameter[0]));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8AvmLanguage .................[%d]", _tEarlyNor.u8AvmLanguage));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoSourceRectangle_X .....[%d]", _tEarlyNorForce.u16VideoSourceRectangle_X));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoSourceRectangle_Y .....[%d]", _tEarlyNorForce.u16VideoSourceRectangle_Y));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoSourceRectangle_Width .[%d]", _tEarlyNorForce.u16VideoSourceRectangle_Width));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoSourceRectangle_Height [%d]", _tEarlyNorForce.u16VideoSourceRectangle_Height));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoDestinationRectangle_X.[%d]", _tEarlyNorForce.u16VideoDestinationRectangle_X));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoDestinationRectangle_Y.[%d]", _tEarlyNorForce.u16VideoDestinationRectangle_Y));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoDestinationRectangle_Width .[%d]", _tEarlyNorForce.u16VideoDestinationRectangle_Width));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoDestinationRectangle_Height [%d]", _tEarlyNorForce.u16VideoDestinationRectangle_Height));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoCropping_Up ...........[%d]", _tEarlyNorForce.u16VideoCropping_Up));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoCropping_Down .........[%d]", _tEarlyNorForce.u16VideoCropping_Down));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoCropping_Left .........[%d]", _tEarlyNorForce.u16VideoCropping_Left));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VideoCropping_Right ........[%d]", _tEarlyNorForce.u16VideoCropping_Right));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() bVideoScalingSet ..............[%d]", _tEarlyNorForce.bVideoScalingSet));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() bVideoCroppingSet .............[%d]", _tEarlyNorForce.bVideoCroppingSet));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8EarlyBrand ..................[%d]", _tEarlyNorForce.u8EarlyBrand));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16VehicleType.................[0x%04X]", _tEarlyNorForce.u16VehicleType));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8EarlyOpeningAnimation .......[%d]", _tEarlyNorForce.u8EarlyOpeningAnimation));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8EarlyDisplayAspectRatio .....[%d]", _tEarlyNorForce.u8EarlyDisplayAspectRatio));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16EarlyDestinationRegion .....[%d]", _tEarlyNorForce.u16EarlyDestinationRegion));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() bLeftHandSteeringPosition .....[%d]", _tEarlyNorForce.bLeftHandSteeringPosition));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8CameraConnectionType ........[%d]", _tEarlyNorForce.u8CameraConnectionType));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16CameraWidth ................[%d]", _tEarlyNorForce.u16CameraWidth));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16CameraHeight ...............[%d]", _tEarlyNorForce.u16CameraHeight));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16CameraXOffset ..............[%d]", _tEarlyNorForce.u16CameraXOffset));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16CameraYOffset ..............[%d]", _tEarlyNorForce.u16CameraYOffset));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8DisplayType .................[%d]", _tEarlyNorForce.u8DisplayType));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display1Width ..............[%d]", _tEarlyNorForce.u16Display1Width));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display1Height .............[%d]", _tEarlyNorForce.u16Display1Height));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display1XOffset ............[%d]", _tEarlyNorForce.u16Display1XOffset));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display1YOffset ............[%d]", _tEarlyNorForce.u16Display1YOffset));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display2Width ..............[%d]", _tEarlyNorForce.u16Display2Width));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display2Height .............[%d]", _tEarlyNorForce.u16Display2Height));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display2XOffset ............[%d]", _tEarlyNorForce.u16Display2XOffset));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u16Display2YOffset ............[%d]", _tEarlyNorForce.u16Display2YOffset));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8DisplayOrientation...........[%d]", _tEarlyNorForce.u8EarlyDisplayOrientation));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8VCANDiversity ...............[%d]", _tEarlyNorForce.u8VCANDiversity));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8CameraImageMirror ...........[%d]", _tEarlyNorForce.u8CameraImageMirror));
   ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() u8EarlyWelcomeSequence ........[%d]", _tEarlyNorForce.u8EarlyWelcomeSequence));
   //ETG_TRACE_FATAL(("dispvidctrl_tclPersistentData() resolution ....................[%s]", _tEarlyNorForce.au8EarlyResolution));
}



/******************************************************************************/
/* bSetEarlyNorConfigurationPersistent                                        */
/******************************************************************************/
/**
*  \brief       To store early NOR configuration persistent
*
*  \param       none
*  \return      success state
*/
/******************************************************************************/
tBool dispvidctrl_tclPersistentData::bSetEarlyNorConfigurationPersistent(tVoid)
{
   if (m_bValueChanged)
   {
      m_bValueChanged = FALSE;
      dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig oDatapool;
      tS32 res = oDatapool.s32SetData(_tEarlyNor);
      ETG_TRACE_USR1(("bSetEarlyNorConfigurationPersistent (Persistent set result %d)", res));
   }
   else
   {
      ETG_TRACE_USR1(("bSetEarlyNorConfigurationPersistent no value changed"));
   }
   
   if (m_bForceValueChanged)
   {
      m_bForceValueChanged = FALSE;
      dp_tclDATASET_VD_EARLY_FORCE_CONFIGEarlyNorConfigForce oDatapoolForce;
      tS32 res = oDatapoolForce.s32SetData(_tEarlyNorForce);
      ETG_TRACE_USR1(("bSetEarlyNorConfigurationPersistent (Persistent Force set result %d)", res));
   }
   else
   {
      ETG_TRACE_USR1(("bSetEarlyNorConfigurationPersistent no Force value changed"));
   }

   return (TRUE);
}

/******************************************************************************/
/* Set Functions                                                              */
/******************************************************************************/
/**
*  \brief       Set value in structure
*
*  \param       value as tU32
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclPersistentData::vSet_BlackLevel_Day(tU32 u32NewValue)
{
   if (_tEarlyNor.u32RvcBlackLevelDay != u32NewValue)
   {
      m_bValueChanged = TRUE;
      _tEarlyNor.u32RvcBlackLevelDay = u32NewValue;
      ETG_TRACE_USR4(("vSet_BlackLevel_Day - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_BlackLevel_Night(tU32 u32NewValue)
{
   if (_tEarlyNor.u32RvcBlackLevelNight != u32NewValue)
   {
      m_bValueChanged = TRUE;
      _tEarlyNor.u32RvcBlackLevelNight = u32NewValue;
      ETG_TRACE_USR4(("vSet_BlackLevel_Night - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_Brightness_Day(tU32 u32NewValue)
{
   if (_tEarlyNor.u32RvcBrightnessDay != u32NewValue)
   {
      m_bValueChanged = TRUE;
      _tEarlyNor.u32RvcBrightnessDay  = u32NewValue;
      ETG_TRACE_USR4(("vSet_Brightness_Day - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_Brightness_Night(tU32 u32NewValue)
{
   if (_tEarlyNor.u32RvcBrightnessNight != u32NewValue)
   {
      m_bValueChanged = TRUE;
      _tEarlyNor.u32RvcBrightnessNight  = u32NewValue;
      ETG_TRACE_USR4(("vSet_Brightness_Night - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_Colour_Day(tU32 u32NewValue)
{
   if (_tEarlyNor.u32RvcColourDay != u32NewValue)
   {
      m_bValueChanged = TRUE;
      _tEarlyNor.u32RvcColourDay  = u32NewValue;
      ETG_TRACE_USR4(("vSet_Colour_Day - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_Colour_Night(tU32 u32NewValue)
{
   if (_tEarlyNor.u32RvcColourNight != u32NewValue)
   {
      m_bValueChanged = TRUE;
      _tEarlyNor.u32RvcColourNight  = u32NewValue;
      ETG_TRACE_USR4(("vSet_Colour_Night - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_Contrast_Day(tU32 u32NewValue)
{
   if (_tEarlyNor.u32RvcContrastDay != u32NewValue)
   {
      m_bValueChanged = TRUE;
      _tEarlyNor.u32RvcContrastDay  = u32NewValue;
      ETG_TRACE_USR4(("vSet_Contrast_Day - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_Contrast_Night(tU32 u32NewValue)
{
   if (_tEarlyNor.u32RvcContrastNight != u32NewValue)
   {
      m_bValueChanged = TRUE;
      _tEarlyNor.u32RvcContrastNight  = u32NewValue;
      ETG_TRACE_USR4(("vSet_Contrast_Night - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_Hue_Day(tU32 u32NewValue)
{
   if (_tEarlyNor.u32RvcHueDay != u32NewValue)
   {
      m_bValueChanged = TRUE;
      _tEarlyNor.u32RvcHueDay  = u32NewValue;
      ETG_TRACE_USR4(("vSet_Hue_Day - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_Hue_Night(tU32 u32NewValue)
{
   if (_tEarlyNor.u32RvcHueNight != u32NewValue)
   {
      m_bValueChanged = TRUE;
      _tEarlyNor.u32RvcHueNight  = u32NewValue;
      ETG_TRACE_USR4(("vSet_Hue_Night - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_BacklightDimming_Day(tU32 u32NewValue)
{
//todo
   //m_bValueChanged = TRUE;
   (tVoid) u32NewValue;
}

tVoid dispvidctrl_tclPersistentData::vSet_BacklightDimming_Night(tU32 u32NewValue)
{
//todo
   //m_bValueChanged = TRUE;
   (tVoid) u32NewValue;
}

tVoid dispvidctrl_tclPersistentData::vSet_SPMAutoMode(tU32 u32NewValue)
{
   if (_tEarlyNor.u32SpmAutoMode != u32NewValue)
   {
      m_bValueChanged = TRUE;
      _tEarlyNor.u32SpmAutoMode  = u32NewValue;
      ETG_TRACE_USR4(("vSet_SPMAutoMode - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_RVCLowSpeedThreshold(tU32 u32NewValue)
{
   if (_tEarlyNorForce.u32RvcLowSpeedThreshold != u32NewValue)
   {
      m_bForceValueChanged = TRUE;
      _tEarlyNorForce.u32RvcLowSpeedThreshold  = u32NewValue;
      ETG_TRACE_USR4(("vSet_RVCLowSpeedThreshold - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_RVCHighSpeedThreshold(tU32 u32NewValue)
{
   if (_tEarlyNorForce.u32RvcHighSpeedThreshold != u32NewValue)
   {
      m_bForceValueChanged = TRUE;
      _tEarlyNorForce.u32RvcHighSpeedThreshold  = u32NewValue;
      ETG_TRACE_USR4(("vSet_RVCHighSpeedThreshold - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_RVCReverseOffGuardTime(tU32 u32NewValue)
{
   if (_tEarlyNorForce.u32RvcReverseOffGuardTime != u32NewValue)
   {
      m_bForceValueChanged = TRUE;
      _tEarlyNorForce.u32RvcReverseOffGuardTime  = u32NewValue;
      ETG_TRACE_USR4(("vSet_RVCReverseOffGuardTime - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_WarningTextLanguage(tU32 u32NewValue)
{
   if (_tEarlyNor.u32GuidelineWarningLanguage != u32NewValue)
   {
      m_bValueChanged = TRUE;
      _tEarlyNor.u32GuidelineWarningLanguage  = u32NewValue;
      ETG_TRACE_USR4(("vSet_WarningTextLanguage - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_WarningTextVisibility(tU32 u32NewValue)
{
   if (_tEarlyNorForce.u32GuidelineWarningText != u32NewValue)
   {
      m_bForceValueChanged = TRUE;
      _tEarlyNorForce.u32GuidelineWarningText  = u32NewValue;
      ETG_TRACE_USR4(("vSet_WarningTextVisibility - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_WarningTextBackground(tU32 u32NewValue)
{
   if (_tEarlyNorForce.u32GuidelineBlackWarningTextBackground != u32NewValue)
   {
      m_bForceValueChanged = TRUE;
      _tEarlyNorForce.u32GuidelineBlackWarningTextBackground  = u32NewValue;
      ETG_TRACE_USR4(("vSet_WarningTextBackground - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_GuidelineCameraType(tU32 u32NewValue) // RVCLensParameterSet
{
   if (_tEarlyNorForce.u32GuidelineCameraType != u32NewValue)
   {
      m_bForceValueChanged = TRUE;
      _tEarlyNorForce.u32GuidelineCameraType  = u32NewValue;
      ETG_TRACE_USR4(("vSet_GuidelineCameraType - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_GuidelineVehicleParameter(const tU8* GuidelineVehicleParameter)
{
   if ( 0 != memcmp(&_tEarlyNorForce.au8GuidelineVehicleParameter[0], GuidelineVehicleParameter, (tU32) 80))
   {
      m_bForceValueChanged = TRUE;
      (tVoid) OSAL_pvMemoryCopy(&_tEarlyNorForce.au8GuidelineVehicleParameter[0], GuidelineVehicleParameter, (tU32) 80);  //array with 80 bytes
      ETG_TRACE_USR4(("vSet_GuidelineVehicleParameter - Changing to ConfigStringVersion %d ", _tEarlyNorForce.au8GuidelineVehicleParameter[0]));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_GuideLineVisibilityMode(tU32 u32NewValue)
{
   if (_tEarlyNor.u32GuidelineVisibilityMode != u32NewValue)
   {
      m_bValueChanged = TRUE;
      _tEarlyNor.u32GuidelineVisibilityMode  = u32NewValue;
      ETG_TRACE_USR4(("vSet_GuidelineVisibilityMode - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_CameraSystemType(tU32 u32NewValue) // RVC, AVM ...
{
   if (_tEarlyNorForce.u32GuidelineCameraSystemType != u32NewValue)
   {
      m_bForceValueChanged = TRUE;
      _tEarlyNorForce.u32GuidelineCameraSystemType  = u32NewValue;
      ETG_TRACE_USR4(("vSet_CameraSystemType - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_Language_Avm(tU32 u32NewValue)
{
   if (_tEarlyNor.u8AvmLanguage != (tU8) u32NewValue)
   {
      m_bValueChanged = TRUE;
      _tEarlyNor.u8AvmLanguage  = (tU8) u32NewValue;
      ETG_TRACE_USR4(("vSet_Language_Avm - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_Brand(tU32 u32NewValue)
{
   if (_tEarlyNorForce.u8EarlyBrand != (tU8) u32NewValue)
   {
      m_bForceValueChanged = TRUE;
      _tEarlyNorForce.u8EarlyBrand  = (tU8) u32NewValue;
      ETG_TRACE_USR4(("vSet_Brand - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_VehicleType(tU16 u16NewValue)
{
   if (_tEarlyNorForce.u16VehicleType != u16NewValue)
   {
      m_bForceValueChanged = TRUE;
      _tEarlyNorForce.u16VehicleType  = u16NewValue;
      ETG_TRACE_USR4(("vSet_VehicleType - Changing to %d", u16NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_OpeningAnimation(tU32 u32NewValue)
{
   if (_tEarlyNorForce.u8EarlyOpeningAnimation != (tU8) u32NewValue)
   {
      m_bForceValueChanged = TRUE;
      _tEarlyNorForce.u8EarlyOpeningAnimation  = (tU8) u32NewValue;
      ETG_TRACE_USR4(("vSet_OpeningAnimation - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_DisplayAspectRatio(tU32 u32NewValue)
{
   if (_tEarlyNorForce.u8EarlyDisplayAspectRatio != (tU8) u32NewValue)
   {
      m_bForceValueChanged = TRUE;
      _tEarlyNorForce.u8EarlyDisplayAspectRatio  = (tU8) u32NewValue;
      ETG_TRACE_USR4(("vSet_DisplayAspectRatio - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_DestinationRegion(tU32 u32NewValue)
{
   if (_tEarlyNorForce.u16EarlyDestinationRegion != (tU8) u32NewValue)
   {
      m_bForceValueChanged = TRUE;
      _tEarlyNorForce.u16EarlyDestinationRegion  = (tU8) u32NewValue;
      ETG_TRACE_USR4(("vSet_DestinationRegion - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_CameraConnectionType(tU32 u32NewValue)
{
   if (_tEarlyNorForce.u8CameraConnectionType != (tU8) u32NewValue)
   {
      m_bForceValueChanged = TRUE;
      _tEarlyNorForce.u8CameraConnectionType  = (tU8) u32NewValue;
      ETG_TRACE_USR4(("vSet_CameraConnectionType - Changing to %d", u32NewValue));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_SteeringPosition(tU32 u32NewValue)
{
    if (_tEarlyNorForce.bLeftHandSteeringPosition != (tU8) u32NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.bLeftHandSteeringPosition  = (tU8) u32NewValue;
       ETG_TRACE_USR4(("vSet_SteeringPosition - Changing to %d", u32NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_GuidelineVisibility(tBool bNewValue)
{
    if (_tEarlyNorForce.bGuidelineVisibility != bNewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.bGuidelineVisibility = bNewValue;
       ETG_TRACE_USR4(("vSet_GuidelineVisibility - Changing to %d", bNewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_CameraWidth(tU16 u16NewValue)
{
    if (_tEarlyNorForce.u16CameraWidth != (tU16) u16NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16CameraWidth  = (tU16) u16NewValue;
       ETG_TRACE_USR4(("vSet_CameraWidth - Changing to %d", u16NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_CameraHeight(tU16 u16NewValue)
{
    if (_tEarlyNorForce.u16CameraHeight != (tU16) u16NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16CameraHeight  = (tU8) u16NewValue;
       ETG_TRACE_USR4(("vSet_CameraHeight - Changing to %d", u16NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_CameraXOffset(tU16 u16NewValue)
{
    if (_tEarlyNorForce.u16CameraXOffset != (tU16) u16NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16CameraXOffset  = (tU8) u16NewValue;
       ETG_TRACE_USR4(("vSet_CameraXOffset - Changing to %d", u16NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_CameraYOffset(tU16 u16NewValue)
{
    if (_tEarlyNorForce.u16CameraYOffset != (tU16) u16NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16CameraYOffset  = (tU8) u16NewValue;
       ETG_TRACE_USR4(("vSet_CameraYOffset - Changing to %d", u16NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_DisplayType(tU8 u8NewValue)
{
    if (_tEarlyNorForce.u8DisplayType != (tU8) u8NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u8DisplayType  = (tU8) u8NewValue;
       ETG_TRACE_USR4(("vSet_DisplayType - Changing to %d", u8NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_Display1Width(tU16 u16NewValue)
{
    if (_tEarlyNorForce.u16Display1Width != (tU16) u16NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16Display1Width  = (tU16) u16NewValue;
       ETG_TRACE_USR4(("vSet_Display1Width - Changing to %d", u16NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_Display1Height(tU16 u16NewValue)
{
    if (_tEarlyNorForce.u16Display1Height != (tU16) u16NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16Display1Height  = (tU16) u16NewValue;
       ETG_TRACE_USR4(("vSet_Display1Height - Changing to %d", u16NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_Display1XOffset(tU16 u16NewValue)
{
    if (_tEarlyNorForce.u16Display1XOffset != (tU16) u16NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16Display1XOffset  = (tU16) u16NewValue;
       ETG_TRACE_USR4(("vSet_Display1XOffset - Changing to %d", u16NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_Display1YOffset(tU16 u16NewValue)
{
    if (_tEarlyNorForce.u16Display1YOffset != (tU16) u16NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16Display1YOffset  = (tU16) u16NewValue;
       ETG_TRACE_USR4(("vSet_Display1YOffset - Changing to %d", u16NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_Display2Width(tU16 u16NewValue)
{
    if (_tEarlyNorForce.u16Display2Width != (tU16) u16NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16Display2Width  = (tU8) u16NewValue;
       ETG_TRACE_USR4(("vSet_Display2Width - Changing to %d", u16NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_Display2Height(tU16 u16NewValue)
{
    if (_tEarlyNorForce.u16Display2Height != (tU16) u16NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16Display2Height  = (tU16) u16NewValue;
       ETG_TRACE_USR4(("vSet_Display2Height - Changing to %d", u16NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_Display2XOffset(tU16 u16NewValue)
{
    if (_tEarlyNorForce.u16Display2XOffset != (tU16) u16NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16Display2XOffset  = (tU16) u16NewValue;
       ETG_TRACE_USR4(("vSet_Display2XOffset - Changing to %d", u16NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_Display2YOffset(tU16 u16NewValue)
{
    if (_tEarlyNorForce.u16Display2YOffset != (tU16) u16NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16Display2YOffset  = (tU16) u16NewValue;
       ETG_TRACE_USR4(("vSet_Display2YOffset - Changing to %d", u16NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_DisplayOrientation(tU8 u8NewValue)
{
    if (_tEarlyNorForce.u8EarlyDisplayOrientation != (tU8) u8NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u8EarlyDisplayOrientation  = (tU8) u8NewValue;
       ETG_TRACE_USR4(("vSet_DisplayOrientation - Changing to %d", u8NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_VCANDiversity(tU8 u8NewValue)
{
    if (_tEarlyNorForce.u8VCANDiversity != (tU8) u8NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u8VCANDiversity  = (tU8) u8NewValue;
	   #ifdef VARIANT_S_FTR_ENABLE_SMART
	   _tEarlyNorForce.u8VCANDiversity  = 1;
	   #endif
       ETG_TRACE_USR4(("vSet_VCANDiversity - Changing to %d", u8NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_CameraImageMirror(tU8 u8NewValue)
{
    if (_tEarlyNorForce.u8CameraImageMirror != (tU8) u8NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u8CameraImageMirror  = (tU8) u8NewValue;
       ETG_TRACE_USR4(("vSet_CameraImageMirror - Changing to %d", u8NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_WelcomeSequence(tU8 u8NewValue)
{
    if (_tEarlyNorForce.u8EarlyWelcomeSequence != (tU8) u8NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u8EarlyWelcomeSequence  = (tU8) u8NewValue;
       ETG_TRACE_USR4(("vSet_WelcomeSequence - Changing to %d", u8NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_Resolution(const tU8* Resolution)
{
   if ( 0 != memcmp(&_tEarlyNorForce.au8EarlyResolution[0], Resolution, (tU32) 32))
   {
      m_bForceValueChanged = TRUE;
      (tVoid) OSAL_pvMemoryCopy(&_tEarlyNorForce.au8EarlyResolution[0], Resolution, (tU32) 32);  //array with 32 bytes
      ETG_TRACE_USR4(("vSet_Resolution - Changing to Resolution %s ", _tEarlyNorForce.au8EarlyResolution));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_DisplayOrder(const tU8* DisplayOrder)
{
   ETG_TRACE_FATAL(("vSet_DisplayOrder - Received DisplayOrder %d, %d, %d, %d ", DisplayOrder[0], DisplayOrder[1], DisplayOrder[2], DisplayOrder[3]));
   ETG_TRACE_FATAL(("vSet_DisplayOrder - Current DisplayOrder %d, %d, %d, %d ", _tEarlyNorForce.au8EarlyDisplayOrder[0], _tEarlyNorForce.au8EarlyDisplayOrder[1], _tEarlyNorForce.au8EarlyDisplayOrder[2], _tEarlyNorForce.au8EarlyDisplayOrder[3]));
   if ( 0 != memcmp(&_tEarlyNorForce.au8EarlyDisplayOrder[0], DisplayOrder, (tU32) 4))
   {
      m_bForceValueChanged = TRUE;
      (tVoid) OSAL_pvMemoryCopy(&_tEarlyNorForce.au8EarlyDisplayOrder[0], DisplayOrder, (tU32) 4);  //array with 4 bytes
      ETG_TRACE_FATAL(("vSet_DisplayOrder - Changing to DisplayOrder %d, %d, %d, %d ", _tEarlyNorForce.au8EarlyDisplayOrder[0], _tEarlyNorForce.au8EarlyDisplayOrder[1], _tEarlyNorForce.au8EarlyDisplayOrder[2], _tEarlyNorForce.au8EarlyDisplayOrder[3]));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_FlushDesignConfigFile(const tU8* FlushDesignConfigFile)
{
   if ( 0 != memcmp(&_tEarlyNorForce.au8EarlyFlushDesignConfigFile[0], FlushDesignConfigFile, (tU32) 64))
   {
      m_bForceValueChanged = TRUE;
      (tVoid) OSAL_pvMemoryCopy(&_tEarlyNorForce.au8EarlyFlushDesignConfigFile[0], FlushDesignConfigFile, (tU32) 64);  //array with 64 bytes
      ETG_TRACE_USR4(("vSet_FlushDesignConfigFile - Changing to FlushDesignConfigFile %d ", _tEarlyNorForce.au8EarlyFlushDesignConfigFile[0]));
   }
}

tVoid dispvidctrl_tclPersistentData::vSet_Cropping_Up(tU8 u8NewValue)
{
    if (_tEarlyNorForce.u16VideoCropping_Up != (tU8) u8NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16VideoCropping_Up  = (tU8) u8NewValue;
       ETG_TRACE_USR4(("vSet_Cropping_Up - Changing to %d", u8NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_Cropping_Down(tU8 u8NewValue)
{
    if (_tEarlyNorForce.u16VideoCropping_Down != (tU8) u8NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16VideoCropping_Down  = (tU8) u8NewValue;
       ETG_TRACE_USR4(("vSet_Cropping_Down - Changing to %d", u8NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_Cropping_Left(tU8 u8NewValue)
{
    if (_tEarlyNorForce.u16VideoCropping_Left != (tU8) u8NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16VideoCropping_Left  = (tU8) u8NewValue;
       ETG_TRACE_USR4(("vSet_Cropping_Left - Changing to %d", u8NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_Cropping_Right(tU8 u8NewValue)
{
    if (_tEarlyNorForce.u16VideoCropping_Right != (tU8) u8NewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16VideoCropping_Right  = (tU8) u8NewValue;
       ETG_TRACE_USR4(("vSet_Cropping_Right - Changing to %d", u8NewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_Cropping_Set(tBool bNewValue)
{
    if (_tEarlyNorForce.bVideoCroppingSet != bNewValue)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.bVideoCroppingSet  = bNewValue;
       ETG_TRACE_USR4(("vSet_Cropping_Set - Changing to %d", bNewValue));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_SourceWidth(tU16& u16Value)
{
    if (_tEarlyNorForce.u16VideoSourceRectangle_Width != u16Value)
    {
        m_bForceValueChanged = TRUE;
        _tEarlyNorForce.u16VideoSourceRectangle_Width = u16Value;
        ETG_TRACE_USR4(("vSet_SourceWidth - Changing to %d", u16Value));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_SourceHeight(tU16& u16Value)
{
    if (_tEarlyNorForce.u16VideoSourceRectangle_Height != u16Value)
    {
        m_bForceValueChanged = TRUE;
        _tEarlyNorForce.u16VideoSourceRectangle_Height = u16Value;
        ETG_TRACE_USR4(("vSet_SourceHeight - Changing to %d", u16Value));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_SourceXOffset(tU16& u16Value)
{
    if (_tEarlyNorForce.u16VideoSourceRectangle_X != u16Value)
    {
        m_bForceValueChanged = TRUE;
        _tEarlyNorForce.u16VideoSourceRectangle_X = u16Value;
        ETG_TRACE_USR4(("vSet_SourceXOffset - Changing to %d", u16Value));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_SourceYOffset(tU16& u16Value)
{
    if (_tEarlyNorForce.u16VideoSourceRectangle_Y != u16Value)
    {
        _tEarlyNorForce.u16VideoSourceRectangle_Y = u16Value;
        m_bForceValueChanged = TRUE;
        ETG_TRACE_USR4(("vSet_SourceYOffset - Changing to %d", u16Value));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_DestinationWidth(tU16& u16Value)
{
    if (_tEarlyNorForce.u16VideoDestinationRectangle_Width != u16Value)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16VideoDestinationRectangle_Width = u16Value;
        ETG_TRACE_USR4(("vSet_DestinationWidth - Changing to %d", u16Value));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_DestinationHeight(tU16& u16Value)
{
    if (_tEarlyNorForce.u16VideoDestinationRectangle_Height != u16Value)
    {
        m_bForceValueChanged = TRUE;
        _tEarlyNorForce.u16VideoDestinationRectangle_Height = u16Value;
        ETG_TRACE_USR4(("vSet_DestinationHeight - Changing to %d", u16Value));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_DestinationXOffset(tU16& u16Value)
{
    if (_tEarlyNorForce.u16VideoDestinationRectangle_X != u16Value)
    {
        m_bForceValueChanged = TRUE;
        _tEarlyNorForce.u16VideoDestinationRectangle_X = u16Value;
        ETG_TRACE_USR4(("vSet_DestinationXOffset - Changing to %d", u16Value));
    }
}

tVoid dispvidctrl_tclPersistentData::vSet_DestinationYOffset(tU16& u16Value)
{
    if (_tEarlyNorForce.u16VideoDestinationRectangle_Y != u16Value)
    {
       m_bForceValueChanged = TRUE;
       _tEarlyNorForce.u16VideoDestinationRectangle_Y = u16Value;
       ETG_TRACE_USR4(("vSet_DestinationYOffset - Changing to %d", u16Value));
    }
}

/******************************************************************************/
/* Get Functions                                                              */
/******************************************************************************/
/**
*  \brief       Get value from persistent memory / data pool
*
*  \param       reference to tU32
*  \return      success state
*/
/******************************************************************************/
tBool dispvidctrl_tclPersistentData::bGetPersistent_BlackLevel_Day(tU32& u32Value) const
{
   u32Value = _tEarlyNor.u32RvcBlackLevelDay;
   ETG_TRACE_USR4(("vGetPersistentData - VideoBlackLevelDay [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_BlackLevel_Night(tU32& u32Value) const
{
   u32Value = _tEarlyNor.u32RvcBlackLevelNight;
   ETG_TRACE_USR4(("vGetPersistentData - VideoBlackLevelNight [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Brightness_Day(tU32& u32Value) const
{
   u32Value = _tEarlyNor.u32RvcBrightnessDay;
   ETG_TRACE_USR4(("vGetPersistentData - VideoBrightnessDay [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Brightness_Night(tU32& u32Value) const
{
   u32Value = _tEarlyNor.u32RvcBrightnessNight;
   ETG_TRACE_USR4(("vGetPersistentData - VideoBrightnessNight [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Colour_Day(tU32& u32Value) const
{
   u32Value = _tEarlyNor.u32RvcColourDay;
   ETG_TRACE_USR4(("vGetPersistentData - VideoColourDay [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Colour_Night(tU32& u32Value) const
{
   u32Value = _tEarlyNor.u32RvcColourNight;
   ETG_TRACE_USR4(("vGetPersistentData - VideoColourNight [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Contrast_Day(tU32& u32Value) const
{
   u32Value = _tEarlyNor.u32RvcContrastDay;
   ETG_TRACE_USR4(("vGetPersistentData - VideoContrastDay [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Contrast_Night(tU32& u32Value) const
{
   u32Value = _tEarlyNor.u32RvcContrastNight;
   ETG_TRACE_USR4(("vGetPersistentData - VideoContrastNight [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Hue_Day(tU32& u32Value) const
{
   u32Value = _tEarlyNor.u32RvcHueDay;
   ETG_TRACE_USR4(("vGetPersistentData - VideoHueDay [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Hue_Night(tU32& u32Value) const
{
   u32Value = _tEarlyNor.u32RvcHueNight;
   ETG_TRACE_USR4(("vGetPersistentData - VideoHueNight [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_BacklightDimming_Day(tU32& u32Value) const
{
   (tVoid) u32Value;
//todo
//   dp_tclDATASET_VD_EARLY_CONFIGRVCDimmingDay oDatapool;
//   tS32 res = oDatapool.s32GetData(u32Value);
//   ETG_TRACE_USR4(("vGetPersistentData - VideoDimmingDay [%d]", u32Value));
   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_BacklightDimming_Night(tU32& u32Value) const
{
   (tVoid) u32Value;
//todo
//   dp_tclDATASET_VD_EARLY_CONFIGRVCDimmingNight oDatapool;
//   tS32 res = oDatapool.s32GetData(u32Value);
//   ETG_TRACE_USR4(("vGetPersistentData - VideoDimmingNight [%d]", u32Value));
   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_SPMAutoMode(tU32& u32Value) const
{
   u32Value = _tEarlyNor.u32SpmAutoMode;
   ETG_TRACE_USR4(("vGetPersistentData - SPMAutoMode [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_RVCLowSpeedThreshold(tU32& u32Value) const
{
   u32Value = _tEarlyNorForce.u32RvcLowSpeedThreshold;
   ETG_TRACE_USR4(("vGetPersistentData - RVCLowSpeedThreshold [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_RVCHighSpeedThreshold(tU32& u32Value) const
{
   u32Value = _tEarlyNorForce.u32RvcHighSpeedThreshold;
   ETG_TRACE_USR4(("vGetPersistentData - RVCHighSpeedThreshold [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_RVCReverseOffGuardTime(tU32& u32Value) const
{
   u32Value = _tEarlyNorForce.u32RvcReverseOffGuardTime;
   ETG_TRACE_USR4(("vGetPersistentData - RVCReverseOffGuardTime [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_WarningTextLanguage(tU32& u32Value) const
{
   u32Value = _tEarlyNor.u32GuidelineWarningLanguage;
   ETG_TRACE_USR4(("vGetPersistentData - GuidelineWarningLanguage [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_WarningTextVisibility(tU32& u32Value) const
{
   u32Value = _tEarlyNorForce.u32GuidelineWarningText;
   ETG_TRACE_USR4(("vGetPersistentData - GuidelineWarningText [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_WarningTextBackground(tU32& u32Value) const
{
   u32Value = _tEarlyNorForce.u32GuidelineBlackWarningTextBackground;
   ETG_TRACE_USR4(("vGetPersistentData - GuidelineBlackWarningTextBackground [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_GuidelineCameraType(tU32& u32Value) const // RVCLensParameterSet
{
   u32Value = _tEarlyNorForce.u32GuidelineCameraType;
   ETG_TRACE_USR4(("vGetPersistentData - GuidelineCameraType [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_GuidelineVehicleParameter(tU8* GuidelineVehicleParameter) const  //array/structure with 84 bytes
{
   //array with 80 bytes
   (tVoid) OSAL_pvMemoryCopy(GuidelineVehicleParameter, &_tEarlyNorForce.au8GuidelineVehicleParameter[0], (tU32) 80);
   ETG_TRACE_USR4(("vGetPersistentData - GuidelineVehicleParameter  ConfigStringVersion [%d]", _tEarlyNorForce.au8GuidelineVehicleParameter[0]));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_GuideLineVisibilityMode(tU32& u32Value) const
{
   u32Value = _tEarlyNor.u32GuidelineVisibilityMode;
   ETG_TRACE_USR4(("vGetPersistentData - GuidelineVisibilityMode [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_CameraSystemType(tU32& u32Value) const // RVC, AVM ...
{
   u32Value = _tEarlyNorForce.u32GuidelineCameraSystemType;
   ETG_TRACE_USR4(("vGetPersistentData - GuidelineCameraSystemType [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Language_Avm(tU32& u32Value) const
{
   u32Value = (tU32) _tEarlyNor.u8AvmLanguage;
   ETG_TRACE_USR4(("bGetPersistent_Language_Avm [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Brand(tU32& u32Value) const
{
   u32Value = (tU32) _tEarlyNorForce.u8EarlyBrand;
   ETG_TRACE_USR4(("bGetPersistent_Brand [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_VehicleType(tU16& u16Value) const
{
   u16Value = (tU32) _tEarlyNorForce.u16VehicleType;
   ETG_TRACE_USR4(("bGetPersistent_VehicleType [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_OpeningAnimation(tU32& u32Value) const
{
   u32Value = (tU32) _tEarlyNorForce.u8EarlyOpeningAnimation;
   ETG_TRACE_USR4(("bGetPersistent_OpeningAnimation [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_DisplayAspectRatio(tU32& u32Value) const
{
   u32Value = (tU32) _tEarlyNorForce.u8EarlyDisplayAspectRatio;
   ETG_TRACE_USR4(("bGetPersistent_DisplayAspectRatio [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_DestinationRegion(tU32& u32Value) const
{
   u32Value = (tU32) _tEarlyNorForce.u16EarlyDestinationRegion;
   ETG_TRACE_USR4(("bGetPersistent_DestinationRegion [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_CameraConnectionType(tU32& u32Value) const
{
   u32Value = (tU32) _tEarlyNorForce.u8CameraConnectionType;
   ETG_TRACE_USR4(("bGetPersistent_CameraConnectionType [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_SteeringPosition(tU32& u32Value) const
{
   u32Value = (tU32) _tEarlyNorForce.bLeftHandSteeringPosition;
   ETG_TRACE_USR4(("bGetPersistent_SteeringPosition [%d]", u32Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_CameraWidth(tU16& u16Value) const
{
   u16Value = (tU16) _tEarlyNorForce.u16CameraWidth;
   ETG_TRACE_USR4(("bGetPersistent_CameraWidth [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_CameraHeight(tU16& u16Value) const
{
   u16Value = (tU16) _tEarlyNorForce.u16CameraHeight;
   ETG_TRACE_USR4(("bGetPersistent_CameraHeight [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_CameraXOffset(tU16& u16Value) const
{
   u16Value = (tU16) _tEarlyNorForce.u16CameraXOffset;
   ETG_TRACE_USR4(("bGetPersistent_CameraXOffset [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_CameraYOffset(tU16& u16Value) const
{
   u16Value = (tU16) _tEarlyNorForce.u16CameraYOffset;
   ETG_TRACE_USR4(("bGetPersistent_CameraYOffset [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_DisplayType(tU8& u8Value) const
{
   u8Value = (tU8) _tEarlyNorForce.u8DisplayType;
   ETG_TRACE_USR4(("bGetPersistent_DisplayType [%d]", u8Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Display1Width(tU16& u16Value) const
{
   u16Value = (tU16) _tEarlyNorForce.u16Display1Width;
   ETG_TRACE_USR4(("bGetPersistent_Display1Width [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Display1Height(tU16& u16Value) const
{
   u16Value = (tU16) _tEarlyNorForce.u16Display1Height;
   ETG_TRACE_USR4(("bGetPersistent_Display1Height [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Display1XOffset(tU16& u16Value) const
{
   u16Value = (tU16) _tEarlyNorForce.u16Display1XOffset;
   ETG_TRACE_USR4(("bGetPersistent_Display1XOffset [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Display1YOffset(tU16& u16Value) const
{
   u16Value = (tU16) _tEarlyNorForce.u16Display1YOffset;
   ETG_TRACE_USR4(("bGetPersistent_Display1YOffset [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Display2Width(tU16& u16Value) const
{
   u16Value = (tU16) _tEarlyNorForce.u16Display2Width;
   ETG_TRACE_USR4(("bGetPersistent_Display2Width [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Display2Height(tU16& u16Value) const
{
   u16Value = (tU16) _tEarlyNorForce.u16Display2Height;
   ETG_TRACE_USR4(("bGetPersistent_Display2Height [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Display2XOffset(tU16& u16Value) const
{
   u16Value = (tU16) _tEarlyNorForce.u16Display2XOffset;
   ETG_TRACE_USR4(("bGetPersistent_Display2XOffset [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Display2YOffset(tU16& u16Value) const
{
   u16Value = (tU16) _tEarlyNorForce.u16Display2YOffset;
   ETG_TRACE_USR4(("bGetPersistent_Display2YOffset [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_DisplayOrientation(tU8& u8Value) const
{
   u8Value = _tEarlyNorForce.u8EarlyDisplayOrientation;
   ETG_TRACE_USR4(("bGetPersistent_DisplayOrientation [%d]", u8Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_SourceWidth(tU16& u16Value) const
{
   u16Value = _tEarlyNorForce.u16VideoSourceRectangle_Width;
   ETG_TRACE_USR4(("bGetPersistent_SourceWidth [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_SourceHeight(tU16& u16Value) const
{
   u16Value = _tEarlyNorForce.u16VideoSourceRectangle_Height;
   ETG_TRACE_USR4(("bGetPersistent_SourceHeight [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_SourceXOffset(tU16& u16Value) const
{
   u16Value = _tEarlyNorForce.u16VideoSourceRectangle_X;
   ETG_TRACE_USR4(("bGetPersistent_SourceXOffset [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_SourceYOffset(tU16& u16Value) const
{
   u16Value = _tEarlyNorForce.u16VideoSourceRectangle_Y;
   ETG_TRACE_USR4(("bGetPersistent_SourceYOffset [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_DestinationWidth(tU16& u16Value) const
{
   u16Value = _tEarlyNorForce.u16VideoDestinationRectangle_Width;
   ETG_TRACE_USR4(("bGetPersistent_DestinationWidth [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_DestinationHeight(tU16& u16Value) const
{
   u16Value = _tEarlyNorForce.u16VideoDestinationRectangle_Height;
   ETG_TRACE_USR4(("bGetPersistent_DestinationHeight [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_DestinationXOffset(tU16& u16Value) const
{
   u16Value = _tEarlyNorForce.u16VideoDestinationRectangle_X;
   ETG_TRACE_USR4(("bGetPersistent_DestinationXOffset [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_DestinationYOffset(tU16& u16Value) const
{
   u16Value = _tEarlyNorForce.u16VideoDestinationRectangle_Y;
   ETG_TRACE_USR4(("bGetPersistent_DestinationYOffset [%d]", u16Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_VCANDiversity(tU8& u8Value) const
{
   u8Value = _tEarlyNorForce.u8VCANDiversity;
   #ifdef VARIANT_S_FTR_ENABLE_SMART
   u8Value = 1;
   #endif
   ETG_TRACE_USR4(("bGetPersistent_VCANDiversity [%d]", u8Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_CameraImageMirror(tU8& u8Value) const
{
   u8Value = _tEarlyNorForce.u8CameraImageMirror;
   ETG_TRACE_USR4(("bGetPersistent_CameraImageMirror [%d]", u8Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_WelcomeSequence(tU8& u8Value) const
{
   u8Value = _tEarlyNorForce.u8EarlyWelcomeSequence;
   ETG_TRACE_USR4(("bGetPersistent_WelcomeSequence [%d]", u8Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Resolution(tU8* Resolution) const  //array/structure with 32 bytes
{
   //array with 32 bytes
   (tVoid) OSAL_pvMemoryCopy(Resolution, &_tEarlyNorForce.au8EarlyResolution[0], (tU32) 32);
   ETG_TRACE_USR4(("vGetPersistentData - Resolution  [%d]", _tEarlyNorForce.au8EarlyResolution[0]));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_DisplayOrder(tU8* DisplayOrder) const  //array/structure with 4 bytes
{
   //array with 4 bytes
   (tVoid) OSAL_pvMemoryCopy(DisplayOrder, &_tEarlyNorForce.au8EarlyDisplayOrder[0], (tU32) 4);
   ETG_TRACE_USR4(("vGetPersistentData - DisplayOrder  [%d]", _tEarlyNorForce.au8EarlyDisplayOrder[0]));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_FlushDesignConfigFile(tU8* FlushDesignConfigFile) const  //array/structure with 64 bytes
{
   //array with 64 bytes
   (tVoid) OSAL_pvMemoryCopy(FlushDesignConfigFile, &_tEarlyNorForce.au8EarlyFlushDesignConfigFile[0], (tU32) 64);
   ETG_TRACE_USR4(("vGetPersistentData - FlushDesignConfigFile  [%d]", _tEarlyNorForce.au8EarlyFlushDesignConfigFile[0]));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Cropping_Up(tU8& u8Value) const
{
   u8Value = _tEarlyNorForce.u16VideoCropping_Up;
   ETG_TRACE_USR4(("bGetPersistent_Cropping_Up [%d]", u8Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Cropping_Down(tU8& u8Value) const
{
   u8Value = _tEarlyNorForce.u16VideoCropping_Down;
   ETG_TRACE_USR4(("bGetPersistent_Cropping_Down [%d]", u8Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Cropping_Left(tU8& u8Value) const
{
   u8Value = _tEarlyNorForce.u16VideoCropping_Left;
   ETG_TRACE_USR4(("bGetPersistent_Cropping_Left [%d]", u8Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Cropping_Right(tU8& u8Value) const
{
   u8Value = _tEarlyNorForce.u16VideoCropping_Right;
   ETG_TRACE_USR4(("bGetPersistent_Cropping_Right [%d]", u8Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGetPersistent_Cropping_Set(tU8& u8Value) const
{
   u8Value = _tEarlyNorForce.bVideoCroppingSet;
   ETG_TRACE_USR4(("bGetPersistent_Cropping_Set [%d]", u8Value));

   return(TRUE);
}

tBool dispvidctrl_tclPersistentData::bGet_VideoResizeIndex(tU8& u8Value) const
{ 
   u8Value = m_u8VideoResizeParamIndex; 
   return TRUE;
}
