/******************************************************************************/
/**
* \file    dispvidctrl_tclFsm_ReverseSignal.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann
* \remark  Scope     : A-IVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_FSM_REVERSESIGNAL_H_
#define _DISPVIDCTRL_TCL_FSM_REVERSESIGNAL_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_tclFsm_Base.h"

//***********************************************************************
//  CLASS
//***********************************************************************

class dispvidctrl_tclFsm_ReverseSignal: public dispvidctrl_tclFsm_Base
{
   public:

      // Available States -----------------------------------------------
      enum
      {
         eState_OFF                    = 0,
         eState_Debouncing_Level_1     = 1,
         eState_ON_Debouncing_Level_2  = 2,
         eState_ON                     = 3,
         eState_Max,
         eState_Invalid                = 0xFFFF
      };

      // Available Trigger ----------------------------------------------
      enum
      {
         eTrigger_SignalChange                = 0x00000001,
         eTrigger_StateVerificationTimeout    = 0x00000002,
         eTrigger_Level1Timeout               = 0x00000004,
         eTrigger_Level2Timeout               = 0x00000008,
    
         eTrigger_ReverseGpioHigh             = 0x00000010,
         eTrigger_AskForReverseDebouncedEvent = 0x00000020
      };

      static dispvidctrl_tclFsm_ReverseSignal* tclCreateInstance(dispvidctrl_tclControl_Rvc* poControl_Rvc);

      dispvidctrl_tclFsm_ReverseSignal();                                      // constructor
      dispvidctrl_tclFsm_ReverseSignal(dispvidctrl_tclControl_Rvc* poControl_Rvc);  // constructor
      virtual ~dispvidctrl_tclFsm_ReverseSignal();                             // destructor

      tVoid vNewTrigger(tU32 u32Trigger, tBool bTriggerState) const;
      tVoid vUpdateTriggerState(tU32 u32Trigger, tBool bTriggerState);

      // project specific configuration setting
      tVoid vSetDebouncingLevel1TimeInMs(tU32 u32DebouncingLevel1TimeInMs);
      tVoid vSetDebouncingLevel2TimeInMs(tU32 u32DebouncingLevel2TimeInMs);

      // debug support
      tVoid vTraceDebugInfo(tVoid);

   protected:
      virtual tVoid vStartFsmStateTimer(tU32 u32Time); // overwrites FsmBase class function
      virtual tVoid vStateChangeDetected(tVoid);
      //virtual tVoid vUpdateRelatedTrigger(tU32 u32Trigger);

   private:
      static tVoid vEntry_OFF(tVoid);
      static tVoid    vDo_OFF(tVoid);
      static tVoid vEntry_Debouncing_Level_1(tVoid);
      static tVoid vEntry_ON_Debouncing_Level_2(tVoid);
      static tVoid  vExit_ON_Debouncing_Level_2(tVoid);
      static tVoid vEntry_ON(tVoid);
      static tVoid    vDo_ON(tVoid);

      static OSAL_tpfCallback _pfCallbackTimer_FsmStateTimeout(tVoid* pArg);
      static OSAL_tpfCallback _pfCallbackTimer_DebounceLevel1(tVoid* pArg);
      static OSAL_tpfCallback _pfCallbackTimer_DebounceLevel2(tVoid* pArg);
      tBool  _bSetTimer_DebounceLevel1(OSAL_tMSecond msTimeout) const;
      tBool  _bSetTimer_DebounceLevel2(OSAL_tMSecond msTimeout) const;
      OSAL_tTimerHandle  m_hTimerHandle_FsmStateTimeout;
      OSAL_tTimerHandle  m_hTimerHandle_DebounceLevel1;
      OSAL_tTimerHandle  m_hTimerHandle_DebounceLevel2;

      static TFsmStateConf     aFsm_ReverseSignal_StateTable[eState_Max];
      static TStateTransitions aFsm_ReverseSignal_StateTransitionTable[];

      dispvidctrl_tclControl_Rvc*                   m_poControl_Rvc;
      static dispvidctrl_tclFsm_ReverseSignal*      m_poInstance;

      tBool  m_bStateTimeout;

      // configuration data
      tU32    m_u32DebounceLevel1Time; //[ms]
      tU32    m_u32DebounceLevel2Time; //[ms]
};


#endif // _DISPVIDCTRL_TCL_FSM_REVERSESIGNAL_H_

/*******************************************************************************
*                                       E O F
*******************************************************************************/

