/******************************************************************************/
/**
* \file    dispvidctrl_tclFsm_OnOff.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann
* \remark  Scope     : A-IVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_FSM_ONOFF_H_
#define _DISPVIDCTRL_TCL_FSM_ONOFF_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_tclFsm_Base.h"

//***********************************************************************
//  CLASS
//***********************************************************************

class dispvidctrl_tclFsm_OnOff: public dispvidctrl_tclFsm_Base
{
   public:

      // Available States -----------------------------------------------
      enum
      {
         eState_OFF_EARLY              = 0,
         eState_OFF                    = 1,
         eState_ON                     = 2,
         eState_Max,
         eState_Invalid                = 0xFFFF
      };

      // Available Trigger ----------------------------------------------
      enum
      {
         eTrigger_NONE                         = 0x00000000,

         eTrigger_STATE_VERIFICATION_TIMEOUT   = 0x00000001,
         eTrigger_HMI_AVAILABLE_FALSE          = 0x00000002,
         eTrigger_HMI_AVAILABLE_TRUE           = 0x00000004,
         eTrigger_VIDEO_STATUS_RECEIVED        = 0x00000008,

         eTrigger_APPLICATION_STATE_NOT_NORMAL = 0x00000010,
         eTrigger_APPLICATION_STATE_NORMAL     = 0x00000020,
         eTrigger_CRITICAL_VOLTAGE_START       = 0x00000040,
         eTrigger_CRITICAL_VOLTAGE_END         = 0x00000080,

         eTrigger_START                        = 0x00000100
      };

      static dispvidctrl_tclFsm_OnOff* tclCreateInstance(dispvidctrl_tclControl* poControl);

      dispvidctrl_tclFsm_OnOff();                              // default constructor
      dispvidctrl_tclFsm_OnOff(dispvidctrl_tclControl* poControl);  // constructor
      virtual ~dispvidctrl_tclFsm_OnOff();                     // destructor

      tVoid vNewTrigger(tU32 u32Trigger, tBool bTriggerState) const;
      tVoid vUpdateTriggerState(tU32 u32Trigger, tBool bTriggerState);

   protected:
      virtual tVoid vStartFsmStateTimer(tU32 u32Time); // overwrites FsmBase class function
      virtual tVoid vStateChangeDetected(tVoid);
      virtual tVoid vUpdateRelatedTrigger(tU32 u32Trigger);

   private:
      //static tVoid vEntry_OffEarly(tVoid);
      static tVoid    vDo_OffEarly(tVoid);
      //static tVoid  vExit_OffEarly(tVoid);
      static tVoid vEntry_Off(tVoid);
      static tVoid    vDo_Off(tVoid);
      //static tVoid  vExit_Off(tVoid);
      static tVoid vEntry_On(tVoid);
      static tVoid    vDo_On(tVoid);
      //static tVoid  vExit_On(tVoid);

      static OSAL_tpfCallback _pfCallbackTimer_FsmStateTimeout(tVoid* pArg);
      OSAL_tTimerHandle  m_hTimerHandle_FsmStateTimeout;

      static TFsmStateConf     aFsm_OnOff_StateTable[eState_Max];
      static TStateTransitions aFsm_OnOff_StateTransitionTable[];

      dispvidctrl_tclControl*           m_poControl;
      static dispvidctrl_tclFsm_OnOff*  m_poInstance;

      tBool  m_bStateTimeout;
      tBool  m_bEarly;
};


#endif // _DISPVIDCTRL_TCL_FSM_REVERSESIGNAL_H_

/*******************************************************************************
*                                       E O F
*******************************************************************************/

