/******************************************************************************/
/**
* \file    dispvidctrl_tclFsm_IpaSwitchOperation.cpp
* \ingroup
*
* \brief   state machine for IPA switch CAN signal behavior
*
* \remark  Copyright : (c) 2012 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann CM-AI/PJ-CB32
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/
/*
 *
 */


#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_tclControl_Avm.h"
#include "dispvidctrl_tclFsm_IpaSwitchOperation.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#ifndef ET_TRACE_INFO_ON // reference to define ET_TRACE_INFO_ON because of lint Info 750
// Info 750: prio2: local macro 'ET_TRACE_INFO_ON' not referenced
// (this lint error is related to the ETG framework and can't be solved within vd_rvc)
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_tclFsm_IpaSwitchOperation.cpp.trc.h"
#endif

#define ELEMENTE(array)       ((tU16)(sizeof(array)/sizeof(array[0])))

#define DISPVIDCTRL_RVC_TRACE_ID_FSM_IPASWITCHOPERATION 0x07

//#define VD_RVC_FSM_IPASWITCHOPERATION_SENDWAIT_TIME_IN_MS  12


dispvidctrl_tclFsm_IpaSwitchOperation*   dispvidctrl_tclFsm_IpaSwitchOperation::m_poInstance  = OSAL_NULL;

/*******************************************************************************
*                                  STATE TABLE
*******************************************************************************/
dispvidctrl_tclFsm_IpaSwitchOperation::TFsmStateConf dispvidctrl_tclFsm_IpaSwitchOperation::aFsm_IpaSwitchOperation_StateTable[eState_Max] =
{
      {
            eState_ReadyForSwitchOperation,
            0,                                            //u32Timeout
            NULL,                                         //tFsmStateEntryFunc
            NULL,                                         //tFsmStateReachedFunc
            NULL,                                         //tFsmStateExitFunc
      },
      {
            eState_Send_NoSwitchOperation,
            12,                                           //u32Timeout
            vEntry_Send_NoSwitchOperation,                //tFsmStateEntryFunc
            NULL,                                         //tFsmStateReachedFunc
            NULL,                                         //tFsmStateExitFunc
      },
      {
            eState_Send_SwitchOperated_KeyValue,
            12,                                           //u32Timeout
            vEntry_Send_SwitchOperated_KeyValue,          //tFsmStateEntryFunc
            NULL,                                         //tFsmStateReachedFunc
            NULL,                                         //tFsmStateExitFunc
      },
      {
            eState_ReadyForSwitchAndLongPressOperation,
            0,                                            //u32Timeout
            NULL,                                         //tFsmStateEntryFunc
            NULL,                                         //tFsmStateReachedFunc
            NULL,                                         //tFsmStateExitFunc
      },
      {
            eState_Send_LongPressOperation,
            12,                                           //u32Timeout
            vEntry_Send_LongPressOperation,               //tFsmStateEntryFunc
            NULL,                                         //tFsmStateReachedFunc
            NULL,                                         //tFsmStateExitFunc
      },
      {
            eState_ReadyForSwitchAndNoLongPressOperation,
            0,                                            //u32Timeout
            NULL,                                         //tFsmStateEntryFunc
            NULL,                                         //tFsmStateReachedFunc
            NULL,                                         //tFsmStateExitFunc
      },
      {
            eState_Send_NoLongPressOperation,
            12,                                           //u32Timeout
            vEntry_Send_NoLongPressOperation,             //tFsmStateEntryFunc
            NULL,                                         //tFsmStateReachedFunc
            NULL,                                         //tFsmStateExitFunc
      }
};

/*******************************************************************************
 *                             STATE TRANSITION TABLE
 *******************************************************************************/
dispvidctrl_tclFsm_IpaSwitchOperation::TStateTransitions dispvidctrl_tclFsm_IpaSwitchOperation::aFsm_IpaSwitchOperation_StateTransitionTable[] =
{
      // eState_ReadyForNewKey
      {   100,                                  // transitionId
            eState_ReadyForSwitchOperation,     // current FSM State
            eTrigger_KeyPress,                  // trigger update
            FSM_DONT_CARE,                      // current active trigger(s)
            FSM_DONT_CARE,                      // current not active trigger(s)
            eState_Send_NoSwitchOperation       // next FSM State
      },

      // eState_Send_NoSwitchOperation
      {   200,                                  // transitionId
            eState_Send_NoSwitchOperation,      // current FSM State
            eTrigger_StateTimeout,              // trigger update
            FSM_DONT_CARE,                      // current active trigger(s)
            FSM_DONT_CARE,                      // current not active trigger(s)
            eState_Send_SwitchOperated_KeyValue // next FSM State
      },

      // eState_Send_SwitchOperated_Keyvalue
      {   300,                                   // transitionId
            eState_Send_SwitchOperated_KeyValue, // current FSM State
            eTrigger_StateTimeout,               // trigger update
            eTrigger_KeyLongPress,               // current active trigger(s)
            FSM_DONT_CARE,                       // current not active trigger(s)
            eState_ReadyForSwitchOperation       // next FSM State
      },
      {   301,                                   // transitionId
            eState_Send_SwitchOperated_KeyValue, // current FSM State
            eTrigger_StateTimeout,               // trigger update
            eTrigger_KeyRelease,                 // current active trigger(s)
            FSM_DONT_CARE,                       // current not active trigger(s)
            eState_ReadyForSwitchOperation       // next FSM State
      },
      {   302,                                   // transitionId
            eState_Send_SwitchOperated_KeyValue, // current FSM State
            eTrigger_StateTimeout,               // trigger update
            eTrigger_KeyPress,                   // current active trigger(s)
            FSM_DONT_CARE,                       // current not active trigger(s)
            eState_Send_NoSwitchOperation        // next FSM State
      },
      {   303,                                   // transitionId
            eState_Send_SwitchOperated_KeyValue, // current FSM State
            eTrigger_StateTimeout,               // trigger update
            FSM_DONT_CARE,                       // current active trigger(s)
            FSM_DONT_CARE,                       // current not active trigger(s)
            eState_ReadyForSwitchAndLongPressOperation // next FSM State
      },

      // eState_ReadyForSwitchAndLongPressOperation
      {   400,                                   // transitionId
            eState_ReadyForSwitchAndLongPressOperation, // current FSM State
            eTrigger_KeyLongPress,               // trigger update
            FSM_DONT_CARE,                       // current active trigger(s)
            FSM_DONT_CARE,                       // current not active trigger(s)
            eState_Send_LongPressOperation       // next FSM State
      },
      {   401,                                   // transitionId
            eState_ReadyForSwitchAndLongPressOperation, // current FSM State
            eTrigger_KeyRelease,                 // trigger update
            FSM_DONT_CARE,                       // current active trigger(s)
            FSM_DONT_CARE,                       // current not active trigger(s)
            eState_ReadyForSwitchOperation       // next FSM State
      },
      {   402,                                   // transitionId
            eState_ReadyForSwitchAndLongPressOperation, // current FSM State
            eTrigger_KeyPress,                   // trigger update
            FSM_DONT_CARE,                       // current active trigger(s)
            FSM_DONT_CARE,                       // current not active trigger(s)
            eState_Send_NoSwitchOperation        // next FSM State
      },

      // eState_Send_LongPressOperation
      {   500,                                  // transitionId
            eState_Send_LongPressOperation,     // current FSM State
            eTrigger_StateTimeout,              // trigger update
            eTrigger_KeyLongPress,              // current active trigger(s)
            FSM_DONT_CARE,                      // current not active trigger(s)
            eState_Send_NoLongPressOperation    // next FSM State
      },
      {   501,                                  // transitionId
            eState_Send_LongPressOperation,     // current FSM State
            eTrigger_StateTimeout,              // trigger update
            eTrigger_KeyRelease,                // current active trigger(s)
            FSM_DONT_CARE,                      // current not active trigger(s)
            eState_Send_NoLongPressOperation    // next FSM State
      },
      {   502,                                  // transitionId
            eState_Send_LongPressOperation,     // current FSM State
            eTrigger_StateTimeout,              // trigger update
            eTrigger_KeyPress,                  // current active trigger(s)
            FSM_DONT_CARE,                      // current not active trigger(s)
            eState_Send_NoSwitchOperation       // next FSM State
      },
      {   503,                                  // transitionId
            eState_Send_LongPressOperation,     // current FSM State
            eTrigger_StateTimeout,              // trigger update
            FSM_DONT_CARE,                      // current active trigger(s)
            FSM_DONT_CARE,                      // current not active trigger(s)
            eState_ReadyForSwitchAndNoLongPressOperation  // next FSM State
      },

      // eState_ReadyForSwitchAndNoLongPressOperation
      {   600,                                  // transitionId
            eState_ReadyForSwitchAndNoLongPressOperation,     // current FSM State
            eTrigger_KeyLongPress,              // trigger update
            FSM_DONT_CARE,                       // current active trigger(s)
            FSM_DONT_CARE,                      // current not active trigger(s)
            eState_Send_NoLongPressOperation    // next FSM State
      },
      {   601,                                  // transitionId
            eState_ReadyForSwitchAndNoLongPressOperation,     // current FSM State
            eTrigger_KeyRelease,                // trigger update
            FSM_DONT_CARE,                      // current active trigger(s)
            FSM_DONT_CARE,                      // current not active trigger(s)
            eState_Send_NoLongPressOperation    // next FSM State
      },
      {   602,                                  // transitionId
            eState_ReadyForSwitchAndNoLongPressOperation,     // current FSM State
            eTrigger_KeyPress,                  // trigger update
            FSM_DONT_CARE,                      // current active trigger(s)
            FSM_DONT_CARE,                      // current not active trigger(s)
            eState_Send_NoSwitchOperation       // next FSM State
      },

      // eState_Send_NoLongPressOperation
      {   700,                                  // transitionId
            eState_Send_NoLongPressOperation,   // current FSM State
            eTrigger_StateTimeout,              // trigger update
            eTrigger_KeyRelease,                // current active trigger(s)
            FSM_DONT_CARE,                      // current not active trigger(s)
            eState_ReadyForSwitchOperation      // next FSM State
      },
      {   701,                                  // transitionId
            eState_Send_NoLongPressOperation,   // current FSM State
            eTrigger_StateTimeout,              // trigger update
            eTrigger_KeyPress,                  // current active trigger(s)
            FSM_DONT_CARE,                      // current not active trigger(s)
            eState_Send_NoSwitchOperation       // next FSM State
      },
      {   702,                                  // transitionId
            eState_Send_NoLongPressOperation,   // current FSM State
            eTrigger_StateTimeout,              // trigger update
            FSM_DONT_CARE,                      // current active trigger(s)
            FSM_DONT_CARE,                      // current not active trigger(s)
            eState_ReadyForSwitchOperation      // next FSM State
      },
};


/******************************************************************************/
/* FUNCTION     dispvidctrl_tclFsm_IpaSwitchOperation                              */
/******************************************************************************/
/**
*  \brief       Constructor
*
*
*
*  \param       pointer to main application
*               ahl_tclFsmBase( tU32 u32InitFsmSTate,
*                               tU32 u32MaxTransitionEntry,
*                               TStateTransitions* paFsmTransitionTable,
*                               tU32 u32MaxStateEntry,
*                               FsmStateConf* paFsmStateTable,
*                               tU32 u32TraceClass);
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclFsm_IpaSwitchOperation::dispvidctrl_tclFsm_IpaSwitchOperation(dispvidctrl_tclControl_Avm* poMain)
: dispvidctrl_tclFsm_Base(
      eState_ReadyForSwitchOperation,
     ELEMENTE(aFsm_IpaSwitchOperation_StateTransitionTable), aFsm_IpaSwitchOperation_StateTransitionTable,
     ELEMENTE(aFsm_IpaSwitchOperation_StateTable)          , aFsm_IpaSwitchOperation_StateTable,
     (tU32) TR_CLASS_DISPVIDCTRL_APPLICATION,
     DISPVIDCTRL_RVC_TRACE_ID_FSM_IPASWITCHOPERATION)
, m_hTimerHandle_FsmStateTimeout(OSAL_C_INVALID_HANDLE)
, m_poControl_Avm(poMain)
, m_bStateTimeout(FALSE)
, m_u8KeyValue_Trigger(0)
, m_u8KeyValue_SwitchOperation(0)
, m_u8KeyValue_LongPressSwitchOperation(0)
{
   // create timer for FSM state timeouts
   // used to cover minimum CAN message to message time distance
   if( OSAL_s32TimerCreate( (OSAL_tpfCallback)_pfCallbackTimer_FsmStateTimeout, (tPVoid)this, &m_hTimerHandle_FsmStateTimeout) != OSAL_OK)
   {
      ETG_TRACE_USR4(("ERROR - Could not create FSM timer!"));
      m_hTimerHandle_FsmStateTimeout = OSAL_C_INVALID_HANDLE;
   }
}


/******************************************************************************/
/* FUNCTION     ~dispvidctrl_tclFsm_IpaSwitchOperation                             */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclFsm_IpaSwitchOperation::~dispvidctrl_tclFsm_IpaSwitchOperation(tVoid)
{
   // delete timers
   if (OSAL_C_INVALID_HANDLE != m_hTimerHandle_FsmStateTimeout)
   {
      OSAL_s32TimerSetTime(m_hTimerHandle_FsmStateTimeout, 0, 0);
      OSAL_s32TimerDelete(m_hTimerHandle_FsmStateTimeout);
   }

   m_poInstance = NULL;
   m_poControl_Avm = NULL;
}


/******************************************************************************/
/* FUNCTION     tclCreateInstance                                             */
/******************************************************************************/
/**
*  \brief       Create instance (singleton pattern)
*
*  \param       pointer to main application
*  \return      pointer to instance
*/
/******************************************************************************/
dispvidctrl_tclFsm_IpaSwitchOperation* dispvidctrl_tclFsm_IpaSwitchOperation::tclCreateInstance(dispvidctrl_tclControl_Avm* poMain)
{
   if (m_poInstance == NULL)
   {
      m_poInstance = OSAL_NEW dispvidctrl_tclFsm_IpaSwitchOperation(poMain);
   }
   return m_poInstance;
}


/******************************************************************************/
/* FUNCTION     vNewTrigger                                                   */
/******************************************************************************/
/**
*  \brief       To be called to enter a new Trigger
*
*  \param       Trigger and State
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_IpaSwitchOperation::vNewTrigger(tU32 u32Trigger, tBool bTriggerState, tU8 u8Key)
{
   m_u8KeyValue_Trigger = u8Key;

   if (NULL != m_poInstance)
   {
       m_poInstance->u32CalcNewFsmState(u32Trigger, bTriggerState);
   }
}


/******************************************************************************/
/* FUNCTION     vStateChangeDetected                                          */
/******************************************************************************/
/**
*  \brief       called when a state change happens
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_IpaSwitchOperation::vStateChangeDetected(tVoid)
{
   if (NULL != m_poInstance)
   {
      m_poInstance->vTraceStatusInfo(0);
   }

   if (NULL != m_poControl_Avm)
   {
      //m_poControl_Avm->vPostEvent(PDC_EV_PDC_CONFIG_CHANGE);
   }
   return;
}


/******************************************************************************/
/* FUNCTION     _pfCallbackTimer_FsmStateTimeout                              */
/******************************************************************************/
/**
*  \brief
*
*  \param       pArg - pointer to this class
*  \return      none
*/
/******************************************************************************/
OSAL_tpfCallback dispvidctrl_tclFsm_IpaSwitchOperation::_pfCallbackTimer_FsmStateTimeout(tVoid* pArg)
{
   (tVoid) pArg;

   //ETG_TRACE_USR4(("  ====>>  : _pfCallbackTimer_FsmStateTimeout()"));

   //eTrigger_StateTimeout
   if (   (m_poInstance)
           && (m_poInstance->m_poControl_Avm))
   {
       m_poInstance->m_poControl_Avm->vHandleFsmOutEvent_IpaSwitchOperation(FSM_IPASWITCHOPERATION_OUT__FSM_IPASWITCHOPERATION_INPUT_EVENT
                                                                            , (tU32) eTrigger_StateTimeout);
   }

   return 0;
};


/******************************************************************************/
/* FUNCTION     vStartFsmStateTimer                                           */
/******************************************************************************/
/**
*  \brief       start or stop the timer
*
*  \param       timeout value
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_IpaSwitchOperation::vStartFsmStateTimer(tU32 u32Time)
{
   if(u32Time > 0)
   {
      OSAL_s32TimerSetTime(m_hTimerHandle_FsmStateTimeout, u32Time, 0);      // set Shutdown-Timer active
   }
   else
   {
      OSAL_s32TimerSetTime(m_hTimerHandle_FsmStateTimeout,       0, 0);     // reset Shutdown-Timer
   }
}


/******************************************************************************/
/* FUNCTION     vEntry_Send_NoSwitchOperation                                 */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_IpaSwitchOperation::vEntry_Send_NoSwitchOperation(tVoid)
{
   if (NULL != m_poInstance)
   {
      // clear Trigger states
      //  - eTrigger_KeyPress
      //  - eTrigger_KeyLongPress
      //  - eTrigger_KeyRelease
      m_poInstance->vUpdateTrigger((eTrigger_KeyPress | eTrigger_KeyLongPress | eTrigger_KeyRelease), FALSE);

      // hold new Key value
      m_poInstance->m_u8KeyValue_SwitchOperation = m_poInstance->m_u8KeyValue_Trigger;
      m_poInstance->m_u8KeyValue_LongPressSwitchOperation = m_poInstance->m_u8KeyValue_Trigger;

      // send IPA_SW_OPERATION_STATUS = 0 = No Switch Operation
      // and IPA_SW_LONG_PRESS = 0 = No long press operation
      if (m_poInstance->m_poControl_Avm)
      {
          m_poInstance->m_poControl_Avm->vHandleFsmOutEvent_IpaSwitchOperation(FSM_AVM_OUT__CSM_WRITE_IPA_SW_OPERATION_PRESS_STATUS, 0);
          m_poInstance->m_poControl_Avm->vHandleFsmOutEvent_IpaSwitchOperation(FSM_AVM_OUT__CSM_WRITE_IPA_SW_LONG_PRESS_STATUS, 0);
      }
   }
}


/******************************************************************************/
/* FUNCTION     vEntry_Send_SwitchOperated_KeyValue                           */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_IpaSwitchOperation::vEntry_Send_SwitchOperated_KeyValue(tVoid)
{
   if (NULL != m_poInstance)
   {
      // send IPA_SW_OPERATION_STATUS = m_u8KeyValue
      // and IPA_SW_LONG_PRESS = 0 = No long press operation

      if (m_poInstance->m_poControl_Avm)
      {
          m_poInstance->m_poControl_Avm->vHandleFsmOutEvent_IpaSwitchOperation(FSM_AVM_OUT__CSM_WRITE_IPA_SW_OPERATION_PRESS_STATUS, m_poInstance->m_u8KeyValue_SwitchOperation);
          m_poInstance->m_poControl_Avm->vHandleFsmOutEvent_IpaSwitchOperation(FSM_AVM_OUT__CSM_WRITE_IPA_SW_LONG_PRESS_STATUS, 0);
      }
   }
}


/******************************************************************************/
/* FUNCTION     vEntry_Send_LongPressOperation                                */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_IpaSwitchOperation::vEntry_Send_LongPressOperation(tVoid)
{
   if (NULL != m_poInstance)
   {
      if (m_poInstance->m_u8KeyValue_LongPressSwitchOperation == m_poInstance->m_u8KeyValue_Trigger) {
         //current long press trigger is for the key switch we did send before

         //clear trigger
         m_poInstance->vUpdateTrigger(eTrigger_KeyLongPress, FALSE);

         // send IPA_SW_OPERATION_STATUS = m_u8KeyValue
         // and IPA_SW_LONG_PRESS = 1 = Long press operation
         if (m_poInstance->m_poControl_Avm)
         {
        	 m_poInstance->m_poControl_Avm->vHandleFsmOutEvent_IpaSwitchOperation(FSM_AVM_OUT__CSM_WRITE_IPA_SW_OPERATION_PRESS_STATUS, m_poInstance->m_u8KeyValue_LongPressSwitchOperation);
             m_poInstance->m_poControl_Avm->vHandleFsmOutEvent_IpaSwitchOperation(FSM_AVM_OUT__CSM_WRITE_IPA_SW_LONG_PRESS_STATUS, 1);
         }
      }
      else {
         ETG_TRACE_USR4(("ERROR - Key Value different to the one of press operation -> no LongPressOperation CSM Signal written!"));
      }
   }
}


/******************************************************************************/
/* FUNCTION     vEntry_Send_NoLongPressOperation                              */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_IpaSwitchOperation::vEntry_Send_NoLongPressOperation(tVoid)
{
   if (NULL != m_poInstance)
   {
      // clear trigger
      m_poInstance->vUpdateTrigger((eTrigger_KeyLongPress | eTrigger_KeyRelease), FALSE);

      // send IPA_SW_OPERATION_STATUS = m_u8KeyValue
      // and IPA_SW_LONG_PRESS = 0 = No long press operation
      if (m_poInstance->m_poControl_Avm)
      {
          m_poInstance->m_poControl_Avm->vHandleFsmOutEvent_IpaSwitchOperation(FSM_AVM_OUT__CSM_WRITE_IPA_SW_OPERATION_PRESS_STATUS, m_poInstance->m_u8KeyValue_LongPressSwitchOperation);
          m_poInstance->m_poControl_Avm->vHandleFsmOutEvent_IpaSwitchOperation(FSM_AVM_OUT__CSM_WRITE_IPA_SW_LONG_PRESS_STATUS, 0);
      }
   }
}


/*******************************************************************************
*                                       E O F
*******************************************************************************/
