/*****************************************************************************
* FILE:         dispvidctrl_tclFsm_HmiAvm3.c
* PROJECT:      G3G project
* SW-COMPONENT: DisplayVideoController
* Template:     appl_tclFsm.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               User specific implementations are possible only between these tags:
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_tclFsm_HmiAvm3.h"
#include "dispvidctrl_tclControl_HmiAvm3.h"


// dispvidctrl_tclFsm_HmiAvm3_includes: user specific code start
// dispvidctrl_tclFsm_HmiAvm3_includes: user specific code end


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"  //Lint537 repeatedly included
#ifndef ET_TRACE_INFO_ON // reference to define ET_TRACE_INFO_ON because of lint Info 750
// Info 750: prio2: local macro 'ET_TRACE_INFO_ON' not referenced
// (this lint error is related to the ETG framework and can't be solved here)
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_tclFsm_HmiAvm3.cpp.trc.h"
#endif

#define DISPVIDCTRL_TRACE_ID_FSM_HMIAVM3   (tU8) 0x09


// general helper macros

#define FSM_NUM_ELEMENTS(array)   (sizeof(array)/sizeof(array[0]))


// global FSM settings

#define FSM_HMIAVM3_INIT_STATE                eStateHmiAvm3_OFF

#define FSM_HMIAVM3_USE_REENTER_TRANSITIONS   FALSE


// macros for the definition of states

#define FSM_NO_STATE_TIMEOUT           0
#define FSM_NO_ENTRY_FUNC              NULL
#define FSM_NO_DO_FUNC                 NULL
#define FSM_NO_EXIT_FUNC               NULL

// macros for the definition of transitions

#define FSM_TRANSITION_ID(x)           (x)

#define FSM_IN_STATE(x)                (x)
#define FSM_IN_ANY_STATE               FSM_DONT_CARE
#define FSM_ON_EVENT(x)                (x)
#define FSM_ON_ANY_EVENT               FSM_DONT_CARE
#define FSM_IF_GUARDS_TRUE(x)          (x)
#define FSM_IGNORE_TRUE_GUARDS         FSM_DONT_CARE
#define FSM_IF_GUARDS_FALSE(x)         (x)
#define FSM_IGNORE_FALSE_GUARDS        FSM_DONT_CARE

// generated in the config for 'true' state change transtions X => Y with X != Y
#define FSM_GOTO_STATE(x)              (x)

// generated in the config for transitions <any_state> => X (which may result in either exit+entry or do, depending on whether or not <any_state> == X). Cases 'go' or 'stay' get discriminated in base class.
#define FSM_GOTO_OR_STAY_IN_STATE(x)   (x)

// generated in the config for transitions <any_state> => <same_state>
#define FSM_STAY_INSIDE_CURR_STATE     FSM_STATE_ID_NONE

// generated in the config for transitions X => <same_state>
// (same effect as FSM_STAY_IN_CURRENT_STATE above, just a somewhat more expressive which exploits that the from-state X is known)
#define FSM_STAY_INSIDE_STATE(x)       FSM_STATE_ID_NONE

#define FSM_TRANSITION_ACTION(x)       (x)
#define FSM_TRANSITION_ACTION_PARAM(x) (tU32)(x)
#define FSM_NO_TRANSITION_ACTION       FSM_TRANSITION_ACTION_ID_NONE


// other shortcut macros

#define FSM_IS_FULLY_OPERATIONAL       (m_poInstance && m_poInstance->m_poControl)
#define FSM_CLEAR_TRIGGER(x)           m_poInstance->vUpdateTrigger((x), FALSE)
#define FSM_SET_TRIGGER(x)             m_poInstance->vUpdateTrigger((x), TRUE )
#define FSM_CURRENT_TRIGGER            m_poInstance->u32GetCurrentTrigger
#define FSM_TRIGGER_STATE(x)           m_poInstance->bGetTriggerState(x)
#define FSM_IS_TRIGGER_SET(x)          (TRUE  == FSM_TRIGGER_STATE(x))
#define FSM_IS_TRIGGER_CLEARED(x)      (FALSE == FSM_TRIGGER_STATE(x))
#define FSM_START_TIMER(x,t)           (m_poInstance->bSetTimer((x),(t)))
#define FSM_STOP_TIMER(x)              (m_poInstance->bSetTimer((x),0))

#define FSM_HMIAVM3_OUT_EVENT          m_poInstance->m_poControl->vHandleFsmOutEvent_HmiAvm3


dispvidctrl_tclFsm_HmiAvm3*  dispvidctrl_tclFsm_HmiAvm3::m_poInstance = OSAL_NULL;


// dispvidctrl_tclFsm_HmiAvm3_globals: user specific code start

#define FSM_HMIAVM3_VISOFF_REASON      m_poInstance->m_enHmiVisualisationOffReason
#define FSM_HMIAVM3_SET_VIDEO_CAPTURE  m_poInstance->bSetVideoCapturingOnOrOff
#define FSM_IS_TRANSITION_FROM_STATE(x)   ((x) == m_poInstance->crstGetTransitionInfo().u32OldState)

#define FSM_HMIAVM3_SAFEGUARD_TOUT_BLANKIN_MS        1000
#define FSM_HMIAVM3_SAFEGUARD_TOUT_BLANKOUT_MS       1000
#define FSM_HMIAVM3_SAFEGUARD_TOUT_DIAG_BLANKIN_MS   2000
#define FSM_HMIAVM3_SAFEGUARD_TOUT_DIAG_BLANKOUT_MS  2000

// dispvidctrl_tclFsm_HmiAvm3_globals: user specific code end


/*******************************************************************************
*                                  STATE TABLE
*******************************************************************************/
dispvidctrl_tclFsm_HmiAvm3::TFsmStateConf dispvidctrl_tclFsm_HmiAvm3::aFsm_HmiAvm3_StateTable[eStateHmiAvm3_MAX]=
{
    {
        eStateHmiAvm3_OFF,   // <== initial state
        FSM_NO_STATE_TIMEOUT,
        vEntry_OFF,
        FSM_NO_DO_FUNC,
        FSM_NO_EXIT_FUNC,
    },
    {
        eStateHmiAvm3_WAIT_FOR_BLANK_IN,
        FSM_NO_STATE_TIMEOUT,
        vEntry_WAIT_FOR_BLANK_IN,
        FSM_NO_DO_FUNC,
        vExit_WAIT_FOR_BLANK_IN,
    },
    {
        eStateHmiAvm3_BLANK_IN_ACTIVE,
        FSM_NO_STATE_TIMEOUT,
        vEntry_BLANK_IN_ACTIVE,
        FSM_NO_DO_FUNC,
        vExit_BLANK_IN_ACTIVE,
    },
    {
        eStateHmiAvm3_ON,
        FSM_NO_STATE_TIMEOUT,
        vEntry_ON,
        FSM_NO_DO_FUNC,
        FSM_NO_EXIT_FUNC,
    },
    {
        eStateHmiAvm3_WAIT_FOR_BLANK_OUT,
        FSM_NO_STATE_TIMEOUT,
        vEntry_WAIT_FOR_BLANK_OUT,
        FSM_NO_DO_FUNC,
        vExit_WAIT_FOR_BLANK_OUT,
    },
    {
        eStateHmiAvm3_BLANK_OUT_ACTIVE,
        FSM_NO_STATE_TIMEOUT,
        vEntry_BLANK_OUT_ACTIVE,
        FSM_NO_DO_FUNC,
        vExit_BLANK_OUT_ACTIVE,
    },
    {
        eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE,
        FSM_NO_STATE_TIMEOUT,
        vEntry_DIAG_BLANK_IN_ACTIVE,
        FSM_NO_DO_FUNC,
        FSM_NO_EXIT_FUNC,
    },
    {
        eStateHmiAvm3_ON_DIAG,
        FSM_NO_STATE_TIMEOUT,
        vEntry_ON_DIAG,
        FSM_NO_DO_FUNC,
        FSM_NO_EXIT_FUNC,
    },
    {
        eStateHmiAvm3_DIAG_BLANK_OUT_ACTIVE,
        FSM_NO_STATE_TIMEOUT,
        vEntry_DIAG_BLANK_OUT_ACTIVE,
        FSM_NO_DO_FUNC,
        FSM_NO_EXIT_FUNC,
    },
    {
        eStateHmiAvm3_ON_VID_SETTINGS,
        FSM_NO_STATE_TIMEOUT,
        vEntry_ON_VID_SETTINGS,
        FSM_NO_DO_FUNC,
        FSM_NO_EXIT_FUNC,
    },
    {
        eStateHmiAvm3_EXEC_FSM_RESET,
        FSM_NO_STATE_TIMEOUT,
        FSM_NO_ENTRY_FUNC,
        FSM_NO_DO_FUNC,
        FSM_NO_EXIT_FUNC,
    },
};

/*******************************************************************************
*                             STATE TRANSITION TABLE
*******************************************************************************/
dispvidctrl_tclFsm_HmiAvm3::TStateTransitions dispvidctrl_tclFsm_HmiAvm3::aFsm_HmiAvm3_StateTransitionTable[] =
{
    {   // state change transition <any_state> --> eStateHmiAvm3_EXEC_FSM_RESET  *OR*  do-only transition inside eStateHmiAvm3_EXEC_FSM_RESET  (depending on current state) 
        FSM_TRANSITION_ID(1),
        FSM_IN_ANY_STATE,
        FSM_ON_EVENT(eTriggerHmiAvm3_REQ_FSM_RESET),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_OR_STAY_IN_STATE(eStateHmiAvm3_EXEC_FSM_RESET)
    },

    //  ===== transitions from state eStateHmiAvm3_OFF ==============================

    {   // state change transition eStateHmiAvm3_OFF --> eStateHmiAvm3_WAIT_FOR_BLANK_IN 
        FSM_TRANSITION_ID(2),
        FSM_IN_STATE(eStateHmiAvm3_OFF),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON),
        FSM_IF_GUARDS_TRUE(eTriggerHmiAvm3_HMI_AVAILABLE),
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_IN)
    },
    {   // state change transition eStateHmiAvm3_OFF --> eStateHmiAvm3_BLANK_IN_ACTIVE 
        FSM_TRANSITION_ID(3),
        FSM_IN_STATE(eStateHmiAvm3_OFF),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IF_GUARDS_FALSE(eTriggerHmiAvm3_HMI_AVAILABLE),
        FSM_GOTO_STATE(eStateHmiAvm3_BLANK_IN_ACTIVE)
    },
    {   // state change transition eStateHmiAvm3_OFF --> (transition action SetTimer) --> eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE 
        FSM_TRANSITION_ID(4),
        FSM_IN_STATE(eStateHmiAvm3_OFF),
        FSM_ON_EVENT(eTriggerHmiAvm3_DIAG_REQ_VISUAL_ON),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE),
        FSM_TRANSITION_ACTION(eActionHmiAvm3_SetTimer),
        FSM_TRANSITION_ACTION_PARAM(eTimerHmiAvm3_StateToutDiagBlankIn),
        FSM_TRANSITION_ACTION_PARAM(FSM_HMIAVM3_SAFEGUARD_TOUT_DIAG_BLANKIN_MS)
    },
    {   // state change transition eStateHmiAvm3_OFF --> eStateHmiAvm3_WAIT_FOR_BLANK_IN 
        FSM_TRANSITION_ID(5),
        FSM_IN_STATE(eStateHmiAvm3_OFF),
        FSM_ON_EVENT(eTriggerHmiAvm3_VIDSET_REQ_VISUAL_ON),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_IN)
    },

    //  ===== transitions from state eStateHmiAvm3_WAIT_FOR_BLANK_IN ==============================

    {   // state change transition eStateHmiAvm3_WAIT_FOR_BLANK_IN --> eStateHmiAvm3_BLANK_IN_ACTIVE 
        FSM_TRANSITION_ID(6),
        FSM_IN_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_IN),
        FSM_ON_EVENT(eTriggerHmiAvm3_HMI_CONF_BLANK_IN),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_BLANK_IN_ACTIVE)
    },
    {   // state change transition eStateHmiAvm3_WAIT_FOR_BLANK_IN --> eStateHmiAvm3_BLANK_IN_ACTIVE 
        FSM_TRANSITION_ID(7),
        FSM_IN_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_IN),
        FSM_ON_EVENT(eTriggerHmiAvm3_STATE_TOUT_WAIT_FOR_BLANK_IN),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_BLANK_IN_ACTIVE)
    },
    {   // state change transition eStateHmiAvm3_WAIT_FOR_BLANK_IN --> eStateHmiAvm3_WAIT_FOR_BLANK_OUT 
        FSM_TRANSITION_ID(8),
        FSM_IN_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_IN),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_OUT)
    },

    //  ===== transitions from state eStateHmiAvm3_BLANK_IN_ACTIVE ==============================

    {   // (transition action RequestViewSetup)-only transition inside eStateHmiAvm3_BLANK_IN_ACTIVE 
        FSM_TRANSITION_ID(9),
        FSM_IN_STATE(eStateHmiAvm3_BLANK_IN_ACTIVE),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_BLANK_IN_END),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_STAY_INSIDE_STATE(eStateHmiAvm3_BLANK_IN_ACTIVE),
        FSM_TRANSITION_ACTION(eActionHmiAvm3_RequestViewSetup)
    },
    {   // state change transition eStateHmiAvm3_BLANK_IN_ACTIVE --> eStateHmiAvm3_ON_VID_SETTINGS 
        FSM_TRANSITION_ID(10),
        FSM_IN_STATE(eStateHmiAvm3_BLANK_IN_ACTIVE),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_CONF_VIEW_SETUP),
        FSM_IF_GUARDS_TRUE(eTriggerHmiAvm3_VIDSET_REQ_VISUAL_ON),
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_ON_VID_SETTINGS)
    },
    {   // state change transition eStateHmiAvm3_BLANK_IN_ACTIVE --> eStateHmiAvm3_ON 
        FSM_TRANSITION_ID(11),
        FSM_IN_STATE(eStateHmiAvm3_BLANK_IN_ACTIVE),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_CONF_VIEW_SETUP),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_ON)
    },
    {   // state change transition eStateHmiAvm3_BLANK_IN_ACTIVE --> eStateHmiAvm3_WAIT_FOR_BLANK_OUT 
        FSM_TRANSITION_ID(12),
        FSM_IN_STATE(eStateHmiAvm3_BLANK_IN_ACTIVE),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF),
        FSM_IF_GUARDS_TRUE(eTriggerHmiAvm3_HMI_AVAILABLE),
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_OUT)
    },
    {   // state change transition eStateHmiAvm3_BLANK_IN_ACTIVE --> eStateHmiAvm3_BLANK_OUT_ACTIVE 
        FSM_TRANSITION_ID(13),
        FSM_IN_STATE(eStateHmiAvm3_BLANK_IN_ACTIVE),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IF_GUARDS_FALSE(eTriggerHmiAvm3_HMI_AVAILABLE),
        FSM_GOTO_STATE(eStateHmiAvm3_BLANK_OUT_ACTIVE)
    },

    //  ===== transitions from state eStateHmiAvm3_ON ==============================

    {   // state change transition eStateHmiAvm3_ON --> eStateHmiAvm3_WAIT_FOR_BLANK_OUT 
        FSM_TRANSITION_ID(14),
        FSM_IN_STATE(eStateHmiAvm3_ON),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF),
        FSM_IF_GUARDS_TRUE(eTriggerHmiAvm3_HMI_AVAILABLE),
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_OUT)
    },
    {   // state change transition eStateHmiAvm3_ON --> eStateHmiAvm3_BLANK_OUT_ACTIVE 
        FSM_TRANSITION_ID(15),
        FSM_IN_STATE(eStateHmiAvm3_ON),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IF_GUARDS_FALSE(eTriggerHmiAvm3_HMI_AVAILABLE),
        FSM_GOTO_STATE(eStateHmiAvm3_BLANK_OUT_ACTIVE)
    },
    {   // state change transition eStateHmiAvm3_ON --> eStateHmiAvm3_WAIT_FOR_BLANK_IN 
        FSM_TRANSITION_ID(16),
        FSM_IN_STATE(eStateHmiAvm3_ON),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON),
        FSM_IF_GUARDS_TRUE(eTriggerHmiAvm3_HMI_AVAILABLE),
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_IN)
    },
    {   // state change transition eStateHmiAvm3_ON --> eStateHmiAvm3_BLANK_IN_ACTIVE 
        FSM_TRANSITION_ID(17),
        FSM_IN_STATE(eStateHmiAvm3_ON),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IF_GUARDS_FALSE(eTriggerHmiAvm3_HMI_AVAILABLE),
        FSM_GOTO_STATE(eStateHmiAvm3_BLANK_IN_ACTIVE)
    },
    {   // (transition action RequestViewSetupUpdate)-only transition inside eStateHmiAvm3_ON 
        FSM_TRANSITION_ID(18),
        FSM_IN_STATE(eStateHmiAvm3_ON),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_BLANKLESS_CHG),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_STAY_INSIDE_STATE(eStateHmiAvm3_ON),
        FSM_TRANSITION_ACTION(eActionHmiAvm3_RequestViewSetupUpdate)
    },

    //  ===== transitions from state eStateHmiAvm3_ON_VID_SETTINGS ==============================

    {   // state change transition eStateHmiAvm3_ON_VID_SETTINGS --> eStateHmiAvm3_WAIT_FOR_BLANK_OUT 
        FSM_TRANSITION_ID(19),
        FSM_IN_STATE(eStateHmiAvm3_ON_VID_SETTINGS),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_OUT)
    },
    {   // state change transition eStateHmiAvm3_ON_VID_SETTINGS --> eStateHmiAvm3_WAIT_FOR_BLANK_IN 
        FSM_TRANSITION_ID(20),
        FSM_IN_STATE(eStateHmiAvm3_ON_VID_SETTINGS),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_IN)
    },
    {   // (transition action RequestViewSetupUpdate)-only transition inside eStateHmiAvm3_ON_VID_SETTINGS 
        FSM_TRANSITION_ID(21),
        FSM_IN_STATE(eStateHmiAvm3_ON_VID_SETTINGS),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_BLANKLESS_CHG),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_STAY_INSIDE_STATE(eStateHmiAvm3_ON_VID_SETTINGS),
        FSM_TRANSITION_ACTION(eActionHmiAvm3_RequestViewSetupUpdate)
    },

    //  ===== transitions from state eStateHmiAvm3_WAIT_FOR_BLANK_OUT ==============================

    {   // state change transition eStateHmiAvm3_WAIT_FOR_BLANK_OUT --> eStateHmiAvm3_BLANK_OUT_ACTIVE 
        FSM_TRANSITION_ID(22),
        FSM_IN_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_OUT),
        FSM_ON_EVENT(eTriggerHmiAvm3_HMI_CONF_BLANK_OUT),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_BLANK_OUT_ACTIVE)
    },
    {   // state change transition eStateHmiAvm3_WAIT_FOR_BLANK_OUT --> eStateHmiAvm3_BLANK_OUT_ACTIVE 
        FSM_TRANSITION_ID(23),
        FSM_IN_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_OUT),
        FSM_ON_EVENT(eTriggerHmiAvm3_STATE_TOUT_WAIT_FOR_BLANK_OUT),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_BLANK_OUT_ACTIVE)
    },
    {   // state change transition eStateHmiAvm3_WAIT_FOR_BLANK_OUT --> eStateHmiAvm3_WAIT_FOR_BLANK_IN 
        FSM_TRANSITION_ID(24),
        FSM_IN_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_OUT),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_IN)
    },

    //  ===== transitions from state eStateHmiAvm3_BLANK_OUT_ACTIVE ==============================

    {   // state change transition eStateHmiAvm3_BLANK_OUT_ACTIVE --> eStateHmiAvm3_OFF 
        FSM_TRANSITION_ID(25),
        FSM_IN_STATE(eStateHmiAvm3_BLANK_OUT_ACTIVE),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_BLANK_OUT_END),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_OFF)
    },
    {   // state change transition eStateHmiAvm3_BLANK_OUT_ACTIVE --> eStateHmiAvm3_WAIT_FOR_BLANK_IN 
        FSM_TRANSITION_ID(26),
        FSM_IN_STATE(eStateHmiAvm3_BLANK_OUT_ACTIVE),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON),
        FSM_IF_GUARDS_TRUE(eTriggerHmiAvm3_HMI_AVAILABLE),
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_IN)
    },
    {   // state change transition eStateHmiAvm3_BLANK_OUT_ACTIVE --> eStateHmiAvm3_BLANK_IN_ACTIVE 
        FSM_TRANSITION_ID(27),
        FSM_IN_STATE(eStateHmiAvm3_BLANK_OUT_ACTIVE),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IF_GUARDS_FALSE(eTriggerHmiAvm3_HMI_AVAILABLE),
        FSM_GOTO_STATE(eStateHmiAvm3_BLANK_IN_ACTIVE)
    },

    //  ===== transitions from state eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE ==============================

    {   // (transition action RequestViewSetup)-only transition inside eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE 
        FSM_TRANSITION_ID(28),
        FSM_IN_STATE(eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_BLANK_IN_END),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_STAY_INSIDE_STATE(eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE),
        FSM_TRANSITION_ACTION(eActionHmiAvm3_RequestViewSetup)
    },
    {   // (transition action RequestViewSetup)-only transition inside eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE 
        FSM_TRANSITION_ID(29),
        FSM_IN_STATE(eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE),
        FSM_ON_EVENT(eTriggerHmiAvm3_STATE_TOUT_DIAG_BLANK_IN),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_STAY_INSIDE_STATE(eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE),
        FSM_TRANSITION_ACTION(eActionHmiAvm3_RequestViewSetup)
    },
    {   // state change transition eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE --> (transition action SetTimer) --> eStateHmiAvm3_ON_DIAG 
        FSM_TRANSITION_ID(30),
        FSM_IN_STATE(eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_CONF_VIEW_SETUP),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_ON_DIAG),
        FSM_TRANSITION_ACTION(eActionHmiAvm3_SetTimer),
        FSM_TRANSITION_ACTION_PARAM(eTimerHmiAvm3_StateToutDiagBlankIn),
        FSM_TRANSITION_ACTION_PARAM(0)
    },

    //  ===== transitions from state eStateHmiAvm3_ON_DIAG ==============================

    {   // state change transition eStateHmiAvm3_ON_DIAG --> (transition action SetTimer) --> eStateHmiAvm3_DIAG_BLANK_OUT_ACTIVE 
        FSM_TRANSITION_ID(31),
        FSM_IN_STATE(eStateHmiAvm3_ON_DIAG),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_DIAG_BLANK_OUT_ACTIVE),
        FSM_TRANSITION_ACTION(eActionHmiAvm3_SetTimer),
        FSM_TRANSITION_ACTION_PARAM(eTimerHmiAvm3_StateToutDiagBlankOut),
        FSM_TRANSITION_ACTION_PARAM(FSM_HMIAVM3_SAFEGUARD_TOUT_DIAG_BLANKOUT_MS)
    },

    //  ===== transitions from state eStateHmiAvm3_DIAG_BLANK_OUT_ACTIVE ==============================

    {   // state change transition eStateHmiAvm3_DIAG_BLANK_OUT_ACTIVE --> (transition action SetTimer) --> eStateHmiAvm3_OFF 
        FSM_TRANSITION_ID(32),
        FSM_IN_STATE(eStateHmiAvm3_DIAG_BLANK_OUT_ACTIVE),
        FSM_ON_EVENT(eTriggerHmiAvm3_AVM_REQ_BLANK_OUT_END),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_OFF),
        FSM_TRANSITION_ACTION(eActionHmiAvm3_SetTimer),
        FSM_TRANSITION_ACTION_PARAM(eTimerHmiAvm3_StateToutDiagBlankOut),
        FSM_TRANSITION_ACTION_PARAM(0)
    },
    {   // state change transition eStateHmiAvm3_DIAG_BLANK_OUT_ACTIVE --> eStateHmiAvm3_OFF 
        FSM_TRANSITION_ID(33),
        FSM_IN_STATE(eStateHmiAvm3_DIAG_BLANK_OUT_ACTIVE),
        FSM_ON_EVENT(eTriggerHmiAvm3_STATE_TOUT_DIAG_BLANK_OUT),
        FSM_IGNORE_TRUE_GUARDS,
        FSM_IGNORE_FALSE_GUARDS,
        FSM_GOTO_STATE(eStateHmiAvm3_OFF)
    },
};

/******************************************************************************/
// FUNCTION     dispvidctrl_tclFsm_HmiAvm3
/******************************************************************************/
/**
*  \brief       default constructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/

/******************************************************************************/
// FUNCTION     dispvidctrl_tclFsm_HmiAvm3(dispvidctrl_tclControl_HmiAvm3* poControl)
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       pointer to control application
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclFsm_HmiAvm3::dispvidctrl_tclFsm_HmiAvm3(dispvidctrl_tclControl_HmiAvm3* poControl):
    dispvidctrl_tclFsm_Base( FSM_HMIAVM3_INIT_STATE,
               (tU16)FSM_NUM_ELEMENTS(aFsm_HmiAvm3_StateTransitionTable),    aFsm_HmiAvm3_StateTransitionTable,
               (tU16)FSM_NUM_ELEMENTS(aFsm_HmiAvm3_StateTable),              aFsm_HmiAvm3_StateTable,
               (tU32) TR_CLASS_DISPVIDCTRL_APPLICATION,
               DISPVIDCTRL_TRACE_ID_FSM_HMIAVM3, FSM_HMIAVM3_USE_REENTER_TRANSITIONS)
    , _hTimerHandle_StateToutWaitForBlankIn(OSAL_C_INVALID_HANDLE)
    , _hTimerHandle_StateToutWaitForBlankOut(OSAL_C_INVALID_HANDLE)
    , _hTimerHandle_StateToutDiagBlankIn(OSAL_C_INVALID_HANDLE)
    , _hTimerHandle_StateToutDiagBlankOut(OSAL_C_INVALID_HANDLE)
    , m_poControl(poControl)
// dispvidctrl_tclFsm_HmiAvm3::dispvidctrl_tclFsm_HmiAvm3_head: user specific code start
    , m_enHmiVisualisationOffReason(EN_VD_RVC_HMI_VISUALISATION_OFF__NOT_SPEZIFIED)
// dispvidctrl_tclFsm_HmiAvm3::dispvidctrl_tclFsm_HmiAvm3_head: user specific code end
{
    ETG_TRACE_USR4((" FSM-HMIAVM3  :: dispvidctrl_tclFsm_HmiAvm3(): ................... entered!"));

    if( OSAL_s32TimerCreate( (OSAL_tpfCallback)_pfCallbackTimer_StateToutWaitForBlankIn, (tPVoid)this, &_hTimerHandle_StateToutWaitForBlankIn) != OSAL_OK) {
        ETG_TRACE_ERR((" FSM-HMIAVM3  :: E R R O R in dispvidctrl_tclFsm_HmiAvm3(): ...... Could not create timer StateToutWaitForBlankIn!"));
        _hTimerHandle_StateToutWaitForBlankIn = OSAL_C_INVALID_HANDLE;
    }
    if( OSAL_s32TimerCreate( (OSAL_tpfCallback)_pfCallbackTimer_StateToutWaitForBlankOut, (tPVoid)this, &_hTimerHandle_StateToutWaitForBlankOut) != OSAL_OK) {
        ETG_TRACE_ERR((" FSM-HMIAVM3  :: E R R O R in dispvidctrl_tclFsm_HmiAvm3(): ...... Could not create timer StateToutWaitForBlankOut!"));
        _hTimerHandle_StateToutWaitForBlankOut = OSAL_C_INVALID_HANDLE;
    }
    if( OSAL_s32TimerCreate( (OSAL_tpfCallback)_pfCallbackTimer_StateToutDiagBlankIn, (tPVoid)this, &_hTimerHandle_StateToutDiagBlankIn) != OSAL_OK) {
        ETG_TRACE_ERR((" FSM-HMIAVM3  :: E R R O R in dispvidctrl_tclFsm_HmiAvm3(): ...... Could not create timer StateToutDiagBlankIn!"));
        _hTimerHandle_StateToutDiagBlankIn = OSAL_C_INVALID_HANDLE;
    }
    if( OSAL_s32TimerCreate( (OSAL_tpfCallback)_pfCallbackTimer_StateToutDiagBlankOut, (tPVoid)this, &_hTimerHandle_StateToutDiagBlankOut) != OSAL_OK) {
        ETG_TRACE_ERR((" FSM-HMIAVM3  :: E R R O R in dispvidctrl_tclFsm_HmiAvm3(): ...... Could not create timer StateToutDiagBlankOut!"));
        _hTimerHandle_StateToutDiagBlankOut = OSAL_C_INVALID_HANDLE;
    }

    // dispvidctrl_tclFsm_HmiAvm3::dispvidctrl_tclFsm_HmiAvm3_body: user specific code start
    // dispvidctrl_tclFsm_HmiAvm3::dispvidctrl_tclFsm_HmiAvm3_body: user specific code end
}

/******************************************************************************/
/* FUNCTION     ~dispvidctrl_tclFsm_HmiAvm3                                            */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclFsm_HmiAvm3::~dispvidctrl_tclFsm_HmiAvm3(tVoid)
{
    ETG_TRACE_USR4((" FSM-HMIAVM3  :: ~dispvidctrl_tclFsm_HmiAvm3(): .................. entered!"));

    if (OSAL_C_INVALID_HANDLE  !=  _hTimerHandle_StateToutWaitForBlankIn)  {
       (void) OSAL_s32TimerSetTime(_hTimerHandle_StateToutWaitForBlankIn, 0, 0);
       (void) OSAL_s32TimerDelete (_hTimerHandle_StateToutWaitForBlankIn);
       _hTimerHandle_StateToutWaitForBlankIn = OSAL_C_INVALID_HANDLE;
    }
    if (OSAL_C_INVALID_HANDLE  !=  _hTimerHandle_StateToutWaitForBlankOut)  {
       (void) OSAL_s32TimerSetTime(_hTimerHandle_StateToutWaitForBlankOut, 0, 0);
       (void) OSAL_s32TimerDelete (_hTimerHandle_StateToutWaitForBlankOut);
       _hTimerHandle_StateToutWaitForBlankOut = OSAL_C_INVALID_HANDLE;
    }
    if (OSAL_C_INVALID_HANDLE  !=  _hTimerHandle_StateToutDiagBlankIn)  {
       (void) OSAL_s32TimerSetTime(_hTimerHandle_StateToutDiagBlankIn, 0, 0);
       (void) OSAL_s32TimerDelete (_hTimerHandle_StateToutDiagBlankIn);
       _hTimerHandle_StateToutDiagBlankIn = OSAL_C_INVALID_HANDLE;
    }
    if (OSAL_C_INVALID_HANDLE  !=  _hTimerHandle_StateToutDiagBlankOut)  {
       (void) OSAL_s32TimerSetTime(_hTimerHandle_StateToutDiagBlankOut, 0, 0);
       (void) OSAL_s32TimerDelete (_hTimerHandle_StateToutDiagBlankOut);
       _hTimerHandle_StateToutDiagBlankOut = OSAL_C_INVALID_HANDLE;
    }

    // dispvidctrl_tclFsm_HmiAvm3::~dispvidctrl_tclFsm_HmiAvm3: user specific code start
    // dispvidctrl_tclFsm_HmiAvm3::~dispvidctrl_tclFsm_HmiAvm3: user specific code end

    m_poControl = NULL;
}



/******************************************************************************/
/* FUNCTION     tclCreateInstance                                             */
/******************************************************************************/
/**
*  \brief       Create instance (singleton pattern)
*
*  \param       pointer to control application
*  \return      instance pointer
*/
/******************************************************************************/
dispvidctrl_tclFsm_HmiAvm3* dispvidctrl_tclFsm_HmiAvm3::tclCreateInstance(dispvidctrl_tclControl_HmiAvm3* poControl)
{
    if (m_poInstance == NULL)
    {
        m_poInstance = OSAL_NEW dispvidctrl_tclFsm_HmiAvm3(poControl);
    }
    return m_poInstance;
}


/******************************************************************************/
/* FUNCTION     vNewTrigger                                                   */
/******************************************************************************/
/**
*  \brief       To be called to enter a new Trigger
*
*  \param       trigger and state
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vNewTrigger(tU32 u32Trigger, tBool bTriggerState)
{
    ETG_TRACE_FATAL((" FSM-HMIAVM3   :: dispvidctrl_tclFsm_HmiAvm3::vNewTrigger(%u = %u) in state %u", ETG_ENUM(tenFsm_HmiAvm3_TriggerBit,u32Trigger), bTriggerState, ETG_ENUM(tenFsm_HmiAvm3_State,u32GetFsmState()) ));
    (tVoid) u32CalcNewFsmState(u32Trigger, bTriggerState);
}


/******************************************************************************/
/* FUNCTION     vUpdateTriggerState                                           */
/******************************************************************************/
/**
*  \brief       To be called to correct Trigger states
*
*  \param       Trigger and State
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vUpdateTriggerState(tU32 u32Trigger, tBool bTriggerState)
{
    vUpdateTrigger(u32Trigger, bTriggerState);
}


/******************************************************************************/
/* FUNCTION     vStateChangeDetected                                          */
/******************************************************************************/
/**
*  \brief       called when a state change happens
*               overwritten base class function
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vStateChangeDetected(tVoid)
{
    // dispvidctrl_tclFsm_HmiAvm3::vStateChangeDetected: user specific code start
    if (_u32FsmState == eStateHmiAvm3_EXEC_FSM_RESET) {
        
        if (OSAL_C_INVALID_HANDLE  !=  _hTimerHandle_StateToutWaitForBlankIn) {
           (void) OSAL_s32TimerSetTime(_hTimerHandle_StateToutWaitForBlankIn,  0, 0);
        }
        if (OSAL_C_INVALID_HANDLE  !=  _hTimerHandle_StateToutWaitForBlankOut) {
           (void) OSAL_s32TimerSetTime(_hTimerHandle_StateToutWaitForBlankOut, 0, 0);
        }
        if (OSAL_C_INVALID_HANDLE  !=  _hTimerHandle_StateToutDiagBlankIn) {
           (void) OSAL_s32TimerSetTime(_hTimerHandle_StateToutDiagBlankIn, 0, 0);
        }
        if (OSAL_C_INVALID_HANDLE  !=  _hTimerHandle_StateToutDiagBlankOut) {
           (void) OSAL_s32TimerSetTime(_hTimerHandle_StateToutDiagBlankOut, 0, 0);
        }
        _u32FsmState         = FSM_HMIAVM3_INIT_STATE;
        _u32LastFsmState     = FSM_STATE_ID_NONE;
        vUpdateTrigger(0xFFFFFFFF,FALSE);
       
        FSM_HMIAVM3_VISOFF_REASON = EN_VD_RVC_HMI_VISUALISATION_OFF__NOT_SPEZIFIED;
    }
    // dispvidctrl_tclFsm_HmiAvm3::vStateChangeDetected: user specific code end
    
    vTraceStatusInfo(0);
}


/******************************************************************************/
/* FUNCTION     vStartFsmStateTimer                                           */
/******************************************************************************/
/**
*  \brief       Called by base class on each state entry to start/stop
*                the generic FSM state timeout timer
*                overwritten base class function
*
*  \param       time out value in milliseconds
*  \return      none
*/
/******************************************************************************/
// overwrites tclFsmBase class function
tVoid dispvidctrl_tclFsm_HmiAvm3::vStartFsmStateTimer(tU32 u32Time)
{
   (tVoid) u32Time; // no generic state timeout timer defined for this FSM
   
   // dispvidctrl_tclFsm_HmiAvm3::vStartFsmStateTimer: user specific code start
   // dispvidctrl_tclFsm_HmiAvm3::vStartFsmStateTimer: user specific code end
}


/******************************************************************************/
/* FUNCTION     vUpdateRelatedTrigger                                         */
/******************************************************************************/
/**
*  \brief       to correct "hold" trigger states which are related to actual
*               trigger
*               overwritten base class function
*
*  \param       actual Trigger
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vUpdateRelatedTrigger(tU32 u32Trigger)
{
   // dispvidctrl_tclFsm_HmiAvm3::vUpdateRelatedTrigger_entry: user specific code start
   // dispvidctrl_tclFsm_HmiAvm3::vUpdateRelatedTrigger_entry: user specific code end   

   if (FSM_IS_FULLY_OPERATIONAL)
   {
      switch (u32Trigger)
      {
         case eTriggerHmiAvm3_AVM_REQ_VISUAL_ON:
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF);
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_DIAG_REQ_VISUAL_ON);
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_VIDSET_REQ_VISUAL_ON);
            break;
         case eTriggerHmiAvm3_VIDSET_REQ_VISUAL_ON:
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF);
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_DIAG_REQ_VISUAL_ON);
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON);
            break;
         case eTriggerHmiAvm3_DIAG_REQ_VISUAL_ON:
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF);
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON);
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_VIDSET_REQ_VISUAL_ON);
            break;
         case eTriggerHmiAvm3_AVM_REQ_BLANKLESS_CHG:
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_AVM_REQ_BLANKLESS_CHG);
            break;
         case eTriggerHmiAvm3_HMI_CONF_BLANK_IN:
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_HMI_CONF_BLANK_IN);
            break;
         case eTriggerHmiAvm3_HMI_CONF_ON:
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_HMI_CONF_OFF);
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_HMI_CONF_ON_CAM_SETTINGS);
            break;
         case eTriggerHmiAvm3_HMI_CONF_BLANK_OUT:
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_HMI_CONF_BLANK_OUT);
            break;
         case eTriggerHmiAvm3_HMI_CONF_OFF:
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_HMI_CONF_ON);
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_HMI_CONF_ON_CAM_SETTINGS);
            break;
         case eTriggerHmiAvm3_HMI_CONF_ON_CAM_SETTINGS:
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_HMI_CONF_ON);
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_HMI_CONF_OFF);
            break;
         case eTriggerHmiAvm3_AVM_CONF_VIEW_SETUP:
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_AVM_CONF_VIEW_SETUP);
            break;
         case eTriggerHmiAvm3_STATE_TOUT_WAIT_FOR_BLANK_IN:
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_STATE_TOUT_WAIT_FOR_BLANK_IN);
            break;
         case eTriggerHmiAvm3_STATE_TOUT_WAIT_FOR_BLANK_OUT:
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_STATE_TOUT_WAIT_FOR_BLANK_OUT);
            break;
         case eTriggerHmiAvm3_STATE_TOUT_DIAG_BLANK_IN:
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_STATE_TOUT_DIAG_BLANK_IN);
            break;
         case eTriggerHmiAvm3_STATE_TOUT_DIAG_BLANK_OUT:
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_STATE_TOUT_DIAG_BLANK_OUT);
            break;
         case eTriggerHmiAvm3_REQ_FSM_RESET:
            FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_REQ_FSM_RESET);
            break;
         default:
            break;
      }
   }
   
   // dispvidctrl_tclFsm_HmiAvm3::vUpdateRelatedTrigger_exit: user specific code start
   // dispvidctrl_tclFsm_HmiAvm3::vUpdateRelatedTrigger_exit: user specific code end
}


/******************************************************************************/
/* FUNCTION     vTransitionAction                                             */
/******************************************************************************/
/**
*  \brief       called by base class on transitions having a transition action defined,
*               between exit of old state and entry of new state
*               overwritten base class function
*
*  \param       ID of the action to be carried out
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vTransitionAction(tU32 u32ActionId, tU32 u32Param1, tU32 u32Param2)
{
   ETG_TRACE_USR4((" FSM-HMIAVM3  :: vTransitionAction() called: actionId=%u , param1=%u, param2=%u", ETG_ENUM(tenFsm_HmiAvm3_Action, u32ActionId), u32Param1, u32Param2));
   
   if (FSM_IS_FULLY_OPERATIONAL) {
      // dispvidctrl_tclFsm_HmiAvm3::vTransitionAction_entry: user specific code start
      // dispvidctrl_tclFsm_HmiAvm3::vTransitionAction_entry: user specific code end   

      switch (u32ActionId)
      {       
         case eActionHmiAvm3_SetTimer:
            // transition candidate(s):
            //   transID 0004:  eStateHmiAvm3_OFF --(eTriggerHmiAvm3_DIAG_REQ_VISUAL_ON)--> eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE  (during state change)
            //     call sequence:  vTransitionAction(SetTimer,eTimerHmiAvm3_StateToutDiagBlankIn,FSM_HMIAVM3_SAFEGUARD_TOUT_DIAG_BLANKIN_MS) -> vEntry_DIAG_BLANK_IN_ACTIVE()
            //   transID 0030:  eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE --(eTriggerHmiAvm3_AVM_CONF_VIEW_SETUP)--> eStateHmiAvm3_ON_DIAG  (during state change)
            //     call sequence:  vTransitionAction(SetTimer,eTimerHmiAvm3_StateToutDiagBlankIn,0) -> vEntry_ON_DIAG()
            //   transID 0031:  eStateHmiAvm3_ON_DIAG --(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF)--> eStateHmiAvm3_DIAG_BLANK_OUT_ACTIVE  (during state change)
            //     call sequence:  vTransitionAction(SetTimer,eTimerHmiAvm3_StateToutDiagBlankOut,FSM_HMIAVM3_SAFEGUARD_TOUT_DIAG_BLANKOUT_MS) -> vEntry_DIAG_BLANK_OUT_ACTIVE()
            //   transID 0032:  eStateHmiAvm3_DIAG_BLANK_OUT_ACTIVE --(eTriggerHmiAvm3_AVM_REQ_BLANK_OUT_END)--> eStateHmiAvm3_OFF  (during state change)
            //     call sequence:  vTransitionAction(SetTimer,eTimerHmiAvm3_StateToutDiagBlankOut,0) -> vEntry_OFF()

            // dispvidctrl_tclFsm_HmiAvm3::vTransitionAction_case_SetTimer: user specific code start
            (tVoid) bSetTimer(u32Param1,u32Param2);
            // dispvidctrl_tclFsm_HmiAvm3::vTransitionAction_case_SetTimer: user specific code end
            break;

         case eActionHmiAvm3_RequestViewSetup:
            // transition candidate(s):
            //   transID 0009:  eStateHmiAvm3_BLANK_IN_ACTIVE --(eTriggerHmiAvm3_AVM_REQ_BLANK_IN_END)--> <same_state>  (while staying inside current state)
            //     call sequence:  vTransitionAction(RequestViewSetup)
            //   transID 0028:  eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE --(eTriggerHmiAvm3_AVM_REQ_BLANK_IN_END)--> <same_state>  (while staying inside current state)
            //     call sequence:  vTransitionAction(RequestViewSetup)
            //   transID 0029:  eStateHmiAvm3_DIAG_BLANK_IN_ACTIVE --(eTriggerHmiAvm3_STATE_TOUT_DIAG_BLANK_IN)--> <same_state>  (while staying inside current state)
            //     call sequence:  vTransitionAction(RequestViewSetup)

            // dispvidctrl_tclFsm_HmiAvm3::vTransitionAction_case_RequestViewSetup: user specific code start
            FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__AVM_REQ_VIEW_SETUP);
            // dispvidctrl_tclFsm_HmiAvm3::vTransitionAction_case_RequestViewSetup: user specific code end
            break;

         case eActionHmiAvm3_RequestViewSetupUpdate:
            // transition candidate(s):
            //   transID 0018:  eStateHmiAvm3_ON --(eTriggerHmiAvm3_AVM_REQ_BLANKLESS_CHG)--> <same_state>  (while staying inside current state)
            //     call sequence:  vTransitionAction(RequestViewSetupUpdate)
            //   transID 0021:  eStateHmiAvm3_ON_VID_SETTINGS --(eTriggerHmiAvm3_AVM_REQ_BLANKLESS_CHG)--> <same_state>  (while staying inside current state)
            //     call sequence:  vTransitionAction(RequestViewSetupUpdate)

            // dispvidctrl_tclFsm_HmiAvm3::vTransitionAction_case_RequestViewSetupUpdate: user specific code start
            FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__AVM_REQ_BLANKLESS_CHG);
            // dispvidctrl_tclFsm_HmiAvm3::vTransitionAction_case_RequestViewSetupUpdate: user specific code end
            break;

         // dispvidctrl_tclFsm_HmiAvm3::vTransitionAction_switch: user specific code start
         // dispvidctrl_tclFsm_HmiAvm3::vTransitionAction_switch: user specific code end

         default:
            ETG_TRACE_USR1((" FSM-HMIAVM3  :: vTransitionAction(): invalid transition action %u", ETG_ENUM(tenFsm_HmiAvm3_Action, u32ActionId) ));
            break;
      }

      // dispvidctrl_tclFsm_HmiAvm3::vTransitionAction_exit: user specific code start
      // dispvidctrl_tclFsm_HmiAvm3::vTransitionAction_exit: user specific code end
   }
}


/******************************************************************************/
// FUNCTION     vEntry_OFF
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vEntry_OFF(tVoid)
{
// transition candidates:
//   transID 0025:  state BLANK_OUT_ACTIVE --(eTriggerHmiAvm3_AVM_REQ_BLANK_OUT_END)--> state OFF  (during state change)
//     call sequence:  vExit_BLANK_OUT_ACTIVE() -> vEntry_OFF()
//   transID 0032:  state DIAG_BLANK_OUT_ACTIVE --(eTriggerHmiAvm3_AVM_REQ_BLANK_OUT_END)--> state OFF  (during state change)
//     call sequence:  vTransitionAction(eActionHmiAvm3_SetTimer,eTimerHmiAvm3_StateToutDiagBlankOut,0) -> vEntry_OFF()
//   transID 0033:  state DIAG_BLANK_OUT_ACTIVE --(eTriggerHmiAvm3_STATE_TOUT_DIAG_BLANK_OUT)--> state OFF  (during state change)
//     call sequence:  vEntry_OFF()

   if (FSM_IS_FULLY_OPERATIONAL) {
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_OFF: user specific code start
      
      // tenFsmOutEvent_HmiAvm3 enNewSystemStatus = FSM_HMIAVM3_OUT__HMI_VISUALISATION_OFF;
      // switch (FSM_HMIAVM3_VISOFF_REASON) {
      //    case EN_VD_RVC_HMI_VISUALISATION_OFF__CRITICAL_UNDERVOLTAGE:
      //    case EN_VD_RVC_HMI_VISUALISATION_OFF__APPLICATION_STATE_NOT_NORMAL:
      //    case EN_VD_RVC_HMI_VISUALISATION_OFF__REQUEST_OFF:
      //    case EN_VD_RVC_HMI_VISUALISATION_OFF__DIAG_VIDEO_LAYER_OFF:
      //    case EN_VD_RVC_HMI_VISUALISATION_OFF__GUIDELINE_ADJUSTMENT_OFF:
      //       FSM_HMIAVM3_VISOFF_REASON = EN_VD_RVC_HMI_VISUALISATION_OFF__NOT_SPEZIFIED;
      //       break;
      //    case EN_VD_RVC_HMI_VISUALISATION_OFF__SYSTEM_MALFUNCTION:
      //       // enNewSystemStatus = FSM_HMIAVM3_OUT__HMI_VISUALISATION_OFF_SYSTEM_MALFUNCTION;
      //       break;
      //    case EN_VD_RVC_HMI_VISUALISATION_OFF__RVC_ELECTRIC_FAILURE:
      //       // enNewSystemStatus = FSM_HMIAVM3_OUT__HMI_VISUALISATION_OFF_VIDEO_SIGNAL_FAILURE;
      //       break;
      //    case EN_VD_RVC_HMI_VISUALISATION_OFF__VIDEO_SIGNAL_FAILURE:
      //       // enNewSystemStatus = FSM_HMIAVM3_OUT__HMI_VISUALISATION_OFF_VIDEO_SIGNAL_FAILURE;
      //       // // todo  condition rvc/avm?
      //       // FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__AVM_VIDEO_SIGNAL_FAILURE);
      //       break;
      //    case EN_VD_RVC_HMI_VISUALISATION_OFF__ON_REQUEST_AFTER_BLACKOUT:
      //       // NCG3D-23844: We have to clear this Flag here, otherwise 
      //       // we run into the issue if the OnRequestAfterBlackOut occurs twice without going to OFF state
      //       FSM_HMIAVM3_VISOFF_REASON = EN_VD_RVC_HMI_VISUALISATION_OFF__NOT_SPEZIFIED;
      //       break;
      //    default:
      //       break;
      // }
      // // update system status property
      // ETG_TRACE_USR4((" FSM-HMIAVM3   :: HmiVisualisationOffReason = ............ %-40d", ETG_CENUM(tenHmiVisualisationOffReason, FSM_HMIAVM3_VISOFF_REASON)));
      // FSM_HMIAVM3_OUT_EVENT( enNewSystemStatus );
      
      FSM_HMIAVM3_VISOFF_REASON = EN_VD_RVC_HMI_VISUALISATION_OFF__NOT_SPEZIFIED;
      FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON);
      FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_DIAG_REQ_VISUAL_ON);
      FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_VIDSET_REQ_VISUAL_ON);
      
      FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_VISUALISATION_OFF);  // update property SystemStatus
               
      FSM_HMIAVM3_SET_VIDEO_CAPTURE(FALSE);   // video signal check will be stopped with capturing stop as well
            
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_OFF: user specific code end
   }
}


/******************************************************************************/
// FUNCTION     vEntry_WAIT_FOR_BLANK_IN
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vEntry_WAIT_FOR_BLANK_IN(tVoid)
{
// transition candidates:
//   transID 0002:  state OFF --(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON)--> state WAIT_FOR_BLANK_IN  if (eTriggerHmiAvm3_HMI_AVAILABLE)  (during state change)
//     call sequence:  vEntry_WAIT_FOR_BLANK_IN()
//   transID 0005:  state OFF --(eTriggerHmiAvm3_VIDSET_REQ_VISUAL_ON)--> state WAIT_FOR_BLANK_IN  (during state change)
//     call sequence:  vEntry_WAIT_FOR_BLANK_IN()
//   transID 0016:  state ON --(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON)--> state WAIT_FOR_BLANK_IN  if (eTriggerHmiAvm3_HMI_AVAILABLE)  (during state change)
//     call sequence:  vEntry_WAIT_FOR_BLANK_IN()
//   transID 0020:  state ON_VID_SETTINGS --(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON)--> state WAIT_FOR_BLANK_IN  (during state change)
//     call sequence:  vEntry_WAIT_FOR_BLANK_IN()
//   transID 0024:  state WAIT_FOR_BLANK_OUT --(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON)--> state WAIT_FOR_BLANK_IN  (during state change)
//     call sequence:  vExit_WAIT_FOR_BLANK_OUT() -> vEntry_WAIT_FOR_BLANK_IN()
//   transID 0026:  state BLANK_OUT_ACTIVE --(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON)--> state WAIT_FOR_BLANK_IN  if (eTriggerHmiAvm3_HMI_AVAILABLE)  (during state change)
//     call sequence:  vExit_BLANK_OUT_ACTIVE() -> vEntry_WAIT_FOR_BLANK_IN()

   if (FSM_IS_FULLY_OPERATIONAL) {
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_WAIT_FOR_BLANK_IN: user specific code start
      
      if (FSM_IS_TRIGGER_SET(eTriggerHmiAvm3_VIDSET_REQ_VISUAL_ON)) {
         FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_IN_CAMERA_SETTINGS);  // update property SystemStatus
      } else {
         FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_IN);  // update property SystemStatus
      }
      
      if (FSM_IS_TRANSITION_FROM_STATE(eStateHmiAvm3_OFF)) {
         FSM_HMIAVM3_SET_VIDEO_CAPTURE(TRUE);
      }
      
      FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_AVM_REQ_BLANK_IN_END);
      (tVoid) FSM_START_TIMER(eTimerHmiAvm3_StateToutWaitForBlankIn,FSM_HMIAVM3_SAFEGUARD_TOUT_BLANKIN_MS);
      
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_WAIT_FOR_BLANK_IN: user specific code end
   }
}


/******************************************************************************/
// FUNCTION     vExit_WAIT_FOR_BLANK_IN
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vExit_WAIT_FOR_BLANK_IN(tVoid)
{
// transition candidates:
//   transID 0001:  <any_state> --(eTriggerHmiAvm3_REQ_FSM_RESET)--> state EXEC_FSM_RESET  (during state change)
//     call sequence:  vExit_WAIT_FOR_BLANK_IN()
//   transID 0006:  state WAIT_FOR_BLANK_IN --(eTriggerHmiAvm3_HMI_CONF_BLANK_IN)--> state BLANK_IN_ACTIVE  (during state change)
//     call sequence:  vExit_WAIT_FOR_BLANK_IN() -> vEntry_BLANK_IN_ACTIVE()
//   transID 0007:  state WAIT_FOR_BLANK_IN --(eTriggerHmiAvm3_STATE_TOUT_WAIT_FOR_BLANK_IN)--> state BLANK_IN_ACTIVE  (during state change)
//     call sequence:  vExit_WAIT_FOR_BLANK_IN() -> vEntry_BLANK_IN_ACTIVE()
//   transID 0008:  state WAIT_FOR_BLANK_IN --(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF)--> state WAIT_FOR_BLANK_OUT  (during state change)
//     call sequence:  vExit_WAIT_FOR_BLANK_IN() -> vEntry_WAIT_FOR_BLANK_OUT()

   if (FSM_IS_FULLY_OPERATIONAL) {
      // dispvidctrl_tclFsm_HmiAvm3::vExit_WAIT_FOR_BLANK_IN: user specific code start

      (tVoid) FSM_STOP_TIMER(eTimerHmiAvm3_StateToutWaitForBlankIn);
      
      // dispvidctrl_tclFsm_HmiAvm3::vExit_WAIT_FOR_BLANK_IN: user specific code end
   }
}


/******************************************************************************/
// FUNCTION     vEntry_BLANK_IN_ACTIVE
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vEntry_BLANK_IN_ACTIVE(tVoid)
{
// transition candidates:
//   transID 0003:  state OFF --(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON)--> state BLANK_IN_ACTIVE  if !(eTriggerHmiAvm3_HMI_AVAILABLE)  (during state change)
//     call sequence:  vEntry_BLANK_IN_ACTIVE()
//   transID 0006:  state WAIT_FOR_BLANK_IN --(eTriggerHmiAvm3_HMI_CONF_BLANK_IN)--> state BLANK_IN_ACTIVE  (during state change)
//     call sequence:  vExit_WAIT_FOR_BLANK_IN() -> vEntry_BLANK_IN_ACTIVE()
//   transID 0007:  state WAIT_FOR_BLANK_IN --(eTriggerHmiAvm3_STATE_TOUT_WAIT_FOR_BLANK_IN)--> state BLANK_IN_ACTIVE  (during state change)
//     call sequence:  vExit_WAIT_FOR_BLANK_IN() -> vEntry_BLANK_IN_ACTIVE()
//   transID 0017:  state ON --(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON)--> state BLANK_IN_ACTIVE  if !(eTriggerHmiAvm3_HMI_AVAILABLE)  (during state change)
//     call sequence:  vEntry_BLANK_IN_ACTIVE()
//   transID 0027:  state BLANK_OUT_ACTIVE --(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON)--> state BLANK_IN_ACTIVE  if !(eTriggerHmiAvm3_HMI_AVAILABLE)  (during state change)
//     call sequence:  vExit_BLANK_OUT_ACTIVE() -> vEntry_BLANK_IN_ACTIVE()

   if (FSM_IS_FULLY_OPERATIONAL) {
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_BLANK_IN_ACTIVE: user specific code start
      
      if (! FSM_IS_TRANSITION_FROM_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_IN)) {  // avoid duplicate FSM_OUT-event if we come from WAIT_FOR_BLANK_IN
         FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_IN);  // update property SystemStatus
         
         if (FSM_IS_TRANSITION_FROM_STATE(eStateHmiAvm3_OFF)) {  // if we came from OFF via WAIT_FOR_BLANK_IN, it has alrady been done then and there
            FSM_HMIAVM3_SET_VIDEO_CAPTURE(TRUE);
         }
      }
      
      FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_CONFIRM_VISUALISATION_BLACK_IN);
      
      if (FSM_IS_TRIGGER_SET(eTriggerHmiAvm3_AVM_REQ_BLANK_IN_END)) {  // if the trigger has arrived while we were in WAIT_FOR_BLANK_IN:
         FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__AVM_REQ_VIEW_SETUP);
      }
      
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_BLANK_IN_ACTIVE: user specific code end
   }
}


/******************************************************************************/
// FUNCTION     vExit_BLANK_IN_ACTIVE
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vExit_BLANK_IN_ACTIVE(tVoid)
{
// transition candidates:
//   transID 0001:  <any_state> --(eTriggerHmiAvm3_REQ_FSM_RESET)--> state EXEC_FSM_RESET  (during state change)
//     call sequence:  vExit_BLANK_IN_ACTIVE()
//   transID 0010:  state BLANK_IN_ACTIVE --(eTriggerHmiAvm3_AVM_CONF_VIEW_SETUP)--> state ON_VID_SETTINGS  if (eTriggerHmiAvm3_VIDSET_REQ_VISUAL_ON)  (during state change)
//     call sequence:  vExit_BLANK_IN_ACTIVE() -> vEntry_ON_VID_SETTINGS()
//   transID 0011:  state BLANK_IN_ACTIVE --(eTriggerHmiAvm3_AVM_CONF_VIEW_SETUP)--> state ON  (during state change)
//     call sequence:  vExit_BLANK_IN_ACTIVE() -> vEntry_ON()
//   transID 0012:  state BLANK_IN_ACTIVE --(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF)--> state WAIT_FOR_BLANK_OUT  if (eTriggerHmiAvm3_HMI_AVAILABLE)  (during state change)
//     call sequence:  vExit_BLANK_IN_ACTIVE() -> vEntry_WAIT_FOR_BLANK_OUT()
//   transID 0013:  state BLANK_IN_ACTIVE --(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF)--> state BLANK_OUT_ACTIVE  if !(eTriggerHmiAvm3_HMI_AVAILABLE)  (during state change)
//     call sequence:  vExit_BLANK_IN_ACTIVE() -> vEntry_BLANK_OUT_ACTIVE()

   if (FSM_IS_FULLY_OPERATIONAL) {
      // dispvidctrl_tclFsm_HmiAvm3::vExit_BLANK_IN_ACTIVE: user specific code start

      FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_AVM_REQ_BLANK_IN_END);
      
      // dispvidctrl_tclFsm_HmiAvm3::vExit_BLANK_IN_ACTIVE: user specific code end
   }
}


/******************************************************************************/
// FUNCTION     vEntry_ON
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vEntry_ON(tVoid)
{
// transition candidates:
//   transID 0011:  state BLANK_IN_ACTIVE --(eTriggerHmiAvm3_AVM_CONF_VIEW_SETUP)--> state ON  (during state change)
//     call sequence:  vExit_BLANK_IN_ACTIVE() -> vEntry_ON()

   if (FSM_IS_FULLY_OPERATIONAL) {
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_ON: user specific code start
      
      FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_VISUALISATION_ON);      // send property update
      
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_ON: user specific code end
   }
}


/******************************************************************************/
// FUNCTION     vEntry_WAIT_FOR_BLANK_OUT
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vEntry_WAIT_FOR_BLANK_OUT(tVoid)
{
// transition candidates:
//   transID 0008:  state WAIT_FOR_BLANK_IN --(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF)--> state WAIT_FOR_BLANK_OUT  (during state change)
//     call sequence:  vExit_WAIT_FOR_BLANK_IN() -> vEntry_WAIT_FOR_BLANK_OUT()
//   transID 0012:  state BLANK_IN_ACTIVE --(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF)--> state WAIT_FOR_BLANK_OUT  if (eTriggerHmiAvm3_HMI_AVAILABLE)  (during state change)
//     call sequence:  vExit_BLANK_IN_ACTIVE() -> vEntry_WAIT_FOR_BLANK_OUT()
//   transID 0014:  state ON --(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF)--> state WAIT_FOR_BLANK_OUT  if (eTriggerHmiAvm3_HMI_AVAILABLE)  (during state change)
//     call sequence:  vEntry_WAIT_FOR_BLANK_OUT()
//   transID 0019:  state ON_VID_SETTINGS --(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF)--> state WAIT_FOR_BLANK_OUT  (during state change)
//     call sequence:  vEntry_WAIT_FOR_BLANK_OUT()

   if (FSM_IS_FULLY_OPERATIONAL) {
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_WAIT_FOR_BLANK_OUT: user specific code start

      if (FSM_IS_TRIGGER_SET(eTriggerHmiAvm3_VIDSET_REQ_VISUAL_ON)) {
         FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_OUT_CAMERA_SETTINGS);  // update property SystemStatus
      } else {
         FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_OUT);                  // update property SystemStatus
      }

      if (EN_VD_RVC_HMI_VISUALISATION_OFF__CRITICAL_UNDERVOLTAGE == FSM_HMIAVM3_VISOFF_REASON) {
         FSM_HMIAVM3_SET_VIDEO_CAPTURE(FALSE);  // In case of critical under-voltage stop video capturing immediately
      }
      
      FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_AVM_REQ_BLANK_OUT_END);
      (tVoid) FSM_START_TIMER(eTimerHmiAvm3_StateToutWaitForBlankOut,FSM_HMIAVM3_SAFEGUARD_TOUT_BLANKOUT_MS);
      
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_WAIT_FOR_BLANK_OUT: user specific code end
   }
}


/******************************************************************************/
// FUNCTION     vExit_WAIT_FOR_BLANK_OUT
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vExit_WAIT_FOR_BLANK_OUT(tVoid)
{
// transition candidates:
//   transID 0001:  <any_state> --(eTriggerHmiAvm3_REQ_FSM_RESET)--> state EXEC_FSM_RESET  (during state change)
//     call sequence:  vExit_WAIT_FOR_BLANK_OUT()
//   transID 0022:  state WAIT_FOR_BLANK_OUT --(eTriggerHmiAvm3_HMI_CONF_BLANK_OUT)--> state BLANK_OUT_ACTIVE  (during state change)
//     call sequence:  vExit_WAIT_FOR_BLANK_OUT() -> vEntry_BLANK_OUT_ACTIVE()
//   transID 0023:  state WAIT_FOR_BLANK_OUT --(eTriggerHmiAvm3_STATE_TOUT_WAIT_FOR_BLANK_OUT)--> state BLANK_OUT_ACTIVE  (during state change)
//     call sequence:  vExit_WAIT_FOR_BLANK_OUT() -> vEntry_BLANK_OUT_ACTIVE()
//   transID 0024:  state WAIT_FOR_BLANK_OUT --(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON)--> state WAIT_FOR_BLANK_IN  (during state change)
//     call sequence:  vExit_WAIT_FOR_BLANK_OUT() -> vEntry_WAIT_FOR_BLANK_IN()

   if (FSM_IS_FULLY_OPERATIONAL) {
      // dispvidctrl_tclFsm_HmiAvm3::vExit_WAIT_FOR_BLANK_OUT: user specific code start
      
      (tVoid) FSM_STOP_TIMER(eTimerHmiAvm3_StateToutWaitForBlankOut);

      // dispvidctrl_tclFsm_HmiAvm3::vExit_WAIT_FOR_BLANK_OUT: user specific code end
   }
}


/******************************************************************************/
// FUNCTION     vEntry_BLANK_OUT_ACTIVE
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vEntry_BLANK_OUT_ACTIVE(tVoid)
{
// transition candidates:
//   transID 0013:  state BLANK_IN_ACTIVE --(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF)--> state BLANK_OUT_ACTIVE  if !(eTriggerHmiAvm3_HMI_AVAILABLE)  (during state change)
//     call sequence:  vExit_BLANK_IN_ACTIVE() -> vEntry_BLANK_OUT_ACTIVE()
//   transID 0015:  state ON --(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF)--> state BLANK_OUT_ACTIVE  if !(eTriggerHmiAvm3_HMI_AVAILABLE)  (during state change)
//     call sequence:  vEntry_BLANK_OUT_ACTIVE()
//   transID 0022:  state WAIT_FOR_BLANK_OUT --(eTriggerHmiAvm3_HMI_CONF_BLANK_OUT)--> state BLANK_OUT_ACTIVE  (during state change)
//     call sequence:  vExit_WAIT_FOR_BLANK_OUT() -> vEntry_BLANK_OUT_ACTIVE()
//   transID 0023:  state WAIT_FOR_BLANK_OUT --(eTriggerHmiAvm3_STATE_TOUT_WAIT_FOR_BLANK_OUT)--> state BLANK_OUT_ACTIVE  (during state change)
//     call sequence:  vExit_WAIT_FOR_BLANK_OUT() -> vEntry_BLANK_OUT_ACTIVE()

   if (FSM_IS_FULLY_OPERATIONAL) {
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_BLANK_OUT_ACTIVE: user specific code start
      
      ETG_TRACE_USR4((" FSM-HMIAVM3   :: HmiVisualisationOffReason = ............ %-40d", ETG_CENUM(tenHmiVisualisationOffReason, FSM_HMIAVM3_VISOFF_REASON)));

      if (! FSM_IS_TRANSITION_FROM_STATE(eStateHmiAvm3_WAIT_FOR_BLANK_OUT)) {  // avoid duplicate FSM_OUT-event if we come from WAIT_FOR_BLANK_OUT
         FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_OUT);  // update property SystemStatus
         
         if (EN_VD_RVC_HMI_VISUALISATION_OFF__CRITICAL_UNDERVOLTAGE == FSM_HMIAVM3_VISOFF_REASON) {
            FSM_HMIAVM3_SET_VIDEO_CAPTURE(FALSE);  // In case of critical under-voltage stop video capturing immediately
         }
      }
            
      FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_CONFIRM_VISUALISATION_BLACK_OUT);     
      FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__AVM_REQ_DIRECT_CAM_OFF);

      if (FSM_IS_TRIGGER_SET(eTriggerHmiAvm3_AVM_REQ_BLANK_OUT_END)) {  // if the trigger has already arrived while we were still in WAIT_FOR_BLANK_OUT:
         // trigger it again to bring us to OFF without further waiting
         FSM_HMIAVM3_OUT_EVENT( FSM_HMIAVM3_OUT__FSM_HMIAVM3_INPUT_EVENT, (tU32) eTriggerHmiAvm3_AVM_REQ_BLANK_OUT_END );
      }
      
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_BLANK_OUT_ACTIVE: user specific code end
   }
}


/******************************************************************************/
// FUNCTION     vExit_BLANK_OUT_ACTIVE
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vExit_BLANK_OUT_ACTIVE(tVoid)
{
// transition candidates:
//   transID 0001:  <any_state> --(eTriggerHmiAvm3_REQ_FSM_RESET)--> state EXEC_FSM_RESET  (during state change)
//     call sequence:  vExit_BLANK_OUT_ACTIVE()
//   transID 0025:  state BLANK_OUT_ACTIVE --(eTriggerHmiAvm3_AVM_REQ_BLANK_OUT_END)--> state OFF  (during state change)
//     call sequence:  vExit_BLANK_OUT_ACTIVE() -> vEntry_OFF()
//   transID 0026:  state BLANK_OUT_ACTIVE --(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON)--> state WAIT_FOR_BLANK_IN  if (eTriggerHmiAvm3_HMI_AVAILABLE)  (during state change)
//     call sequence:  vExit_BLANK_OUT_ACTIVE() -> vEntry_WAIT_FOR_BLANK_IN()
//   transID 0027:  state BLANK_OUT_ACTIVE --(eTriggerHmiAvm3_AVM_REQ_VISUAL_ON)--> state BLANK_IN_ACTIVE  if !(eTriggerHmiAvm3_HMI_AVAILABLE)  (during state change)
//     call sequence:  vExit_BLANK_OUT_ACTIVE() -> vEntry_BLANK_IN_ACTIVE()

   if (FSM_IS_FULLY_OPERATIONAL) {
      // dispvidctrl_tclFsm_HmiAvm3::vExit_BLANK_OUT_ACTIVE: user specific code start

      FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_AVM_REQ_BLANK_OUT_END);

      // dispvidctrl_tclFsm_HmiAvm3::vExit_BLANK_OUT_ACTIVE: user specific code end
   }
}


/******************************************************************************/
// FUNCTION     vEntry_DIAG_BLANK_IN_ACTIVE
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vEntry_DIAG_BLANK_IN_ACTIVE(tVoid)
{
// transition candidates:
//   transID 0004:  state OFF --(eTriggerHmiAvm3_DIAG_REQ_VISUAL_ON)--> state DIAG_BLANK_IN_ACTIVE  (during state change)
//     call sequence:  vTransitionAction(eActionHmiAvm3_SetTimer,eTimerHmiAvm3_StateToutDiagBlankIn,FSM_HMIAVM3_SAFEGUARD_TOUT_DIAG_BLANKIN_MS) -> vEntry_DIAG_BLANK_IN_ACTIVE()

   if (FSM_IS_FULLY_OPERATIONAL) {
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_DIAG_BLANK_IN_ACTIVE: user specific code start
      
      FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_IN);  // update property SystemStatus
      FSM_HMIAVM3_SET_VIDEO_CAPTURE(TRUE);

      FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_CONFIRM_VISUALISATION_BLACK_IN);
      
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_DIAG_BLANK_IN_ACTIVE: user specific code end
   }
}


/******************************************************************************/
// FUNCTION     vEntry_ON_DIAG
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vEntry_ON_DIAG(tVoid)
{
// transition candidates:
//   transID 0030:  state DIAG_BLANK_IN_ACTIVE --(eTriggerHmiAvm3_AVM_CONF_VIEW_SETUP)--> state ON_DIAG  (during state change)
//     call sequence:  vTransitionAction(eActionHmiAvm3_SetTimer,eTimerHmiAvm3_StateToutDiagBlankIn,0) -> vEntry_ON_DIAG()

   if (FSM_IS_FULLY_OPERATIONAL) {
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_ON_DIAG: user specific code start
      
      FSM_CLEAR_TRIGGER(eTriggerHmiAvm3_AVM_REQ_BLANK_IN_END);
      FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_VISUALISATION_ON);      // send property update
      
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_ON_DIAG: user specific code end
   }
}


/******************************************************************************/
// FUNCTION     vEntry_DIAG_BLANK_OUT_ACTIVE
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vEntry_DIAG_BLANK_OUT_ACTIVE(tVoid)
{
// transition candidates:
//   transID 0031:  state ON_DIAG --(eTriggerHmiAvm3_AVM_REQ_VISUAL_OFF)--> state DIAG_BLANK_OUT_ACTIVE  (during state change)
//     call sequence:  vTransitionAction(eActionHmiAvm3_SetTimer,eTimerHmiAvm3_StateToutDiagBlankOut,FSM_HMIAVM3_SAFEGUARD_TOUT_DIAG_BLANKOUT_MS) -> vEntry_DIAG_BLANK_OUT_ACTIVE()

   if (FSM_IS_FULLY_OPERATIONAL) {
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_DIAG_BLANK_OUT_ACTIVE: user specific code start

      FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_OUT);  // update property SystemStatus
      FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_CONFIRM_VISUALISATION_BLACK_OUT);
      FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__AVM_REQ_DIRECT_CAM_OFF);
            
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_DIAG_BLANK_OUT_ACTIVE: user specific code end
   }
}


/******************************************************************************/
// FUNCTION     vEntry_ON_VID_SETTINGS
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_HmiAvm3::vEntry_ON_VID_SETTINGS(tVoid)
{
// transition candidates:
//   transID 0010:  state BLANK_IN_ACTIVE --(eTriggerHmiAvm3_AVM_CONF_VIEW_SETUP)--> state ON_VID_SETTINGS  if (eTriggerHmiAvm3_VIDSET_REQ_VISUAL_ON)  (during state change)
//     call sequence:  vExit_BLANK_IN_ACTIVE() -> vEntry_ON_VID_SETTINGS()

   if (FSM_IS_FULLY_OPERATIONAL) {
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_ON_VID_SETTINGS: user specific code start

      FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__VIDEO_SET_VIDEO_CONTROLS);  // set video controls (brightness, contrast, colour)
      FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__HMI_VISUALISATION_ON_CAMERA_SETTINGS);     // update property SystemStatus
      
      // dispvidctrl_tclFsm_HmiAvm3::vEntry_ON_VID_SETTINGS: user specific code end
   }
}


/******************************************************************************/
// FUNCTION     _bSetTimer_StateToutWaitForBlankIn
/******************************************************************************/
/**
*  \brief       start or stop user-managed timer StateToutWaitForBlankIn
*
*  \param       time out value in millisecond
*  \return      tBool - timer start/stop success state
*/
/******************************************************************************/
tBool  dispvidctrl_tclFsm_HmiAvm3::_bSetTimer_StateToutWaitForBlankIn( OSAL_tMSecond msTimeout ) const
{
    tBool bSuccess = TRUE;
    if ( OSAL_C_INVALID_HANDLE  != _hTimerHandle_StateToutWaitForBlankIn ) {
        if ( OSAL_s32TimerSetTime( _hTimerHandle_StateToutWaitForBlankIn, msTimeout, 0 ) != OSAL_OK )  // user-managed timer StateToutWaitForBlankIn
        {
            bSuccess = FALSE;
        }
    }
    return(bSuccess);
}


/******************************************************************************/
// FUNCTION     _bSetTimer_StateToutWaitForBlankOut
/******************************************************************************/
/**
*  \brief       start or stop user-managed timer StateToutWaitForBlankOut
*
*  \param       time out value in millisecond
*  \return      tBool - timer start/stop success state
*/
/******************************************************************************/
tBool  dispvidctrl_tclFsm_HmiAvm3::_bSetTimer_StateToutWaitForBlankOut( OSAL_tMSecond msTimeout ) const
{
    tBool bSuccess = TRUE;
    if ( OSAL_C_INVALID_HANDLE  != _hTimerHandle_StateToutWaitForBlankOut ) {
        if ( OSAL_s32TimerSetTime( _hTimerHandle_StateToutWaitForBlankOut, msTimeout, 0 ) != OSAL_OK )  // user-managed timer StateToutWaitForBlankOut
        {
            bSuccess = FALSE;
        }
    }
    return(bSuccess);
}


/******************************************************************************/
// FUNCTION     _bSetTimer_StateToutDiagBlankIn
/******************************************************************************/
/**
*  \brief       start or stop user-managed timer StateToutDiagBlankIn
*
*  \param       time out value in millisecond
*  \return      tBool - timer start/stop success state
*/
/******************************************************************************/
tBool  dispvidctrl_tclFsm_HmiAvm3::_bSetTimer_StateToutDiagBlankIn( OSAL_tMSecond msTimeout ) const
{
    tBool bSuccess = TRUE;
    if ( OSAL_C_INVALID_HANDLE  != _hTimerHandle_StateToutDiagBlankIn ) {
        if ( OSAL_s32TimerSetTime( _hTimerHandle_StateToutDiagBlankIn, msTimeout, 0 ) != OSAL_OK )  // user-managed timer StateToutDiagBlankIn
        {
            bSuccess = FALSE;
        }
    }
    return(bSuccess);
}


/******************************************************************************/
// FUNCTION     _bSetTimer_StateToutDiagBlankOut
/******************************************************************************/
/**
*  \brief       start or stop user-managed timer StateToutDiagBlankOut
*
*  \param       time out value in millisecond
*  \return      tBool - timer start/stop success state
*/
/******************************************************************************/
tBool  dispvidctrl_tclFsm_HmiAvm3::_bSetTimer_StateToutDiagBlankOut( OSAL_tMSecond msTimeout ) const
{
    tBool bSuccess = TRUE;
    if ( OSAL_C_INVALID_HANDLE  != _hTimerHandle_StateToutDiagBlankOut ) {
        if ( OSAL_s32TimerSetTime( _hTimerHandle_StateToutDiagBlankOut, msTimeout, 0 ) != OSAL_OK )  // user-managed timer StateToutDiagBlankOut
        {
            bSuccess = FALSE;
        }
    }
    return(bSuccess);
}


/******************************************************************************/
// FUNCTION     _pfCallbackTimer_StateToutWaitForBlankIn
/******************************************************************************/
/**
*  \brief       Called by OS if user-managed timer StateToutWaitForBlankIn elapses
*
*  \param       pArg - pointer to this class
*  \return      none
*/
/******************************************************************************/
OSAL_tpfCallback dispvidctrl_tclFsm_HmiAvm3::_pfCallbackTimer_StateToutWaitForBlankIn(tVoid* pArg)
{
   (tVoid) pArg;
   if (FSM_IS_FULLY_OPERATIONAL) {
      // send loop-back event to ourselves for timeout of user-managed timer StateToutWaitForBlankIn
      FSM_HMIAVM3_OUT_EVENT( FSM_HMIAVM3_OUT__FSM_HMIAVM3_INPUT_EVENT, (tU32) eTriggerHmiAvm3_STATE_TOUT_WAIT_FOR_BLANK_IN );
   }
   return 0;
}


/******************************************************************************/
// FUNCTION     _pfCallbackTimer_StateToutWaitForBlankOut
/******************************************************************************/
/**
*  \brief       Called by OS if user-managed timer StateToutWaitForBlankOut elapses
*
*  \param       pArg - pointer to this class
*  \return      none
*/
/******************************************************************************/
OSAL_tpfCallback dispvidctrl_tclFsm_HmiAvm3::_pfCallbackTimer_StateToutWaitForBlankOut(tVoid* pArg)
{
   (tVoid) pArg;
   if (FSM_IS_FULLY_OPERATIONAL) {
      // send loop-back event to ourselves for timeout of user-managed timer StateToutWaitForBlankOut
      FSM_HMIAVM3_OUT_EVENT( FSM_HMIAVM3_OUT__FSM_HMIAVM3_INPUT_EVENT, (tU32) eTriggerHmiAvm3_STATE_TOUT_WAIT_FOR_BLANK_OUT );
   }
   return 0;
}


/******************************************************************************/
// FUNCTION     _pfCallbackTimer_StateToutDiagBlankIn
/******************************************************************************/
/**
*  \brief       Called by OS if user-managed timer StateToutDiagBlankIn elapses
*
*  \param       pArg - pointer to this class
*  \return      none
*/
/******************************************************************************/
OSAL_tpfCallback dispvidctrl_tclFsm_HmiAvm3::_pfCallbackTimer_StateToutDiagBlankIn(tVoid* pArg)
{
   (tVoid) pArg;
   if (FSM_IS_FULLY_OPERATIONAL) {
      // send loop-back event to ourselves for timeout of user-managed timer StateToutDiagBlankIn
      FSM_HMIAVM3_OUT_EVENT( FSM_HMIAVM3_OUT__FSM_HMIAVM3_INPUT_EVENT, (tU32) eTriggerHmiAvm3_STATE_TOUT_DIAG_BLANK_IN );
   }
   return 0;
}


/******************************************************************************/
// FUNCTION     _pfCallbackTimer_StateToutDiagBlankOut
/******************************************************************************/
/**
*  \brief       Called by OS if user-managed timer StateToutDiagBlankOut elapses
*
*  \param       pArg - pointer to this class
*  \return      none
*/
/******************************************************************************/
OSAL_tpfCallback dispvidctrl_tclFsm_HmiAvm3::_pfCallbackTimer_StateToutDiagBlankOut(tVoid* pArg)
{
   (tVoid) pArg;
   if (FSM_IS_FULLY_OPERATIONAL) {
      // send loop-back event to ourselves for timeout of user-managed timer StateToutDiagBlankOut
      FSM_HMIAVM3_OUT_EVENT( FSM_HMIAVM3_OUT__FSM_HMIAVM3_INPUT_EVENT, (tU32) eTriggerHmiAvm3_STATE_TOUT_DIAG_BLANK_OUT );
   }
   return 0;
}


/******************************************************************************/
// FUNCTION     bSetTimer
/******************************************************************************/
/**
*  \brief       start or stop one of the FSM timers via its ID
*
*  \param       timer ID
*  \param       time out value in millisecond
*  \return      tBool - timer start/stop success state
*/
/******************************************************************************/
tBool  dispvidctrl_tclFsm_HmiAvm3::bSetTimer(tU32 u32TimerId, tU32 u32MilliSec) const
{
    ETG_TRACE_USR4((" FSM-HMIAVM3  :: bSetTimer() called - timerID=%u, timeOut=%u", ETG_ENUM(tenFsm_HmiAvm3_Timer, u32TimerId),u32MilliSec ));
    
    tBool bSuccess = FALSE;
    switch (u32TimerId)
    {
       case eTimerHmiAvm3_StateToutWaitForBlankIn:
          bSuccess = _bSetTimer_StateToutWaitForBlankIn((OSAL_tMSecond) u32MilliSec);
          break;
       case eTimerHmiAvm3_StateToutWaitForBlankOut:
          bSuccess = _bSetTimer_StateToutWaitForBlankOut((OSAL_tMSecond) u32MilliSec);
          break;
       case eTimerHmiAvm3_StateToutDiagBlankIn:
          bSuccess = _bSetTimer_StateToutDiagBlankIn((OSAL_tMSecond) u32MilliSec);
          break;
       case eTimerHmiAvm3_StateToutDiagBlankOut:
          bSuccess = _bSetTimer_StateToutDiagBlankOut((OSAL_tMSecond) u32MilliSec);
          break;

       // dispvidctrl_tclFsm_HmiAvm3::bSetTimer: user specific code start
       // dispvidctrl_tclFsm_HmiAvm3::bSetTimer: user specific code end

       default:
          ETG_TRACE_USR1((" FSM-HMIAVM3  :: bSetTimer(): invalid timer ID %u", ETG_ENUM(tenFsm_HmiAvm3_Timer, u32TimerId) ));
          break;
    }

    ETG_TRACE_USR4((" FSM-HMIAVM3  :: bSetTimer(): bSuccess=%u", bSuccess ));
    return bSuccess;
}


// dispvidctrl_tclFsm_HmiAvm3_code: user specific code start


void dispvidctrl_tclFsm_HmiAvm3::bSetVideoCapturingOnOrOff(tBool bOn)
{
    if (bOn) {
       // before we start video capturing, we have to enable gamma correction
       FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__VIDEO_SET_GAMMA_ON);
       // start capturing, but do not show video layer yet
       FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__VIDEO_CAPTURING_START);
       // start video signal detection check for verification in all cases
       FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__VIDEO_SIGNAL_CHECK, (tU32) EN_HMIAVM3_VID_TIMER__START);
    } else {
       // stop video capturing
       FSM_HMIAVM3_OUT_EVENT(FSM_HMIAVM3_OUT__VIDEO_CAPTURING_STOP);
       // video signal check will be stopped with capturing stop
    }    
}


// dispvidctrl_tclFsm_HmiAvm3_code: user specific code end
