/******************************************************************************/
/**
* \file    dispvidctrl_tclFsm_Hmi.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Harry Wentland, Michael Niemann
* \remark  Scope     : AIVI - fc_dispvidctrl Hmi
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_FSM_HMI_H_
#define _DISPVIDCTRL_TCL_FSM_HMI_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
   #define OSAL_S_IMPORT_INTERFACE_GENERIC
   #include "osal_if.h"
#endif

#include "dispvidctrl_tclFsm_Base.h"

/*******************************************************************************
                        Defines
*******************************************************************************/

typedef struct
{
   tU32 u32BlackInTime;
   tU32 u32BlackOutTime;
   tBool bRvcMode;
}TConfiguration_Fsm_Hmi;


class dispvidctrl_tclControl_Hmi;
//******************************************************************************
//  CLASS dispvidctrl_tclFsm_Hmi
//******************************************************************************

class dispvidctrl_tclFsm_Hmi: public dispvidctrl_tclFsm_Base
{
   public:

      // available states ------------------------------------------
      enum
      {
         eState_OFF                               =  0,
         eState_BLACK_IN                          =  1,
         eState_BLACK_IN_CAMERA_SETTINGS_REQUEST  =  2,
         eState_ON                                =  3,
         eState_ON_CAMERA_SETTINGS                =  4,
         eState_BLACK_OUT                         =  5,
         eState_ON_CAMERA_DIAG                    =  6,
         eState_BLACK_IN_CAMERA_DIAG_REQUEST      =  7,

         // special wait states, to keep HMI and midw screen transitions in sync
         eState_WAITING_HMI_BLACK_IN                      =  8,
         eState_WAITING_BLACK_IN_CAMERA_SETTINGS_REQUEST  =  9,

         eState_BLACK_IN_GUIDELINE_ADJUSTMENT     =  10,
         eState_ON_GUIDELINE_ADJUSTMENT           =  11,

         eState_MAX,
         eState_INVALID                           = 0xFFFF
      };

      // available FSM input trigger -------------------------------
      enum
      {
         eTrigger_NONE                             = 0x00000000,

         eTrigger_HMI_AVAILABLE                    = 0x00000001,
         eTrigger_VIDEO_SIGNAL_FALSE               = 0x00000002,
         eTrigger_VIDEO_SIGNAL_TRUE                = 0x00000004,
         eTrigger_TIMEOUT_BLACKIN                  = 0x00000008,

         eTrigger_TIMEOUT_BLACKOUT                 = 0x00000010,
         eTrigger_ON_REQUEST_AFTER_BLACKOUT        = 0x00000020,
         eTrigger_VIDEO_SIGNAL_FAILURE             = 0x00000040,
         eTrigger_VISUALISATION_ON_CAMERA_SETTINGS = 0x00000080,

         eTrigger_VISUALISATION_OFF                = 0x00000100,
         eTrigger_VISUALISATION_ON                 = 0x00000200,
         eTrigger_TOGGLE_GUIDELINES                = 0x00000400,
         eTrigger_OFF_REASON_CLEAN_UP              = 0x00000800,

         eTrigger_DIRECT_OFF                       = 0x00001000,
         eTrigger_DIRECT_ON                        = 0x00002000,
         eTrigger_DIRECT_BLACK_OUT                 = 0x00004000,
         eTrigger_DIRECT_BLACK_IN                  = 0x00008000,

         eTrigger_VISUALISATION_ON_CAMERA_DIAG          = 0x00010000,
         eTrigger_VISUALISATION_ON_GUIDELINE_ADJUSTMENT = 0x00020000,
         eTrigger_GRAPHICS_OFF                          = 0x00040000,
         eTrigger_GRAPHICS_ON                           = 0x00080000,

         // triggers related to confirmation from HMI about the state transitions
         // switch the actual states, only after confirmation to keep HMI and Midw in sync
         // this is to avoid flicker during the transition
         eTrigger_HMI_OFF_CONFIRM                  = 0x00100000,
         eTrigger_HMI_BLACKIN_CONFIRM              = 0x00200000,
         eTrigger_HMI_ON_CONFIRM                   = 0x00400000,
         eTrigger_HMI_BLACKOUT_CONFIRM             = 0x00800000,

         eTrigger_HMI_ON_CAMERASETTINGS            = 0x01000000,
         eTrigger_REVERSE_OFF                      = 0x02000000,
         eTrigger_REVERSE_ON                       = 0x04000000,
         eTrigger_BLACK_OUT_WAITING_NOT_ALLOWED    = 0x08000000,
         
         eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT   = 0x10000000,
         eTrigger_STATE_OVERSPEED_RVC                  = 0x20000000,
         eTrigger_STATE_TIMEOUT                        = 0x40000000,

      };

      enum tenHmiVisualisationOffReason
      {
         EN_VD_RVC_HMI_VISUALISATION_OFF__NOT_SPEZIFIED = 0,
         EN_VD_RVC_HMI_VISUALISATION_OFF__REQUEST_OFF,
         EN_VD_RVC_HMI_VISUALISATION_OFF__ON_SETTINGS_REQUEST_AFTER_BLACKOUT,
         EN_VD_RVC_HMI_VISUALISATION_OFF__ON_REQUEST_AFTER_BLACKOUT,
         EN_VD_RVC_HMI_VISUALISATION_OFF__SERVICE_REQUEST_OFF, // Used for Ignition, Speed, Disable triggers
         EN_VD_RVC_HMI_VISUALISATION_OFF__OVERSPEED,
         EN_VD_RVC_HMI_VISUALISATION_OFF__OVERSPEED_RVCMODE,
         EN_VD_RVC_HMI_VISUALISATION_OFF__VIDEO_SIGNAL_FAILURE,
         EN_VD_RVC_HMI_VISUALISATION_OFF__RVC_ELECTRIC_FAILURE,
         EN_VD_RVC_HMI_VISUALISATION_OFF__SYSTEM_MALFUNCTION,
         EN_VD_RVC_HMI_VISUALISATION_OFF__APPLICATION_STATE_NOT_NORMAL,
         EN_VD_RVC_HMI_VISUALISATION_OFF__CRITICAL_UNDERVOLTAGE,
         EN_VD_RVC_HMI_VISUALISATION_OFF__HMI_NOT_AVAILABLE,
         EN_VD_RVC_HMI_VISUALISATION_OFF__DIAG_VIDEO_LAYER_OFF,
         EN_VD_RVC_HMI_VISUALISATION_OFF__GUIDELINE_ADJUSTMENT_OFF,
         EN_VD_RVC_HMI_VISUALISATION_OFF__INITIAL_OFF
      };

      static dispvidctrl_tclFsm_Hmi* tclCreateInstance(dispvidctrl_tclControl_Hmi* poHmiControl);

      dispvidctrl_tclFsm_Hmi();                           // default constructor
      dispvidctrl_tclFsm_Hmi(dispvidctrl_tclControl_Hmi* poHmiControl);  // constructor
      virtual ~dispvidctrl_tclFsm_Hmi(tVoid);             // destructor

      tVoid vConfigure(const TConfiguration_Fsm_Hmi* pStConfiguration_Fsm_Hmi);

      tVoid vNewTrigger(tU32 u32Trigger, tBool bTriggerState);
      tVoid vUpdateTriggerState(tU32 u32Trigger, tBool bTriggerState);

      tenHmiVisualisationOffReason m_enHmiVisualisationOffReason;

   protected:
      virtual tVoid vStateChangeDetected(tVoid);
      virtual tVoid vStartFsmStateTimer(tU32 u32Time); // overwrites FsmBase class function
      virtual tVoid vUpdateRelatedTrigger(tU32 u32Trigger);

   private:
      static tVoid vEntry_Off(tVoid);
      static tVoid vDo_Off(tVoid);
      static tVoid vExit_Off(tVoid);
      static tVoid vEntry_BlackIn(tVoid);
      static tVoid vExit_BlackIn(tVoid);
      static tVoid vEntry_BlackInCameraSettingsRequest(tVoid);
      static tVoid vExit_BlackInCameraSettingsRequest(tVoid);
      static tVoid vEntry_BlackInCameraDiagRequest(tVoid);
      static tVoid vExit_BlackInCameraDiagRequest(tVoid);
      static tVoid vDo_On(tVoid);
      static tVoid vExit_On(tVoid);
      static tVoid vDo_OnCameraSettings(tVoid);
      static tVoid vExit_OnCameraSettings(tVoid);
      static tVoid vExit_OnCameraDiag(tVoid);
      static tVoid vEntry_BlackOut(tVoid);
      static tVoid vDo_BlackOut(tVoid);
      static tVoid vExit_BlackOut(tVoid);
      static tVoid vExit_WaitingHMIBlackIn(tVoid);
      static tVoid vExit_Waiting_BlackIn_Camera_Settings(tVoid);
      static tVoid vEntry_BlackInGuidelineAdjustment(tVoid);
      static tVoid vExit_BlackInGuidelineAdjustment(tVoid);
      static tVoid vExit_OnGuidelineAdjustment(tVoid);

      static OSAL_tpfCallback _pfCallbackTimer_BlackIn(tVoid* pArg);
      static OSAL_tpfCallback _pfCallbackTimer_BlackOut(tVoid* pArg);
      static OSAL_tpfCallback _pfCallbackTimer_FsmStateChange(tVoid* pArg);
      tBool  _bSetTimer_BlackIn(tBool bStartStop) const;
      tBool  _bSetTimer_BlackOut(tBool bStartStop) const;
      tBool  _bSetTimer_FsmStateChange(OSAL_tMSecond msTimeout) const;
      OSAL_tTimerHandle  _hTimerHandle_BlackIn;
      OSAL_tTimerHandle  _hTimerHandle_BlackOut;
      OSAL_tTimerHandle  _hTimerHandle_FsmStateChange;

      static TFsmStateConf     aFsm_Hmi_StateTable[eState_MAX];
      static TStateTransitions aFsm_Hmi_StateTransitionTable[];

      dispvidctrl_tclControl_Hmi* m_poHmiControl;
      static dispvidctrl_tclFsm_Hmi* m_poInstance;

      // configuration data
      tU32 m_u32BlackInTime;
      tU32 m_u32BlackOutTime;
      static tBool m_bRvcMode;
};

#endif

