/******************************************************************************/
/**
* \file    dispvidctrl_tclFsm_Hmi.cpp
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Harry Wentland
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/
/*
*
*/
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_tclFsm_Hmi.h"
#include "dispvidctrl_tclControl_Hmi.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"  //Lint537 repeatedly included
#ifndef ET_TRACE_INFO_ON // reference to define ET_TRACE_INFO_ON because of lint Info 750
// Info 750: prio2: local macro 'ET_TRACE_INFO_ON' not referenced
// (this lint error is related to the ETG framework and can't be solved here)
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_tclFsm_Hmi.cpp.trc.h"
#endif

#define ELEMENTE(array)       ((tU16)(sizeof(array)/sizeof(array[0])))

#define DISPVIDCTRL_TRACE_ID_FSM_HMI           (tU8) 0x04

dispvidctrl_tclFsm_Hmi*  dispvidctrl_tclFsm_Hmi::m_poInstance = OSAL_NULL;

tU8 dispvidctrl_tclFsm_Hmi::m_bRvcMode = 0;

/*******************************************************************************
*                                  STATE TABLE
*******************************************************************************/
dispvidctrl_tclFsm_Hmi::TFsmStateConf dispvidctrl_tclFsm_Hmi::aFsm_Hmi_StateTable[eState_MAX]=
{
    {
        eState_OFF,
        0,                                              //u32Timeout
        vEntry_Off,                                     //tFsmStateEntryFunc
        vDo_Off,                                        //tFsmStateDoFunc
        vExit_Off                                       //tFsmStateExitFunc
    },
    {
        eState_BLACK_IN_CAMERA_SETTINGS_REQUEST,
        0,                                              //u32Timeout
        vEntry_BlackInCameraSettingsRequest,            //tFsmStateEntryFunc
        NULL,                                           //tFsmStateDoFunc
        vExit_BlackInCameraSettingsRequest              //tFsmStateExitFunc
    },
    {
        eState_ON_CAMERA_SETTINGS,
        0,                                              //u32Timeout
        NULL,                                           //tFsmStateEntryFunc
        vDo_OnCameraSettings,                           //tFsmStateDoFunc
        vExit_OnCameraSettings                          //tFsmStateExitFunc
    },
    {
        eState_BLACK_IN,
        0,                                              //u32Timeout
        vEntry_BlackIn,                                 //tFsmStateEntryFunc
        NULL,                                           //tFsmStateDoFunc
        vExit_BlackIn                                   //tFsmStateExitFunc
    },
    {
        eState_ON,
        0,                                              //u32Timeout
        NULL,                                           //tFsmStateEntryFunc
        vDo_On,                                         //tFsmStateDoFunc
        vExit_On                                        //tFsmStateExitFunc
    },
    {
        eState_BLACK_OUT,
        500,                                            //u32Timeout
        vEntry_BlackOut,                                //tFsmStateEntryFunc
        vDo_BlackOut,                                   //tFsmStateDoFunc
        vExit_BlackOut                                  //tFsmStateExitFunc
    },
    {
        eState_ON_CAMERA_DIAG,
        0,                                              //u32Timeout
        NULL,                                           //tFsmStateEntryFunc
        NULL,                                           //tFsmStateDoFunc
        vExit_OnCameraDiag                              //tFsmStateExitFunc
    },
    {
        eState_BLACK_IN_CAMERA_DIAG_REQUEST,
        0,                                              //u32Timeout
        vEntry_BlackInCameraDiagRequest,                //tFsmStateEntryFunc
        NULL,                                           //tFsmStateDoFunc
        vExit_BlackInCameraDiagRequest                  //tFsmStateExitFunc
    },
    {
        eState_WAITING_HMI_BLACK_IN,
        500,                                            //u32Timeout
        NULL,                                           //tFsmStateEntryFunc
        NULL,                                           //tFsmStateDoFunc
        vExit_WaitingHMIBlackIn                         //tFsmStateExitFunc
    },
    {
        eState_WAITING_BLACK_IN_CAMERA_SETTINGS_REQUEST,
        500,                                            //u32Timeout
        NULL,                                           //tFsmStateEntryFunc
        NULL,                                           //tFsmStateDoFunc
        vExit_Waiting_BlackIn_Camera_Settings           //tFsmStateExitFunc
    },
    {
        eState_BLACK_IN_GUIDELINE_ADJUSTMENT,
        0,                                              //u32Timeout
        vEntry_BlackInGuidelineAdjustment,              //tFsmStateEntryFunc
        NULL,                                           //tFsmStateDoFunc
        vExit_BlackInGuidelineAdjustment                //tFsmStateExitFunc
    },
    {
        eState_ON_GUIDELINE_ADJUSTMENT,
        0,                                              //u32Timeout
        NULL,                                           //tFsmStateEntryFunc
        NULL,                                           //tFsmStateDoFunc
        vExit_OnGuidelineAdjustment                     //tFsmStateExitFunc
    }
};

/*******************************************************************************
*                             STATE TRANSITION TABLE
*******************************************************************************/
dispvidctrl_tclFsm_Hmi::TStateTransitions dispvidctrl_tclFsm_Hmi::aFsm_Hmi_StateTransitionTable[] =
{
    //  ===== eState_OFF ==============================
    //  ---- transition actions------------------------
    {   100,                                            // transitionId
        eState_OFF,                                     // current FSM State
        eTrigger_VISUALISATION_ON_CAMERA_SETTINGS,      // trigger update
        eTrigger_HMI_AVAILABLE,                         // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_WAITING_BLACK_IN_CAMERA_SETTINGS_REQUEST // next FSM State
    },
    {   101,                                            // transitionId
        eState_OFF,                                     // current FSM State
        eTrigger_VISUALISATION_ON,                      // trigger update
        eTrigger_HMI_AVAILABLE,                         // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_WAITING_HMI_BLACK_IN                     // next FSM State
    },
    // eState_OFF --> eState_BLACK_IN_XXX
    {   105,                                            // transitionId
        eState_OFF,                                     // current FSM State
        eTrigger_VISUALISATION_ON_CAMERA_SETTINGS,      // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        eTrigger_HMI_AVAILABLE,                         // current not active trigger(s)
        eState_BLACK_IN_CAMERA_SETTINGS_REQUEST         // next FSM State
    },
    {   106,                                            // transitionId
        eState_OFF,                                     // current FSM State
        eTrigger_VISUALISATION_ON,                      // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        eTrigger_HMI_AVAILABLE,                         // current not active trigger(s)
        eState_BLACK_IN                                 // next FSM State
    },
    //  ---- direct transitions after Hmi available ---
    {   110,                                            // transitionId
        eState_OFF,                                     // current FSM State
        eTrigger_DIRECT_BLACK_IN,                       // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_IN                                 // next FSM State
    },
    {   111,                                            // transitionId
        eState_OFF,                                     // current FSM State
        eTrigger_DIRECT_ON,                             // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_ON                                       // next FSM State
    },
    {   112,                                            // transitionId
        eState_OFF,                                     // current FSM State
        eTrigger_DIRECT_BLACK_OUT,                      // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },
    {   113,                                            // transitionId
        eState_OFF,                                     // current FSM State
        eTrigger_VISUALISATION_ON_CAMERA_DIAG,          // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_IN_CAMERA_DIAG_REQUEST             // next FSM State
    },
    {   114,                                            // transitionId
        eState_OFF,                                     // current FSM State
        eTrigger_VISUALISATION_ON_GUIDELINE_ADJUSTMENT, // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_IN_GUIDELINE_ADJUSTMENT            // next FSM State
    },

    // ---- do actions -------------------------------
    {   130,                                            // transitionId
        eState_OFF,                                     // current FSM State
        eTrigger_DIRECT_OFF,                            // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_OFF                                      // next FSM State
    },

    //  ===== eState_BLACK_IN_CAMERA_SETTINGS_REQUEST =
    //  ---- transition actions -----------------------
    {   200,                                            // transitionId
        eState_BLACK_IN_CAMERA_SETTINGS_REQUEST,        // current FSM State
        eTrigger_TIMEOUT_BLACKIN,                       // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_ON_CAMERA_SETTINGS                       // next FSM State
    },
    {   201,                                            // transitionId
        eState_BLACK_IN_CAMERA_SETTINGS_REQUEST,        // current FSM State
        eTrigger_VISUALISATION_ON,                      // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_IN                                 // next FSM State
    },
    {   202,                                            // transitionId
        eState_BLACK_IN_CAMERA_SETTINGS_REQUEST,        // current FSM State
        eTrigger_VISUALISATION_OFF,                     // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },
    // ---- do actions -------------------------------
    {   230,                                            // transitionId
        eState_BLACK_IN_CAMERA_SETTINGS_REQUEST,        // current FSM State
        eTrigger_VIDEO_SIGNAL_TRUE,                     // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_IN_CAMERA_SETTINGS_REQUEST         // next FSM State
    },

    //  ===== eState_ON_CAMERA_SETTINGS ===============
    //  ---- transition actions -----------------------
    {   300,                                            // transitionId
        eState_ON_CAMERA_SETTINGS,                      // current FSM State
        eTrigger_VISUALISATION_ON,                      // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },
    {   301,                                            // transitionId
        eState_ON_CAMERA_SETTINGS,                      // current FSM State
        eTrigger_VISUALISATION_OFF,                     // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE1
    {   302,                                            // transitionId
        eState_ON_CAMERA_SETTINGS,                      // current FSM State
        eTrigger_VIDEO_SIGNAL_FALSE,                    // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },
#endif
    // ---- do actions -------------------------------
#ifndef VARIANT_S_FTR_ENABLE_AIVI_SCOPE1
    {   304,                                            // transitionId
        eState_ON_CAMERA_SETTINGS,                      // current FSM State
        eTrigger_VIDEO_SIGNAL_FALSE,                    // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_ON_CAMERA_SETTINGS                       // next FSM State
    },
    {   305,                                            // transitionId
        eState_ON_CAMERA_SETTINGS,                      // current FSM State
        eTrigger_VIDEO_SIGNAL_TRUE,                     // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_ON_CAMERA_SETTINGS                       // next FSM State
    },
#endif

    //  ===== eState_BLACK_IN =========================
    //  ---- transition actions -----------------------
    {   400,                                            // transitionId
        eState_BLACK_IN,                                // current FSM State
        eTrigger_TIMEOUT_BLACKIN,                       // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_ON                                       // next FSM State
    },
    {   401,                                            // transitionId
        eState_BLACK_IN,                                // current FSM State
        eTrigger_VISUALISATION_OFF,                     // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },

    //  ===== eState_ON ===============================
    //  ---- transition actions -----------------------
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE1
    {   500,                                            // transitionId
        eState_ON,                                      // current FSM State
        eTrigger_VIDEO_SIGNAL_FALSE,                    // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },
#else // do action to notify other SMs about Video Signal Failure
    {   500,                                            // transitionId
        eState_ON,                                      // current FSM State
        eTrigger_VIDEO_SIGNAL_FALSE,                    // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_ON                                       // next FSM State
    },
#endif
    {   501,                                            // transitionId
        eState_ON,                                      // current FSM State
        eTrigger_VISUALISATION_OFF,                     // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },
	{   550,                                            // transitionId
        eState_ON,                                      // current FSM State
        eTrigger_REVERSE_OFF,                     // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },
// Only in Renault we are allowed to switch between Camera and Camera Settings
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
    {   502,
        eState_ON,                                      // current FSM State
        eTrigger_VISUALISATION_ON_CAMERA_SETTINGS,      // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },
#endif
    // ---- do actions -------------------------------
    {   530,                                            // transitionId
        eState_ON,                                      // current FSM State
        eTrigger_TOGGLE_GUIDELINES,                     // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_ON                                       // next FSM State
    },
    {   531,                                            // transitionId
        eState_ON,                                      // current FSM State
        eTrigger_VIDEO_SIGNAL_TRUE,                     // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_ON                                       // next FSM State
    },
// Only in Renault we have to switch Graphics On/Off while we are On the Video
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
    {   532,
        eState_ON,                                      // current FSM State
        eTrigger_GRAPHICS_OFF,                          // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_ON                                       // next FSM State
    },
    {   533,
        eState_ON,                                      // current FSM State
        eTrigger_GRAPHICS_ON,                           // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_ON                                       // next FSM State
    },
#endif

    //  ===== eState_BLACK_OUT ========================
    //  ---- transition actions -----------------------
    // ----- eState_BLACK_OUT --> eState_OFF -------
    // Black-out Timer expire, check for HMI Confirmation before going to OFF State only if Reverse is OFF
    {   600,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_TIMEOUT_BLACKOUT,                      // trigger update
        eTrigger_HMI_BLACKOUT_CONFIRM,                  // current active trigger(s)
        eTrigger_ON_REQUEST_AFTER_BLACKOUT |
        eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT,    // current not active trigger(s)
        eState_OFF                                      // next FSM State
    },
    //todo: there is some map flicker observed with this, we need to re-visit this part
    // HMI Black-out confirmation as a trigger to go to Off Already if the Blac-out timer expired already
    //{   601,                                            // transitionId
    //    eState_BLACK_OUT,                               // current FSM State
    //    eTrigger_HMI_BLACKOUT_CONFIRM,                  // trigger update
    //    NULL,                                           // current active trigger(s)
    //    eTrigger_ON_REQUEST_AFTER_BLACKOUT |
    //    eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT |
    //    eTrigger_REVERSE_ON,                            // current not active trigger(s)
    //    eState_OFF                                      // next FSM State
    //},
    // Safety timer expired, while waiting for HMI confirmation for Black-out
    {   602,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_STATE_TIMEOUT,                         // trigger update
        eTrigger_BLACK_OUT_WAITING_NOT_ALLOWED,         // current active trigger(s)
        eTrigger_ON_REQUEST_AFTER_BLACKOUT |
        eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT,    // current not active trigger(s)
        eState_OFF                                      // next FSM State
    },
    // Safety timer expired, while waiting for HMI confirmation for Black-out
    {   603,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_STATE_TIMEOUT,                         // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        eTrigger_ON_REQUEST_AFTER_BLACKOUT |
        eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT |
        eTrigger_STATE_OVERSPEED_RVC,                   // current not active trigger(s)
        eState_OFF                                      // next FSM State
    },
    // Reverse Off and the Safety timer has already expired
    {   604,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_REVERSE_OFF,                           // trigger update
        eTrigger_STATE_TIMEOUT,                         // current active trigger(s)
        eTrigger_ON_REQUEST_AFTER_BLACKOUT |
        eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT,    // current not active trigger(s)
        eState_OFF                                      // next FSM State
    },
    // ----- eState_BLACK_OUT --> eState_WAITING_HMI_BLACK_IN -------
    {   605,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_TIMEOUT_BLACKOUT,                      // trigger update
        eTrigger_ON_REQUEST_AFTER_BLACKOUT |
        eTrigger_HMI_AVAILABLE,                         // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_WAITING_HMI_BLACK_IN                     // next FSM State
    },
    {   606,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_TIMEOUT_BLACKOUT,                      // trigger update
        eTrigger_ON_REQUEST_AFTER_BLACKOUT,             // current active trigger(s)
        eTrigger_HMI_AVAILABLE,                         // current not active trigger(s)
        eState_BLACK_IN                                 // next FSM State
    },
    {   607,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_TIMEOUT_BLACKOUT,                      // trigger update
        eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT |
        eTrigger_HMI_AVAILABLE,                         // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_WAITING_BLACK_IN_CAMERA_SETTINGS_REQUEST // next FSM State
    },
    {   608,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_TIMEOUT_BLACKOUT,                      // trigger update
        eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT,    // current active trigger(s)
        eTrigger_HMI_AVAILABLE,                         // current not active trigger(s)
        eState_BLACK_IN_CAMERA_SETTINGS_REQUEST         // next FSM State
    },
    // if eTrigger_ON_REQUEST_AFTER_BLACKOUT after Black-out timer has already expired (while waiting for HMI Confirmation)
    {   609,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_STATE_TIMEOUT,                         // trigger update
        eTrigger_ON_REQUEST_AFTER_BLACKOUT |
        eTrigger_HMI_AVAILABLE,                         // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_WAITING_HMI_BLACK_IN                     // next FSM State
    },  
    {   610,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_STATE_TIMEOUT,                         // trigger update
        eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT |
        eTrigger_HMI_AVAILABLE,                         // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_WAITING_BLACK_IN_CAMERA_SETTINGS_REQUEST // next FSM State
    },  
    // if eTrigger_ON_REQUEST_AFTER_BLACKOUT after Black-out timer has already expired (while waiting for HMI Confirmation)
    {   611,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_STATE_TIMEOUT,                         // trigger update
        eTrigger_ON_REQUEST_AFTER_BLACKOUT,             // current active trigger(s)
        eTrigger_HMI_AVAILABLE,                         // current not active trigger(s)
        eState_BLACK_IN                                 // next FSM State
    },
    {   612,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_STATE_TIMEOUT,                         // trigger update
        eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT,    // current active trigger(s)
        eTrigger_HMI_AVAILABLE,                         // current not active trigger(s)
        eState_BLACK_IN_CAMERA_SETTINGS_REQUEST         // next FSM State
    },

    {   620,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_VISUALISATION_ON,                      // trigger update
        eTrigger_STATE_TIMEOUT,                         // current active trigger(s)
        eTrigger_HMI_AVAILABLE,                         // current not active trigger(s)
        eState_BLACK_IN                                 // next FSM State
    },
    {   621,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_VISUALISATION_ON,                      // trigger update
        eTrigger_STATE_TIMEOUT |
        eTrigger_HMI_AVAILABLE,                         // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_WAITING_HMI_BLACK_IN                     // next FSM State
    },  
    {   622,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_VISUALISATION_ON_CAMERA_SETTINGS,      // trigger update
        eTrigger_STATE_TIMEOUT,                         // current active trigger(s)
        eTrigger_HMI_AVAILABLE,                         // current not active trigger(s)
        eState_BLACK_IN_CAMERA_SETTINGS_REQUEST         // next FSM State
    },
    {   623,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_VISUALISATION_ON_CAMERA_SETTINGS,      // trigger update
        eTrigger_STATE_TIMEOUT |
        eTrigger_HMI_AVAILABLE,                         // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_WAITING_BLACK_IN_CAMERA_SETTINGS_REQUEST // next FSM State
    },
    // ---- do actions --------------------------------
    {   630,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_VISUALISATION_OFF,                     // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },
    {   631,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_VISUALISATION_ON,                      // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },
    {   632,                                            // transitionId
        eState_BLACK_OUT,                               // current FSM State
        eTrigger_OFF_REASON_CLEAN_UP,                   // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },

    //  ===== eState_BLACK_IN_DIAG_ON_CAMERA ==========
    //  ---- transition actions -----------------------
    {   700,                                            // transitionId
        eState_BLACK_IN_CAMERA_DIAG_REQUEST,            // current FSM State
        eTrigger_TIMEOUT_BLACKIN,                       // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_ON_CAMERA_DIAG                           // next FSM State
    },

    //  ===== eState_DIAG_ON_CAMERA ===================
    //  ---- transition actions -----------------------
    {   800,                                            // transitionId
        eState_ON_CAMERA_DIAG,                          // current FSM State
        eTrigger_VISUALISATION_OFF,                     // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },

    //  ===== eState_WAITING_HMI_BLACK_IN ===================
    // transition from Wait States to confirm states
    {   900,                                            // transitionId
        eState_WAITING_HMI_BLACK_IN,                    // current FSM State
        eTrigger_HMI_BLACKIN_CONFIRM,                   // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_IN                                 // next FSM State
    },
    // Maximum Wait for HMI confirmation timed out
    {   901,                                            // transitionId
        eState_WAITING_HMI_BLACK_IN,                    // current FSM State
        eTrigger_STATE_TIMEOUT,                         // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_IN                                 // next FSM State
    },
    // Handle Visualisation OFF from Wait States as well
    {   902,                                            // transitionId
        eState_WAITING_HMI_BLACK_IN,                    // current FSM State
        eTrigger_VISUALISATION_OFF,                     // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },
    //  ===== eState_WAITING_BLACK_IN_CAMERA_SETTINGS_REQUEST ===================
    {   1000,                                           // transitionId
        eState_WAITING_BLACK_IN_CAMERA_SETTINGS_REQUEST,// current FSM State
        eTrigger_HMI_BLACKIN_CONFIRM,                   // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_IN_CAMERA_SETTINGS_REQUEST         // next FSM State
    },
    // Maximum Wait for HMI confirmation timed out
    {   1001,                                           // transitionId
        eState_WAITING_BLACK_IN_CAMERA_SETTINGS_REQUEST,// current FSM State
        eTrigger_STATE_TIMEOUT,                         // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_IN_CAMERA_SETTINGS_REQUEST         // next FSM State
    },
    // Handle Visualisation OFF from Wait States as well
    {   1002,                                           // transitionId
        eState_WAITING_BLACK_IN_CAMERA_SETTINGS_REQUEST,// current FSM State
        eTrigger_VISUALISATION_OFF,                     // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    },

    //  ===== eState_BLACK_IN_GUIDELINE_ADJUSTMENT ====
    //  ---- transition actions -----------------------
    {   1100,                                           // transitionId
        eState_BLACK_IN_GUIDELINE_ADJUSTMENT,           // current FSM State
        eTrigger_TIMEOUT_BLACKIN,                       // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_ON_GUIDELINE_ADJUSTMENT                  // next FSM State
    },

    //  ===== eState_ON_GUIDELINE_ADJUSTMENT ==========
    //  ---- transition actions -----------------------
    {   1200,                                           // transitionId
        eState_ON_GUIDELINE_ADJUSTMENT,                 // current FSM State
        eTrigger_VISUALISATION_OFF,                     // trigger update
        FSM_DONT_CARE,                                  // current active trigger(s)
        FSM_DONT_CARE,                                  // current not active trigger(s)
        eState_BLACK_OUT                                // next FSM State
    }
};

/******************************************************************************/
/* FUNCTION     dispvidctrl_tclFsm_Hmi                                             */
/******************************************************************************/
/**
*  \brief       default constructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/

/******************************************************************************/
/* FUNCTION     dispvidctrl_tclFsm_Hmi(dispvidctrl_tclControl_Hmi* poHmiControl)        */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       pointer to control application
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclFsm_Hmi::dispvidctrl_tclFsm_Hmi(dispvidctrl_tclControl_Hmi* poHmiControl):
    dispvidctrl_tclFsm_Base( eState_OFF,
               ELEMENTE(aFsm_Hmi_StateTransitionTable),    aFsm_Hmi_StateTransitionTable,
               ELEMENTE(aFsm_Hmi_StateTable),              aFsm_Hmi_StateTable,
               (tU32) TR_CLASS_DISPVIDCTRL_APPLICATION,
               DISPVIDCTRL_TRACE_ID_FSM_HMI)
, m_enHmiVisualisationOffReason(EN_VD_RVC_HMI_VISUALISATION_OFF__NOT_SPEZIFIED)
, _hTimerHandle_BlackIn(OSAL_C_INVALID_HANDLE)
, _hTimerHandle_BlackOut(OSAL_C_INVALID_HANDLE)
, _hTimerHandle_FsmStateChange(OSAL_C_INVALID_HANDLE)
, m_poHmiControl(poHmiControl)
, m_u32BlackInTime(0)
, m_u32BlackOutTime(0)
{
    ETG_TRACE_USR4((" FSM-HMI  :: dispvidctrl_tclFsm_Hmi(): ................... entered!                                "));

    // create timer for HMI BlackIn
    if( OSAL_s32TimerCreate((OSAL_tpfCallback) _pfCallbackTimer_BlackIn, (tVoid*) this, &_hTimerHandle_BlackIn) != OSAL_OK) {
        //FATAL_M_ASSERT_ALWAYS();
        tU32 u32OSALError = OSAL_u32ErrorCode();
        ETG_TRACE_ERR((" FSM-HMI  :: E R R O R in dispvidctrl_tclFsm_Hmi(): could not create Hmi BlackIn timer! 'Osal Error = %u', %s", u32OSALError, OSAL_coszErrorText(u32OSALError)));
        _hTimerHandle_BlackIn = OSAL_C_INVALID_HANDLE;
    }
    else {
      ETG_TRACE_USR4((" FSM-HMI  :: CallbackTimer_BlackIn created: _hTimerHandle_BlackIn = %u.", _hTimerHandle_BlackIn));
    }
    // create timer for HMI BlackOut
    if( OSAL_s32TimerCreate((OSAL_tpfCallback) _pfCallbackTimer_BlackOut, (tVoid*) this, &_hTimerHandle_BlackOut) != OSAL_OK) {
        //FATAL_M_ASSERT_ALWAYS();
        tU32 u32OSALError = OSAL_u32ErrorCode();
        ETG_TRACE_ERR((" FSM-HMI  :: E R R O R in dispvidctrl_tclFsm_Hmi(): could not create Hmi BlackOut timer! 'Osal Error = %u', %s", u32OSALError, OSAL_coszErrorText(u32OSALError)));
        _hTimerHandle_BlackOut = OSAL_C_INVALID_HANDLE;
    }
    else {
      ETG_TRACE_USR4((" FSM-HMI  :: CallbackTimer_BlackOut created: _hTimerHandle_BlackOut = %u.", _hTimerHandle_BlackOut));
    }

    // timer for state machine state time-out usage
    if( OSAL_s32TimerCreate( (OSAL_tpfCallback)_pfCallbackTimer_FsmStateChange, (tPVoid)this, &_hTimerHandle_FsmStateChange) != OSAL_OK) {
        ETG_TRACE_ERR((" FSM-HMI  :: E R R O R in dispvidctrl_tclFsm_Hmi(): ...... Could not create FSM timer!             "));
        _hTimerHandle_FsmStateChange = OSAL_C_INVALID_HANDLE;
    }
}

/******************************************************************************/
/* FUNCTION     ~dispvidctrl_tclFsm_Hmi                                            */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclFsm_Hmi::~dispvidctrl_tclFsm_Hmi(tVoid)
{
    ETG_TRACE_USR4((" FSM-HMI  :: ~dispvidctrl_tclFsm_Hmi(): .................. entered!                                "));


    //stop and delete all timer
    if (OSAL_C_INVALID_HANDLE != _hTimerHandle_BlackIn)
    {
       (void) OSAL_s32TimerSetTime(_hTimerHandle_BlackIn, 0, 0);
       (void) OSAL_s32TimerDelete(_hTimerHandle_BlackIn);
    }

    if (OSAL_C_INVALID_HANDLE != _hTimerHandle_BlackOut)
    {
       (void) OSAL_s32TimerSetTime(_hTimerHandle_BlackOut, 0, 0);
       (void) OSAL_s32TimerDelete(_hTimerHandle_BlackOut);
    }

    if (OSAL_C_INVALID_HANDLE != _hTimerHandle_FsmStateChange)
    {
       (void) OSAL_s32TimerSetTime(_hTimerHandle_FsmStateChange, 0, 0);
       (void) OSAL_s32TimerDelete(_hTimerHandle_FsmStateChange);
    }

    m_poHmiControl = NULL;
}



/******************************************************************************/
/* FUNCTION     tclCreateInstance                                             */
/******************************************************************************/
/**
*  \brief       Create instance (singleton pattern)
*
*  \param       pointer to control application
*  \return      instance pointer
*/
/******************************************************************************/
dispvidctrl_tclFsm_Hmi* dispvidctrl_tclFsm_Hmi::tclCreateInstance(dispvidctrl_tclControl_Hmi* poHmiControl)
{
    if (m_poInstance == NULL)
    {
        m_poInstance = OSAL_NEW dispvidctrl_tclFsm_Hmi(poHmiControl);
    }
    return m_poInstance;
}

/******************************************************************************/
/* FUNCTION     vConfigure                                                    */
/******************************************************************************/
/**
*  \brief       Called from Control to set configuration values
*
*  \param       pointer to configuration data structure
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vConfigure(const TConfiguration_Fsm_Hmi* pStConfiguration_Fsm_Hmi)
{
  m_u32BlackInTime  = pStConfiguration_Fsm_Hmi->u32BlackInTime;
  m_u32BlackOutTime = pStConfiguration_Fsm_Hmi->u32BlackOutTime;
  m_bRvcMode = pStConfiguration_Fsm_Hmi->bRvcMode;
}

/******************************************************************************/
/* FUNCTION     vNewTrigger                                                   */
/******************************************************************************/
/**
*  \brief       To be called to enter a new Trigger
*
*  \param       trigger and state
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vNewTrigger(tU32 u32Trigger, tBool bTriggerState)
{
    (tVoid) u32CalcNewFsmState(u32Trigger, bTriggerState);
}


/******************************************************************************/
/* FUNCTION     vUpdateTriggerState                                           */
/******************************************************************************/
/**
*  \brief       To be called to correct Trigger states
*
*  \param       Trigger and State
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vUpdateTriggerState(tU32 u32Trigger, tBool bTriggerState)
{
    vUpdateTrigger(u32Trigger, bTriggerState);
}


/******************************************************************************/
/* FUNCTION     vStateChangeDetected                                          */
/******************************************************************************/
/**
*  \brief       called when a state change happens
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vStateChangeDetected(tVoid)
{
    vTraceStatusInfo(0);
}


/******************************************************************************/
/* FUNCTION     vStartFsmStateTimer                                           */
/******************************************************************************/
/**
*  \brief       Called to start the state-timer
*
*  \param       time out value in milliseconds
*  \return      none
*/
/******************************************************************************/
// overwrites tclFsmBase class function
tVoid dispvidctrl_tclFsm_Hmi::vStartFsmStateTimer(tU32 u32Time)
{
   (tVoid) _bSetTimer_FsmStateChange((OSAL_tMSecond) u32Time);
}


/******************************************************************************/
/* FUNCTION     vUpdateRelatedTrigger                                         */
/******************************************************************************/
/**
*  \brief       to correct "hold" trigger states which are related to actual
*               trigger,
*               overwritten base class function
*
*  \param       actual Trigger
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vUpdateRelatedTrigger(tU32 u32Trigger)
{
   switch (u32Trigger)
   {
      case dispvidctrl_tclFsm_Hmi::eTrigger_VISUALISATION_ON:
         vUpdateTrigger(eTrigger_VISUALISATION_OFF, FALSE);
         vUpdateTrigger(eTrigger_VISUALISATION_ON_CAMERA_SETTINGS, FALSE);
         break;
      case dispvidctrl_tclFsm_Hmi::eTrigger_VISUALISATION_OFF:
         vUpdateTrigger(eTrigger_VISUALISATION_ON, FALSE);
         vUpdateTrigger(eTrigger_VISUALISATION_ON_CAMERA_SETTINGS, FALSE);
         vUpdateTrigger(eTrigger_ON_REQUEST_AFTER_BLACKOUT, FALSE);
         vUpdateTrigger(eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT, FALSE);
         vUpdateTrigger(eTrigger_TIMEOUT_BLACKIN, FALSE);
         vUpdateTrigger(eTrigger_VISUALISATION_ON_CAMERA_DIAG, FALSE);
         vUpdateTrigger(eTrigger_VISUALISATION_ON_GUIDELINE_ADJUSTMENT, FALSE);
         break;
      case dispvidctrl_tclFsm_Hmi::eTrigger_VIDEO_SIGNAL_FALSE:
         vUpdateTrigger(eTrigger_VIDEO_SIGNAL_TRUE, FALSE);
         vUpdateTrigger(eTrigger_ON_REQUEST_AFTER_BLACKOUT, FALSE);
         vUpdateTrigger(eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT, FALSE);
         break;
      case dispvidctrl_tclFsm_Hmi::eTrigger_VIDEO_SIGNAL_TRUE:
         vUpdateTrigger(eTrigger_VIDEO_SIGNAL_FALSE, FALSE);
         break;
      case dispvidctrl_tclFsm_Hmi::eTrigger_VISUALISATION_ON_CAMERA_DIAG:
         vUpdateTrigger(eTrigger_VISUALISATION_ON, FALSE);
         vUpdateTrigger(eTrigger_VISUALISATION_OFF, FALSE);
         vUpdateTrigger(eTrigger_ON_REQUEST_AFTER_BLACKOUT, FALSE);
         vUpdateTrigger(eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT, FALSE);
         vUpdateTrigger(eTrigger_VIDEO_SIGNAL_TRUE, FALSE);
         vUpdateTrigger(eTrigger_VIDEO_SIGNAL_FALSE, FALSE);
         break;
      case dispvidctrl_tclFsm_Hmi::eTrigger_VISUALISATION_ON_GUIDELINE_ADJUSTMENT:
         vUpdateTrigger(eTrigger_VISUALISATION_ON, FALSE);
         vUpdateTrigger(eTrigger_VISUALISATION_OFF, FALSE);
         vUpdateTrigger(eTrigger_ON_REQUEST_AFTER_BLACKOUT, FALSE);
         vUpdateTrigger(eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT, FALSE);
         vUpdateTrigger(eTrigger_VIDEO_SIGNAL_TRUE, FALSE);
         vUpdateTrigger(eTrigger_VIDEO_SIGNAL_FALSE, FALSE);
         break;
     case dispvidctrl_tclFsm_Hmi::eTrigger_HMI_OFF_CONFIRM:
        vUpdateTrigger(eTrigger_HMI_OFF_CONFIRM, FALSE);
        break;
     case dispvidctrl_tclFsm_Hmi::eTrigger_HMI_BLACKIN_CONFIRM:
         vUpdateTrigger(eTrigger_HMI_BLACKIN_CONFIRM, FALSE);
         break;
     case dispvidctrl_tclFsm_Hmi::eTrigger_HMI_ON_CONFIRM:
        vUpdateTrigger(eTrigger_HMI_ON_CONFIRM, FALSE);
        break;
     case dispvidctrl_tclFsm_Hmi::eTrigger_HMI_BLACKOUT_CONFIRM:
        //vUpdateTrigger(eTrigger_HMI_BLACKOUT_CONFIRM, FALSE);
        break;
     case dispvidctrl_tclFsm_Hmi::eTrigger_HMI_ON_CAMERASETTINGS:
        vUpdateTrigger(eTrigger_HMI_ON_CAMERASETTINGS, FALSE);
        break;
      case dispvidctrl_tclFsm_Hmi::eTrigger_REVERSE_OFF:
        vUpdateTrigger(eTrigger_REVERSE_ON, FALSE);
        break;
      case dispvidctrl_tclFsm_Hmi::eTrigger_REVERSE_ON:
        vUpdateTrigger(eTrigger_REVERSE_OFF, FALSE);
        break;
      case dispvidctrl_tclFsm_Hmi::eTrigger_GRAPHICS_OFF:
        vUpdateTrigger(eTrigger_GRAPHICS_ON, FALSE);
        break;
      case dispvidctrl_tclFsm_Hmi::eTrigger_GRAPHICS_ON:
        vUpdateTrigger(eTrigger_GRAPHICS_OFF, FALSE);
        break;
      default:
        break;
   }
}

/******************************************************************************/
/* FUNCTION     vEntry_Off                                                    */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vEntry_Off(tVoid)
{
// trigger(s):
// eTrigger_TIMEOUT_BLACKOUT

   if (NULL != m_poInstance) {
      // reset trigger and member variables
      m_poInstance->vUpdateTrigger(eTrigger_ON_REQUEST_AFTER_BLACKOUT, FALSE);
      m_poInstance->vUpdateTrigger(eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT, FALSE);
      m_poInstance->vUpdateTrigger(eTrigger_DIRECT_ON, FALSE);
      m_poInstance->vUpdateTrigger(eTrigger_DIRECT_BLACK_OUT, FALSE);
      m_poInstance->vUpdateTrigger(eTrigger_DIRECT_BLACK_IN, FALSE);
      m_poInstance->vUpdateTrigger(eTrigger_TIMEOUT_BLACKIN, FALSE);
      m_poInstance->vUpdateTrigger(eTrigger_TIMEOUT_BLACKOUT, FALSE);
      m_poInstance->vUpdateTrigger(eTrigger_TOGGLE_GUIDELINES, FALSE);
      m_poInstance->vUpdateTrigger(eTrigger_HMI_BLACKOUT_CONFIRM, FALSE);
      m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__NOT_SPEZIFIED;
   }
}

/******************************************************************************/
/* FUNCTION     vDo_Off                                                       */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vDo_Off(tVoid)
{
// trigger(s):
// eTrigger_DIRECT_OFF

   if (NULL != m_poInstance)
   {
      if (m_poInstance->m_poHmiControl)
      {
         // update property SystemState
         m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_OFF);
      }
   }
}

/******************************************************************************/
/* FUNCTION     vExit_Off                                                     */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vExit_Off(tVoid)
{
// trigger(s):
// eTrigger_VISUALISATION_ON;
// eTrigger_VISUALISATION_CAMERA_SETTINGS_REQUEST;
// eTrigger_DIRECT_ON;
// eTrigger_DIRECT_BLACK_OUT;
// eTrigger_DIRECT_BLACK_IN;
// eTrigger_VISUALISATION_ON_CAMERA_DIAG;
// eTrigger_VISUALISATION_ON_GUIDELINE_ADJUSTMENT;

   /* ---------------------------------------------------------------- */
   /* activities to switch on black_in screen are controlled by        */
   /* HMI External Application Widget                                  */
   /* black in screen is drawn by HMI                                  */
   /* ---------------------------------------------------------------- */
   if (NULL != m_poInstance)
   {
      if (m_poInstance->m_poHmiControl)
      {
         switch (m_poInstance->u32GetCurrentTrigger())
         {
            case eTrigger_VISUALISATION_ON_CAMERA_DIAG:
               {
                  // update property SystemState
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_IN);
                  // start capturing, but do not show video layer yet
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_CAPTURING_DIAG_START);
               }
               break;
            case eTrigger_VISUALISATION_ON_GUIDELINE_ADJUSTMENT:
               {
                  // update property SystemState
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_IN_CAMERA_SETTINGS);
                  // start capturing, but do not show video layer yet
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_CAPTURING_GDL_ADJ_START);
               }
               break;
            case eTrigger_DIRECT_BLACK_IN:
               {
                  // update property SystemState
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_DIRECT_BLACK_IN);
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SIGNAL_CHECK, (tU32) EN_CONTROL_VID_TIMER__START);
               }
               break;
            case eTrigger_DIRECT_ON:
               {
                  // update property SystemState
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_DIRECT_ON);
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SIGNAL_CHECK, (tU32) EN_CONTROL_VID_TIMER__START);
               }
               break;
            case eTrigger_DIRECT_BLACK_OUT:
               {
                  // update property SystemState
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_DIRECT_BLACK_OUT);
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SIGNAL_CHECK, (tU32) EN_CONTROL_VID_TIMER__START);
               }
               break;
            case eTrigger_VISUALISATION_ON_CAMERA_SETTINGS:
               {
                  // update property SystemState
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_IN_CAMERA_SETTINGS);
               }
               break;
            case eTrigger_VISUALISATION_ON:
               {
                  // update property SystemState
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_IN);
               }
               break;
            default:
               {
               }
               break;
         }
         
         // Only if we jump to Black-in state directly without waiting for HMI Confirmation
         // If HMI is already available then we start Video Capturing on Exiting WaitHMIBlackIn
         if (FALSE == m_poInstance->bGetTriggerState(eTrigger_HMI_AVAILABLE))
         {
            // before we start video capturing, we have to enable gamma correction
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SET_GAMMA_ON);
            // start capturing, but do not show video layer yet
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_CAPTURING_START);
            // start video signal detection check for verification in all cases
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SIGNAL_CHECK, (tU32) EN_CONTROL_VID_TIMER__START);
         }
      }
   }
}

/******************************************************************************/
/* FUNCTION     vEntry_BlackInCameraSettingsRequest                           */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vEntry_BlackInCameraSettingsRequest(tVoid)
{
// trigger(s):
// eTrigger_VISUALISATION_ON_CAMERA_SETTINGS
// eTrigger_HMI_BLACKIN_CONFIRM

   if (NULL != m_poInstance) {
      // start BlackIn timer
      m_poInstance->_bSetTimer_BlackIn(TRUE);
      // Reset the Confirm HMI Black-in trigger once we are in the black-in state
      // update guard condition
      m_poInstance->vUpdateTrigger(eTrigger_HMI_BLACKIN_CONFIRM, FALSE);
      
      // in settings screen we don't want to show guidelines and warning text
#ifndef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
      if (m_poInstance->m_poHmiControl) {
         m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_GRAPHICS_OFF);
      }
#else
      if (m_poInstance->m_poHmiControl) {
         m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_GRAPHICS_ON);
      }
#endif
   }
}

/******************************************************************************/
/* FUNCTION     vExit_BlackInCameraSettingsRequest                            */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vExit_BlackInCameraSettingsRequest(tVoid)
{
// trigger(s):
// eTrigger_VISUALISATION_OFF;
// eTrigger_TIMEOUT_BLACK_IN

   if (NULL != m_poInstance)
   {
      if(m_poInstance->u32GetCurrentTrigger() == eTrigger_VISUALISATION_OFF )
      {
         // In case of critical under-voltage stop video capturing immediately
         if (m_poInstance->m_enHmiVisualisationOffReason == EN_VD_RVC_HMI_VISUALISATION_OFF__CRITICAL_UNDERVOLTAGE) {
            // stop video capturing (system status is Visualisation OFF)
            // todo  do we will set system status Visualisation OFF??
            // video signal check will be stopped with capturing stop
             m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_CAPTURING_STOP);
         }
         // change to off -> start black out
         // we are still in black-in screen (HMI) or we (HMI) will enter black-in screen just now.

         // stop black in timer
         (tVoid) m_poInstance->_bSetTimer_BlackIn(FALSE);

         // and set property of system status
         if (m_poInstance->m_poHmiControl) {
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_OUT_CAMERA_SETTINGS);
         }
      }
      if (m_poInstance->u32GetCurrentTrigger() == eTrigger_TIMEOUT_BLACKIN )
      {
         if (m_poInstance->m_poHmiControl) {
            // set video controls (brightness, contrast, colour)
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SET_VIDEO_CONTROLS);
            // switch dimming video back-light request on
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__DIMMING_BACKLIGHT_CAMERA_MODE_ON);
            // send "SystemStatus" property update
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_ON_CAMERA_SETTINGS);
         }
      }
   }
}   

/******************************************************************************/
/* FUNCTION     vEntry_BlackIn                                                */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vEntry_BlackIn(tVoid)
{
// trigger(s):
// eTrigger_VISUALISATION_ON
// eTrigger_HMI_BLACKIN_CONFIRM
// eTrigger_STATE_TIMEOUT

   if (NULL != m_poInstance) {
      // start BlackIn timer
      m_poInstance->_bSetTimer_BlackIn(TRUE);
      // Reset the Confirm HMI Black-in trigger once we are in the black-in state
      // update guard condition
      m_poInstance->vUpdateTrigger(eTrigger_HMI_BLACKIN_CONFIRM, FALSE);
      
      // in normal screen we can show guidelines and warning text
      if (m_poInstance->m_poHmiControl) {
         m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_GRAPHICS_ON);
         // restart the video signal detection check
         m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SIGNAL_CHECK, (tU32) EN_CONTROL_VID_TIMER__STOP);
         m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SIGNAL_CHECK, (tU32) EN_CONTROL_VID_TIMER__START);
      }
   }
}

/******************************************************************************/
/* FUNCTION     vExit_BlackIn                                                 */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vExit_BlackIn(tVoid)
{
// trigger(s):
// eTrigger_VISUALISATION_OFF;

   if (NULL != m_poInstance) {
      if (m_poInstance->u32GetCurrentTrigger() == eTrigger_VISUALISATION_OFF)
      {
         // In case of critical under-voltage stop video capturing immediately
         if (m_poInstance->m_enHmiVisualisationOffReason == EN_VD_RVC_HMI_VISUALISATION_OFF__CRITICAL_UNDERVOLTAGE) {
            // stop video capturing (system status is Visualisation OFF)
            // todo  do we will set system status Visualisation OFF??
            // video signal check will be stopped with capturing stop
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_CAPTURING_STOP);
         }
         // change to off -> start black out
         // we are still in black-in screen (HMI) or we (HMI) will enter black-in screen just now.

         // stop black in timer
         (tVoid) m_poInstance->_bSetTimer_BlackIn(FALSE);

         // and set property of system status
         if (m_poInstance->m_poHmiControl) {
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_OUT);
         }

      }
      if (m_poInstance->u32GetCurrentTrigger() == eTrigger_TIMEOUT_BLACKIN )
      {
         if (m_poInstance->m_poHmiControl) {
            // set video controls (brightness, contrast, colour)
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SET_VIDEO_CONTROLS);
            // switch dimming video back-light request on
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__DIMMING_BACKLIGHT_CAMERA_MODE_ON);
            // send property update
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_ON);
         }
      }
   }
}


/******************************************************************************/
/* FUNCTION     vEntry_BlackInCameraDiagRequest                               */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vEntry_BlackInCameraDiagRequest(tVoid)
{
// trigger(s):
// eTrigger_DIAG_ON_CAMERA_SETTINGS

   if (NULL != m_poInstance)
   {
      // start BlackIn timer
      m_poInstance->_bSetTimer_BlackIn(TRUE);
   }
}

/******************************************************************************/
/* FUNCTION     vExit_BlackInCameraDiagRequest                                */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vExit_BlackInCameraDiagRequest(tVoid)
{
// trigger(s):
// eTrigger_TIMEOUT_BLACK_IN

   if (NULL != m_poInstance)
   {

         if (m_poInstance->m_poHmiControl)
         {
            // switch dimming video back-light request on
            // TODO diag dimming value should be 50% for day/night
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__DIMMING_BACKLIGHT_CAMERA_MODE_ON);
            // send "SystemStatus" property update
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_ON);
         }
   }
}

/******************************************************************************/
/* FUNCTION     vEntry_BlackInGuidelineAdjustment                             */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vEntry_BlackInGuidelineAdjustment(tVoid)
{
// trigger(s):
// eTrigger_VISUALISATION_ON_GUIDELINE_ADJUSTMENT

   if (NULL != m_poInstance)
   {
      // start BlackIn timer
      m_poInstance->_bSetTimer_BlackIn(TRUE);
   }
}

/******************************************************************************/
/* FUNCTION     vExit_BlackInGuidelineAdjustment                              */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vExit_BlackInGuidelineAdjustment(tVoid)
{
// trigger(s):
// eTrigger_TIMEOUT_BLACK_IN

   if (NULL != m_poInstance)
   {

         if (m_poInstance->m_poHmiControl)
         {
            // switch dimming video back-light request on
            // TODO diag dimming value should be 50% for day/night
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__DIMMING_BACKLIGHT_CAMERA_MODE_ON);
            // send "SystemStatus" property update
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_ON_GUIDELINE_ADJUSTMENT);
         }
   }
}


/******************************************************************************/
/* FUNCTION     vDo_On                                                        */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vDo_On(tVoid)
{
// trigger(s):
// eTrigger_TOGGLE_GUIDELINES
// eTrigger_VIDEO_SIGNAL_FALSE
// eTrigger_VIDEO_SIGNAL_TRUE
// eTrigger_GRAPHICS_OFF
// eTrigger_GRAPHICS_ON

   if(NULL != m_poInstance) {
      if (m_poInstance->u32GetCurrentTrigger() == eTrigger_TOGGLE_GUIDELINES ) {
         // toggle guideline visibility for RVC.
         if (m_poInstance->m_poHmiControl) {
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_GUIDELINE_WARNINGTEXT_TOGGLE);
         }
      } else if (m_poInstance->u32GetCurrentTrigger() == eTrigger_VIDEO_SIGNAL_FALSE ) {
         if (m_poInstance->m_poHmiControl) {
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__AVM_VIDEO_SIGNAL_FAILURE);
         }
      } else if (m_poInstance->u32GetCurrentTrigger() == eTrigger_VIDEO_SIGNAL_TRUE ) {
         if (m_poInstance->m_poHmiControl) {
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__AVM_VIDEO_SIGNAL_RESTORED);
         }
      } else if (m_poInstance->u32GetCurrentTrigger() == eTrigger_GRAPHICS_OFF ) {
         if (m_poInstance->m_poHmiControl) {
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_GRAPHICS_OFF);
         }
      } else if (m_poInstance->u32GetCurrentTrigger() == eTrigger_GRAPHICS_ON ) {
         if (m_poInstance->m_poHmiControl) {
            m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_GRAPHICS_ON);
         }
      } else {
      }
   }
}

/******************************************************************************/
/* FUNCTION     vExit_On                                                      */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vExit_On(tVoid)
{
// trigger(s):
// eTrigger_VIDEO_SIGNAL_FALSE
// eTrigger_VISUALISATION_OFF
// eTrigger_VISUALISATION_ON_CAMERA_SETTINGS (Only for Renault)

   if(NULL != m_poInstance && NULL != m_poInstance->m_poHmiControl) {

      switch (m_poInstance->u32GetCurrentTrigger())
      {
         case eTrigger_VIDEO_SIGNAL_FALSE:
            m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__VIDEO_SIGNAL_FAILURE;
            break;
            
         case eTrigger_VISUALISATION_OFF:
            // In case of critical under-voltage stop video capturing immediately
            if (m_poInstance->m_enHmiVisualisationOffReason == EN_VD_RVC_HMI_VISUALISATION_OFF__CRITICAL_UNDERVOLTAGE) {
               // stop video capturing (system status is Visualisation OFF)
               // video signal check will be stopped with capturing stop
               m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_CAPTURING_STOP);
            }
            else if (m_poInstance->m_enHmiVisualisationOffReason == EN_VD_RVC_HMI_VISUALISATION_OFF__OVERSPEED) {
               m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__OVERSPEED_RVCMODE;
            }
			else
			{
				m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__NOT_SPEZIFIED;
				m_poInstance->vUpdateTrigger(eTrigger_ON_REQUEST_AFTER_BLACKOUT, FALSE);
			}
            break;

         case eTrigger_VISUALISATION_ON_CAMERA_SETTINGS:
            // we have to change to VISUALISATION_ON_SETTINGS state via black out and black in
            m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__ON_SETTINGS_REQUEST_AFTER_BLACKOUT;
            // update guard condition
            m_poInstance->vUpdateTrigger(eTrigger_ON_REQUEST_AFTER_BLACKOUT, FALSE);
            m_poInstance->vUpdateTrigger(eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT, TRUE);
            break;
            
         default:
		 m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__NOT_SPEZIFIED;
				m_poInstance->vUpdateTrigger(eTrigger_ON_REQUEST_AFTER_BLACKOUT, FALSE);
            break;
      }
      
      // first send the info to HMI
      m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_OUT);
      // switch dimming video screen back-light request off
      m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__DIMMING_BACKLIGHT_CAMERA_MODE_OFF);
   }
}

/******************************************************************************/
/* FUNCTION     vDo_OnCameraSettings                                        */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vDo_OnCameraSettings(tVoid)
{
// trigger(s):
// eTrigger_VIDEO_SIGNAL_FALSE
// eTrigger_VIDEO_SIGNAL_TRUE
   if ( NULL != m_poInstance && NULL != m_poInstance->m_poHmiControl )
   {
      if (m_poInstance->u32GetCurrentTrigger() == eTrigger_VIDEO_SIGNAL_FALSE) {
         m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__AVM_VIDEO_SIGNAL_FAILURE);
      } else if (m_poInstance->u32GetCurrentTrigger() == eTrigger_VIDEO_SIGNAL_TRUE) {
         m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__AVM_VIDEO_SIGNAL_RESTORED);
      }
   }
}

/******************************************************************************/
/* FUNCTION     vExit_OnCameraSettings                                        */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vExit_OnCameraSettings(tVoid)
{
// trigger(s):
// eTrigger_VIDEO_SIGNAL_FALSE
// eTrigger_VISUALISATION_OFF
// eTrigger_VISUALISATION_ON

   if(NULL != m_poInstance && NULL != m_poInstance->m_poHmiControl) {
      
      switch (m_poInstance->u32GetCurrentTrigger())
      {
         case eTrigger_VIDEO_SIGNAL_FALSE:
            m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__VIDEO_SIGNAL_FAILURE;
            break;
            
         case eTrigger_VISUALISATION_OFF:
            // In case of critical under-voltage stop video capturing immediately
            if (m_poInstance->m_enHmiVisualisationOffReason == EN_VD_RVC_HMI_VISUALISATION_OFF__CRITICAL_UNDERVOLTAGE) {
               // stop video capturing (system status is Visualisation OFF)
               // video signal check will be stopped with capturing stop
               m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_CAPTURING_STOP);
            }
            break;
            
         case eTrigger_VISUALISATION_ON:
            // we have to change to VISUALISATION_ON state via black out and black in
            m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__ON_REQUEST_AFTER_BLACKOUT;
            // update guard condition
            m_poInstance->vUpdateTrigger(eTrigger_ON_REQUEST_AFTER_BLACKOUT, TRUE);
            m_poInstance->vUpdateTrigger(eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT, FALSE);
            break;
            
         default:
            break;
      }

      // switch dimming video screen back-light request off
      m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__DIMMING_BACKLIGHT_CAMERA_MODE_OFF);

      m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_OUT_CAMERA_SETTINGS);
   }
}

/******************************************************************************/
/* FUNCTION     vExit_OnCameraDiag                                            */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vExit_OnCameraDiag(tVoid)
{
// trigger(s):
// eTrigger_VISUALISATION_OFF

   if(NULL != m_poInstance)
   {
      if (m_poInstance->m_poHmiControl)
      {
         // switch dimming video screen back-light request off
         m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__DIMMING_BACKLIGHT_CAMERA_MODE_OFF);
         m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_OUT);
      }
   }
}

/******************************************************************************/
/* FUNCTION     vExit_OnGuidelineAdjustment                                   */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vExit_OnGuidelineAdjustment(tVoid)
{
// trigger(s):
// eTrigger_VISUALISATION_OFF

   if(NULL != m_poInstance)
   {
      if (m_poInstance->m_poHmiControl)
      {
         // switch dimming video screen back-light request off
         m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__DIMMING_BACKLIGHT_CAMERA_MODE_OFF);
         m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_OUT_CAMERA_SETTINGS);
      }
   }
}

/******************************************************************************/
/* FUNCTION     vEntry_BlackOut                                               */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vEntry_BlackOut(tVoid)
{
// trigger(s):
// eTrigger_VIDEO_SIGNAL_FALSE
// eTrigger_VISUALISATION_OFF
// eTrigger_VISUALISATION_ON

    if (NULL != m_poInstance) {
        // start BlackIn timer
        if (m_poInstance->m_enHmiVisualisationOffReason != EN_VD_RVC_HMI_VISUALISATION_OFF__OVERSPEED_RVCMODE)
        {
           m_poInstance->_bSetTimer_BlackOut(TRUE);
        }
        else 
        {
           m_poInstance->vUpdateTrigger(eTrigger_STATE_OVERSPEED_RVC, TRUE);
        }

        ETG_TRACE_USR4((" CA-HMI   :: HmiVisualisationOffReason = ............ %-40d", ETG_CENUM(tenHmiVisualisationOffReason, m_poInstance->m_enHmiVisualisationOffReason)));

        // is it possibel to wait in Black-out state if the Reverse is found to be ON (only for RVC System)
        if ( m_bRvcMode )
        {
           if ( m_poInstance->m_enHmiVisualisationOffReason <= EN_VD_RVC_HMI_VISUALISATION_OFF__ON_REQUEST_AFTER_BLACKOUT )
           {
               // Waiting in Black-out is allowed
               m_poInstance->vUpdateTrigger(eTrigger_BLACK_OUT_WAITING_NOT_ALLOWED, FALSE);
           }
           else 
           {
              if( EN_VD_RVC_HMI_VISUALISATION_OFF__OVERSPEED_RVCMODE != m_poInstance->m_enHmiVisualisationOffReason)
              {
                // Waiting in Black-out is NOT allowed
                m_poInstance->vUpdateTrigger(eTrigger_BLACK_OUT_WAITING_NOT_ALLOWED, TRUE);
              }
              else 
              {
                m_poInstance->vUpdateTrigger(eTrigger_BLACK_OUT_WAITING_NOT_ALLOWED, FALSE);
              }
           }
        }
        else
        {
           // Waiting in Black-out is NOT allowed
           m_poInstance->vUpdateTrigger(eTrigger_BLACK_OUT_WAITING_NOT_ALLOWED, TRUE);
        }
    }
}

/******************************************************************************/
/* FUNCTION     vDo_BlackOut                                                  */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vDo_BlackOut(tVoid)
{
   // trigger(s):
   // eTrigger_VISUALISATION_OFF
   // eTrigger_VISUALISATION_ON
   // eTrigger_OFF_REASON_CLEAN_UP

   if(NULL != m_poInstance)
   {
      switch (m_poInstance->u32GetCurrentTrigger())
      {
      case eTrigger_VISUALISATION_OFF:
         {
            // In case of critical under-voltage stop video capturing immediately
            if (m_poInstance->m_enHmiVisualisationOffReason == EN_VD_RVC_HMI_VISUALISATION_OFF__CRITICAL_UNDERVOLTAGE) {
               // stop video capturing (system status is Visualisation OFF)
               // video signal check will be stopped with capturing stop
               m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_CAPTURING_STOP);
            }
            // clear EN_VD_RVC_HMI_VISUALISATION_OFF__ON_REQUEST_AFTER_BLACKOUT if set
            else if (EN_VD_RVC_HMI_VISUALISATION_OFF__ON_REQUEST_AFTER_BLACKOUT == m_poInstance->m_enHmiVisualisationOffReason)
            {
               m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__REQUEST_OFF;
               // update guard condition
               m_poInstance->vUpdateTrigger(eTrigger_ON_REQUEST_AFTER_BLACKOUT, FALSE);
            }
            else if (EN_VD_RVC_HMI_VISUALISATION_OFF__ON_SETTINGS_REQUEST_AFTER_BLACKOUT == m_poInstance->m_enHmiVisualisationOffReason)
            {
               m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__REQUEST_OFF;
               m_poInstance->vUpdateTrigger(eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT, FALSE);
            }
            else
            {
            }

            // is it possibel to wait in Black-out state if the Reverse is found to be ON
            if (m_poInstance->m_enHmiVisualisationOffReason <= EN_VD_RVC_HMI_VISUALISATION_OFF__REQUEST_OFF)
            {
               // update guard condition
               m_poInstance->vUpdateTrigger(eTrigger_BLACK_OUT_WAITING_NOT_ALLOWED, FALSE);
            }
            else
            {
               // update guard condition
               m_poInstance->vUpdateTrigger(eTrigger_BLACK_OUT_WAITING_NOT_ALLOWED, TRUE);
            }
         }
         break;

      case eTrigger_VISUALISATION_ON:
         // new view cycle will start after we finished black out
         // only if priority > than current off reason
         if (EN_VD_RVC_HMI_VISUALISATION_OFF__ON_REQUEST_AFTER_BLACKOUT >= m_poInstance->m_enHmiVisualisationOffReason) {
            m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__ON_REQUEST_AFTER_BLACKOUT;
            // update guard condition
            m_poInstance->vUpdateTrigger(eTrigger_ON_REQUEST_AFTER_BLACKOUT, TRUE);
         }
         break;
         
      case eTrigger_VISUALISATION_ON_CAMERA_SETTINGS:
         // new Settings view cycle will start after we finished black out
         // only if priority > than current off reason
         if (EN_VD_RVC_HMI_VISUALISATION_OFF__ON_SETTINGS_REQUEST_AFTER_BLACKOUT >= m_poInstance->m_enHmiVisualisationOffReason) {
            m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__ON_SETTINGS_REQUEST_AFTER_BLACKOUT;
            // update guard condition
            m_poInstance->vUpdateTrigger(eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT, TRUE);
         }
         break;

      case eTrigger_OFF_REASON_CLEAN_UP:
         // If we did stop because of critical under voltage or
         // application state not normal, we have to clean up this
         // remembered off trigger.
         // Otherwise we will not change to black in if an new
         // Visualisation ON Request because of Screen reactivation will be received.
         // Required only here in black out state.

         // with getting this event the critical under voltage etc. are over
         m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__NOT_SPEZIFIED;
         // update guard condition
         m_poInstance->vUpdateTrigger(eTrigger_ON_REQUEST_AFTER_BLACKOUT, FALSE);
            // update guard condition
            m_poInstance->vUpdateTrigger(eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT, FALSE);
         break;
         
      default:
         break;
      }
   }
}

/******************************************************************************/
/* FUNCTION     vExit_BlackOut                                                */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vExit_BlackOut(tVoid)
{
// trigger(s):
// eTrigger_TIMEOUT_BLACKOUT
// eTrigger_STATE_TIMEOUT
// eTrigger_ON_REQUEST_AFTER_BLACKOUT
// eTrigger_VISUALISATION_ON

   if(NULL != m_poInstance) {
      
      switch (m_poInstance->u32GetCurrentTrigger())
      {
         case eTrigger_VISUALISATION_ON:
         {
             ETG_TRACE_USR4(("  CA_HMI :: FSM-HMI ::  BlackOut -> BlackIn -> On "));
         
             // new view cycle will start after we finished black out
             // only if priority > than current off reason
             if (EN_VD_RVC_HMI_VISUALISATION_OFF__ON_REQUEST_AFTER_BLACKOUT >= m_poInstance->m_enHmiVisualisationOffReason) {
                m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__ON_REQUEST_AFTER_BLACKOUT;
             }
             else if ( EN_VD_RVC_HMI_VISUALISATION_OFF__OVERSPEED_RVCMODE == m_poInstance->m_enHmiVisualisationOffReason) {
                m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__NOT_SPEZIFIED;
             }
         
             //(tVoid) m_poInstance->_bSetTimer_BlackIn(TRUE);
         
             // change to black in
             // if we do not stop the capturing, we do not need to restart it
             // start video signal detection check
             if (m_poInstance->m_poHmiControl) {
                m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_IN);
                m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SIGNAL_CHECK, (tU32) EN_CONTROL_VID_TIMER__START);
             }
         }
         break;

         case eTrigger_VISUALISATION_ON_CAMERA_SETTINGS:
         {
             ETG_TRACE_USR4(("  CA_HMI :: FSM-HMI ::  BlackOut -> BlackIn -> OnSettings "));
         
             // new view cycle will start after we finished black out
             // only if priority > than current off reason
             if (EN_VD_RVC_HMI_VISUALISATION_OFF__ON_SETTINGS_REQUEST_AFTER_BLACKOUT >= m_poInstance->m_enHmiVisualisationOffReason) {
                m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__ON_SETTINGS_REQUEST_AFTER_BLACKOUT;
             }
         
             //(tVoid) m_poInstance->_bSetTimer_BlackIn(TRUE);
         
             // change to black in
             // if we do not stop the capturing, we do not need to restart it
             // start video signal detection check
             if (m_poInstance->m_poHmiControl) {
                m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_IN_CAMERA_SETTINGS);
                m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SIGNAL_CHECK, (tU32) EN_CONTROL_VID_TIMER__START);
             }
         }
         break;

         case eTrigger_TIMEOUT_BLACKOUT:
         case eTrigger_STATE_TIMEOUT:
         case eTrigger_REVERSE_OFF:
         {
            if(m_poInstance->bGetTriggerState(eTrigger_ON_REQUEST_AFTER_BLACKOUT) == TRUE) {
               ETG_TRACE_USR4(("  CA_HMI :: FSM-HMI ::  eTrigger_ON_REQUEST_AFTER_BLACKOUT -> BlackIn   "));
               //(tVoid) m_poInstance->_bSetTimer_BlackIn(TRUE);
         
               // change to black in
               // if we do not stop the capturing, we do not need to restart it
               // start video signal detection check
               if (m_poInstance->m_poHmiControl) {
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_IN);
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SIGNAL_CHECK, (tU32) EN_CONTROL_VID_TIMER__START);
               }
            }
            else if(m_poInstance->bGetTriggerState(eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT) == TRUE) {
               ETG_TRACE_USR4(("  CA_HMI :: FSM-HMI ::  eTrigger_ON_SETTINGS_REQUEST_AFTER_BLACKOUT -> BlackIn   "));
               //(tVoid) m_poInstance->_bSetTimer_BlackIn(TRUE);
         
               // change to black in Settings
               // if we do not stop the capturing, we do not need to restart it
               // start video signal detection check
               if (m_poInstance->m_poHmiControl) {
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_IN_CAMERA_SETTINGS);
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SIGNAL_CHECK, (tU32) EN_CONTROL_VID_TIMER__START);
               }
            }
            else {
               // select new System Status, next state will be OFF
               tenFsmOutEvent_Hmi enNewSystemStatus = FSM_HMI_OUT__HMI_VISUALISATION_OFF;
               switch (m_poInstance->m_enHmiVisualisationOffReason) {
                  case EN_VD_RVC_HMI_VISUALISATION_OFF__CRITICAL_UNDERVOLTAGE:
                  case EN_VD_RVC_HMI_VISUALISATION_OFF__APPLICATION_STATE_NOT_NORMAL:
                  case EN_VD_RVC_HMI_VISUALISATION_OFF__REQUEST_OFF:
                  case EN_VD_RVC_HMI_VISUALISATION_OFF__DIAG_VIDEO_LAYER_OFF:
                  case EN_VD_RVC_HMI_VISUALISATION_OFF__GUIDELINE_ADJUSTMENT_OFF:
                     m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__NOT_SPEZIFIED;
                     break;
                  case EN_VD_RVC_HMI_VISUALISATION_OFF__SYSTEM_MALFUNCTION:
                     {
                        enNewSystemStatus = FSM_HMI_OUT__HMI_VISUALISATION_OFF_SYSTEM_MALFUNCTION;
                     }
                     break;
                  case EN_VD_RVC_HMI_VISUALISATION_OFF__RVC_ELECTRIC_FAILURE:
                     {
                        enNewSystemStatus = FSM_HMI_OUT__HMI_VISUALISATION_OFF_VIDEO_SIGNAL_FAILURE;
                     }
                     break;
                  case EN_VD_RVC_HMI_VISUALISATION_OFF__VIDEO_SIGNAL_FAILURE:
                     {
                        enNewSystemStatus = FSM_HMI_OUT__HMI_VISUALISATION_OFF_VIDEO_SIGNAL_FAILURE;
                        // todo  condition rvc/avm?
                        if (m_poInstance->m_poHmiControl) {
                           m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__AVM_VIDEO_SIGNAL_FAILURE);
                        }
                     }
                     break;
                  case EN_VD_RVC_HMI_VISUALISATION_OFF__ON_REQUEST_AFTER_BLACKOUT:
                  case EN_VD_RVC_HMI_VISUALISATION_OFF__ON_SETTINGS_REQUEST_AFTER_BLACKOUT:
                     {
                        // NCG3D-23844: We have to clear this Flag here, otherwise 
                        // we run into the issue if the OnRequestAfterBlackOut occurs twice without going to OFF state
                        m_poInstance->m_enHmiVisualisationOffReason = EN_VD_RVC_HMI_VISUALISATION_OFF__NOT_SPEZIFIED;
                     }
                     break;
                  default:
                     break;
               }
               
               if ( m_poInstance->m_poHmiControl ) {
                  // video signal check will be stopped with capturing stop
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_CAPTURING_STOP);
                  // switch dimming video screen back-light request off
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__DIMMING_BACKLIGHT_CAMERA_MODE_OFF);
                  // post event to switch camera pin off
         
         
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi( FSM_HMI_OUT__RVC_CAMERA_OFF );
                  // update system status property
                  ETG_TRACE_USR4((" CA-HMI   :: HmiVisualisationOffReason = ............ %-40d", ETG_CENUM(tenHmiVisualisationOffReason, m_poInstance->m_enHmiVisualisationOffReason)));
                  m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi( enNewSystemStatus );
               }
            }
         }
         break;
         default:
            break;
      }

      // update guard condition
      m_poInstance->vUpdateTrigger(eTrigger_HMI_BLACKOUT_CONFIRM, FALSE);
      if (m_poInstance->m_enHmiVisualisationOffReason == EN_VD_RVC_HMI_VISUALISATION_OFF__OVERSPEED_RVCMODE)
      {
           m_poInstance->vUpdateTrigger(eTrigger_STATE_OVERSPEED_RVC, FALSE);
      }
   }
}

/******************************************************************************/
/* FUNCTION     vExit_WaitingHMIBlackIn                                       */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vExit_WaitingHMIBlackIn(tVoid)
{
// eTrigger_VISUALISATION_OFF
// eTrigger_HMI_BLACKIN_CONFIRM
// eTrigger_STATE_TIMEOUT

    if (NULL != m_poInstance)
    {
        if (m_poInstance->u32GetCurrentTrigger() == eTrigger_VISUALISATION_OFF)
        {
           // In case of critical under-voltage stop video capturing immediately
           if (m_poInstance->m_enHmiVisualisationOffReason == EN_VD_RVC_HMI_VISUALISATION_OFF__CRITICAL_UNDERVOLTAGE) {
              // stop video capturing (system status is Visualisation OFF)
              // todo  do we will set system status Visualisation OFF??
              // video signal check will be stopped with capturing stop
              m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_CAPTURING_STOP);
           }
           // change to off -> start black out
           // we are still in black-in screen (HMI) or we (HMI) will enter black-in screen just now.

           // stop black in timer
           (tVoid) m_poInstance->_bSetTimer_BlackIn(FALSE);

           // and set property of system status
           // But do not draw Middleware Black-screen before Starting Video Capturing = 0xFFFFFFFF
           if (m_poInstance->m_poHmiControl) {
              m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_OUT, 0xFFFFFFFF);
           }
        }
        else
        {
            if (m_poInstance->m_poHmiControl)
            {
                // update property SystemState
                m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_CONFIRM_VISUALISATION_BLACK_IN);
                
                // Only if we are waiting for HMI Confirmation we Start Capturing here
                // Video Capturing should be started just before entering Black-in
                if (TRUE == m_poInstance->bGetTriggerState(eTrigger_HMI_AVAILABLE))
                {
                   // before we start video capturing, we have to enable gamma correction
                   m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SET_GAMMA_ON);
                   // start capturing, but do not show video layer yet
                   m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_CAPTURING_START);
                   // start video signal detection check for verification in all cases
                   m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SIGNAL_CHECK, (tU32) EN_CONTROL_VID_TIMER__START);
                }
            }
        }
    }
}

/******************************************************************************/
/* FUNCTION     vExit_Waiting_BlackIn_Camera_Settings                         */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_Hmi::vExit_Waiting_BlackIn_Camera_Settings(tVoid)
{
// eTrigger_VISUALISATION_OFF
// eTrigger_HMI_BLACKIN_CONFIRM
// eTrigger_STATE_TIMEOUT

    if (NULL != m_poInstance)
    {
        if (m_poInstance->u32GetCurrentTrigger() == eTrigger_VISUALISATION_OFF )
        {
           // In case of critical under-voltage stop video capturing immediately
           if (m_poInstance->m_enHmiVisualisationOffReason == EN_VD_RVC_HMI_VISUALISATION_OFF__CRITICAL_UNDERVOLTAGE) {
              // stop video capturing (system status is Visualisation OFF)
              // todo  do we will set system status Visualisation OFF??
              // video signal check will be stopped with capturing stop
               m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_CAPTURING_STOP);
           }
           // change to off -> start black out
           // we are still in black-in screen (HMI) or we (HMI) will enter black-in screen just now.

           // stop black in timer
           (tVoid) m_poInstance->_bSetTimer_BlackIn(FALSE);

           // and set property of system status
           if (m_poInstance->m_poHmiControl) {
              m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_VISUALISATION_BLACK_OUT_CAMERA_SETTINGS);
           }
        }
        else
        {
            if (m_poInstance->m_poHmiControl)
            {
                // update property SystemState
                m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__HMI_CONFIRM_VISUALISATION_BLACK_IN);
                
                // Only if we jump to Black-in state directly without waiting for HMI Confirmation
                // Start Video Capturing just before we enter Black-in State
                if (TRUE == m_poInstance->bGetTriggerState(eTrigger_HMI_AVAILABLE))
                {
                   // before we start video capturing, we have to enable gamma correction
                   m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SET_GAMMA_ON);
                   // start capturing, but do not show video layer yet
                   m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_CAPTURING_START);
                   // start video signal detection check for verification in all cases
                   m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi(FSM_HMI_OUT__VIDEO_SIGNAL_CHECK, (tU32) EN_CONTROL_VID_TIMER__START);
                }
            }
        }
    }
}

/******************************************************************************/
/* FUNCTION     _pfCallbackTimer_FsmStateChange                               */
/******************************************************************************/
/**
*  \brief
*
*  \param       pArg - pointer to this class
*  \return      none
*/
/******************************************************************************/
OSAL_tpfCallback dispvidctrl_tclFsm_Hmi::_pfCallbackTimer_FsmStateChange(tVoid* pArg)
{
   (tVoid) pArg;

   if ((m_poInstance) && (m_poInstance->m_poHmiControl) ) {
      m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi( FSM_HMI_OUT__FSM_HMI_INPUT_EVENT,
                                                            (tU32) eTrigger_STATE_TIMEOUT );
   }
   return 0;
}

/******************************************************************************/
/* FUNCTION     _bSetTimer_FsmStateChange                                     */
/******************************************************************************/
/**
*  \brief       start or stop the timer
*
*  \param       time out value in millisecond
*  \return      tBool - timer start/stop success state
*/
/******************************************************************************/
tBool  dispvidctrl_tclFsm_Hmi::_bSetTimer_FsmStateChange( OSAL_tMSecond msTimeout ) const
{
    tBool bSuccess = TRUE;
    if ( OSAL_C_INVALID_HANDLE != _hTimerHandle_FsmStateChange ) {
        if ( OSAL_s32TimerSetTime( _hTimerHandle_FsmStateChange, msTimeout, 0 ) != OSAL_OK )
        {
            bSuccess = FALSE;
        }
    }
    return(bSuccess);
}

/******************************************************************************/
/* FUNCTION     _pfCallbackTimer_BlackIn                                      */
/******************************************************************************/
/**
*  \brief
*
*  \param       pArg - pointer to this class
*  \return      none
*/
/******************************************************************************/
OSAL_tpfCallback dispvidctrl_tclFsm_Hmi::_pfCallbackTimer_BlackIn(tVoid* pArg)
{
   (tVoid) pArg;

   if ((m_poInstance) && (m_poInstance->m_poHmiControl) ) {
      m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi( FSM_HMI_OUT__FSM_HMI_INPUT_EVENT,
                                                            (tU32) eTrigger_TIMEOUT_BLACKIN );
      ETG_TRACE_USR4((" FSM-HMI  :: _pfCallbackTimer_BlackIn(): called! _hTimerHandle_BlackIn = %u",  m_poInstance->_hTimerHandle_BlackIn));
   }
   return 0;
}

/******************************************************************************/
/* FUNCTION     _pfCallbackTimer_BlackOut                                     */
/******************************************************************************/
/**
*  \brief
*
*  \param       pArg - pointer to this class
*  \return      none
*/
/******************************************************************************/
OSAL_tpfCallback dispvidctrl_tclFsm_Hmi::_pfCallbackTimer_BlackOut(tVoid* pArg)
{
   (tVoid) pArg;

   if ((m_poInstance) && (m_poInstance->m_poHmiControl) ) {
      m_poInstance->m_poHmiControl->vHandleFsmOutEvent_Hmi( FSM_HMI_OUT__FSM_HMI_INPUT_EVENT,
                                                            (tU32) eTrigger_TIMEOUT_BLACKOUT );
      ETG_TRACE_USR4((" FSM-HMI  :: _pfCallbackTimer_BlackOut(): called! _hTimerHandle_BlackOut = %u",  m_poInstance->_hTimerHandle_BlackOut));
   }
   return 0;
}

/******************************************************************************/
/* FUNCTION     _bSetTimer_BlackIn                                            */
/******************************************************************************/
/**
*  \brief       start or stop the timer
*
*  \param       tBool TRUE  Start Timer
*                     FALSE Stop Timer
*  \return      tBool - timer start success state
*/
/******************************************************************************/
tBool  dispvidctrl_tclFsm_Hmi::_bSetTimer_BlackIn( tBool bStartStop ) const
{
   tBool bSuccess = TRUE;

   if ( OSAL_C_INVALID_HANDLE != _hTimerHandle_BlackIn ) {
      if (bStartStop) {
         if ( OSAL_s32TimerSetTime( _hTimerHandle_BlackIn, (OSAL_tMSecond) m_u32BlackInTime, 0 ) != OSAL_OK ) {
            bSuccess = FALSE;
            tU32 u32OSALError = OSAL_u32ErrorCode();
            ETG_TRACE_ERR((" FSM-HMI  :: E R R O R in _bSetTimer_BlackIn(): timer start failed! _hTimerHandle_BlackIn = %u, 'Osal Error = %u', %s", _hTimerHandle_BlackIn, u32OSALError, OSAL_coszErrorText(u32OSALError)));
         }
         else {
            ETG_TRACE_USR4((" FSM-HMI  :: _bSetTimer_BlackIn(): timer started! _hTimerHandle_BlackIn = %u", _hTimerHandle_BlackIn));
         }
      }
      else {
         if ( OSAL_s32TimerSetTime( _hTimerHandle_BlackIn, (OSAL_tMSecond) 0, 0 ) != OSAL_OK ) {
            bSuccess = FALSE;
            
            tU32 u32OSALError = OSAL_u32ErrorCode();
            ETG_TRACE_ERR((" FSM-HMI  :: E R R O R in _bSetTimer_BlackIn(): timer stop failed! _hTimerHandle_BlackIn = %u, 'Osal Error = %u', %s", _hTimerHandle_BlackIn, u32OSALError, OSAL_coszErrorText(u32OSALError)));
         }
         else {
            ETG_TRACE_USR4((" FSM-HMI  :: _bSetTimer_BlackIn(): timer stopped! _hTimerHandle_BlackIn = %u", _hTimerHandle_BlackIn));
         }
      }
   }
   return(bSuccess);
}

/******************************************************************************/
/* FUNCTION     _bSetTimer_BlackOut                                           */
/******************************************************************************/
/**
*  \brief       start or stop the timer
*
*  \param       tBool TRUE  Start Timer
*                     FALSE Stop Timer
*  \return      tBool - timer start success state
*/
/******************************************************************************/
tBool  dispvidctrl_tclFsm_Hmi::_bSetTimer_BlackOut( tBool bStartStop ) const
{
   tBool bSuccess = TRUE;

   if ( OSAL_C_INVALID_HANDLE != _hTimerHandle_BlackOut ) {
      if (bStartStop) {
         if ( OSAL_s32TimerSetTime( _hTimerHandle_BlackOut, (OSAL_tMSecond) m_u32BlackOutTime, 0 ) != OSAL_OK ) {
            bSuccess = FALSE;
            tU32 u32OSALError = OSAL_u32ErrorCode();
            ETG_TRACE_ERR((" FSM-HMI  :: E R R O R in _bSetTimer_BlackOut(): timer start failed! _hTimerHandle_BlackOut = %u, 'Osal Error = %u', %s", _hTimerHandle_BlackOut, u32OSALError, OSAL_coszErrorText(u32OSALError)));
         }
         else {
            ETG_TRACE_USR4((" FSM-HMI  :: _bSetTimer_BlackOut(): timer started! _hTimerHandle_BlackOut = %u", _hTimerHandle_BlackOut));
         }
      }
      else {
         if ( OSAL_s32TimerSetTime( _hTimerHandle_BlackOut, (OSAL_tMSecond) 0, 0 ) != OSAL_OK ) {
            bSuccess = FALSE;
            tU32 u32OSALError = OSAL_u32ErrorCode();
            ETG_TRACE_ERR((" FSM-HMI  :: E R R O R in _bSetTimer_BlackOut(): timer stop failed! _hTimerHandle_BlackOut = %u, 'Osal Error = %u', %s", _hTimerHandle_BlackOut, u32OSALError, OSAL_coszErrorText(u32OSALError)));
         }
         else {
            ETG_TRACE_USR4((" FSM-HMI  :: _bSetTimer_BlackOut(): timer stopped! _hTimerHandle_BlackOut = %u", _hTimerHandle_BlackOut));
         }
      }
   }
   return(bSuccess);
}
