/******************************************************************************/
/**
* \file    dispvidctrl_tclFsm_CameraSupplySupervision.cpp
* \ingroup
*
* \brief   state machine for CameraSupplySupervision handling
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann CM-AI/PJ-CB32
* \remark  Scope     : A-IVI
*
* \todo
*/
/******************************************************************************/
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_tclControl_Rvc.h"
#include "dispvidctrl_tclFsm_CameraSupplySupervision.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_tclFsm_CameraSupplySupervision.cpp.trc.h"
#endif

#define DISPVIDCTRL_TRACE_ID_FSM_CAMERASUPPLYSUPERVISION 0x06

#define DISPVIDCTRL_CAMERA_SUPPLY_SUPERVISION_TIME 1000

#define ELEMENTE(array)       ((tU16)(sizeof(array)/sizeof(array[0])))

dispvidctrl_tclFsm_CameraSupplySupervision*   dispvidctrl_tclFsm_CameraSupplySupervision::m_poInstance  = OSAL_NULL;

/*******************************************************************************
*                                  STATE TABLE
*******************************************************************************/
dispvidctrl_tclFsm_CameraSupplySupervision::TFsmStateConf dispvidctrl_tclFsm_CameraSupplySupervision::aFsm_CameraSupplySupervision_StateTable[eState_Max] =
{
   {
      eState_Off,
      0,                                   //u32Timeout
      vEntry_Off,                          //tFsmStateEntryFunc
      vDo_Off,                             //tFsmStateDoFunc
      vExit_Off,                           //tFsmStateExitFunc
   },
   {
      eState_On,
      0,                                   //u32Timeout
      vEntry_On,                           //tFsmStateEntryFunc
      vDo_On,                              //tFsmStateDoFunc
      vExit_On,                            //tFsmStateExitFunc
   },
   {
      eState_DiagControlCamera,
      1000,                                //u32Timeout
      NULL,                                //tFsmStateEntryFunc
      vDo_DiagControlCamera,               //tFsmStateDoFunc
      NULL,                                //tFsmStateExitFunc
   },
   {
      eState_DiagControlMicrophone,
      1000,                                //u32Timeout
      NULL,                                //tFsmStateEntryFunc
      vDo_DiagControlMicrophone,           //tFsmStateDoFunc
      NULL,                                //tFsmStateExitFunc
   }
};

/*******************************************************************************
 *                             STATE TRANSITION TABLE
 *******************************************************************************/
dispvidctrl_tclFsm_CameraSupplySupervision::TStateTransitions dispvidctrl_tclFsm_CameraSupplySupervision::aFsm_CameraSupplySupervision_StateTransitionTable[] =
{
   // ===== eState_OFF ===================
   // ----- transition actions ----------
   {  100,                                // transitionId
      eState_Off,                         // current FSM State
      eTrigger_SupervisionOn,             // trigger update
      FSM_DONT_CARE,                      // current active trigger(s)
      FSM_DONT_CARE,                      // current not active trigger(s)
      eState_On                           // next FSM State
   },
   // ---- do actions -------------------
   {  130,                                // transitionId
      eState_Off,                         // current FSM State
      eTrigger_SendNextTestResult,        // trigger update
      FSM_DONT_CARE,                      // current active trigger(s)
      FSM_DONT_CARE,                      // current not active trigger(s)
      eState_Off                          // next FSM State
   },

   // ===== eState_ON ===================
   // ----- transition actions ----------
   {  200,                                // transitionId
      eState_On,                          // current FSM State
      eTrigger_SupervisionOff,            // trigger update
      FSM_DONT_CARE,                      // current active trigger(s)
      FSM_DONT_CARE,                      // current not active trigger(s)
      eState_Off                          // next FSM State
   },
   // ---- do actions -------------------
   {  230,                                // transitionId
      eState_On,                          // current FSM State
      eTrigger_SupervisionTimeout,        // trigger update
      FSM_DONT_CARE,                      // current active trigger(s)
      FSM_DONT_CARE,                      // current not active trigger(s)
      eState_On                           // next FSM State
   },
   {  231,                                // transitionId
      eState_On,                          // current FSM State
      eTrigger_SendNextTestResult,        // trigger update
      FSM_DONT_CARE,                      // current active trigger(s)
      FSM_DONT_CARE,                      // current not active trigger(s)
      eState_On                           // next FSM State
   },
   {  232,                                // transitionId
      eState_On,                          // current FSM State
      eTrigger_CameraSupplyError,         // trigger update
      FSM_DONT_CARE,                      // current active trigger(s)
      FSM_DONT_CARE,                      // current not active trigger(s)
      eState_On                           // next FSM State
   },
   // ---- Diag IO Control Camera ------------------
   {
      300,                                // transitionId
      FSM_DONT_CARE,                      // current FSM State
      eTrigger_DiagCameraSupervisionOn,   // trigger update
      FSM_DONT_CARE,                      // current active trigger(s)
      FSM_DONT_CARE,                      // current not active trigger(s)
      eState_DiagControlCamera            // next FSM State
   },
   // switch off the camera after exiting the diagnosis freeze state
   // even if the camera supervision is still ON
   {
      301,                                // transitionId
      eState_DiagControlCamera,           // current FSM State
      eTrigger_DiagCameraSupervisionOff,  // trigger update
      FSM_DONT_CARE,                      // current active trigger(s)
      FSM_DONT_CARE,                      // current not active trigger(s)
      eState_Off                          // next FSM State
   },
   // do action - on timeout of 1s
   {
      305,                                // transitionId
      eState_DiagControlCamera,           // current FSM State
      eTrigger_StateTimeout,              // trigger update
      FSM_DONT_CARE,                      // current active trigger(s)
      FSM_DONT_CARE,                      // current not active trigger(s)
      eState_DiagControlCamera            // next FSM State
   },
   // ---- Diag IO Control Microphone ------------------
   {
      310,                                // transitionId
      FSM_DONT_CARE,                      // current FSM State
      eTrigger_DiagMicSupervisionOn,      // trigger update
      FSM_DONT_CARE,                      // current active trigger(s)
      FSM_DONT_CARE,                      // current not active trigger(s)
      eState_DiagControlMicrophone        // next FSM State
   },
   {
      311,                                // transitionId
      eState_DiagControlMicrophone,       // current FSM State
      eTrigger_DiagMicSupervisionOff,     // trigger update
      FSM_DONT_CARE,                      // current active trigger(s)
      FSM_DONT_CARE,                      // current not active trigger(s)
      eState_Off                          // next FSM State
   },
   // do action - on timeout of 1s
   {
      315,                                // transitionId
      eState_DiagControlMicrophone,       // current FSM State
      eTrigger_StateTimeout,              // trigger update
      FSM_DONT_CARE,                      // current active trigger(s)
      FSM_DONT_CARE,                      // current not active trigger(s)
      eState_DiagControlMicrophone        // next FSM State
   },
};


/******************************************************************************/
/* FUNCTION     ~dispvidctrl_tclFsm_CameraSupplySupervision                        */
/******************************************************************************/
/**
*  \brief       Constructor
*
*
*
*  \param       pointer to main application
*               ahl_tclFsmBase( tU32 u32InitFsmSTate,
*                               tU32 u32MaxTransitionEntry,
*                               TStateTransitions* paFsmTransitionTable,
*                               tU32 u32MaxStateEntry,
*                               FsmStateConf* paFsmStateTable,
*                               tU32 u32TraceClass
*                               tU8  u8FsmTraceId);
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclFsm_CameraSupplySupervision::dispvidctrl_tclFsm_CameraSupplySupervision(dispvidctrl_tclControl_Rvc* poControl_Rvc)
: dispvidctrl_tclFsm_Base(
     eState_Off,
     ELEMENTE(aFsm_CameraSupplySupervision_StateTransitionTable), aFsm_CameraSupplySupervision_StateTransitionTable,
     ELEMENTE(aFsm_CameraSupplySupervision_StateTable)          , aFsm_CameraSupplySupervision_StateTable,
     (tU32) TR_CLASS_DISPVIDCTRL_APPLICATION,
     DISPVIDCTRL_TRACE_ID_FSM_CAMERASUPPLYSUPERVISION)
, m_hTimerHandle_FsmStateTimeout(OSAL_C_INVALID_HANDLE)
, m_hTimerHandle_FsmSupervisionTimeout(OSAL_C_INVALID_HANDLE)
, m_poControl_Rvc(poControl_Rvc)
{
   // create timer for FSM state time outs used for state verification
   if( OSAL_s32TimerCreate( (OSAL_tpfCallback)_pfCallbackTimer_FsmStateTimeout, (tPVoid)this, &m_hTimerHandle_FsmStateTimeout) != OSAL_OK)
   {
      ETG_TRACE_USR4(("ERROR - Could not create FSM timer!"));
      m_hTimerHandle_FsmStateTimeout = OSAL_C_INVALID_HANDLE;
   }

   // create timer for cyclic supervision
   if( OSAL_s32TimerCreate( (OSAL_tpfCallback)_pfCallbackTimer_FsmSupervisionTimeout, (tPVoid)this, &m_hTimerHandle_FsmSupervisionTimeout) != OSAL_OK)
   {
      ETG_TRACE_USR4(("ERROR - Could not create FSM timer!"));
      m_hTimerHandle_FsmSupervisionTimeout = OSAL_C_INVALID_HANDLE;
   }
}


/******************************************************************************/
/* FUNCTION     ~dispvidctrl_tclFsm_CameraSupplySupervision                   */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclFsm_CameraSupplySupervision::~dispvidctrl_tclFsm_CameraSupplySupervision(tVoid)
{
   // delete timers
   if (OSAL_C_INVALID_HANDLE != m_hTimerHandle_FsmStateTimeout)
   {
      OSAL_s32TimerSetTime(m_hTimerHandle_FsmStateTimeout, 0, 0);
      OSAL_s32TimerDelete(m_hTimerHandle_FsmStateTimeout);
   }

   if (OSAL_C_INVALID_HANDLE != m_hTimerHandle_FsmSupervisionTimeout)
   {
      OSAL_s32TimerSetTime(m_hTimerHandle_FsmSupervisionTimeout, 0, 0);
      OSAL_s32TimerDelete(m_hTimerHandle_FsmSupervisionTimeout);
   }

   m_poInstance = NULL;
   m_poControl_Rvc = NULL;
}


/******************************************************************************/
/* FUNCTION     tclCreateInstance                                             */
/******************************************************************************/
/**
*  \brief       Create instance (singleton pattern)
*
*  \param       pointer to main application
*  \return      pointer to instance
*/
/******************************************************************************/
dispvidctrl_tclFsm_CameraSupplySupervision* dispvidctrl_tclFsm_CameraSupplySupervision::tclCreateInstance(dispvidctrl_tclControl_Rvc* poControl_Rvc)
{
   if (m_poInstance == NULL)
   {
      m_poInstance = OSAL_NEW dispvidctrl_tclFsm_CameraSupplySupervision(poControl_Rvc);
   }
   return m_poInstance;
}


/******************************************************************************/
/* FUNCTION     vNewTrigger                                                   */
/******************************************************************************/
/**
*  \brief       To be called to enter a new Trigger
*
*  \param       Trigger and State
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_CameraSupplySupervision::vNewTrigger(tU32 u32Trigger, tBool bTriggerState) const
{
   if (NULL != m_poInstance)
   {
      m_poInstance->u32CalcNewFsmState(u32Trigger, bTriggerState);
   }
}


/******************************************************************************/
/* FUNCTION     vStateChangeDetected                                          */
/******************************************************************************/
/**
*  \brief       called when a state change happens
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_CameraSupplySupervision::vStateChangeDetected(tVoid)
{
   if (NULL != m_poInstance)
   {
      m_poInstance->vTraceStatusInfo(0);
   }

   return;
}

/******************************************************************************/
/* FUNCTION     vUpdateRelatedTrigger                                         */
/******************************************************************************/
/**
*  \brief       to correct "hold" trigger states which are related to actual
*               trigger,
*               overwritten base class function
*
*  \param       actual Trigger
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_CameraSupplySupervision::vUpdateRelatedTrigger(tU32 u32Trigger)
{
   switch (u32Trigger)
   {
      case dispvidctrl_tclFsm_CameraSupplySupervision::eTrigger_SupervisionOff:
         vUpdateTrigger(eTrigger_SupervisionOn, FALSE);
         break;
      case dispvidctrl_tclFsm_CameraSupplySupervision::eTrigger_SupervisionOn:
         vUpdateTrigger(eTrigger_SupervisionOff, FALSE);
         break;
      case dispvidctrl_tclFsm_CameraSupplySupervision::eTrigger_DiagMicSupervisionOff:
         vUpdateTrigger(eTrigger_DiagMicSupervisionOn, FALSE);
         break;
      case dispvidctrl_tclFsm_CameraSupplySupervision::eTrigger_DiagMicSupervisionOn:
         vUpdateTrigger(eTrigger_DiagMicSupervisionOff, FALSE);
         break;
      case dispvidctrl_tclFsm_CameraSupplySupervision::eTrigger_DiagCameraSupervisionOff:
         vUpdateTrigger(eTrigger_DiagCameraSupervisionOn, FALSE);
         break;
      case dispvidctrl_tclFsm_CameraSupplySupervision::eTrigger_DiagCameraSupervisionOn:
         vUpdateTrigger(eTrigger_DiagCameraSupervisionOff, FALSE);
         break;
      default:
         break;
   }
}

/******************************************************************************/
/* FUNCTION     _pfCallbackTimer_FsmStateTimeout                              */
/******************************************************************************/
/**
*  \brief
*
*  \param       pArg - pointer to this class
*  \return      none
*/
/******************************************************************************/
OSAL_tpfCallback dispvidctrl_tclFsm_CameraSupplySupervision::_pfCallbackTimer_FsmStateTimeout(tVoid* pArg)
{
   (tVoid) pArg;

   //ETG_TRACE_USR4(("  ====>>  : _pfCallbackTimer_FsmStateTimeout()"));

   //eTrigger_StateTimeout
   if ((m_poInstance) && (m_poInstance->m_poControl_Rvc))
   {
      m_poInstance->m_poControl_Rvc->vHandleFsmOutEvent_CameraSupplySupervision(FSM_CAMERASUPPLYSUPERVISION_OUT__FSM_CAMERASUPPLYSUPERVISION_INPUT_EVENT,
                                                                         (tU32) eTrigger_StateTimeout);
   }

   return 0;
};

/******************************************************************************/
/* FUNCTION     _pfCallbackTimer_FsmSupervisionTimeout                        */
/******************************************************************************/
/**
*  \brief
*
*  \param       pArg - pointer to this class
*  \return      none
*/
/******************************************************************************/
OSAL_tpfCallback dispvidctrl_tclFsm_CameraSupplySupervision::_pfCallbackTimer_FsmSupervisionTimeout(tVoid* pArg)
{
   (tVoid) pArg;

   //ETG_TRACE_USR4(("  ====>>  : _pfCallbackTimer_FsmSupervisionTimeout()"));

   //eTrigger_SupervisionTimeout
   if ((m_poInstance) && (m_poInstance->m_poControl_Rvc))
   {
      m_poInstance->m_poControl_Rvc->vHandleFsmOutEvent_CameraSupplySupervision(FSM_CAMERASUPPLYSUPERVISION_OUT__FSM_CAMERASUPPLYSUPERVISION_INPUT_EVENT,
                                                                         (tU32) eTrigger_SupervisionTimeout);
   }

   return 0;
};

/******************************************************************************/
/* FUNCTION     vStartFsmStateTimer                                           */
/******************************************************************************/
/**
*  \brief       start or stop the timer
*
*  \param       time out value
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_CameraSupplySupervision::vStartFsmStateTimer(tU32 u32Time)
{
   OSAL_s32TimerSetTime(m_hTimerHandle_FsmStateTimeout, u32Time, u32Time);
}


/******************************************************************************/
/* FUNCTION     vStartFsmSupervisionTimer                                     */
/******************************************************************************/
/**
*  \brief       start or stop the timer
*
*  \param       time out value
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_CameraSupplySupervision::vStartFsmSupervisionTimer(tU32 u32Time)
{
   OSAL_s32TimerSetTime(m_hTimerHandle_FsmSupervisionTimeout, u32Time, 0);
}


/******************************************************************************/
/* FUNCTION     vEntry_Off                                                    */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_CameraSupplySupervision::vEntry_Off(tVoid)
{
// trigger(s):
// eTrigger_SupervisionOff
// eTrigger_DiagCameraSupervisionOff

    // stop supervision timer
    if (NULL != m_poInstance)
    {
        m_poInstance->vStartFsmSupervisionTimer(0);
    }
}

/******************************************************************************/
/* FUNCTION     vDo_Off                                                       */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_CameraSupplySupervision::vDo_Off(tVoid)
{
// trigger(s):
// eTrigger_SendNextTestResult

   if ((m_poInstance) && (m_poInstance->m_poControl_Rvc) )
   {
      m_poInstance->m_poControl_Rvc->vHandleFsmOutEvent_CameraSupplySupervision(FSM_CAMERASUPPLYSUPERVISION_OUT__SEND_NO_RESULT);
   }
}

/******************************************************************************/
/* FUNCTION     vExit_Off                                                     */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_CameraSupplySupervision::vExit_Off(tVoid)
{
// trigger(s):
// eTrigger_SupervisionOn

}


/******************************************************************************/
/* FUNCTION     vEntry_On                                                     */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_CameraSupplySupervision::vEntry_On(tVoid)
{
// trigger(s):
// eTrigger_SupervisionOn

// start supervision timer
   if (NULL != m_poInstance)
   {
      m_poInstance->vStartFsmSupervisionTimer((tU32) DISPVIDCTRL_CAMERA_SUPPLY_SUPERVISION_TIME);
   }
}

/******************************************************************************/
/* FUNCTION     vDo_On                                                        */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_CameraSupplySupervision::vDo_On(tVoid)
{
// trigger(s):
// eTrigger_SupervisionTimeout
// eTrigger_SendNextTestResult
// eTrigger_CameraSupplyError

   if ((m_poInstance) && (m_poInstance->m_poControl_Rvc) )
   {
      if (eTrigger_SupervisionTimeout == m_poInstance->u32GetCurrentTrigger() )
      {
         m_poInstance->m_poControl_Rvc->vHandleFsmOutEvent_CameraSupplySupervision(FSM_CAMERASUPPLYSUPERVISION_OUT__CHECK_CURRENT_CONSUMPTION);
         if ( m_poInstance->bGetTriggerState ( dispvidctrl_tclFsm_CameraSupplySupervision::eTrigger_SpeedSupervisionActive ) )
         {
            m_poInstance->m_poControl_Rvc->vHandleFsmOutEvent_CameraSupplySupervision(FSM_CAMERASUPPLYSUPERVISION_OUT__CHECK_CURRENT_SPEED);
         }
         // restart supervision timer
         m_poInstance->vStartFsmSupervisionTimer((tU32) DISPVIDCTRL_CAMERA_SUPPLY_SUPERVISION_TIME);
      }
      else if (eTrigger_SendNextTestResult == m_poInstance->u32GetCurrentTrigger() )
      {
         m_poInstance->m_poControl_Rvc->vHandleFsmOutEvent_CameraSupplySupervision(FSM_CAMERASUPPLYSUPERVISION_OUT__SEND_NEXT_TEST_RESULT);
      }
      else if (eTrigger_CameraSupplyError == m_poInstance->u32GetCurrentTrigger() )
      {
         // set second parameter to "TRUE" in case of a error state GPIO callback trigger
         m_poInstance->m_poControl_Rvc->vHandleFsmOutEvent_CameraSupplySupervision(FSM_CAMERASUPPLYSUPERVISION_OUT__CHECK_CURRENT_CONSUMPTION, (tU32) TRUE);
      }
      else
      {
      }
   }
}

/******************************************************************************/
/* FUNCTION     vExit_On                                                      */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_CameraSupplySupervision::vExit_On(tVoid)
{
}

/******************************************************************************/
/* FUNCTION     vDo_DiagControlCamera                                         */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_CameraSupplySupervision::vDo_DiagControlCamera(tVoid)
{
// trigger(s):
// eTrigger_StateTimeout
// eTrigger_DiagMicrophoneFreeze

    if ((m_poInstance) && (m_poInstance->m_poControl_Rvc) )
    {
      if (eTrigger_StateTimeout == m_poInstance->u32GetCurrentTrigger() )
      {
         m_poInstance->m_poControl_Rvc->vHandleFsmOutEvent_CameraSupplySupervision(FSM_CAMERASUPPLYSUPERVISION_OUT__DIAG_CAMERA_VCC_MONITOR_TIMEOUT);
      }
    }
}

/******************************************************************************/
/* FUNCTION     vDo_DiagControlMicrophone                                     */
/******************************************************************************/
/**
*  \brief
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclFsm_CameraSupplySupervision::vDo_DiagControlMicrophone(tVoid)
{
// trigger(s):
// eTrigger_StateTimeout
// eTrigger_DiagMicrophoneFreeze

    if ((m_poInstance) && (m_poInstance->m_poControl_Rvc) )
    {
      if (eTrigger_StateTimeout == m_poInstance->u32GetCurrentTrigger() )
      {
         m_poInstance->m_poControl_Rvc->vHandleFsmOutEvent_CameraSupplySupervision(FSM_CAMERASUPPLYSUPERVISION_OUT__DIAG_MICROPHONE_VCC_MONITOR_TIMEOUT);
      }
    }
}

/*******************************************************************************
*                                       E O F
*******************************************************************************/
