/******************************************************************************/
/**
* \file    dispvidctrl_tclFsm_CameraSupply.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann
* \remark  Scope     : A-IVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_FSM_CAMERASUPPLY_H_
#define _DISPVIDCTRL_TCL_FSM_CAMERASUPPLYL_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_tclFsm_Base.h"

/*******************************************************************************
                        Defines
*******************************************************************************/

typedef struct
{
   tU8 u8Brand;
   tU8 u8CameraVideoHoldingTime;
}TConfiguration_Fsm_CameraSupply;


//***********************************************************************
//  CLASS
//***********************************************************************

class dispvidctrl_tclFsm_CameraSupply: public dispvidctrl_tclFsm_Base
{
public:

      // Available States -----------------------------------------------
      enum
      {
          eState_CameraOff                    = 0,
          eState_CameraBoot_ReverseRequest    = 1,
          eState_CameraBoot_SettingsRequest   = 2,
          eState_CameraOn_ReverseRequest      = 3,
          eState_CameraOn_SettingsRequest     = 4,
          eState_CameraOn_WaitForOffRequest   = 5,
          eState_Max,
          eState_Invalid                  = 0xFFFF
      };

      // Available Trigger ----------------------------------------------
      enum
      {
          eTrigger_None                  = 0x00000000,
          eTrigger_ReverseOn             = 0x00000001,
          eTrigger_ReverseDebounced      = 0x00000002,
          eTrigger_ReverseOff            = 0x00000004,
     
          eTrigger_ServiceRequestOff     = 0x00000010,
          eTrigger_CameraOff             = 0x00000020,
          eTrigger_CameraBootTimeout     = 0x00000040,
          eTrigger_StateTimeout          = 0x00000080,
     
          eTrigger_Disable               = 0x00000100,
          eTrigger_CameraOffDelayTimeout = 0x00000200,
          eTrigger_DirectOnReverseReq    = 0x00000400,
          eTrigger_CameraSupplyOff       = 0x00000800,

          eTrigger_VideoHoldingTimeout   = 0x00001000,
          eTrigger_IgnitionOff           = 0x00002000,
          eTrigger_IgnitionOn            = 0x00004000,
          
          eTrigger_SettingsOn            = 0x00010000,
          eTrigger_SettingsOff           = 0x00020000,
          eTrigger_TailgateOpen          = 0x00040000,
          eTrigger_TailgateClose         = 0x00080000
      };

      static dispvidctrl_tclFsm_CameraSupply* tclCreateInstance(dispvidctrl_tclControl_Rvc* poControl_Rvc);

      dispvidctrl_tclFsm_CameraSupply();                                      // constructor
      dispvidctrl_tclFsm_CameraSupply(dispvidctrl_tclControl_Rvc* poControl_Rvc);  // constructor
      virtual ~dispvidctrl_tclFsm_CameraSupply();                             // destructor

      tVoid vConfigure(const TConfiguration_Fsm_CameraSupply* pStConfiguration_Fsm_CameraSupply);

      tVoid vNewTrigger(tU32 u32Trigger, tBool bTriggerState) const;
      tVoid vUpdateTriggerState(tU32 u32Trigger, tBool bTriggerState);


   protected:
      virtual tVoid vStartFsmStateTimer(tU32 u32Time); // overwrites FsmBase class function
      virtual tVoid vStateChangeDetected(tVoid);       // overwrites FsmBase class function
      virtual tVoid vUpdateRelatedTrigger(tU32 u32Trigger);

   private:
      static tVoid vEntry_CameraOff(tVoid);
      static tVoid    vDo_CameraOff(tVoid);
      static tVoid  vExit_CameraOff(tVoid);
      static tVoid vEntry_CameraBoot(tVoid);
      static tVoid  vExit_CameraBoot(tVoid);
      static tVoid vEntry_CameraOn_ReverseRequest(tVoid);
      static tVoid    vDo_CameraOn_ReverseRequest(tVoid);
      static tVoid vEntry_CameraOn_SettingsRequest(tVoid);
      static tVoid  vExit_CameraOn(tVoid);
      static tVoid vEntry_CameraOn_WaitForOffRequest(tVoid);
      static tVoid    vDo_CameraOn_WaitForOffRequest(tVoid);
      static tVoid  vExit_CameraOn_WaitForOffRequest(tVoid);

      static OSAL_tpfCallback _pfCallbackTimer_FsmStateTimeout(tVoid* pArg);
      static OSAL_tpfCallback _pfCallbackTimer_CameraBoot(tVoid* pArg);
      static OSAL_tpfCallback _pfCallbackTimer_CameraOffDelay(tVoid* pArg);
      static OSAL_tpfCallback _pfCallbackTimer_VideoHolding(tVoid* pArg);
      tBool  _bSetTimer_CameraBoot(OSAL_tMSecond msTimeout);
      tBool  _bSetTimer_CameraOffDelay(OSAL_tMSecond msTimeout);
      tBool  _bSetTimer_VideoHolding(OSAL_tMSecond msTimeout);
      OSAL_tTimerHandle  m_hTimerHandle_FsmStateTimeout;
      OSAL_tTimerHandle  m_hTimerHandle_CameraBoot;
      OSAL_tTimerHandle  m_hTimerHandle_CameraOffDelay;
      OSAL_tTimerHandle  m_hTimerHandle_VideoHolding;


      static TFsmStateConf     aFsm_CameraSupply_StateTable[eState_Max];
      static TStateTransitions aFsm_CameraSupply_StateTransitionTable[];

      dispvidctrl_tclControl_Rvc*              m_poControl_Rvc;
      static dispvidctrl_tclFsm_CameraSupply*  m_poInstance;

      tBool  m_bStateTimeout;
      tBool  m_bRvcPowerHoldingActive;
      tU32   m_u32CameraPowerHoldingTimeBrandspezificInMs;
      tU32   m_u32CameraVideoHoldingTimeBrandspezificInMs;

      // configuration data
      tU8    m_u8Brand;
};


#endif // _DISPVIDCTRL_TCL_FSM_CAMERASUPPLY_H_

/*******************************************************************************
*                                       E O F
*******************************************************************************/

