/* ******************************************************FileHeaderBegin** *//**
*
* @file        vd_early_tclFsm_Base.h
*  ShortInfo
*
*  LongInfo
*
* @date        2009-03-14
*
* @note
*
*  &copy; Copyright Robert Bosch Car Multimedia. All Rights reserved!
*
*//* ***************************************************FileHeaderEnd******* */
#ifndef _DISPVIDCTRL_TCL_FSM_BASE_H_
#define _DISPVIDCTRL_TCL_FSM_BASE_H_

#define FSM_TRACE_ID_TRIGGER       0x3000
#define FSM_TRACE_ID_NEW_STATE     0x3001
#define FSM_TRACE_ID_NO_NEW_STATE  0x3002
#define FSM_TRACE_ID_INFO          0x3003

#if !defined (FSM_DONT_CARE)
#define FSM_DONT_CARE                        0xFFFFFFFF
#endif

#if !defined (FSM_STATE_ID_NONE)
#define FSM_STATE_ID_NONE                    0xFFFFFFFF
#endif
#if !defined (FSM_TRIGGER_ID_NONE)
#define FSM_TRIGGER_ID_NONE                  0x00000000
#endif
#if !defined (FSM_TRANSITION_ID_NONE)
#define FSM_TRANSITION_ID_NONE               0xFFFFFFFF
#endif
#if !defined (FSM_TRANSITION_ACTION_ID_NONE)
#define FSM_TRANSITION_ACTION_ID_NONE        0
#endif
#if !defined (FSM_TIMER_ID_NONE)
#define FSM_TIMER_ID_NONE                    0
#endif

class dispvidctrl_tclFsm_Base {
public:
   typedef tVoid tFsmStateEntryFunc      (tVoid);
   typedef tVoid tFsmStateExitFunc       (tVoid);
   typedef tVoid tFsmStateDoFunc         (tVoid);

   typedef struct {
      tU32 u32FsmState;
      tU32 u32Timeout;
      tFsmStateEntryFunc *pfnvStateEntry;
      tFsmStateDoFunc    *pfnvStateDo;
      tFsmStateExitFunc  *pfnvStateExit;
   }TFsmStateConf;

   typedef struct
   {
      tU32 u32TransitionId;
      tU32 u32FsmState;
      tU32 u32UpdateTrigger;
      tU32 u32TriggerSet;    // guard conditions
      tU32 u32TriggerNotSet; // guard conditions
      tU32 u32NextFsmState;
      tU32 u32TransitionActionId;     // <= may be omitted in the initializer list; in this case, the compiler initializes it with 0 (== FSM_TRANSITION_ACTION_ID_NONE)
      tU32 u32TransitionActionParam1; // <= ditto
      tU32 u32TransitionActionParam2; // <= ditto
   }TStateTransitions;

   tU32 u32GetFsmState() const {return _u32FsmState;} 
   tVoid vTraceStatusInfo(tU32 RemainingTime = 0);

   tU32 u32GetCurrentTrigger() const {return _u32UpdateTrigger;}
   tBool bGetTriggerState(tU32 u32Trigger) const {return ((u32Trigger & _u32Trigger) > 0 );}

   typedef struct {  // a struct to hold all info about the last transition which was actually carried out
      tU32  u32TransitionId;
      tU32  u32CurrTrigger;
      tBool bCurrTriggerState;
      tU32  u32OldTriggerStates;
      tU32  u32UpdTriggerStates;
      tU32  u32CfgOldState;
      tU32  u32CfgNewState;
      tU32  u32OldState;
      tU32  u32NewState;
   } stTransitionInfo;
   const stTransitionInfo& crstGetTransitionInfo(tVoid) { return _stTransitionInfo; }
   
protected:
   tU32 _u32FsmState;
   tU32 _u32LastFsmState;
   stTransitionInfo _stTransitionInfo;

private:
   tBool _bUseReenterTransitions;

   tU32 _u32Trigger;         // is holding all triggers (with state = TRUE) the FSM was triggered with
   tU32 _u32UpdateTrigger;   // the new received trigger

   tU32 _u32LastTransitionId;
   tU32 _u32MaxStateEntry;
   tU32 _u32MaxTransitionEntry;
   tU32 _u32TimeOut;
   tU32 _u32TraceClass;
   tU8  _u8FsmTraceId;

   const TStateTransitions* _paFsmTransitionTable;
   const TFsmStateConf* _paFsmStateTable;

   tVoid vActStateExit(tU32 u32FsmState) const;
   tU32  u32ActStateEntry(tU32 u32NewFsmState) const; 
   tVoid vActStateReached(tU32 u32FsmState) const;
   tVoid vActStateDo(tU32 u32FsmState) const;

protected:

   virtual tVoid vStateChangeDetected(tVoid);
   virtual tVoid vUpdateRelatedTrigger(tU32 u32Trigger);

   tVoid vUpdateTrigger(tU32 u32Trigger, tBool bState);
   tU32 u32CalcNewFsmState(tU32 u32Trigger, tBool bState);

   virtual tVoid vStartFsmStateTimer(tU32 u32Time);
   tVoid vStateNoTransition() const;

   virtual tVoid vTransitionAction(tU32 u32ActionId, tU32 u32Param1=0, tU32 u32Param2=0) { (tVoid)u32ActionId; (tVoid)u32Param1; (tVoid)u32Param2; }  // may be overwritten by derived class

   dispvidctrl_tclFsm_Base(tU32 u32InitFsmSTate, tU32 u32MaxTransitionEntry, const TStateTransitions* paFsmTransitionTable, tU32 u32MaxStateEntry,
                           const TFsmStateConf* paFsmStateTable, tU32 u32TraceClass, tU8 u8FsmTraceId, tBool bUseReenterTransitions=FALSE);
   virtual ~dispvidctrl_tclFsm_Base(); // destructor
};

#endif

