/******************************************************************************/
/**
* \file    dispvidctrl_tclDiagSystemSetListener.cpp
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2012 Robert Bosch GmbH, Hildesheim
* \remark  Author    :
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_tclDiagSystemSetListener.h"
// DIMMING: display settings, config manager, INC client handler dimming
#include "I_dispvidctrl_tclDisplaySettings.h"
#include "I_dispvidctrl_tclConfigMgr.h"
#include "Idispvidctrl_ClientDimming.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#ifndef ET_TRACE_INFO_ON // reference to define ET_TRACE_INFO_ON because of lint Info 750
// Info 750: prio2: local macro 'ET_TRACE_INFO_ON' not referenced
// (this lint error is related to the ETG framework and can't be solved within dispvidctrl)
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_tclDiagSystemSetListener.cpp.trc.h"
#endif


/******************************************************************************/
/* FUNCTION     dispvidctrl_tclDiagSystemSetListener                               */
/******************************************************************************/
/**
*  \brief       default constructor,
*               private, can not be called
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclDiagSystemSetListener::dispvidctrl_tclDiagSystemSetListener()
{
    _poSystemSetIF = OSAL_NULL;
}


/******************************************************************************/
/* FUNCTION     dispvidctrl_tclDiagSystemSetListener(..)                           */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       pointer to routine control interface
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclDiagSystemSetListener::dispvidctrl_tclDiagSystemSetListener(diaglib::tclSystemSetIF* poIF)
{
   // +++ Init your data here +++
   _poSystemSetIF = OSAL_NULL;

   if(OSAL_NULL == poIF)
   {
      // +++ Trace Error +++
   }
   else
   {
      // +++ Store the interface pointer +++
      _poSystemSetIF = poIF;
   }
}


/******************************************************************************/
/* FUNCTION     ~dispvidctrl_tclDiagSystemSetListener()                            */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
dispvidctrl_tclDiagSystemSetListener::~dispvidctrl_tclDiagSystemSetListener()
{
   // +++ Free resources you might have created/used +++
   _poSystemSetIF = OSAL_NULL;
}


/******************************************************************************/
/* FUNCTION     vOnSystemSet                                                  */
/******************************************************************************/
/**
*  \brief       Incoming SystemSet event handler
*               Is called on incoming SystemSet requests. Components reaction
*               should be one of the following:
*
*  \param       - u32SystemSetID SystemSet ID of the incoming request
*               - u32SystemSetType The type of system set that is requested
*               - poMsgContext Internal message context. Just return exactly
*                 this context when you answer to this request.
*  \return      tU32 ResultCode, currently not checked. Please return 0.
*/
/******************************************************************************/
tU32 dispvidctrl_tclDiagSystemSetListener::vOnSystemSet( tU32  u32SystemSetID,
                               diaglib::tenSystemSetType  u32SystemSetType,
                                       diaglib::tContext  MsgContext)
{
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );

   // send result to fc_diagnosis
   if(OSAL_NULL != _poSystemSetIF)
   {
      diaglib::tenSystemSetResult _enSysSetResult = diaglib::EN_SYSTEMSET_OK;
      diaglib::tclParameterVector _oErrorList;

      if(diaglib::EN_TYPE_CODING == u32SystemSetType)
      {
         ETG_TRACE_USR4(("dispvidctrl_tclDiagSystemSetListener::vOnSystemSet() - EN_TYPE_CODING received "));
         // coding has been changed (camera system type coding value)
         // previously we have triggered an configuration update in FFD via CSM for correct signal configuration with next start up
         if (SYSSETID_REAR_VIEW_CAME == u32SystemSetID)
         {
        	 dispvidctrl_tclAppMain::theServer()->vHandleConfigUpdate();
         }
         // DIMMING: config manager
         if (SYSSETID_DIMM == u32SystemSetID || SYSSETID_REAR_VIEW_CAME == u32SystemSetID)
         {
			 I_dispvidctrl_tclConfigMgr* _poDimConfigMgr = dynamic_cast<I_dispvidctrl_tclConfigMgr*>(dispvidctrl_tclAppMain::theServer()->getHandler("I_dispvidctrl_tclConfigMgr"));
			 if (OSAL_NULL != _poDimConfigMgr)
			 {
			 #ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
				 _poDimConfigMgr->vReset_DispRenaultDatapool();
			 #endif

				 _poDimConfigMgr->vOnLoadSettings();
			 }
         }

         // in case of invalid references to main or system thread
         //_enSysSetResult = diaglib::EN_SYSTEMSET_NOT_OK;
      }
      else if(diaglib::EN_TYPE_CALIBRATION == u32SystemSetType)
      {
         ETG_TRACE_USR4(("dispvidctrl_tclDiagSystemSetListener::vOnSystemSet() - EN_TYPE_CALIBRATION received "));
         // calibration has been changed

         // in case of invalid references to main or system thread
         //_enSysSetResult = diaglib::EN_SYSTEMSET_NOT_OK;

         // DIMMING: config manager
         if (SYSSETID_DIMM == u32SystemSetID || SYSSETID_REAR_VIEW_CAME == u32SystemSetID)
         {
			 I_dispvidctrl_tclConfigMgr* _poDimConfigMgr = dynamic_cast<I_dispvidctrl_tclConfigMgr*>(dispvidctrl_tclAppMain::theServer()->getHandler("I_dispvidctrl_tclConfigMgr"));
			 if (OSAL_NULL != _poDimConfigMgr)
			 {
			#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
				 _poDimConfigMgr->vReset_DispRenaultDatapool();
			#endif
				 _poDimConfigMgr->vOnLoadSettings();
			 }
         }
      }
      else if (diaglib::EN_TYPE_DEFAULT_HMI == u32SystemSetType || diaglib::EN_TYPE_DEFAULT_TEF == u32SystemSetType)
      {
         ETG_TRACE_USR4(("dispvidctrl_tclDiagSystemSetListener::vOnSystemSet() - EN_TYPE_DEFAULT_TEF or HMI received "));

         // do factory reset

         //tChar strIfName[] = "";
         //dispvidctrl_tclAppMain::theServer()->vPostMsg...(strIfName);

         // in case of invalid references of main or system thread
         //_enSysSetResult = diaglib::EN_SYSTEMSET_NOT_OK;

         // DIMMING: display settings and INC client handler dimming
         if (SYSSETID_DIMM == u32SystemSetID || SYSSETID_REAR_VIEW_CAME == u32SystemSetID)
         {
			 I_dispvidctrl_tclDisplaySettings* _poDimDisplaySettings = dynamic_cast<I_dispvidctrl_tclDisplaySettings*>(dispvidctrl_tclAppMain::theServer()->getHandler("I_dispvidctrl_tclDisplaySettings"));
			 if (OSAL_NULL != _poDimDisplaySettings && 0 > _poDimDisplaySettings->s32ResetDisplaySettings())
			 {
				ETG_TRACE_ERRMEM(("dispvidctrl_tclDiagSystemSetListener::vOnSystemSet() - s32ResetDisplaySettings return negative result "));
				// *commented out related NCG3D-28383*
				// _enSysSetResult = diaglib::EN_SYSTEMSET_NOT_OK;
				// diaglib::trParameter _tErrorCode;
				// _tErrorCode.enType = diaglib::EN_PARAMETER_TYPE_U8ERROR;
				// _tErrorCode.u8ErrorValue = diaglib::EN_ERROR_NO_ERROR;
				// _oErrorList.push_back(_tErrorCode);
			 }
			 I_dispvidctrl_tclClientDimming* _poDimINCDimming = dynamic_cast<I_dispvidctrl_tclClientDimming*>(dispvidctrl_tclAppMain::theServer()->getHandler("I_dispvidctrl_tclClientDimming"));
			 if (OSAL_NULL != _poDimINCDimming && 0 > _poDimINCDimming->s32ResetDimming())
			 {
				ETG_TRACE_ERRMEM(("dispvidctrl_tclDiagSystemSetListener::vOnSystemSet() - s32ResetDimming return negative result "));
				// *commented out related NCG3D-28383*
				// _enSysSetResult = diaglib::EN_SYSTEMSET_NOT_OK;
				// diaglib::trParameter _tErrorCode;
				// _tErrorCode.enType = diaglib::EN_PARAMETER_TYPE_U8ERROR;
				// _tErrorCode.u8ErrorValue = diaglib::EN_ERROR_NO_ERROR;
				// _oErrorList.push_back(_tErrorCode);
			 }
		#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
			 I_dispvidctrl_tclConfigMgr* _poDimConfigMgr = dynamic_cast<I_dispvidctrl_tclConfigMgr*>(dispvidctrl_tclAppMain::theServer()->getHandler("I_dispvidctrl_tclConfigMgr"));
	         if(_poDimConfigMgr != NULL)
			 {
	        	 _poDimConfigMgr->vReset_DispRenaultDatapool();
			 }
		#endif

         }
      }
      else
      {
         // other system type -> not supported
         // probably better NOT to return an error, since diag might trigger again and again
      }

      // send result to diaglib
      _poSystemSetIF->bSendSystemSetResult( _enSysSetResult, _oErrorList, MsgContext );
   }
   return diaglib::U32_DIAGLIB_RETURN_OK;
}


/******************************************************************************/
/* FUNCTION     vOnSystemSetFinished                                          */
/******************************************************************************/
/**
*  \brief       Is called on incoming SystemSetFinished requests.
*               Components reaction should be one of the following:
*
*  \param       - u32SystemSetID SystemSet ID of the incoming request
*               - u32SystemSetType The type of system set that has ended
*               - poMsgContext Internal message context. Just return exactly
*                 this context when you answer to this request.
*  \return      tU32 ResultCode, currently not checked. Please return 0.
*/
/******************************************************************************/
tU32 dispvidctrl_tclDiagSystemSetListener::vOnSystemSetFinished( tU32  u32SystemSetID,
                                       diaglib::tenSystemSetType  u32SystemSetType,
                                               diaglib::tContext  MsgContext)
{
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );

   {
      // On SystemSetFinished update the new configuration data
      // todo:        read new configuration data and update internally
      // could be handled by tclControl OnOff state machine which disables the different controls (RVC, AVM, Sonar ...) and enables again after configuration update
   }


   if(OSAL_NULL != _poSystemSetIF)
   {
      // send result to diaglib
      if(TRUE == _poSystemSetIF->bAcknowledgeSystemSetFinished( MsgContext )) {
         ETG_TRACE_USR4(("dispvidctrl_tclDiagSystemSetListener::vOnSystemSetFinished: _poSystemSetIF->bAcknowledgeSystemSetFinished = TRUE"));
      } else {
         ETG_TRACE_USR4(("dispvidctrl_tclDiagSystemSetListener::vOnSystemSetFinished: _poSystemSetIF->bAcknowledgeSystemSetFinished = FALSE"));
      }
   }
   return diaglib::U32_DIAGLIB_RETURN_OK;
}


/******************************************************************************/
/* FUNCTION     vOnSystemSetPrepare                                           */
/******************************************************************************/
/**
*  \brief       Is called on incoming SystemSetPrepare requests.
*               Components reaction should be one of the following:
*
*  \param       - u32SystemSetID SystemSet ID of the incoming request
*               - u32SystemSetType The type of system set that should be
*                 prepared
*               - poMsgContext Internal message context. Just return exactly
*                 this context when you answer to this request.
*  \return      tU32 ResultCode, currently not checked. Please return 0.
*/
/******************************************************************************/
tU32 dispvidctrl_tclDiagSystemSetListener::vOnSystemSetPrepare( tU32  u32SystemSetID,
                                      diaglib::tenSystemSetType  u32SystemSetType,
                                              diaglib::tContext  MsgContext)
{
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );

   // nothing to do for RVC
   if(OSAL_NULL != _poSystemSetIF)
   {
      diaglib::tenSystemSetResult _enSysSetResult = diaglib::EN_SYSTEMSET_OK;
      diaglib::tclParameterVector _oErrorList;

      // send result to diaglib
      _poSystemSetIF->bSendSystemSetPrepareResult( _enSysSetResult, _oErrorList, MsgContext );
   }
   return diaglib::U32_DIAGLIB_RETURN_OK;
}


/******************************************************************************/
/* FUNCTION     vOnSystemSetCheck                                             */
/******************************************************************************/
/**
*  \brief       Incoming SystemSet check handler
*               Is called on incoming Check SystemSet Request.
*
*  \param       - u32SystemSetID SystemSet ID of the incoming request
*               - u32SystemSetType The type of system set that should be
*                 prepared
*               - poMsgContext Internal message context. Just return exactly
*                 this context when you answer to this request.
*  \return      tU32 ResultCode, currently not checked. Please return 0.
*/
/******************************************************************************/
tU32 dispvidctrl_tclDiagSystemSetListener::vOnSystemSetCheck( tU32  u32SystemSetID,
                                    diaglib::tenSystemSetType  u32SystemSetType,
                                            diaglib::tContext  MsgContext)
{
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );

   // nothing to do for RVC
   if(OSAL_NULL != _poSystemSetIF)
   {
      diaglib::tenSystemSetResult _enSysSetResult = diaglib::EN_SYSTEMSET_OK;
      diaglib::tclParameterVector _oErrorList;

      // send result to diaglib
      _poSystemSetIF->bSendSystemSetCheckResult( _enSysSetResult, _oErrorList, MsgContext );
   }
   return diaglib::U32_DIAGLIB_RETURN_OK;
}

/*******************************************************************************
*                                       E O F
*******************************************************************************/
