/******************************************************************************/
/**
* \file    dispvidctrl_tclDiagRoutineControlListener.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2012 Robert Bosch GmbH, Hildesheim
* \remark  Author    :
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/
/*
* DESCRIPTION: Example implementation of a routine control listener
* that provides access to demodata. The difference of this example
* compared to a realworld usecase is the fact, that usually for a routine
* control you would have longer running tests.
* In case of longer running tests you probably delegate a test request to
* a worker thread. It is no problem to send the response from this worker
* thread instead of how it is done in this example. When you have a worker
* thread the RoutineControlAbort functionality also makes more sense :)
* See general documentation, when you have questions on the sequence of
* a test that you have to implement or consult diagnosis team.
* Anyway take this class as a template for your own listener classes and
* adjust the parts marked with
*/

#ifndef DISPVIDCTRL_DIAGROUTINECONTROLLISTENER_H
#define DISPVIDCTRL_DIAGROUTINECONTROLLISTENER_H

// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_ROUTINE_CONTROL
#define DIAGLIB_INCLUDE_ID_SPEC_TYPES
#include "diaglib_if.h"

#ifndef ROUTINEID_VIDE_SOUR_SELE
   // Video Source Select: Select the Video Source and Norm.
   #define ROUTINEID_VIDE_SOUR_SELE 200
   #define ROUTINEID_VIDE_SOUR_SELE_START_u8RequestedVideoSource 0
   #define ROUTINEID_VIDE_SOUR_SELE_START_PARAM1 (tU8)1
   #define ROUTINEID_VIDE_SOUR_SELE_START_u8RequestedVideoNorm 1
   #define ROUTINEID_VIDE_SOUR_SELE_START_PARAM2 (tU8)1
   #define ROUTINEID_VIDE_SOUR_SELE_START_LEN (tU8)2
   #define ROUTINEID_VIDE_SOUR_SELE_RESULT_u8ActualVideoSource 0
   #define ROUTINEID_VIDE_SOUR_SELE_RESULT_PARAM1 (tU8)1
   #define ROUTINEID_VIDE_SOUR_SELE_RESULT_u8ActualVideoNorm 1
   #define ROUTINEID_VIDE_SOUR_SELE_RESULT_PARAM2 (tU8)1
   #define ROUTINEID_VIDE_SOUR_SELE_RESULT_LEN (tU8)2
   enum tenDiaglibVideoSource //
   {
      EN_VideoSourceINTERNAL = 0x00, // Set to Internal Video Source.
      EN_VideoSourceEXTERNAL = 0x01, // Set to External Video Source.
      EN_VideoSourceIGNORE = 0xFF // Ignore Video Source.
   };
   enum tenDiaglibVideoNorm //
   {
      EN_VideoNormPAL = 0x00, // Set to Video Norm - PAL.
      EN_VideoNormNTSC = 0x01, // Set to Video Norm - NTSC.
      EN_VideoNormCVBS1 = 0x02, // Set to Video Norm - CVBS1.
      EN_VideoNormCVBS2 = 0x03, // Set to Video Norm - CVBS2.
      EN_VideoNormCVBS3 = 0x04, // Set to Video Norm - CVBS3.
      EN_VideoNormLVDS = 0x05, // Set to Video Norm - LVDS.
      EN_VideoNormIGNORE = 0xFF // Ignore Video Norm.
   };
#endif

// +++ Application forward declaration +++


class dispvidctrl_tclDiagRoutineControlListener: public diaglib::tclRoutineControlListenerIF
{

public:
   // +++ Depending on the type of listener you need the associated interface to send responses +++
   dispvidctrl_tclDiagRoutineControlListener(diaglib::tclRoutineControlIF*, dispvidctrl_tclAppMain*);
   virtual ~dispvidctrl_tclDiagRoutineControlListener();

private:
   dispvidctrl_tclDiagRoutineControlListener();

   // +++ Add your own helper functions here. Some of the most useful might be included in diaglib +++
   // +++ in future +++
   tVoid vBuildResultVector (diaglib::tclParameterVector &oResultVector, tU8 u8Param1, tU8 u8Param2) const;
   tVoid vSendError (diaglib::tenInternalError enErrorCode, diaglib::tContext MsgContext);

   // +++ Interface pointer to send responses to, adjust type according to listener type +++
   diaglib::tclRoutineControlIF* m_poRoutineCtrlIF;

   // +++ Pointer to application +++
   dispvidctrl_tclAppMain* m_poAppMain;


public:

   // +++ Place the virtual listener functions here. These depend on the listener you implement +++
   /***************************************************************************
    * RoutineControlListener methods
    ***************************************************************************/

   virtual tU32 vOnGetRoutineResult (
                                      tU32 u32RoutineId,
                                      diaglib::tContext MsgContext
                                    );

   virtual tU32 vOnRoutineControlAbort (
                                         tU32 u32RoutineId,
                                         diaglib::tContext MsgContext
                                       );

   virtual tU32 vOnRoutineControlStart (
                                         tU32 u32RoutineId,
                                         tU32 u32Bitmask,
                                         const diaglib::tclParameterVector& oParamVector,
                                         diaglib::tContext MsgContext
                                       );

};
#endif // DISPVIDCTRL_DIAGROUTINECONTROLLISTENER_H





