/******************************************************************************/
/**
* \file    dispvidctrl_tclDiagIoControlListener.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2012 Robert Bosch GmbH, Hildesheim
* \remark  Author    :
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/
#ifndef DISPVIDCTRL_DIAGIOCONTROLLISTENER_H
#define DISPVIDCTRL_DIAGIOCONTROLLISTENER_H

// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_GENERIC
#include "diaglib_if.h"

#ifndef IOCONTROLID_RVC_CONTROL_LINE
/* This is part of dia_IdSpec.h. If the define is available all defines here can be removed*/
/* control line of RVC */
#define IOCONTROLID_RVC_CONTROL_LINE 22
#define IOCONTROLID_RVC_CONTROL_LINE_SET_u8Mode 0
#define IOCONTROLID_RVC_CONTROL_LINE_SET_PARAM1 (tU8)1
#define IOCONTROLID_RVC_CONTROL_LINE_SET_LEN (tU8)1
#define IOCONTROLID_RVC_CONTROL_LINE_RESULT_u8Mode 0
#define IOCONTROLID_RVC_CONTROL_LINE_RESULT_PARAM1 (tU8)1
#define IOCONTROLID_RVC_CONTROL_LINE_RESULT_LEN (tU8)1
#endif

#ifndef IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1
/* This is part of dia_IdSpec.h. If the define is available all defines here can be removed*/
/* Set Microphon 1 Phantonvoltage */
#define IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1 3
#define IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1_SET_bStatus 0
#define IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1_SET_PARAM1 (tU8)1
#define IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1_SET_LEN (tU8)1
#define IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1_RESULT_bStatus 0
#define IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1_RESULT_PARAM1 (tU8)1
#define IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1_RESULT_LEN (tU8)1
#endif


// +++ Application forward declaration +++

// diag dimming io controls
enum tenDiagDimmingIoControl
{
   EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING = 0,
   EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP,
   EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING,
   EN_DIAG_DIM_IOCTRL_MAX,
   EN_DIAG_DIM_IOCTRL_UNDEF
};

struct tDiagDimmingIoControl
{
	tU32 u32Time;
	tU16 u16Brigthness;
	tBool bInit;
	tU8 u8Session;
};

// class definition
class dispvidctrl_tclDiagIoControlListener : public diaglib::tclIoControlListenerIF
{
public:
   // +++ Depending on the type of listener you need the associated interface to send responses +++
   dispvidctrl_tclDiagIoControlListener( diaglib::tclIoControlIF* poIoControlIF );

   // default destructor
   virtual ~dispvidctrl_tclDiagIoControlListener();

private:
   // default constructor
   dispvidctrl_tclDiagIoControlListener(); //lint !e1704 prio3 reviewed: constructor has private access specification: its use is forbidden
   // copy constructor
   dispvidctrl_tclDiagIoControlListener(const dispvidctrl_tclDiagIoControlListener& rhs); //lint !e1704 prio3 reviewed: constructor has private access specification: its use is forbidden
   // assignment operator
   dispvidctrl_tclDiagIoControlListener& operator=(const dispvidctrl_tclDiagIoControlListener& rhs);

   // attribute: reference to system set interface
   diaglib::tclIoControlIF* m_poIoControlIF;

   // +++ Pointer to application +++


   tVoid vSendResult(diaglib::tContext MsgContext, diaglib::tenIoControlAction enAction, diaglib::tenInternalError enError=diaglib::EN_ERROR_NO_ERROR) const;
   diaglib::tContext _MsgContext;

   // NCG3D-13847: handle IO Control for Dimming
   tU32 u32HandleIoControlFreeze_Dimming(tU32 u32IoControlId);
   tU32 u32HandleIoControlUnfreeze_Dimming(tU32 u32IoControlId);
   tU32 u32HandleIoControlSet_Dimming(tU32 u32IoControlId, tU16 u32Brithness);
   tenDiagDimmingIoControl enGetLastActivatedDimmingIoControl(tVoid) const;
   tDiagDimmingIoControl m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_MAX];
   tU8 m_u8LastContrastLevel;
   // NCG3D-72861: P-IVI: Touch_Controller_Reset_Command_Control, Incorrect response NRC 0x22
   tU32 u32HandleIoControlFreeze_TouchControllerReset(tU32 u32IoControlId);
   tU32 u32HandleIoControlUnfreeze_TouchControllerReset(tU32 u32IoControlId);
   tU32 u32HandleIoControlSet_TouchControllerReset(tU32 u32IoControlId, tU8 u8ExternalDisplay, tU8 u8ControlState);
   tBool m_bTouchControllerReset_Freeze;

public:
    // handler method for system setting
   virtual tU32 vOnIoControl (
                               tU32 u32IoControlId,
                               diaglib::tenIoControlAction enActionId,
                               const diaglib::tclParameterVector& oParameterVector,
                               diaglib::tContext MsgContext
                             );

   // handler method for finalising of system setting

   virtual tU32 vOnIoControlFreeze (
                                     tU32 u32IoControlId,
                                     diaglib::tContext MsgContext
                                   );
   virtual tU32 vOnIoControlUnfreeze (
                                       tU32 u32IoControlId,
                                       diaglib::tContext MsgContext
                                     );

//    tVoid vOnIoControlResult(trMsgSrvRspTestOperation const *poSrvRspTestOperation);

};

#endif

