/******************************************************************************/
/**
* \file    dispvidctrl_tclDiagIoControlListener.cpp
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2012 Robert Bosch GmbH, Hildesheim
* \remark  Author    :
* \remark  Scope     :
*
* \todo
*/
/******************************************************************************/
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_tclDiagIoControlListener.h"
#include "dispvidctrl_tclControl_Rvc.h"

#include "I_dispvidctrl_ServiceDimmingIf.h"
#include "I_dispvidctrl_tclDisplaySettings.h"
#include "I_dispvidctrl_tclConfigMgr.h"
#include "Idispvidctrl_ClientDimming.h"
#include "I_dispvidctrl_tclTouchDriverControl.h"
#include "dispvidctrl_tclTypes.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_tclDiagIoControlListener.cpp.trc.h"
#endif

dispvidctrl_tclDiagIoControlListener::dispvidctrl_tclDiagIoControlListener( diaglib::tclIoControlIF* poIoControlIF)
: m_poIoControlIF(poIoControlIF)
, _MsgContext(0)
{
   ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:dispvidctrl_tclDiagIoControlListener"));

   // init dimming io control
   (tVoid)memset((tVoid*)m_arrDimIoControl,OSAL_NULL,sizeof(m_arrDimIoControl));
   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING].u8Session = (tU8)::dimming_inc_fi::eKEY_FREEZE_SessionType;
   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP].u8Session = (tU8)::dimming_inc_fi::eSETUP_SessionType;
   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING].u8Session = (tU8)::dimming_inc_fi::eDISPLAY_FREEZE_SessionType;
   // NCG3D-54916: init last contrast level
   m_u8LastContrastLevel = DISPVIDCTRL_C_U8_LEVEL_MAX;
	//CID: 150202
	m_bTouchControllerReset_Freeze = FALSE; 
}

dispvidctrl_tclDiagIoControlListener::~dispvidctrl_tclDiagIoControlListener()
{
   ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:~dispvidctrl_tclDiagIoControlListener"));
   m_poIoControlIF = OSAL_NULL;

   // reset dimming io control
   (tVoid)memset((tVoid*)m_arrDimIoControl,OSAL_NULL,sizeof(m_arrDimIoControl));
}


tU32 dispvidctrl_tclDiagIoControlListener::vOnIoControlFreeze (tU32 u32IoControlId, diaglib::tContext MsgContext)
{
   ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:vOnIoControlFreeze ControlId %u", u32IoControlId));

   tU32 u32Ret = 0;
   tBool bFreeze = TRUE;

   //Freeze/Store old GPIO Value
   dispvidctrl_tclControl_Rvc* poControlRVC;
   poControlRVC = dynamic_cast<dispvidctrl_tclControl_Rvc*>(dispvidctrl_tclAppMain::theServer()->getHandler("dispvidctrl_tclControl_Rvc"));

   if ( poControlRVC )
   {
       switch ( u32IoControlId )
       {
       case IOCONTROLID_RVC_CONTROL_LINE:
           poControlRVC->vHandleControl(EN_CONTROL_RVC__DIAG_IOCONTROL_CAMERA_VCC_FREEZE_STATE_CHANGED, bFreeze);
           break;
       case IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1:
           poControlRVC->vHandleControl(EN_CONTROL_RVC__DIAG_IOCONTROL_MICROPHONE_VCC_FREEZE_STATE_CHANGED, bFreeze);
           break;
       default:
           break;
       }
   }

   // NCG3D-13847: handle Io Control Freeze for Dimming
   if ((IOCONTROLID_KEYBOARD_DIMMING == u32IoControlId) || (IOCONTROLID_KEYBOARD_PWM == u32IoControlId) || (IOCONTROLID_DISPLAY_DIMMING_U16 == u32IoControlId))
   {
	   (tVoid)u32HandleIoControlFreeze_Dimming(u32IoControlId);
   }

   // NCG3D-72861: P-IVI: Touch_Controller_Reset_Command_Control, Incorrect response NRC 0x22
   if (IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY == u32IoControlId)
   {
	   (tVoid)u32HandleIoControlFreeze_TouchControllerReset(u32IoControlId);
   }

   if ( !m_poIoControlIF->bSendIoCtrlFreezeResult( diaglib::EN_IO_CONTROL_OK, MsgContext) )
   {
      ETG_TRACE_USR2(("dispvidctrl_tclDiagIoControlListener::vOnIoControlFreeze: could not bSendIoCtrlFreezeResult"));
   }

   return u32Ret;
}

tU32 dispvidctrl_tclDiagIoControlListener::vOnIoControlUnfreeze(tU32 u32IoControlId, diaglib::tContext MsgContext)
{
   ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:vOnIoControlUnfreeze ControlId %u", u32IoControlId));

   tU32 u32Ret = 0;
   tBool bFreeze = FALSE;

   //Unfreeze/Restore old GPIO Value
   dispvidctrl_tclControl_Rvc* poControlRVC;
   poControlRVC = dynamic_cast<dispvidctrl_tclControl_Rvc*>(dispvidctrl_tclAppMain::theServer()->getHandler("dispvidctrl_tclControl_Rvc"));

   if ( poControlRVC )
   {
       switch ( u32IoControlId )
       {
       case IOCONTROLID_RVC_CONTROL_LINE:
           poControlRVC->vHandleControl(EN_CONTROL_RVC__DIAG_IOCONTROL_CAMERA_VCC_FREEZE_STATE_CHANGED, bFreeze);
           break;
       case IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1:
           poControlRVC->vHandleControl(EN_CONTROL_RVC__DIAG_IOCONTROL_MICROPHONE_VCC_FREEZE_STATE_CHANGED, bFreeze);
           break;

       default:
           break;
       }
   }

   // NCG3D-13847: handle Io Control Freeze for Dimming
   if ((IOCONTROLID_KEYBOARD_DIMMING == u32IoControlId) || (IOCONTROLID_KEYBOARD_PWM == u32IoControlId) || (IOCONTROLID_DISPLAY_DIMMING_U16 == u32IoControlId))
   {
	   (tVoid)u32HandleIoControlUnfreeze_Dimming(u32IoControlId);
   }

   // NCG3D-72861: P-IVI: Touch_Controller_Reset_Command_Control, Incorrect response NRC 0x22
   if (IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY == u32IoControlId)
   {
	   (tVoid)u32HandleIoControlUnfreeze_TouchControllerReset(u32IoControlId);
   }

   _MsgContext = MsgContext;
   vSendResult(MsgContext, diaglib::EN_ACTION_UNFREEZE, diaglib::EN_ERROR_NO_ERROR);

   if ( !m_poIoControlIF->bSendIoCtrlUnfreezeResult( diaglib::EN_IO_CONTROL_OK, MsgContext) )
   {
      ETG_TRACE_USR2(("dispvidctrl_tclDiagIoControlListener::vOnIoControlUnfreeze: could not bSendIoCtrlUnfreezeResult"));
   }

   return u32Ret;
}


tU32 dispvidctrl_tclDiagIoControlListener::vOnIoControl ( tU32 u32IoControlId,
                                                     diaglib::tenIoControlAction enActionId,
                                                     const diaglib::tclParameterVector& oParameterVector,
                                                     diaglib::tContext MsgContext)
{
   (tVoid)oParameterVector;
   (tVoid)MsgContext;
   tU32 _u32RetValue = diaglib::U32_DIAGLIB_RETURN_OK;

   dispvidctrl_tclControl_Rvc* poControlRVC = dynamic_cast<dispvidctrl_tclControl_Rvc*>(dispvidctrl_tclAppMain::theServer()->getHandler("dispvidctrl_tclControl_Rvc"));

   switch (u32IoControlId)
   {
   case IOCONTROLID_RVC_CONTROL_LINE:
   {
       if( diaglib::bCheckParameterSignature( oParameterVector,
               IOCONTROLID_RVC_CONTROL_LINE_SET_LEN,
               IOCONTROLID_RVC_CONTROL_LINE_SET_PARAM1) == FALSE)
       {
           _u32RetValue = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
       }
       else
       {
           tU8 u8Mode = oParameterVector[IOCONTROLID_RVC_CONTROL_LINE_SET_u8Mode].u8Value;

           if (poControlRVC)
           {
               poControlRVC->vHandleControl(EN_CONTROL_RVC__DIAG_IOCONTROL_CAMERA_VCC_STATE_CHANGED, (tU32) u8Mode);
           }

           if( enActionId == diaglib::EN_ACTION_SET)
           {
               ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:vOnIoControl: u32IoControlID=%u enActionId=%u", u32IoControlId, enActionId));
           }
           if( enActionId == diaglib::EN_ACTION_FREEZE)
           {
               ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:vOnIoControl: u32IoControlID=%u enActionId=%u", u32IoControlId, enActionId));
           }
           if( enActionId == diaglib::EN_ACTION_UNFREEZE)
           {
               ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:vOnIoControl: u32IoControlID=%u enActionId=%u", u32IoControlId, enActionId));
           }
       }
   }
   break;

   case IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1:
   {
       if( diaglib::bCheckParameterSignature( oParameterVector,
               IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1_SET_LEN,
               IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1_SET_PARAM1) == FALSE)
       {
           _u32RetValue = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
       }
       else
       {
           tBool bStatus = oParameterVector[ IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1_SET_bStatus].bValue;

           if (poControlRVC)
           {
               poControlRVC->vHandleControl(EN_CONTROL_RVC__DIAG_IOCONTROL_MICROPHONE_VCC_STATE_CHANGED, (tU32) bStatus);
           }

           if( enActionId == diaglib::EN_ACTION_SET)
           {
               ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:vOnIoControl: u32IoControlID=%u enActionId=%u", u32IoControlId, enActionId));
           }
           if( enActionId == diaglib::EN_ACTION_FREEZE)
           {
               ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:vOnIoControl: u32IoControlID=%u enActionId=%u", u32IoControlId, enActionId));
           }
           if( enActionId == diaglib::EN_ACTION_UNFREEZE)
           {
               ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:vOnIoControl: u32IoControlID=%u enActionId=%u", u32IoControlId, enActionId));
           }
       }
   }
   break;

   // NCG3D-13847: handle IO Control for Dimming
   case IOCONTROLID_KEYBOARD_DIMMING:
   {
       ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:vOnIoControl: IOCONTROLID_KEYBOARD_DIMMING enActionId=%u", enActionId));

       if (FALSE == diaglib::bCheckParameterSignature(oParameterVector, IOCONTROLID_KEYBOARD_DIMMING_SET_LEN, IOCONTROLID_KEYBOARD_DIMMING_SET_PARAM1))
       {
          _u32RetValue = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
       }
       else
       {
          tU16 _u16KeyboardDimmingPermille = oParameterVector[IOCONTROLID_KEYBOARD_DIMMING_SET_KeyboardDimmingPermille].u16Value;
          _u32RetValue = u32HandleIoControlSet_Dimming(u32IoControlId, _u16KeyboardDimmingPermille);
       }
   }
   break;

   case IOCONTROLID_KEYBOARD_PWM:
   {
       ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:vOnIoControl: IOCONTROLID_KEYBOARD_PWM enActionId=%u", enActionId));

       if (FALSE == diaglib::bCheckParameterSignature(oParameterVector, IOCONTROLID_KEYBOARD_PWM_SET_LEN, IOCONTROLID_KEYBOARD_PWM_SET_PARAM1))
       {
          _u32RetValue = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
       }
       else
       {
          tU16 _u16KeyboardDimmingPWMPermille = oParameterVector[IOCONTROLID_KEYBOARD_PWM_SET_KeyboardDimmingPWMPermille].u16Value;
          _u32RetValue = u32HandleIoControlSet_Dimming(u32IoControlId, _u16KeyboardDimmingPWMPermille);
       }
   }
   break;

   case IOCONTROLID_DISPLAY_DIMMING_U16:
   {
      ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:vOnIoControl: IOCONTROLID_DISPLAY_DIMMING_U16 enActionId=%u", enActionId));

      if (FALSE == diaglib::bCheckParameterSignature(oParameterVector, IOCONTROLID_DISPLAY_DIMMING_U16_SET_LEN, IOCONTROLID_DISPLAY_DIMMING_U16_SET_PARAM1))
      {
         _u32RetValue = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
      }
      else
      {
         tU16 _u16DisplayDimming = oParameterVector[IOCONTROLID_DISPLAY_DIMMING_U16_SET_DisplayDimming].u16Value;
         _u32RetValue = u32HandleIoControlSet_Dimming(u32IoControlId, _u16DisplayDimming);
      }
   }
   break;

   // NCG3D-72861: P-IVI: Touch_Controller_Reset_Command_Control, Incorrect response NRC 0x22
   case IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY:
   {
      ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:vOnIoControl: IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY enActionId=%u", enActionId));
      tU32 _u32ParamLen = IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY_SET_LEN;
      tU8 _u8LenParam1 = IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY_SET_PARAM1;
      tU8 _u8LenParam2 = IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY_SET_PARAM2;

      if (FALSE == diaglib::bCheckParameterSignature(oParameterVector, _u32ParamLen, _u8LenParam1, _u8LenParam2))
      {
          ETG_TRACE_ERR(("dispvidctrl_tclDiagIoControlListener:vOnIoControl: IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY enActionId=%u bCheckParameterSignature(len: %u, %u, %u) failed!",
        		  enActionId, _u32ParamLen, _u8LenParam1, _u8LenParam2 ));
         _u32RetValue = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
      }
      else
      {
    	  tU8 _u8ExternalDisplay = oParameterVector[IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY_SET_ExternalDisplay].u8Value;
    	  tU8 _u8ControlState = oParameterVector[IOCONTROLID_RESET_TOUCHCONTROLLER_EXT_DISPLAY_SET_ControlState].u8Value;
         _u32RetValue = u32HandleIoControlSet_TouchControllerReset(u32IoControlId, _u8ExternalDisplay, _u8ControlState);
      }
   }
   break;

   // unhandled io control id
   default:
   {
       NORMAL_M_ASSERT_ALWAYS();
       ETG_TRACE_ERR(("dispvidctrl_tclDiagIoControlListener:vOnIoControl: u32IoControlID=%u enActionId=%u", u32IoControlId, enActionId));
       vSendResult(_MsgContext, diaglib::EN_ACTION_SET, diaglib::EN_ERROR_ID_NOT_SUPPORTED);
       _u32RetValue = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   }
   break;
   } // switch (u32IoControlId)

   if ( _u32RetValue == diaglib::U32_DIAGLIB_RETURN_OK )
   {
      vSendResult(MsgContext, diaglib::EN_ACTION_SET, diaglib::EN_ERROR_NO_ERROR);
   }

   return _u32RetValue;
}

tVoid dispvidctrl_tclDiagIoControlListener::vSendResult(diaglib::tContext MsgContext, diaglib::tenIoControlAction enAction, diaglib::tenInternalError enError) const
{
   diaglib::tenIoCtrlResult enIoControlResult = diaglib::EN_IO_CONTROL_NOT_OK;
   diaglib::tclParameterVector oResultList;
   if (enError == diaglib::EN_ERROR_NO_ERROR)
   {
      enIoControlResult = diaglib::EN_IO_CONTROL_OK;
   }
   else
   {
      diaglib::trParameter rParameter;
      rParameter.enType=diaglib::EN_PARAMETER_TYPE_U8ERROR;
      rParameter.u8ErrorValue=enError;
      oResultList.push_back(rParameter);
   }
   ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:vSendResult: OK=%d, enError=0x%04x",
   (enIoControlResult == diaglib::EN_IO_CONTROL_OK) ? 1 : 0, enError));
   // send result to diaglib
   if ( !m_poIoControlIF->bSendIoCtrlMethodResult( enIoControlResult, enAction, oResultList, MsgContext) )
   {
      ETG_TRACE_USR2(("dispvidctrl_tclDiagIoControlListener:vSendResult: could not bSendIoControlResult"));
   }
}

tU32 dispvidctrl_tclDiagIoControlListener::u32HandleIoControlFreeze_Dimming(tU32 u32IoControlId)
{
	tU32 _u32RetValue = diaglib::U32_DIAGLIB_RETURN_OK;
	dispvidctrl_tclAppMain* _poApp = dispvidctrl_tclAppMain::theServer();
    
    if (OSAL_NULL != _poApp)
    {
    	const tChar _strIfIncDimName[] = "I_dispvidctrl_tclClientDimming";
    	I_dispvidctrl_tclClientDimming* _poControlDim = dynamic_cast<I_dispvidctrl_tclClientDimming*>(_poApp->getHandler(_strIfIncDimName));
    
    	if ( OSAL_NULL != _poControlDim )
    	{
    	   const tChar _strIfDimSrvHdl[] = "Idispvidctrl_tclServiceDimmingIf";
    	   Idispvidctrl_tclServiceDimmingIf* _poSrvDimming = dynamic_cast<Idispvidctrl_tclServiceDimmingIf*>(_poApp->getHandler(_strIfDimSrvHdl));
    	   if ( (OSAL_NULL != _poSrvDimming) && (TRUE == _poSrvDimming->bSetDimDiagLibIoControl(TRUE)) )
    	   {
    		   tenDiagDimmingIoControl _enReqIoControl = EN_DIAG_DIM_IOCTRL_UNDEF;
    		   tU32 _u32Time = OSAL_ClockGetElapsedTime();
    		   switch ( u32IoControlId )
    		   {
    		   case IOCONTROLID_KEYBOARD_DIMMING:
    			   {
    				   /* Do freeze actions */
    				   _enReqIoControl = EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING;
    				   // reload dimming configuration to update keyboard calibration values
    				   I_dispvidctrl_tclConfigMgr* _poConfigMgr = dynamic_cast<I_dispvidctrl_tclConfigMgr*>(_poApp->getHandler("I_dispvidctrl_tclConfigMgr"));
    				   if (OSAL_NULL != _poConfigMgr)
    				   {
    					   _poConfigMgr->vOnLoadSettings();
    				   }
    			   }
    			   break;
    		   case IOCONTROLID_KEYBOARD_PWM:
    			   {
    				   /* Do freeze actions */
    				   _enReqIoControl = EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP;
    			   }
    			   break;
    		   case IOCONTROLID_DISPLAY_DIMMING_U16:
    			   {
    				  /* Do freeze actions */
    				   _enReqIoControl = EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING;
    				   // NCG3D-54916: backup contrast level and set to maximum
    				   I_dispvidctrl_tclDisplaySettings* _poDisplaySettings = dynamic_cast<I_dispvidctrl_tclDisplaySettings*>(_poApp->getHandler("I_dispvidctrl_tclDisplaySettings"));
    				   if ((OSAL_NULL != _poDisplaySettings) && (0 == m_arrDimIoControl[_enReqIoControl].u32Time))
    				   {
    					   // backup current contrast level
    					   m_u8LastContrastLevel = _poDisplaySettings->u8GetContrastLevel();
    					   // set contrast level to maximum
    					   _poDisplaySettings->s32SetContrastLevel(DISPVIDCTRL_C_U8_LEVEL_MAX);
    					   ETG_TRACE_USR2(("dispvidctrl_tclDiagIoControlListener:vOnIoControlFreeze: stored contrast level %u and set new contrast level %u",
    							   m_u8LastContrastLevel, _poDisplaySettings->u8GetContrastLevel() ));
    				   }
    				   else
    				   {
    					   ETG_TRACE_FATAL(("dispvidctrl_tclDiagIoControlListener:vOnIoControlFreeze: setting of contrast level to %u failed (0x%08x,%dms)",
    							   DISPVIDCTRL_C_U8_LEVEL_MAX, _poDisplaySettings, m_arrDimIoControl[_enReqIoControl].u32Time ));
    				   }
    			   }
    			  break;
    
    		   default:
    			   break;
    		   }
    		   if (DISPVIDCTRL_C_U16_ARRAYELEMENTS(m_arrDimIoControl) > (tU16)_enReqIoControl)
    		   {
    			   if (EN_DIAG_DIM_IOCTRL_MAX <= enGetLastActivatedDimmingIoControl())
    			   {
    				   // storing of all current brightness information before diagnosis session will be started
    				   dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus _oKeybBrightnessStatus;
    				   _poSrvDimming->vGetDIM_KEYB_BrightnessMsg(_oKeybBrightnessStatus);
    				   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING].u16Brigthness = _oKeybBrightnessStatus.Brightness.u16Value;
    				   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING].bInit = TRUE;
    				   ETG_TRACE_USR2(("dispvidctrl_tclDiagIoControlListener:vOnIoControlFreeze: stored brightness %u of io control %u",
    						   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING].u16Brigthness, IOCONTROLID_KEYBOARD_DIMMING ));
    				   // TODO: PWM is depending of activation state of illumination ... using current Keyboard brightness instead of PWM Keyboard brightness
    				   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP].u16Brigthness = _oKeybBrightnessStatus.Brightness.u16Value;
    				   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP].bInit = TRUE;
    				   ETG_TRACE_USR2(("dispvidctrl_tclDiagIoControlListener:vOnIoControlFreeze: stored brightness %u of io control %u",
    						   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP].u16Brigthness, IOCONTROLID_KEYBOARD_PWM ));
    				   dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus _oDispBrightnessStatus;
    				   _poSrvDimming->vGetDIM_DISP_BrightnessMsg(_oDispBrightnessStatus);
    				   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING].u16Brigthness = _oDispBrightnessStatus.Brightness.u16Value;
    				   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING].bInit = TRUE;
    				   ETG_TRACE_USR2(("dispvidctrl_tclDiagIoControlListener:vOnIoControlFreeze: stored brightness %u of io control %u",
    						   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING].u16Brigthness, IOCONTROLID_DISPLAY_DIMMING_U16 ));
    			   }
    			   _poControlDim->qsendDIAG_SESSION((::dimming_inc_fi::ESessionType)m_arrDimIoControl[_enReqIoControl].u8Session);
    			   m_arrDimIoControl[_enReqIoControl].u32Time = _u32Time;
    		   }
    		   if (EN_DIAG_DIM_IOCTRL_MAX <= enGetLastActivatedDimmingIoControl())
    		   {
    			   (tVoid)_poSrvDimming->bSetDimDiagLibIoControl(FALSE);
    			   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING].bInit = FALSE;
    			   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP].bInit = FALSE;
    			   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING].bInit = FALSE;
    		   }
    	   }
    	   else if ( OSAL_NULL == _poSrvDimming )
    	   {
    		   ETG_TRACE_FATAL(("dispvidctrl_tclDiagIoControlListener:vOnIoControlFreeze ... CCA service handler not exist and io control %u not freeze!", u32IoControlId ));
    	   }
    	   else
    	   {
    		   ETG_TRACE_FATAL(("dispvidctrl_tclDiagIoControlListener:vOnIoControlFreeze ... dimming io control blocked from CCA service handler!"));
    	   }
    	}
    	else
    	{
    	   ETG_TRACE_FATAL(("dispvidctrl_tclDiagIoControlListener:vOnIoControlFreeze ... INC Dimming Client doesn't exist!"));
    	}
    }

	return _u32RetValue;
}
tU32 dispvidctrl_tclDiagIoControlListener::u32HandleIoControlUnfreeze_Dimming(tU32 u32IoControlId)
{
    tU32 _u32RetValue = diaglib::U32_DIAGLIB_RETURN_OK;
    dispvidctrl_tclAppMain* _poApp = dispvidctrl_tclAppMain::theServer();

    if ( OSAL_NULL != _poApp )
    {
    	const tChar _strIfIncDimName[] = "I_dispvidctrl_tclClientDimming";
    	I_dispvidctrl_tclClientDimming* _poControlDim = dynamic_cast<I_dispvidctrl_tclClientDimming*>(_poApp->getHandler(_strIfIncDimName));
    
    	tenDiagDimmingIoControl _enDimIoControl = enGetLastActivatedDimmingIoControl();
    	if ( (OSAL_NULL != _poControlDim) && (EN_DIAG_DIM_IOCTRL_MAX > _enDimIoControl) )
    	{
    	   const tChar _strIfDimSrvHdl[] = "Idispvidctrl_tclServiceDimmingIf";
    	   Idispvidctrl_tclServiceDimmingIf* _poSrvDimming = dynamic_cast<Idispvidctrl_tclServiceDimmingIf*>(_poApp->getHandler(_strIfDimSrvHdl));
    
    	   if (OSAL_NULL != _poSrvDimming)
    	   {
    		   switch ( u32IoControlId )
    		   {
    		   case IOCONTROLID_KEYBOARD_DIMMING:
    			   {
    				   /* Do unfreeze actions */
    				   if (0 < m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING].u32Time)
    				   {
    					   tBool _bResult = _poControlDim->qsendDIAG_SESSION((::dimming_inc_fi::ESessionType)m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING].u8Session);
    					   ETG_TRACE_USR2(("dispvidctrl_tclDiagIoControlListener:vOnIoControlUnfreeze: restore brightness %u of io control %u (activation: %u)",
    							   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING].u16Brigthness, u32IoControlId, _bResult ));
    					   _poControlDim->qsendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::eKEY_DeviceType, m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING].u16Brigthness);
    				   }
    				   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING].u32Time = 0;
    			   }
    			   break;
    		   case IOCONTROLID_KEYBOARD_PWM:
    			   {
    				   /* Do unfreeze actions */
    				   if (0 < m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP].u32Time)
    				   {
    					   tBool _bResult = _poControlDim->sendDIAG_SESSION((::dimming_inc_fi::ESessionType)m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP].u8Session);
    					   ETG_TRACE_USR2(("dispvidctrl_tclDiagIoControlListener:vOnIoControlUnfreeze: restore brightness %u of io control %u (activation: %u)",
    							   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP].u16Brigthness, u32IoControlId, _bResult ));
    					   _poControlDim->qsendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::eKEY_DeviceType, m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP].u16Brigthness);
    				   }
    				   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP].u32Time = 0;
    				   // reload dimming configuration to update keyboard calibration values
    				   I_dispvidctrl_tclConfigMgr* _poConfigMgr = dynamic_cast<I_dispvidctrl_tclConfigMgr*>(_poApp->getHandler("I_dispvidctrl_tclConfigMgr"));
    				   if (OSAL_NULL != _poConfigMgr)
    				   {
    					   _poConfigMgr->vOnLoadSettings();
    				   }
    			   }
    			   break;
    		   case IOCONTROLID_DISPLAY_DIMMING_U16:
    			   {
    				   /* Do unfreeze actions */
    				   if (0 < m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING].u32Time)
    				   {
    					   tBool _bResult = _poControlDim->qsendDIAG_SESSION((::dimming_inc_fi::ESessionType)m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING].u8Session);
    					   ETG_TRACE_USR2(("dispvidctrl_tclDiagIoControlListener:vOnIoControlUnfreeze: restore brightness %u of io control %u (activation: %u)",
    							   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING].u16Brigthness, u32IoControlId, _bResult ));
    					   _poControlDim->qsendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::eDISPLAY_DeviceType, m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING].u16Brigthness);
    				   }
    				   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING].u32Time = 0;
    				   // NCG3D-54916: restore contrast level
    				   I_dispvidctrl_tclDisplaySettings* _poDisplaySettings = dynamic_cast<I_dispvidctrl_tclDisplaySettings*>(_poApp->getHandler("I_dispvidctrl_tclDisplaySettings"));
    				   if (OSAL_NULL != _poDisplaySettings)
    				   {
    					   // restore contrast level
    					   ETG_TRACE_USR2(("dispvidctrl_tclDiagIoControlListener:vOnIoControlUnfreeze: restore contrast level to %u from %u ",
    							   m_u8LastContrastLevel, _poDisplaySettings->u8GetColorLevel() ));
    					   _poDisplaySettings->s32SetContrastLevel(m_u8LastContrastLevel);
    				   }
    				   else
    				   {
    					   ETG_TRACE_FATAL(("dispvidctrl_tclDiagIoControlListener:vOnIoControlUnfreeze: restore of contrast level %u failed (0x%08x) ",
    							   m_u8LastContrastLevel, _poDisplaySettings ));
    				   }
    			   }
    			   break;
    
    		   default:
    			   break;
    		   }
    		   _enDimIoControl = enGetLastActivatedDimmingIoControl();
    		   if (EN_DIAG_DIM_IOCTRL_MAX > _enDimIoControl)
    		   {
    			   _poControlDim->qsendDIAG_SESSION((::dimming_inc_fi::ESessionType)m_arrDimIoControl[_enDimIoControl].u8Session);
    		   }
    		   else
    		   {
    			   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING].bInit = FALSE;
    			   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP].bInit = FALSE;
    			   m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING].bInit = FALSE;
    			   _poControlDim->qsendDIAG_SESSION(::dimming_inc_fi::eOFF_SessionType);
    
    			   if ( FALSE == _poSrvDimming->bSetDimDiagLibIoControl(FALSE) )
    			   {
    				   ETG_TRACE_USR2(("dispvidctrl_tclDiagIoControlListener:vOnIoControlUnfreeze ... dimming diag io control deactivated / unblocked!"));
    			   }
    			   else
    			   {
    				   ETG_TRACE_FATAL(("dispvidctrl_tclDiagIoControlListener:vOnIoControlUnfreeze ... dimming io control blocked from CCA service handler!"));
    			   }
    		   }
    	   }
    	   else
    	   {
    		   ETG_TRACE_FATAL(("dispvidctrl_tclDiagIoControlListener:vOnIoControlUnfreeze ... CCA service handler not exist and io control %u not freeze!", u32IoControlId ));
    	   }
    	}
    	else
    	{
    	   ETG_TRACE_FATAL(("dispvidctrl_tclDiagIoControlListener:vOnIoControlUnfreeze ... INC Dimming Client doesn't exist!"));
    	}
    }

    return _u32RetValue;
}
tU32 dispvidctrl_tclDiagIoControlListener::u32HandleIoControlSet_Dimming(tU32 u32IoControlId, tU16 u16Brithness)
{
	tU32 _u32RetValue = diaglib::U32_DIAGLIB_RETURN_OK;
	const diaglib::tenIoControlAction _enActionID = diaglib::EN_ACTION_SET;
	dispvidctrl_tclAppMain* _poApp = dispvidctrl_tclAppMain::theServer();
	const tChar _strIfIncDimName[] = "I_dispvidctrl_tclClientDimming";
	I_dispvidctrl_tclClientDimming* _poControlDim = ((OSAL_NULL !=_poApp) ? dynamic_cast<I_dispvidctrl_tclClientDimming*>(_poApp->getHandler(_strIfIncDimName)) : OSAL_NULL);

	switch( u32IoControlId)
	{
	case IOCONTROLID_KEYBOARD_DIMMING:
	{
		ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:u32HandleIoControlSet_Dimming: IOCONTROLID_KEYBOARD_DIMMING enActionId=%u", _enActionID));
		if ( OSAL_NULL != _poControlDim )
		{
		  if ( 0 != m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING].u32Time )
		  {
			  m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING].u32Time = OSAL_ClockGetElapsedTime();
			  _poControlDim->qsendDIAG_SESSION((::dimming_inc_fi::ESessionType)m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDDIMMING].u8Session);
			  ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:u32HandleIoControlSet_Dimming: u16KeyboardDimmingPermille=%u", u16Brithness));
			  _poControlDim->qsendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::eKEY_DeviceType, u16Brithness);
		  }
		  else
		  {
			  ETG_TRACE_FATAL(("dispvidctrl_tclDiagIoControlListener:u32HandleIoControlSet_Dimming: u16KeyboardDimmingPermille=%u ... dimming io control unfreezed!", u16Brithness ));
			  _u32RetValue = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
		  }
		}
		else
		{
		  ETG_TRACE_FATAL(("dispvidctrl_tclDiagIoControlListener:u32HandleIoControlSet_Dimming: u16KeyboardDimmingPermille=%u ... INC Dimming Client doesn't exist!", u16Brithness));
		  _u32RetValue = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
		}
	}
	break;

	case IOCONTROLID_KEYBOARD_PWM:
	{
		ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:u32HandleIoControlSet_Dimming: IOCONTROLID_KEYBOARD_PWM enActionId=%u", _enActionID));
		if ( OSAL_NULL != _poControlDim )
		{
			if ( 0 != m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP].u32Time )
			{
				m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP].u32Time = OSAL_ClockGetElapsedTime();
				_poControlDim->qsendDIAG_SESSION((::dimming_inc_fi::ESessionType)m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_KEYBOARDSETUP].u8Session);
				ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:vOnIoControl: u16KeyboardDimmingPWMPermille=%u", u16Brithness));
				_poControlDim->qsendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::eKEY_DeviceType, u16Brithness);
			}
			else
			{
				ETG_TRACE_FATAL(("dispvidctrl_tclDiagIoControlListener:u32HandleIoControlSet_Dimming: u16KeyboardDimmingPWMPermille=%u ... dimming io control unfreezed!", u16Brithness ));
				_u32RetValue = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
			}
		}
		else
		{
		  ETG_TRACE_FATAL(("dispvidctrl_tclDiagIoControlListener:u32HandleIoControlSet_Dimming: u16KeyboardDimmingPWMPermille=%u ... INC Dimming Client doesn't exist!", u16Brithness));
		  _u32RetValue = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
		}
	}
	break;

	case IOCONTROLID_DISPLAY_DIMMING_U16:
	{
		ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:u32HandleIoControlSet_Dimming: IOCONTROLID_DISPLAY_DIMMING_U16 enActionId=%u", _enActionID));
		if ( OSAL_NULL != _poControlDim )
		{
			ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:u32HandleIoControlSet_Dimming: u16DisplayDimming=%u", u16Brithness));
			if ( 0 != m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING].u32Time )
			{
				m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING].u32Time = OSAL_ClockGetElapsedTime();
				_poControlDim->qsendDIAG_SESSION((::dimming_inc_fi::ESessionType)m_arrDimIoControl[EN_DIAG_DIM_IOCTRL_DIPLAYDIMMING].u8Session);
				ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:u32HandleIoControlSet_Dimming: u16DisplayDimming=%u", u16Brithness));
				_poControlDim->qsendDIAG_SET_BRIGHTNESS_VAL(::dimming_inc_fi::eDISPLAY_DeviceType, u16Brithness);
			}
			else
			{
				 ETG_TRACE_FATAL(("dispvidctrl_tclDiagIoControlListener:u32HandleIoControlSet_Dimming: u16DisplayDimming=%u ... dimming io control unfreezed!", u16Brithness ));
				 _u32RetValue = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
			}
		}
		else
		{
			ETG_TRACE_FATAL(("dispvidctrl_tclDiagIoControlListener:u32HandleIoControlSet_Dimming: u16DisplayDimming=%u ... INC Dimming Client doesn't exist!", u16Brithness));
			_u32RetValue = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
		}
	}
	break;

	default:
		break;
	}
	return _u32RetValue;
}

tenDiagDimmingIoControl dispvidctrl_tclDiagIoControlListener::enGetLastActivatedDimmingIoControl(tVoid) const
{
	ETG_TRACE_USR4(("dispvidctrl_tclDiagIoControlListener:enGetLastActivatedDimmingIoControl: entered"));

	tenDiagDimmingIoControl _enLastActivedIoControl = EN_DIAG_DIM_IOCTRL_UNDEF;
	tU32 _u32Time = 0;

	for (tU16 _u16Idx = 0; DISPVIDCTRL_C_U16_ARRAYELEMENTS(m_arrDimIoControl) > _u16Idx ; ++_u16Idx)
	{
		if ((0 < m_arrDimIoControl[_u16Idx].u32Time) && (m_arrDimIoControl[_u16Idx].u32Time > _u32Time))
		{
			_u32Time = m_arrDimIoControl[_u16Idx].u32Time;
			_enLastActivedIoControl = (tenDiagDimmingIoControl)_u16Idx;
		}
	}

	ETG_TRACE_USR3(("dispvidctrl_tclDiagIoControlListener:enGetLastActivatedDimmingIoControl: last activated dimming io control = %u at time = %d ms",
			ETG_CENUM(tenDiagDimmingIoControl, _enLastActivedIoControl), _u32Time ));

	return _enLastActivedIoControl;
}

// NCG3D-72861: P-IVI: Touch_Controller_Reset_Command_Control, Incorrect response NRC 0x22
tU32 dispvidctrl_tclDiagIoControlListener::u32HandleIoControlFreeze_TouchControllerReset(tU32 u32IoControlId)
{
	tU32 _u32RetValue = diaglib::U32_DIAGLIB_RETURN_OK;
	m_bTouchControllerReset_Freeze = TRUE;
	ETG_TRACE_USR4(("exit u32HandleIoControlFreeze_TouchControllerReset(ctrlid: 0x%08x) with %d",
			u32IoControlId, _u32RetValue ));
	return _u32RetValue;
}
tU32 dispvidctrl_tclDiagIoControlListener::u32HandleIoControlUnfreeze_TouchControllerReset(tU32 u32IoControlId)
{
	tU32 _u32RetValue = diaglib::U32_DIAGLIB_RETURN_OK;
	m_bTouchControllerReset_Freeze = FALSE;
	ETG_TRACE_USR4(("exit u32HandleIoControlUnfreeze_TouchControllerReset(ctrlid: 0x%08x) with %d",
			u32IoControlId, _u32RetValue ));
	return _u32RetValue;
}
tU32 dispvidctrl_tclDiagIoControlListener::u32HandleIoControlSet_TouchControllerReset(tU32 u32IoControlId, tU8 u8ExternalDisplay, tU8 u8ControlState)
{
	tU32 _u32RetValue = diaglib::U32_DIAGLIB_RETURN_OK;
	dispvidctrl_tclAppMain* _poApp = dispvidctrl_tclAppMain::theServer();
	if ( OSAL_NULL != _poApp)
	{
		const tChar _strIfIncDimName[] = "I_dispvidctrl_tclTouchDriverControl";
		I_dispvidctrl_tclTouchDriverControl* _poControlTouchDriver = dynamic_cast<I_dispvidctrl_tclTouchDriverControl*>(_poApp->getHandler(_strIfIncDimName));
		if (OSAL_NULL != _poControlTouchDriver)
		{
			tU8 _u8TouchDriverIdx = EARLY_CONFIG_TOUCHDRIVER_ALL;
			switch (u8ExternalDisplay)
			{
			case 0:
				{
					_u8TouchDriverIdx = EARLY_CONFIG_TOUCHDRIVER_FIRST;
				}
				break;
			case 1:
				{
					_u8TouchDriverIdx = EARLY_CONFIG_TOUCHDRIVER_SECOND;
				}
				break;
			default:
				{
					// touch driver of all displays
				}
			}
			tS32 _s32Result = _poControlTouchDriver->s32RestartDriver(_u8TouchDriverIdx);
			ETG_TRACE_FATAL(("u32HandleIoControlSet_TouchControllerReset ... restart of touch driver %u (%32s) of external display %u returns %d",
					_u8TouchDriverIdx, _poControlTouchDriver->cstrGetDriverName(_u8TouchDriverIdx), u8ExternalDisplay, _s32Result ));
		}
		else
		{
			ETG_TRACE_FATAL(("u32HandleIoControlSet_TouchControllerReset ... no touch driver control reference!"));
		}
	}
	else
	{
 	   ETG_TRACE_FATAL(("u32HandleIoControlSet_TouchControllerReset ... no application reference!"));
	}
	ETG_TRACE_USR4(("exit u32HandleIoControlSet_TouchControllerReset(ctrlid: 0x%08x, extdisplay: %u, ctrlstate: %u) with %d",
			u32IoControlId, u8ExternalDisplay, u8ControlState, _u32RetValue ));
	return _u32RetValue;
}

