/******************************************************************************/
/**
* \file    dispvidctrl_tclControl_HmiAvm3.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_CONTROL_HMIAVM3_H_
#define _DISPVIDCTRL_TCL_CONTROL_HMIAVM3_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_AppMain.h"


/*******************************************************************************
                        Defines
*******************************************************************************/
   // enumeration of user action events.
   enum tenControl_HmiAvm3
   {
      EN_CONTROL_HMIAVM3__NONE  = 0,
      EN_CONTROL_HMIAVM3__DISABLE,
      EN_CONTROL_HMIAVM3__ENABLE,
      //------------------------------------ direct event to FSM
      EN_CONTROL_HMIAVM3__FSM_HMI_INPUT_EVENT,
      //------------------------------------ loopback, state as information to other
      EN_CONTROL_HMIAVM3__VISUALISATION_OFF,
      EN_CONTROL_HMIAVM3__VISUALISATION_ON,
      EN_CONTROL_HMIAVM3__VISUALISATION_ON_CAMERA_DIAG,
      EN_CONTROL_HMIAVM3__VISUALISATION_ON_VIDEO_SETTINGS,
      EN_CONTROL_HMIAVM3__BLANKOFFREQ_BLACK_IN,
      EN_CONTROL_HMIAVM3__BLANKOFFREQ_BLACK_OUT,
      EN_CONTROL_HMIAVM3__BLANKLESS_CHG_REQ,
      EN_CONTROL_HMIAVM3__CONF_VIEW_SETUP,
//      EN_CONTROL_HMIAVM3__OFF_REASON_CLEAN_UP,
      //------------------------------------ via service
      EN_CONTROL_HMIAVM3__HMI_AVAILABLE,
      EN_CONTROL_HMIAVM3__SYSTEMSTATUS_CONFIRMATION,
      //------------------------------------ from Diag
      EN_CONTROL_HMIAVM3__DIAG_VIDEO_LAYER,
      //------------------------------------ for Video Settings (Brighness/Contrast/Colour)
      EN_CONTROL_HMIAVM3__SERVICE_REQUEST_VISUALISATION,
   };

   // FSM output events
   enum tenFsmOutEvent_HmiAvm3
   {
      FSM_HMIAVM3_OUT__NONE   = 0,
      FSM_HMIAVM3_OUT__FSM_HMIAVM3_INPUT_EVENT,
      //------------------------------------
      FSM_HMIAVM3_OUT__HMI_VISUALISATION_OFF,
      FSM_HMIAVM3_OUT__HMI_VISUALISATION_ON,
      FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_IN,
      FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_OUT,
      //------------------------------------
//      FSM_HMIAVM3_OUT__AVM_VIDEO_SIGNAL_FAILURE,
//      FSM_HMIAVM3_OUT__AVM_VIDEO_SIGNAL_RESTORED,
      //------------------------------------
      FSM_HMIAVM3_OUT__AVM_REQ_VIEW_SETUP,
      FSM_HMIAVM3_OUT__AVM_REQ_DIRECT_CAM_OFF,
      FSM_HMIAVM3_OUT__AVM_REQ_BLANKLESS_CHG,
      //------------------------------------
      FSM_HMIAVM3_OUT__VIDEO_SET_GAMMA_OFF,
      FSM_HMIAVM3_OUT__VIDEO_SET_GAMMA_ON,
      FSM_HMIAVM3_OUT__VIDEO_CAPTURING_STOP,
      FSM_HMIAVM3_OUT__VIDEO_CAPTURING_START,
      FSM_HMIAVM3_OUT__VIDEO_SET_VIDEO_CONTROLS,
      FSM_HMIAVM3_OUT__VIDEO_GRAPHICS_OFF,
      FSM_HMIAVM3_OUT__VIDEO_GRAPHICS_ON,
      FSM_HMIAVM3_OUT__VIDEO_SIGNAL_CHECK,
      //------------------------------------
      FSM_HMIAVM3_OUT__HMI_CONFIRM_VISUALISATION_BLACK_IN,
      FSM_HMIAVM3_OUT__HMI_CONFIRM_VISUALISATION_BLACK_OUT,
      //------------------------------------ for Video Settings (Brighness/Contrast/Colour)
      FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_IN_CAMERA_SETTINGS,
      FSM_HMIAVM3_OUT__HMI_VISUALISATION_ON_CAMERA_SETTINGS,
      FSM_HMIAVM3_OUT__HMI_VISUALISATION_BLACK_OUT_CAMERA_SETTINGS,
   };

   enum tenFsmControl_HmiAvm3_SuperState
   {
      DISPVIDCTRL_CONTROL_HMIAVM3__DISABLED = 0,
      DISPVIDCTRL_CONTROL_HMIAVM3__ENABLED
   };

   enum tenControl_HmiAvm3_VideoSignalCheck
   {
      EN_HMIAVM3_VID_TIMER__NONE = 0,
      EN_HMIAVM3_VID_TIMER__START,
      EN_HMIAVM3_VID_TIMER__STOP,
      EN_HMIAVM3_VID_TIMER__VIDEO_SIGNAL_FALSE,
      EN_HMIAVM3_VID_TIMER__VIDEO_SIGNAL_TRUE,
      EN_HMIAVM3_VID_TIMER__TIMEOUT
   };

   // from FI RVC System Status
   enum tenControl_HmiAvm3_Confirm_SystemStatus
   {
      EN_HMIAVM3_CONFIRM_SYSTEMSTATUS__INIT = 0,
      EN_HMIAVM3_CONFIRM_SYSTEMSTATUS__OFF = 1,
      EN_HMIAVM3_CONFIRM_SYSTEMSTATUS__AVM_BLACK_IN = 40,
      EN_HMIAVM3_CONFIRM_SYSTEMSTATUS__AVM_ON = 41,
      EN_HMIAVM3_CONFIRM_SYSTEMSTATUS__AVM_ON_CAMERA_SETTINGS = 42,
      EN_HMIAVM3_CONFIRM_SYSTEMSTATUS__AVM__BLACK_OUT = 43,
      EN_HMIAVM3_CONFIRM_SYSTEMSTATUS__BLACK_IN_CAM_SETTINGS = 50,
      EN_HMIAVM3_CONFIRM_SYSTEMSTATUS__BLACK_OUT_CAM_SETTINGS = 51,
   };

/*******************************************************************************
   Class
*******************************************************************************/
class dispvidctrl_tclFsm_HmiAvm3;
class I_dispvidctrl_tclMCanClientAvmFsm;
class I_dispvidctrl_tclMCanClientAvm;
class I_dispvidctrl_tclSyncHandler;

//class Idispvidctrl_tclClientDimmingIf;
class dispvidctrl_tclControl_Video;
class Idispvidctrl_tclServiceRvcIf;

class dispvidctrl_tclControl_HmiAvm3 : public dispvidctrl_tclBaseIf
{
   public:
      dispvidctrl_tclControl_HmiAvm3(dispvidctrl_tclAppMain* poMainAppl);
      dispvidctrl_tclControl_HmiAvm3(); // default constructor
      virtual ~dispvidctrl_tclControl_HmiAvm3();

      virtual const tChar* getName() const { return ""; };
      virtual const tChar* getIfName() const { return "dispvidctrl_tclControl_HmiAvm3"; };

      virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
      virtual tVoid vHandleTraceMessage(const tUChar* puchData);
      virtual tVoid vGetReferencesEarly();
      virtual tVoid vGetReferences();
      virtual tVoid vStartCommunicationEarly();
      virtual tVoid vStartCommunication();
      virtual tVoid vTraceInfo();
//      virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);

      tVoid vHandleControl(tenControl_HmiAvm3 enControl, tU32 u32Value = 0);
      tVoid vHandleFsmOutEvent_HmiAvm3(tenFsmOutEvent_HmiAvm3 enFsmHmiOutEvent, tU32 u32Value = 0);
      dispvidctrl_tclFsm_HmiAvm3* vGetPoFsm_Hmi() const { return m_poFsm_Hmi;};

   private:
      tVoid _vOnEvent_FsmControl_Hmi(tenControl_HmiAvm3 enControl, tU32 u32Value = 0);
      tVoid _vSend_SetStatusHmiMResult(tU32 u32Fsm_HmiState);
      tVoid _vSetSystemStatus(tenFsmOutEvent_HmiAvm3 enFsmHmiOutEvent);
      tVoid _vHandleHMIConfirmationStatus(const tU32 u32Value);

      dispvidctrl_tclFsm_HmiAvm3*       m_poFsm_Hmi;
      
      //Idispvidctrl_tclClientDimmingIf*  m_poClientDimmingIf;
      dispvidctrl_tclControl_Video*     m_poControl_Video;
      Idispvidctrl_tclServiceRvcIf*     m_poRvcServiceIf;
      
      I_dispvidctrl_tclMCanClientAvm*   m_poMcanClientAvm;
      I_dispvidctrl_tclMCanClientAvmFsm* m_poMcanClientAvmFsm;
      I_dispvidctrl_tclSyncHandler*     m_poSyncHandler;
            
      tenFsmControl_HmiAvm3_SuperState      m_enFsmControl_Hmi_SuperState;
      
      tBool                             m_bHmiAppVehicleReady;
};
#endif

