/******************************************************************************/
/**
* \file    dispvidctrl_tclControl_Hmi.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_CONTROL_HMI_H_
#define _DISPVIDCTRL_TCL_CONTROL_HMI_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_AppMain.h"


/*******************************************************************************
                        Defines
*******************************************************************************/
   // enumeration of user action events.
   enum tenControl_Hmi
   {
      EN_CONTROL_HMI__NONE  = 0,
      EN_CONTROL_HMI__DISABLE,
      EN_CONTROL_HMI__ENABLE,
      //------------------------------------ direct event to FSM
      EN_CONTROL_HMI__FSM_HMI_INPUT_EVENT,
      //------------------------------------ loopback, state as information to other
      EN_CONTROL_HMI__VISUALISATION_OFF,
      EN_CONTROL_HMI__VISUALISATION_ON,
      EN_CONTROL_HMI__VISUALISATION_ON_CAMERA_SETTINGS,
      EN_CONTROL_HMI__OFF_REASON_CLEAN_UP,
      //------------------------------------ via service
      EN_CONTROL_HMI__HMI_AVAILABLE,
      EN_CONTROL_HMI__TOGGLE_GUIDELINES,
      EN_CONTROL_HMI__DIAG_VIDEO_LAYER,
      EN_CONTROL_HMI__DIMMING,
      EN_CONTROL_HMI__VIDEO_SIGNAL_FALSE,
      EN_CONTROL_HMI__VIDEO_SIGNAL_TRUE,
      EN_CONTROL_HMI__VIDEO_SIGNAL_CHECK_TIMEOUT,
      EN_CONTROL_HMI__SYSTEMSTATUS_CONFIRMATION,
      EN_CONTROL_HMI__VIDEO_SIGNAL_FALSE_CONFIRMED, // After 3s of failure detection for Renault
      //------------------------------------------------------------------------
      EN_CONTROL_HMI__SEND_NEXT_TESTRESULT,                  // request via Diag-Log CCA Client
      //------------------------------------ Guideline Adjustment
      EN_CONTROL_HMI__GDL_ADJ_SCREEN,
      //------------------------------------ Reverse Gear States
      EN_CONTROL_HMI__REVERSE_ON,
      EN_CONTROL_HMI__REVERSE_OFF,
      //------------------------------------ request from CAN Rx
      EN_CONTROL_HMI__TAILGATE_STATUS,
      //------------------------------------ request from other state machine (i.e RVC)
      EN_CONTROL_HMI__VIDEO_FORCE_GRAPHICS_OFF,
      EN_CONTROL_HMI__VIDEO_FORCE_GRAPHICS_ON
      // EN_CONTROL_RVC__CAMERA_OFF                         // request from HMI state machine
      // EN_CONTROL_RVC__VERIFY_AFTER_VIEW_STATUS_STOPPED
   };

   // FSM output events
   enum tenFsmOutEvent_Hmi
   {
      FSM_HMI_OUT__NONE   = 0,
      FSM_HMI_OUT__FSM_HMI_INPUT_EVENT,
      //------------------------------------
      FSM_HMI_OUT__HMI_VISUALISATION_OFF,
      FSM_HMI_OUT__HMI_VISUALISATION_OFF_VIDEO_SIGNAL_FAILURE,
      FSM_HMI_OUT__HMI_VISUALISATION_OFF_SYSTEM_MALFUNCTION,
      FSM_HMI_OUT__HMI_VISUALISATION_ON,
      FSM_HMI_OUT__HMI_VISUALISATION_ON_CAMERA_SETTINGS,
      FSM_HMI_OUT__HMI_VISUALISATION_ON_GUIDELINE_ADJUSTMENT,
      FSM_HMI_OUT__HMI_VISUALISATION_BLACK_IN,
      FSM_HMI_OUT__HMI_VISUALISATION_BLACK_OUT,
      FSM_HMI_OUT__HMI_VISUALISATION_DIRECT_ON,
      FSM_HMI_OUT__HMI_VISUALISATION_DIRECT_BLACK_IN,
      FSM_HMI_OUT__HMI_VISUALISATION_DIRECT_BLACK_OUT,
      FSM_HMI_OUT__HMI_VISUALISATION_BLACK_IN_CAMERA_SETTINGS,
      FSM_HMI_OUT__HMI_VISUALISATION_BLACK_OUT_CAMERA_SETTINGS,
      //------------------------------------
      FSM_HMI_OUT__RVC_CAMERA_OFF,
      //------------------------------------
      FSM_HMI_OUT__AVM_VIDEO_SIGNAL_FAILURE,
      FSM_HMI_OUT__AVM_VIDEO_SIGNAL_RESTORED,
      //------------------------------------
      FSM_HMI_OUT__VIDEO_SET_GAMMA_OFF,
      FSM_HMI_OUT__VIDEO_SET_GAMMA_ON,
      FSM_HMI_OUT__VIDEO_CAPTURING_STOP,
      FSM_HMI_OUT__VIDEO_CAPTURING_START,
      FSM_HMI_OUT__VIDEO_CAPTURING_DIAG_START,
      FSM_HMI_OUT__VIDEO_CAPTURING_GDL_ADJ_START,
      FSM_HMI_OUT__VIDEO_SET_VIDEO_CONTROLS,
      FSM_HMI_OUT__VIDEO_GUIDELINE_WARNINGTEXT_TOGGLE,
      FSM_HMI_OUT__VIDEO_GRAPHICS_OFF,
      FSM_HMI_OUT__VIDEO_GRAPHICS_ON,
      FSM_HMI_OUT__VIDEO_SIGNAL_CHECK,
      //------------------------------------
      FSM_HMI_OUT__DIMMING_BACKLIGHT_CAMERA_MODE_OFF,
      FSM_HMI_OUT__DIMMING_BACKLIGHT_CAMERA_MODE_ON,
      //------------------------------------
      FSM_HMI_OUT__HMI_CONFIRM_VISUALISATION_BLACK_IN,
      FSM_HMI_OUT__HMI_CONFIRM_VISUALISATION_BLACK_OUT
   };

   enum tenFsmControl_Hmi_SuperState
   {
      DISPVIDCTRL_CONTROL_HMI__DISABLED = 0,
      DISPVIDCTRL_CONTROL_HMI__ENABLED
   };

   enum tenControl_VideoSignalCheck
   {
      EN_CONTROL_VID_TIMER__NONE = 0,
      EN_CONTROL_VID_TIMER__START,
      EN_CONTROL_VID_TIMER__STOP,
      EN_CONTROL_VID_TIMER__VIDEO_SIGNAL_FALSE,
      EN_CONTROL_VID_TIMER__VIDEO_SIGNAL_TRUE,
      EN_CONTROL_VID_TIMER__TIMEOUT
   };

   // from FI RVC System Status
   enum tenControl_Hmi_Confirm_SystemStatus
   {
      EN_HMI_CONFIRM_SYSTEMSTATUS__INIT = 0,
      EN_HMI_CONFIRM_SYSTEMSTATUS__OFF = 1,
      EN_HMI_CONFIRM_SYSTEMSTATUS__OFF_VIDEO_SIGNAL_FAILURE = 2,
      EN_HMI_CONFIRM_SYSTEMSTATUS__OFF_SYSTEM_MALFUNCTION = 3,
      EN_HMI_CONFIRM_SYSTEMSTATUS__RVC_BLACK_IN = 20,
      EN_HMI_CONFIRM_SYSTEMSTATUS__RVC_ON = 21,
      EN_HMI_CONFIRM_SYSTEMSTATUS__RVC_ON_CAMERA_SETTINGS = 22,
      EN_HMI_CONFIRM_SYSTEMSTATUS__RVC__BLACK_OUT = 23,
      EN_HMI_CONFIRM_SYSTEMSTATUS__RVC_ON_GUIDELINE_ADJUSTMENT = 24,
      EN_HMI_CONFIRM_SYSTEMSTATUS__RVC_VISUALISATION_ON_WITH_UPA = 25,
      EN_HMI_CONFIRM_SYSTEMSTATUS__RVC_VISUALISATION_ON_WITH_UPA_HFP = 26,
      EN_HMI_CONFIRM_SYSTEMSTATUS__AVM_BLACK_IN = 40,
      EN_HMI_CONFIRM_SYSTEMSTATUS__AVM_ON = 41,
      EN_HMI_CONFIRM_SYSTEMSTATUS__AVM_ON_CAMERA_SETTINGS = 42,
      EN_HMI_CONFIRM_SYSTEMSTATUS__AVM__BLACK_OUT = 43,
      EN_HMI_CONFIRM_SYSTEMSTATUS__AVM_VISUALISATION_ON_WITH_UPA = 45,
      EN_HMI_CONFIRM_SYSTEMSTATUS__AVM_VISUALISATION_ON_WITH_UPA_HFP = 46,
      EN_HMI_CONFIRM_SYSTEMSTATUS__BLACK_IN_CAM_SETTINGS = 50,
      EN_HMI_CONFIRM_SYSTEMSTATUS__BLACK_OUT_CAM_SETTINGS = 51,
      EN_HMI_CONFIRM_SYSTEMSTATUS__MVC_BLACK_IN = 60,
      EN_HMI_CONFIRM_SYSTEMSTATUS__MVC_ON = 61,
      EN_HMI_CONFIRM_SYSTEMSTATUS__MVC_ON_CAMERA_SETTINGS = 62,
      EN_HMI_CONFIRM_SYSTEMSTATUS__MVC__BLACK_OUT = 63
   };

/*******************************************************************************
   Class
*******************************************************************************/
class dispvidctrl_tclFsm_Hmi;
class Idispvidctrl_tclClientDimmingIf;
class dispvidctrl_tclControl_Avm;
class dispvidctrl_tclControl_Rvc;
class dispvidctrl_tclControl_Video;
class Idispvidctrl_tclClientDiaglogIf;
class dispvidctrl_tclControl_Mvc;
class Idispvidctrl_tclServiceRvcIf;
class dispvidctrl_tclControl;

class dispvidctrl_tclControl_Hmi : public dispvidctrl_tclBaseIf
{
   public:
      dispvidctrl_tclControl_Hmi(dispvidctrl_tclAppMain* poMainAppl);
      dispvidctrl_tclControl_Hmi(); // default constructor
      virtual ~dispvidctrl_tclControl_Hmi();

      virtual const tChar* getName() const { return ""; };
      virtual const tChar* getIfName() const { return "dispvidctrl_tclControl_Hmi"; };

      virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
      virtual tVoid vHandleTraceMessage(const tUChar* puchData);
      virtual tVoid vGetReferences();
      virtual tVoid vStartCommunication();
      virtual tVoid vTraceInfo();
      virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);

      tVoid vHandleControl(tenControl_Hmi enControl, tU32 u32Value = 0);
      tVoid vHandleFsmOutEvent_Hmi(tenFsmOutEvent_Hmi enFsmHmiOutEvent, tU32 u32Value = 0);
      dispvidctrl_tclFsm_Hmi* vGetPoFsm_Hmi() const { return m_poFsm_Hmi;};

   private:
      tVoid _vOnEvent_FsmControl_Hmi(tenControl_Hmi enControl, tU32 u32Value = 0);
      tVoid _vOnEvent_FsmVideoSignalCheck(tenControl_VideoSignalCheck enControl, tU32 u32Value = 0);
      tVoid _vSetVideoSignalStatus(tenControl_Hmi enControl, tU32 u32Value = 0);
      tVoid _vSend_SetStatusHmiMResult(tU32 u32Fsm_HmiState);
      tVoid _vSetSystemStatus(tenFsmOutEvent_Hmi enFsmHmiOutEvent);
      tVoid _vUpdateITCStatus(tU8 u8ITCStatus);
      tVoid _vHandleHMIConfirmationStatus(const tU32 u32Value);
      
      tVoid _vHandleRearTrunkStateChange(tVoid);
      
      tBool _bIsGraphicsDisplayOn(tVoid) const;

      //Idispvidctrl_tclClientDimmingIf*  m_poClientDimmingIf;
      dispvidctrl_tclControl*           m_poControl;
      dispvidctrl_tclControl_Avm*       m_poControl_Avm;
      dispvidctrl_tclControl_Rvc*       m_poControl_Rvc;
      dispvidctrl_tclControl_Mvc*       m_poControl_Mvc;
      dispvidctrl_tclControl_Video*     m_poControl_Video;
      Idispvidctrl_tclClientDiaglogIf*  m_poClientDiaglogIf;
      dispvidctrl_tclFsm_Hmi*           m_poFsm_Hmi;
      Idispvidctrl_tclServiceRvcIf*     m_poRvcServiceIf;

      tenFsmControl_Hmi_SuperState  m_enFsmControl_Hmi_SuperState;
      tBool m_bVideoSignalCheck;
      tBool m_bVideoSignalState;
      tU8   m_u8VideoSignalStateTestResult;

      static OSAL_tpfCallback _pfCallbackTimer_VideoSignalCheck(tVoid* pArg);
      tBool  _bSetTimer_VideoSignalCheck(OSAL_tMSecond msTimeout);
      OSAL_tTimerHandle  _hTimerHandle_VideoSignalCheck;

      tU8   m_u8RearTrunkBehaviour;
      tU8   m_u8VideoResizedType;
      
      tBool m_bAvmMode;
      tBool m_bRvcMode;
      tBool m_bMvcMode;
      tBool m_bFapConfigured;
      tBool m_bFapModeActive;
      tBool m_bDiagVideoLayer;
      tBool m_bHmiAppVehicleReady;
      tBool m_bGuidelineAdjustmentScreen;
};
#endif

