/******************************************************************************/
/**
* \file    dispvidctrl_tclControl.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : Michael Niemann
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_CONTROL_H_
#define _DISPVIDCTRL_TCL_CONTROL_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_AppMain.h"

/*******************************************************************************
                        Defines
*******************************************************************************/
   // enumeration of user action events.
   enum tenControl
   {
      EN_CONTROL__NONE  = 0,
      //------------------------------------------------------------------------
      EN_CONTROL__FSM_ONOFF_INPUT_EVENT,  // for direct events to FSM
      //------------------------------------------------------------------------
      EN_CONTROL__START,
      EN_CONTROL__APPLICATION_STATE_NOT_NORMAL,
      EN_CONTROL__APPLICATION_STATE_NORMAL,
      EN_CONTROL__HMI_AVAILABLE,
      EN_CONTROL__VIDEO_STATUS_RECEIVED,
      EN_CONTROL__CRITICAL_VOLTAGE_START,
      EN_CONTROL__CRITICAL_VOLTAGE_END,
      EN_CONTROL__RETRY_MECHANISM_TIMEOUT
      //------------------------------------------------------------------------
   };

   enum tenFsmOutEvent_OnOff
   {
      FSM_ONOFF_OUT__NONE = 0,
      FSM_ONOFF_OUT__FSM_ONOFF_INPUT_EVENT,
      FSM_ONOFF_OUT__ENABLE_CONTROLS,
      FSM_ONOFF_OUT__ENABLE_CONTROLS_INITIAL,
      FSM_ONOFF_OUT__ENABLE_CONTROLS_INITIAL_WITH_EARLY_VIDEO_STATUS,
      FSM_ONOFF_OUT__DISABLE_CONTROLS,
      FSM_ONOFF_OUT__HMI_AVAILABLE,
      FSM_ONOFF_OUT__EARLY_VIDEO_CONTROL_OFF
   };

   enum tenVideoStatus
   {
      EN_VIDEO_STATUS__NONE       = 0,
      EN_VIDEO_STATUS__OFF        = 1,
      EN_VIDEO_STATUS__ON         = 2,
      EN_VIDEO_STATUS__BLACK_IN   = 3,
      EN_VIDEO_STATUS__BLACK_OUT  = 4
   };

//32Bit Bitmask [31|30|...| 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 ]
//                              |   |   |  [x   x   x   x] <- Mask Video Capturing State
//                              |   |  [x] <----------------- Mask Initial Trigger
//                              |  [x] <--------------------- Mask Video Signal State
//                             [x] <------------------------- Mask for the value of the "Initialising Signal" 
//                                                                 which we have transmitted to AVM unit

#define DISPVIDCTRL_VIDEO__MASK_VIDEO_CAPTURING_STATUS 0x0000000F
#define DISPVIDCTRL_VIDEO__MASK_EARLY_ACTIV            0x00000010
#define DISPVIDCTRL_VIDEO__MASK_VIDEO_SIGNAL_STATUS    0x00000020
#define DISPVIDCTRL_VIDEO__MASK_AVM_INIT_FLAG_TX       0x00000040

class dispvidctrl_tclFsm_OnOff;
class dispvidctrl_tclControl_Avm;
class dispvidctrl_tclControl_Rvc;
class dispvidctrl_tclControl_Video;
class Idispvidctrl_tclServiceRvcIf;
class Idispvidctrl_tclClientSpmIf;
/*******************************************************************************
   Class
*******************************************************************************/
class dispvidctrl_tclControl : public dispvidctrl_tclBaseIf
{
   public:

      dispvidctrl_tclControl(const dispvidctrl_tclAppMain* poMainAppl);
      dispvidctrl_tclControl(); // default constructor
      virtual ~dispvidctrl_tclControl();

      virtual const tChar* getName() const { return ""; };
      virtual const tChar* getIfName() const { return "dispvidctrl_tclControl"; };

      virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
      virtual tVoid vHandleTraceMessage(const tUChar* puchData);
      virtual tVoid vGetReferences();
      virtual tVoid vStartCommunication();
      virtual tVoid vTraceInfo();
      virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);

      tVoid vHandleControl(tenControl enControl, tU32 u32Value = 0);
      tVoid vHandleFsmOutEvent_OnOff(tenFsmOutEvent_OnOff enFsmOutEvent_OnOff, tU32 u32Value = 0);

   private:
   
      // this is a generic timer needed for any sort of retry mechanism in the parkassist area 
      // (eg. i2c comm fail, elmos init fail, video source file open error .. etc.. )
      static OSAL_tpfCallback _pfCallbackTimer_RetryMechanism(tVoid* pArg);
      tBool _bSetTimer_RetryMechanism(OSAL_tMSecond msTimeout);
      OSAL_tTimerHandle  m_hTimerHandle_RetryMechanism;
      
      tVoid _vHandleRetryMechanismTimeout(const tBool bForceRetry);
   
      tVoid _vOnEvent_FsmControl(tenControl enControl, tU32 u32Value = 0);

      // references
      dispvidctrl_tclFsm_OnOff*      m_poFsm_OnOff;
      dispvidctrl_tclControl_Avm*    m_poControl_Avm;
      dispvidctrl_tclControl_Rvc*    m_poControl_Rvc;
      dispvidctrl_tclControl_Video*  m_poControl_Video;
      Idispvidctrl_tclServiceRvcIf*  m_poRvcServiceIf;
      Idispvidctrl_tclClientSpmIf*   m_poSpmClientIf;
      // configuration data
      tBool m_Config_bAvmMode;
      tBool m_Config_bRvcMode;
      tBool m_Config_bAvmType_Phase3;
      
      // Keeps the count of no of trials already executed 
      tU8 m_u8NoOfRetriesExecuted;
      
      // runtime states and data
      tU32  m_tU32VideoStatus;

};
#endif

