/******************************************************************************/
/**
* \file    dispvidctrl_tclAudioRouting.h
* \ingroup
*
* \brief
*
* \remark  Copyright : (c) 2015 Robert Bosch GmbH, Hildesheim
* \remark  Author    : deo2kor
* \remark  Scope     : AIVI
*
* \todo
*/
/******************************************************************************/
#ifndef _DISPVIDCTRL_TCL_AUDIO_ROUTING_H_
#define _DISPVIDCTRL_TCL_AUDIO_ROUTING_H_

#ifndef ARL_S_IMPORT_INTERFACE_GENERIC
#define ARL_S_IMPORT_INTERFACE_GENERIC
#include "audio_routing_lib.h"
#endif

#include "dispvidctrl_AppMain.h"

// might be useful for tracing purpose
typedef enum
{
  AUDIO_ALLOCATE = 0,
  AUDIO_DEALLOCATE,
  AUDIO_SOURCE_ACTIVITY,
  AUDIO_MUTE_STATE
} dispvidctrl_tenAudioRoutingRequestType;

typedef enum
{
  /* tbd: Audio Routing Source to be adapted once available */
  DISP_VIDEO_CTRL_TTS = ARL_SRC_IPA_TTS
} dispvidctrl_tenAudioSource;

typedef enum
{
  AUDIO_ALLOCATED = 0,
  AUDIO_DEALLOCATED
} dispvidctrl_tenAudioChannelState;

typedef enum
{
  AUDIO_EN_OFF = 0,
  AUDIO_EN_ON,
  AUDIO_EN_PAUSE,
  AUDIO_EN_UNKNOWN
} dispvidctrl_tenSrcActivityState;


class dispvidctrl_tclControl_Avm;
class Idispvidctrl_tclClientSds_ttsIf;
class I_dispvidctrl_tclAudioPlayer;
class dispvidctrl_tclAppMain;
/*******************************************************************************
   Class
*******************************************************************************/
class dispvidctrl_tclAudio_Routing : public arl_tclISource, public dispvidctrl_tclBaseIf
{
public:
   dispvidctrl_tclAudio_Routing(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclAudio_Routing();
   
   virtual const tChar* getName() const { return ""; };
   virtual const tChar* getIfName() const { return "dispvidctrl_tclAudio_Routing"; };

   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);

   /***************************************************************************
   * Overriding arl_tclISource methods. (AR_TRIGGER Interfaces)
   ***************************************************************************/
   virtual tBool bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute);
   virtual tBool bOnDeAllocate(arl_tenSource enSrcNum);
   virtual tBool bOnSrcActivity(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity);
   virtual tBool bOnMuteState(arl_tenSource enSrcNum, arl_tenMuteState enMuteState);
   
   tVoid vInformAudioPlaybackFinished(const arl_tenSource enAudioSource);

   tBool bRequestAudioRoute(arl_tenSource enAudioSource, arl_tenActivity enActivity);
   tBool bRequestAudioSourceAvailability(arl_tenSource enAudioSource);
   tBool bPrepareTts() const;
   tBool bAbortTts() const;
   
private:

   dispvidctrl_tclControl_Avm* m_poControlAvm;
   Idispvidctrl_tclClientSds_ttsIf* m_poSdsTTS;
   I_dispvidctrl_tclAudioPlayer* m_poAudioPlayer;
   
   tBool m_bTtsAvailable;
   tBool m_AvmIpaConfig;
   tBool m_AvmTypeFap;
   arl_tenSource m_IpaSourceName;
   arl_tenSource m_AvmFapSourceName;
   dispvidctrl_tenAudioChannelState m_AudioChannelState;
   dispvidctrl_tenSrcActivityState m_SrcActivityState;
};

#endif // _DISPVIDCTRL_TCL_AUDIO_ROUTING_H_
