// for own datatypes and defines used together with datapool

#define DISPVIDCTRL_DATA__AFFO_ITS_NOT_AVAILABLE  0
#define DISPVIDCTRL_DATA__AFFO_ITS_INITIALIZING   1
#define DISPVIDCTRL_DATA__AFFO_ITS_AVAILABLE      2

#define DISPVIDCTRL_DATA__AFFO_ITS_FEATURE_UNKNOWN 0
#define DISPVIDCTRL_DATA__AFFO_ITS_FEATURE_OFF     1
#define DISPVIDCTRL_DATA__AFFO_ITS_FEATURE_ON      2

#define DISPVIDCTRL_DATA__SIGNAL_OK        0
#define DISPVIDCTRL_DATA__SIGNAL_FAILURE   1

typedef struct
{
   tU8  u8AffordableIts;
   tU8  u8AffordableItsBsw;
   tU8  u8AffordableItsMod;
   tU8  u8AffordableItsLdw;
}  TAffordableIts;

typedef struct
{
   tU16 u16PwrSupplyID;
   tU8  u8Status;
   tU32 u32Current;
}  TRvc_Camera_PwrSupplyStatus;


#define DISPVIDCTRL_DATA__CAMERA_POWERSUPPLYSTATUS_UNKNOWN                   0
#define DISPVIDCTRL_DATA__CAMERA_POWERSUPPLYSTATUS_OK                        1
#define DISPVIDCTRL_DATA__CAMERA_POWERSUPPLYSTATUS_OPENLOAD                  2
#define DISPVIDCTRL_DATA__CAMERA_POWERSUPPLYSTATUS_SHORTCIRCUIT              3
#define DISPVIDCTRL_DATA__CAMERA_POWERSUPPLYSTATUS_DEACTIVATED               4
#define DISPVIDCTRL_DATA__CAMERA_POWERSUPPLYSTATUS_DEACTIVATED_LOWVOLTAGE    5
#define DISPVIDCTRL_DATA__CAMERA_POWERSUPPLYSTATUS_DEACTIVATED_HIGHVOLTAGE   6
#define DISPVIDCTRL_DATA__CAMERA_POWERSUPPLYSTATUS_NUMBEROFITEMS             7

//#############################################################################
// KDS coding defines from Allianz_IVI_DiagnosisServices_V1.4.pdf

// AllianceCameraSystemType 3 Bit
#define DISPVIDCTRL_AllianceCameraSystemType_None              0x00
#define DISPVIDCTRL_AllianceCameraSystemType_EntryAvm          0x01   // Entry AVM (ITS only with MOD (no LDW and BSW))
#define DISPVIDCTRL_AllianceCameraSystemType_RearCameraRenault 0x02
#define DISPVIDCTRL_AllianceCameraSystemType_RearCameraNissan  0x03
#define DISPVIDCTRL_AllianceCameraSystemType_EntryAvmRenault   0x04
#define DISPVIDCTRL_AllianceCameraSystemType_Mvc               0x05
#define DISPVIDCTRL_AllianceCameraSystemType_AvmPhase3         0x06
// AllianceCameraConnectionType 3 Bit
#define DISPVIDCTRL_AllianceCameraConnectionType_Without  0x00
#define DISPVIDCTRL_AllianceCameraConnectionType_CVBS     0x01
#define DISPVIDCTRL_AllianceCameraConnectionType_LVDS     0x02
#define DISPVIDCTRL_AllianceCameraConnectionType_Ethernet 0x03
// AllianceSonarMenuType
#define DISPVIDCTRL_AllianceSonarMenuType_None         0x00
#define DISPVIDCTRL_AllianceSonarMenuType_Gen3Menu     0x01
#define DISPVIDCTRL_AllianceSonarMenuType_Gen3GD1AMenu 0x02
#define DISPVIDCTRL_AllianceSonarMenuType_Gen5Menu     0x03
// AllianceSonarType
#define DISPVIDCTRL_AllianceSonarType_None              0x00
#define DISPVIDCTRL_AllianceSonarType_FrontAndRearSonar 0x01
#define DISPVIDCTRL_AllianceSonarType_RearSonar         0x02
// AllianceSonarAVMType
#define DISPVIDCTRL_AllianceSonarAVMType_AVM      0x00 // (AVM (integration into video-signal))
#define DISPVIDCTRL_AllianceSonarAVMType_Headunit 0x01 // (HeadUnit (drawing an overlay))
// AllianceSonarVehicleImageType
#define DISPVIDCTRL_AllianceSonarVehicleImageType_NoBodyShape 0x00
#define DISPVIDCTRL_AllianceSonarVehicleImageType_Sedan       0x01
#define DISPVIDCTRL_AllianceSonarVehicleImageType_SUV         0x02
#define DISPVIDCTRL_AllianceSonarVehicleImageType_Van         0x03
#define DISPVIDCTRL_AllianceSonarVehicleImageType_Coupe       0x04
#define DISPVIDCTRL_AllianceSonarVehicleImageType_42P         0x05
#define DISPVIDCTRL_AllianceSonarVehicleImageType_H_B         0x06
// AllianceSteeringPositionType
#define DISPVIDCTRL_AllianceSteeringPositionType_LHD 0x00
#define DISPVIDCTRL_AllianceSteeringPositionType_RHD 0x01
// AllianceVehicleBodyShapeType
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_Convertible            0x32
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_Sedan_2_Door           0x41
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_Sedan_4_Door           0x42
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_Sedan_4_Door_Wide      0x43
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_H_B_2_Door             0x45
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_H_B_4_Door             0x46
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_Coupe_2_Door           0x47
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_Coupe_T_bar            0x48
//#define DISPVIDCTRL_AllianceVehicleBodyShapeType_Wagon_4_Door_Wide      0x49 gibts zweimal? siehe 0x55
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_H_T_2_Door             0x4B
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_H_T_2_Door_HighRoof    0x4C
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_H_T_4_Door             0x4D
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_H_T_4_Door_Wide        0x4E
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_Wagon_2_Door           0x53
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_Waggon_4_Door_HighRoof 0x54
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_Waggon_4_Door_Wide     0x55
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_Van_2_Door             0x57
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_Van_4_Door             0x58
#define DISPVIDCTRL_AllianceVehicleBodyShapeType_Van_4_Door_HighRoof    0x59
// Alliance IPA HFP Type
#define DISPVIDCTRL_AllianceIPAHFP_Type_None                            0x00
#define DISPVIDCTRL_AllianceIPAHFP_Type_IPA                             0x01
#define DISPVIDCTRL_AllianceIPAHFP_Type_FAP                             0x02
#define DISPVIDCTRL_AllianceIPAHFP_Type_HFP_Renault                     0x03
// Alliance VCAN Diversity
#define DISPVIDCTRL_AllianceVCANSlot_Type_0                             0x00
#define DISPVIDCTRL_AllianceVCANSlot_Type_C1A                           0x01
#define DISPVIDCTRL_AllianceVCANSlot_Type_C1R                           0x02
#define DISPVIDCTRL_AllianceVCANSlot_Type_T4VS                          0x03
#define DISPVIDCTRL_AllianceVCANSlot_Type_G1                            0x04
#define DISPVIDCTRL_AllianceVCANSlot_Type_C1N                           0x05
#define DISPVIDCTRL_AllianceVCANSlot_Type_OLD_NISSAN                    0x06
// Alliance ADAS UPA Visual Type
#define DISPVIDCTRL_AllianceADAS_UPA_Visual_Not_Present                 0x00
#define DISPVIDCTRL_AllianceADAS_UPA_Visual_Rear                        0x01
#define DISPVIDCTRL_AllianceADAS_UPA_Visual_Rear_Front                  0x02
// Alliance Display Format Type
#define DISPVIDCTRL_AllianceDisplay_Format_Landscape                    0x00
#define DISPVIDCTRL_AllianceDisplay_Format_Portrait                     0x01
// Alliance Display Type
#define DISPVIDCTRL_AllianceDisplay_Type_Single                         0x00
#define DISPVIDCTRL_AllianceDisplay_Type_Dual                           0x01
#define DISPVIDCTRL_AllianceDisplay_Type_None                           0x02
// Alliance Opening Animation Type
#define DISPVIDCTRL_AllianceOpeningAnimation_Type_Renault               0x00
#define DISPVIDCTRL_AllianceOpeningAnimation_Type_Nissan                0x01
#define DISPVIDCTRL_AllianceOpeningAnimation_Type_Infiniti              0x02
#define DISPVIDCTRL_AllianceOpeningAnimation_Type_EV_Nissan             0x03
#define DISPVIDCTRL_AllianceOpeningAnimation_Type_RSM                   0x04
#define DISPVIDCTRL_AllianceOpeningAnimation_Type_GT_line               0x05
#define DISPVIDCTRL_AllianceOpeningAnimation_Type_Initiale              0x06
#define DISPVIDCTRL_AllianceOpeningAnimation_Type_RS                    0x07
//Alliance Display Aspect Ratio
#define DISPVIDCTRL_AllianceDisplayAspectRatio_Not_Configured           0x00
#define DISPVIDCTRL_AllianceDisplayAspectRatio_15_9                     0x01
#define DISPVIDCTRL_AllianceDisplayAspectRatio_17_9                     0x02
//Alliance Display Orientation
#define DISPVIDCTRL_AllianceDisplayOrientation_Landscape                0x00
#define DISPVIDCTRL_AllianceDisplayOrientation_Portrait                 0x01
//Alliance Transmission Type
#define DISPVIDCTRL_AllianceTransmissionType_unknown                    0x00
#define DISPVIDCTRL_AllianceTransmissionType_AT                         0x01
#define DISPVIDCTRL_AllianceTransmissionType_CVT                        0x02
#define DISPVIDCTRL_AllianceTransmissionType_MT                         0x03 // manual gear box
// Alliance Camera Rear Trunk Behaviour Type
#define DISPVIDCTRL_AllianceRearTrunkBehave_NoAction                   0x00
#define DISPVIDCTRL_AllianceRearTrunkBehave_SwitchOff                  0x01
#define DISPVIDCTRL_AllianceRearTrunkBehave_ShowWarningText            0x02
#define DISPVIDCTRL_AllianceRearTrunkBehave_SwitchOff_ShowWarning      0x03
#define DISPVIDCTRL_AllianceRearTrunkBehave_BlackScreen                0x04
#define DISPVIDCTRL_AllianceRearTrunkBehave_BlackScreen_ShowWarning    0x06
// Alliance Camera Image Mirror Type
#define DISPVIDCTRL_AllianceCameraImageMirror_None                     0x00
#define DISPVIDCTRL_AllianceCameraImageMirror_Vertical                 0x01
#define DISPVIDCTRL_AllianceCameraImageMirror_Horizontal               0x02
#define DISPVIDCTRL_AllianceCameraImageMirror_Vertical_plus_Horizontal 0x03
// Alliance Brand Type
#define DISPVIDCTRL_AllianceBrand_Renault                              0x00
#define DISPVIDCTRL_AllianceBrand_Nissan                               0x01
#define DISPVIDCTRL_AllianceBrand_Infiniti                             0x02
#define DISPVIDCTRL_AllianceBrand_EV_Nissan                            0x03
#define DISPVIDCTRL_AllianceBrand_Dacia                                0x04
#define DISPVIDCTRL_AllianceBrand_Daimler                              0x05
#define DISPVIDCTRL_AllianceBrand_Avtovaz                              0x06
#define DISPVIDCTRL_AllianceBrand_RSM                                  0x07
// Alliance Welcome Sequence Type
#define DISPVIDCTRL_AllianceWelcomeSequence_None                       0x00
#define DISPVIDCTRL_AllianceWelcomeSequence_WS_1                       0x01
#define DISPVIDCTRL_AllianceWelcomeSequence_WS_2                       0x02
#define DISPVIDCTRL_AllianceWelcomeSequence_WS_3                       0x03
#define DISPVIDCTRL_AllianceWelcomeSequence_WS_4                       0x04
#define DISPVIDCTRL_AllianceWelcomeSequence_WS_5                       0x05
#define DISPVIDCTRL_AllianceWelcomeSequence_WS_6                       0x06
#define DISPVIDCTRL_AllianceWelcomeSequence_WS_7                       0x07
#define DISPVIDCTRL_AllianceWelcomeSequence_WS_8                       0x08
//#############################################################################

// KDS VehicleInformation - Steering Position values
#define RVC_STEERING_POSITION_LEFT  0x00 //LHD
#define RVC_STEERING_POSITION_RIGHT 0x01 //RHD

// following Language defines must have same values as in FI type T_e8_RVC_Language
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_ENGLISH_US                        0
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_FRENCH_CAN                        1
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_SPANISH_LATIN_AMERICAN            2
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_ENGLISH_UK                        3
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_GERMAN                            4
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_FRENCH_EUR                        5
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_ITALIAN                           6
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_DUTCH                             7
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_SPANISH_EUR                       8
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_PORTUGUESE                        9
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_RUSSIAN                          10
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_TURKISH                          11
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_DANISH                           12
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_SWEDISH                          13
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_FINNISH                          14
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_NORWEGIAN                        15
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_GREEK                            16
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_POLISH                           17
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_CZECH                            18
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_SLOVAK                           19
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_HUNGARIAN                        20
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_ARABIC                           21
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_THAI                             22
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_AUSTRALIAN                       23
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_BRAZILIAN                        24
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_UKRAINIAN                        25
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_KOREAN                           26
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_CHINESE_SIMPLIFIED               27
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_CHINESE_TRADITIONAL_CANTONESE    28
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_CHINESE_TRADITIONAL_TAIWANESE    29
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_INDONESIAN                       30
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_ROMANIAN                         31
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_ALBANESE                         32
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_BULGARIAN                        33
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_CROATIAN                         34
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_ESTONIAN                         35
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_FLEMISH                          36
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_HEBREW                           37
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_HINDI                            38
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_JAPANESE                         39
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_LATVIAN                          40
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_LITHUANIAN                       41
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_MALAY                            42
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_PERSIAN_FARSI_IRANIAN            43
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_PHILIPPINES                      44
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_SERBIAN                          45
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_SLOVENIAN                        46
#define DISPVIDCTRL_DATA__HMI_LANGUAGE_VIETNAMESE                       47

#define DISPVIDCTRL_DATA__AVM_BEEP_OFF          0
#define DISPVIDCTRL_DATA__AVM_OPERATION_BEEP_ON 1
#define DISPVIDCTRL_DATA__AVM_ERROR_BEEP_ON     2
#define DISPVIDCTRL_DATA__AVM_BEEP_ON           3

#define DISPVIDCTRL_DATA__RFLS_INIT     0
#define DISPVIDCTRL_DATA__RFLS_OFF      1
#define DISPVIDCTRL_DATA__RFLS_ON       2
#define DISPVIDCTRL_DATA__RFLS_FAILURE  255


typedef struct
{
   tU32  u32ViewStatus;
   tU32  u32ViewHandle;
}  THmiLayerSync_ViewStatus;

#define DISPVIDCTRL_DATA__HMI_LAYER_SYNC__VIEW_STATUS_INVALID          0
#define DISPVIDCTRL_DATA__HMI_LAYER_SYNC__VIEW_STATUS_ACTIVE           1
#define DISPVIDCTRL_DATA__HMI_LAYER_SYNC__VIEW_STATUS_STOPPED          2
#define DISPVIDCTRL_DATA__HMI_LAYER_SYNC__VIEW_STATUS_ABOUT_TO_CHANGE  3


// KDS HWConfigurationString - Display Type values
#define DISPVIDCTRL_DISPLAY_SIZE_UNDEFINED 0x00
#define DISPVIDCTRL_DISPLAY_SIZE_SMALL     0x01
#define DISPVIDCTRL_DISPLAY_SIZE_BIG       0x02
#define DISPVIDCTRL_DISPLAY_SIZE_5_8_INCH  0x03
#define DISPVIDCTRL_DISPLAY_SIZE_7_INCH    0x04
#define DISPVIDCTRL_DISPLAY_SIZE_8_INCH    0x05
#define DISPVIDCTRL_DISPLAY_SIZE_DEFAULT   DISPVIDCTRL_DISPLAY_SIZE_7_INCH


// enumeration of possible voltage levels.
enum tenVoltageLevel
{
   EN_LEVEL__LOW_CRITICAL = 0,
   EN_LEVEL__LOW,
   EN_LEVEL__NORMAL,
   EN_LEVEL__HIGH,
   EN_LEVEL__HIGH_CRITICAL
};

#define RVC_APPLICATION_STATE__OFF        0
#define RVC_APPLICATION_STATE__NORMAL     1
#define RVC_APPLICATION_STATE__PAUSE      2
#define RVC_APPLICATION_STATE__DIAGNOSIS  3

// enumeration of possible voltage levels.
enum tenVideoHwInitState
{
   EN_VIDEO_HW_INIT__NOT_RUNNING = 0,
   EN_VIDEO_HW_INIT__RUNNING,
   EN_VIDEO_HW_INIT__FINISHED_OK,
   EN_VIDEO_HW_INIT__FINISHED_FAILED
};

// --- AVM Renault specific defines
#define DISPVIDCTRL_DATA__AVM_R_VIEW_FRONT_BIRD                        0
#define DISPVIDCTRL_DATA__AVM_R_VIEW_FRONT_SIDE                        1
#define DISPVIDCTRL_DATA__AVM_R_VIEW__REAR_BIRD                        2
#define DISPVIDCTRL_DATA__AVM_R_VIEW__REAR_SIDE                        3
#define DISPVIDCTRL_DATA__AVM_R_VIEW__ONLY_REAR                        4
#define DISPVIDCTRL_DATA__AVM_R_VIEW_DEALERMODE                        5

#define DISPVIDCTRL_DATA__AVM_R_REQUEST_NO_REQUEST                     0
#define DISPVIDCTRL_DATA__AVM_R_REQUEST_BIRD_VIEW                      1
#define DISPVIDCTRL_DATA__AVM_R_REQUEST_SIDE_VIEW                      2
#define DISPVIDCTRL_DATA__AVM_R_REQUEST_OFF                            3

// --- Avm Nissan C1A specific define
#define DISPVIDCTRL_DATA__AVM_MOD_REQUEST_NO_REQUEST                     0
#define DISPVIDCTRL_DATA__AVM_MOD_REQUEST_ACTIVATE                       1
#define DISPVIDCTRL_DATA__AVM_MOD_REQUEST_DEACTIVATE                     2
#define DISPVIDCTRL_DATA__AVM_MOD_REQUEST_RESET                          3

// --- IPA specific defines

#define DISPVIDCTRL_DATA__IPA_NOT_AVAILABLE                            0
#define DISPVIDCTRL_DATA__IPA_INITIALISING                             1
#define DISPVIDCTRL_DATA__IPA_AVAILABLE                                2

#define DISPVIDCTRL_DATA__IPA_OPSTATUS_NORMAL                          0
#define DISPVIDCTRL_DATA__IPA_OPSTATUS_MALFUNCTION                     1

#define DISPVIDCTRL_DATA__IPA_MODE_NORMAL                              0
#define DISPVIDCTRL_DATA__IPA_MODE_IPA                                 1

#define DISPVIDCTRL_DATA__IPA_HMI_NOT_ACTIVATED                        0
#define DISPVIDCTRL_DATA__IPA_HMI_ACTIVATED                            1

#define DISPVIDCTRL_DATA__IPA_AUTOVIEW_OFF                             0
#define DISPVIDCTRL_DATA__IPA_AUTOVIEW_ON                              1

#define DISPVIDCTRL_DATA__IPA_REGION_JAPAN                             0
#define DISPVIDCTRL_DATA__IPA_REGION_CHINA                             1
#define DISPVIDCTRL_DATA__IPA_REGION_EUROPE                            2
#define DISPVIDCTRL_DATA__IPA_REGION_USA                               3
#define DISPVIDCTRL_DATA__IPA_REGION_INVALID                           4

#define DISPVIDCTRL_DATA__IPA_SWITCH_NOMASK                            0
#define DISPVIDCTRL_DATA__IPA_SWITCH_LOWSPEED                          1
#define DISPVIDCTRL_DATA__IPA_SWITCH_HIGHSPEED                         2
#define DISPVIDCTRL_DATA__IPA_SWITCH_SYSTEMNOTREADY                    3

// --- Video specific defines ---
// VideoPlayer Interface Parameter Values
//   Camera System Type

//   Warning Text visibility
#define DISPVIDCTRL_VIDEO__WARNINGTEXT_NOT_VISIBLE  0x00
#define DISPVIDCTRL_VIDEO__WARNINGTEXT_VISIBLE      0x01
// used flags for Guideline Calculation API
#define GUIDELINE_DRAW_NONE            0x00
#define GUIDELINE_DRAW_DYNAMIC         0x01
#define GUIDELINE_DRAW_STATIC_SIDE     0x02
#define GUIDELINE_DRAW_STATIC_CENT     0x04
#define GUIDELINE_FORCE_UPDATE         0x08

//Needs to be extended to handle other display resolutions also?

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1 // Renault

  #define DISPVIDCTRL_VIDEO__CAMERAWIDTH           (tU16)  720
  #define DISPVIDCTRL_VIDEO__CAMERAHEIGHT          (tU16)  480
  #define DISPVIDCTRL_VIDEO__CAMERAXOFFSET         (tU16)  0
  #define DISPVIDCTRL_VIDEO__CAMERAYOFFSET         (tU16)  0

#elif VARIANT_S_FTR_ENABLE_AIVI_NPIVI

  #define DISPVIDCTRL_VIDEO__CAMERAWIDTH           (tU16)  1280
  #define DISPVIDCTRL_VIDEO__CAMERAHEIGHT          (tU16)  720
  #define DISPVIDCTRL_VIDEO__CAMERAXOFFSET         (tU16)  0
  #define DISPVIDCTRL_VIDEO__CAMERAYOFFSET         (tU16)  0

#else // default

  #define DISPVIDCTRL_VIDEO__CAMERAWIDTH           (tU16)  800
  #define DISPVIDCTRL_VIDEO__CAMERAHEIGHT          (tU16)  480
  #define DISPVIDCTRL_VIDEO__CAMERAXOFFSET         (tU16)  0
  #define DISPVIDCTRL_VIDEO__CAMERAYOFFSET         (tU16)  0

#endif




#ifndef VARIANT_S_FTR_ENABLE_AIVI_NPIVI
  // Landscape + Display 1
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1WIDTH          (tU16)  800
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1HEIGHT         (tU16)  480
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1XOFFSET        (tU16)  0
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1YOFFSET        (tU16)  0
  // Landscape + Display 2
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY2WIDTH          (tU16)  0
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY2HEIGHT         (tU16)  0
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY2XOFFSET        (tU16)  0
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY2YOFFSET        (tU16)  0
  // Portrait + Display 1
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY1WIDTH           (tU16)  820
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY1HEIGHT          (tU16)  1024
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY1XOFFSET         (tU16)  0
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY1YOFFSET         (tU16)  0
  // Portrait + Display 2
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY2WIDTH           (tU16)  0
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY2HEIGHT          (tU16)  0
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY2XOFFSET         (tU16)  0
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY2YOFFSET         (tU16)  0
#else
  // Landscape + Display 1
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1WIDTH          (tU16)  1280
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1HEIGHT         (tU16)  768
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1XOFFSET        (tU16)  0
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY1YOFFSET        (tU16)  0
  // Landscape + Display 2
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY2WIDTH          (tU16)  1280
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY2HEIGHT         (tU16)  768
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY2XOFFSET        (tU16)  0
  #define DISPVIDCTRL_VIDEO__LANDSCAPE_DISPLAY2YOFFSET        (tU16)  0
  // Portrait + Display 1
  // Portrait for NPIVI is not currently defined
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY1WIDTH           (tU16)  0
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY1HEIGHT          (tU16)  0
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY1XOFFSET         (tU16)  0
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY1YOFFSET         (tU16)  0
  // Portrait + Display 2
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY2WIDTH           (tU16)  0
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY2HEIGHT          (tU16)  0
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY2XOFFSET         (tU16)  0
  #define DISPVIDCTRL_VIDEO__PORTRAIT_DISPLAY2YOFFSET         (tU16)  0
#endif //VARIANT_S_FTR_ENABLE_AIVI_NPIVI

//Region destination
#define DISPVIDCTRL_REGION_US                     (tU8)0
#define DISPVIDCTRL_REGION_CAN                    (tU8)1
#define DISPVIDCTRL_REGION_JPN                    (tU8)25
#define DISPVIDCTRL_REGION_OTHER                  (tU8)255

//some vehicle types which require special treatment
#define DISPVIDCTRL_VEHICLE_TYPE_H61L             (tU16)0x614C  // BCD(61)+ASCII('L')
#define DISPVIDCTRL_VEHICLE_TYPE_UNKNOWN          (tU16)0xFFFF