/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * @file               : dispvidctrl_Parser.h
 * @brief	       :  dispvidctrl_tclControl_Rvc
 * @detail             :
 * @author             : Sathiya
 * @Date               : 27.10.2021
 * Revision History    : 1.0
 */

#ifndef DISPVIDCTRL_PARSER_H_
#define DISPVIDCTRL_PARSER_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "dispvidctrl_AppMain.h"
#include "system_types.h"
#include "AVRoutingParser.h"

class DispvidctrlParser
{
private:
	static DispvidctrlParser* m_pInstance;
public:
	DispvidctrlParser();
       ~DispvidctrlParser();
	static DispvidctrlParser* pGetInstance();
	 DispvidctrlParser(const DispvidctrlParser&);           // Prevent copy-construction
	 DispvidctrlParser& operator=(const DispvidctrlParser&);      // Prevent assignment
	 tBool bParseXml();
	 tVecCamData m_caminfo;
	 tclAvRoutingParser* _avRoutingParser;
	 void readCameraConfig();
	  static void vDeleteInstance();
};
#endif
