/*
 * ThreadAdministration.cpp
 *
 *  Created on: 14.11.2013
 *      Author: mor2hi
 */

#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_ThreadHandler.h"

ThreadHandler::ThreadHandler()
: terminateObserverThread(FALSE)
, ObserverThread (0)
{
}

ThreadHandler::~ThreadHandler()
{
   terminateObserverThread = FALSE;
   ObserverThread = 0;
}

int ThreadHandler::createThread(pthread_t *Thread, void *(*pMessageReceiver)(void *), void* Data)
{
   return (pthread_create(Thread, NULL, pMessageReceiver, Data));
}

int ThreadHandler::createObserverThread(void *(*pMessageReceiver)(void *), void* Data=NULL)
{
   ObserverThread = 0;
   return (createThread(&ObserverThread, pMessageReceiver, Data));
}

int ThreadHandler::waitObserverThreadEnd()
{
   return( waitThreadEnd(ObserverThread) );
}

int ThreadHandler::detachObserverThread()
{
   return( detachThread(ObserverThread) );
}

int ThreadHandler::exitMainThread()
{
   ObserverThread = 0;
   pthread_exit((void *) pthread_self());
   return 0;
}

// Private Functions
int ThreadHandler::waitThreadEnd(pthread_t Thread)
{
   // wait for end of thread
   return (pthread_join(Thread, NULL));
}

int ThreadHandler::detachThread(pthread_t Thread)
{
   // wait for end of thread
   return (pthread_detach(Thread));
}
