/*
 * EpollInput.h
 *
 *  Created on: Mar 10, 2016
 *      Author: sgt4kor
 */

#ifndef _DISPVIDCTRL_TCLEPOLLINPUT_H_
#define _DISPVIDCTRL_TCLEPOLLINPUT_H_

#include <sys/epoll.h>
#include <linux/input.h>

struct epoll_event;

class EpollInput 
{
public:
   EpollInput();
   virtual ~EpollInput();
   static EpollInput* createInstance();
   static void deleteInstance();

   int waitForEvent(struct epoll_event* p_epoll_event_out, int timeout = -1,  int max_events = 1)
   {
      return ( epoll_wait (efiledesc, p_epoll_event_out, max_events, timeout) );
   }

   int addFileDescriptor(int FileDesc);
   int removeFileDescriptor(int FileDesc);
private:
   // Section to create and init epoll events, filedescriptor
   int efiledesc;
   static EpollInput* m_poEpollInput;
};

#endif // _DISPVIDCTRL_TCLEPOLLINPUT_H_
