/*
 * EpollInput.h
 *
 *  Created on: Mar 10, 2016
 *      Author: sgt4kor
 */


#include "dispvidctrl_AppMain.h" 
#include "dispvidctrl_EpollInput.h"

EpollInput* EpollInput::m_poEpollInput = NULL;

EpollInput::EpollInput()
{
   EpollInput::m_poEpollInput = this;
   efiledesc = epoll_create1(0);
}

EpollInput::~EpollInput()
{
   EpollInput::m_poEpollInput = NULL;
}

EpollInput* EpollInput::createInstance()
{
   if (EpollInput::m_poEpollInput == NULL) {
      EpollInput::m_poEpollInput = new EpollInput();
   }
   
   return m_poEpollInput;
}

void EpollInput::deleteInstance()
{
   if (EpollInput::m_poEpollInput != NULL) {
      delete EpollInput::m_poEpollInput;
      EpollInput::m_poEpollInput = NULL;
   }   
}
   
int EpollInput::addFileDescriptor(int FileDesc)
{
   int status = -1;
   struct epoll_event EpollEvent;
   memset(&EpollEvent, 0, sizeof(struct epoll_event));

   EpollEvent.data.fd = FileDesc; // assign filedescriptor of /dev/input to epollev
   EpollEvent.events = EPOLLIN;
   status = epoll_ctl (efiledesc, EPOLL_CTL_ADD, FileDesc, &EpollEvent);

   return status;
}

int EpollInput::removeFileDescriptor(int FileDesc)
{
   int status = -1;
   struct epoll_event EpollEvent;
   memset(&EpollEvent, 0, sizeof(struct epoll_event));

   EpollEvent.data.fd = FileDesc; //assign filedescriptor of /dev/input to epollev
   EpollEvent.events = EPOLLIN;
   status = epoll_ctl (efiledesc, EPOLL_CTL_DEL, FileDesc, &EpollEvent);

   return status;
}

