/************************************************************************
* FILE:         dispvidctrl_InputHandler.h
* PROJECT:
* SW-COMPONENT: DisplayVideoController
*----------------------------------------------------------------------
*
* DESCRIPTION: interface of Input event observer class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 24.02.2017| RBEI/ECV Deora     | init
*
*************************************************************************/
#ifndef dispvidctrl_InputHandler_H_
#define dispvidctrl_InputHandler_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#include "I_dispvidctrl_InputHandler.h"

typedef enum {
   EN_RELEASE = 0,
   EN_PRESS,
   EN_INVALID
} tenTouchStatus;

typedef enum {
   EN_TOUCH_GESTURE_NOT_TOUCH  = 0,
   EN_TOUCH_GESTURE_PRESS      = 1,
   EN_TOUCH_GESTURE_PINCH      = 2,
   EN_TOUCH_GESTURE_DRAG       = 3,
   EN_TOUCH_GESTURE_FLICK      = 4
} tenTouchGesture;

typedef struct {
   tU8 x_ordinate;
   tU8 y_ordinate;
   tenTouchStatus status;
} tsTouchInfoForCan;

typedef enum {
   EN_FAP_I2C_TOUCH_MSG_BYTE_COMMAND        = 0,
   EN_FAP_I2C_TOUCH_MSG_BYTE_TOUCHSTATE     = 1,
   EN_FAP_I2C_TOUCH_MSG_BYTE_HIX1           = 2, // 1st touch X Hi-Byte
   EN_FAP_I2C_TOUCH_MSG_BYTE_LOX1           = 3, // 1st touch X Lo-Byte
   EN_FAP_I2C_TOUCH_MSG_BYTE_HIY1           = 4, // 1st touch Y Hi-Byte
   EN_FAP_I2C_TOUCH_MSG_BYTE_LOY1           = 5, // 1st touch Y Lo-Byte
   EN_FAP_I2C_TOUCH_MSG_BYTE_HIX2           = 6, // 2nd touch X Hi-Byte
   EN_FAP_I2C_TOUCH_MSG_BYTE_LOX2           = 7, // 2nd touch X Lo-Byte
   EN_FAP_I2C_TOUCH_MSG_BYTE_HIY2           = 8, // 2nd touch Y Hi-Byte
   EN_FAP_I2C_TOUCH_MSG_BYTE_LOY2           = 9, // 2nd touch Y Lo-Byte
   EN_FAP_I2C_TOUCH_MSG_BYTE_FLICKSPEED     = 10,
   EN_FAP_I2C_TOUCH_MSG_BYTE_FLICKDIRECTION = 11,
   EN_FAP_I2C_TOUCH_MSG_BYTE_CHECKSUM       = 12,
   EN_FAP_I2C_TOUCH_MSG_NO_OF_BYTES
} tenFapTouchData;

class dispvidctrl_tclEventObserver;
class I_dispvidctrl_tclClientVcan;
/*******************************************************************************
   Class
*******************************************************************************/
class dispvidctrl_tclInputHandler : public I_dispvidctrl_tclInputHandler
{
public:

      dispvidctrl_tclInputHandler(dispvidctrl_tclAppMain* poMainAppl);
      virtual ~dispvidctrl_tclInputHandler();

      virtual const tChar* getName() const { return "dispvidctrl_tclInputHandler"; };

      virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
      virtual tVoid vHandleControl(tenControl_InputHandler enControl, tU32 u32Value = 0);
      virtual tVoid vHandleTraceMessage(const tUChar* puchData);
      virtual tVoid vGetReferences();
      virtual tVoid vStartCommunication();
      virtual tVoid vTraceInfo();

      virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);

      virtual tVoid vUpdateTouchInfo(const sTouchListElement* const poTouchData, const tU8 u8Slot) const;

private:

      static OSAL_tpfCallback _pfCallbackTimer_InputHandler(tVoid* pArg);
      static OSAL_tpfCallback _pfCallbackTimer_FapI2cMessageUpdate(tVoid* pArg);
      OSAL_tTimerHandle  m_hTimerHandle_InputHandler;
      OSAL_tTimerHandle  m_hTimerHandle_FapI2cMessageUpdate;
      tBool _bSetTimer_InputHandler(OSAL_tMSecond msTimeout);
      tBool _bSetTimer_FapI2cMessageUpdate(OSAL_tMSecond msTimeout);

      tVoid _vStartStopObserver(tVoid);
      tVoid _vResetFapTouchInfo(tVoid);
      tBool _bSendI2CMessage(tVoid);
      tBool _bSendCanMessage(tVoid);

      tBool m_bAvmTypeFap;
      tBool m_bFapModeActive;
      tBool m_bObserverRunning;
      tBool m_ObserverReady;

      // to convert the raw touch co-ordinates into a Bytes width data
      tFloat m_fHeightFactor;
      tFloat m_fWidthFactor;

      tU8               m_au8FapI2cTouchDataMsg[EN_FAP_I2C_TOUCH_MSG_NO_OF_BYTES];
      tsTouchInfoForCan m_sTouchInfoForCan;

      tenTouchGesture   m_enTouchGestureState;

      dispvidctrl_tclEventObserver*         m_poEventObserver;
      I_dispvidctrl_tclClientVcan*          m_poClientVcan;
      static dispvidctrl_tclInputHandler*   m_poMyStaticRef;
};


#endif // dispvidctrl_InputHandler_H_