/*
 * TouchDataHandler.h
 *
 *  Created on: Aug 26, 2015
 *      Author: sgt4kor
 */

#ifndef _dispvidctrl_TouchDataHandler_h_
#define _dispvidctrl_TouchDataHandler_h_

#include <linux/input.h>
#include <vector>
#include <pthread.h>

#include "dispvidctrl_AppMain.h"

#define TOUCH_LIST_MAX_SIZE 100

typedef struct
{
   tS64 s64EvTime;
   tU16 u16XCoord;
   tU16 u16YCoord;
   tU8 u8TouchStatus;
   tU8 u8SlotID;
} sTouchListElement;

typedef std::vector<sTouchListElement> Touchlist;

class I_dispvidctrl_tclInputHandler;

class dispvidctrl_tclTouchDataHandler : public dispvidctrl_tclBaseIf
{
public:
   Touchlist m_rawTouchlist;

   dispvidctrl_tclTouchDataHandler(dispvidctrl_tclAppMain* poMainAppl);
   virtual ~dispvidctrl_tclTouchDataHandler();
   
   virtual const tChar* getName() const { return "dispvidctrl_tclTouchDataHandler"; };
   virtual const tChar* getIfName() const { return "dispvidctrl_tclTouchDataHandler"; };
    
   virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
   virtual tVoid vStartCommunicationEarly();
   virtual tVoid vGetReferencesEarly();
   virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues);
   
   tVoid handleTouchEvData(struct input_event sEvent);
   Touchlist* getUpdatedTouchList(); // to get touch entires within 2 Secs
   inline tVoid lockTouchList()   { pthread_mutex_lock(&_MutexTouchList); }
   inline tVoid unlockTouchList() { pthread_mutex_unlock(&_MutexTouchList); }
   
   tVoid vTraceDebugInformation() const;

private:
   sTouchListElement _sTouchData;
   Touchlist _sTouchData1;
   Touchlist _sTouchData2;
   
   struct input_event _sEvent;
   
   pthread_mutex_t _MutexTouchList;

   tVoid storeTouchData(sTouchListElement& TouchData);
   tVoid addNewTouchEntry(sTouchListElement& TouchData);
   tBool changeTouchEntry(sTouchListElement& TouchData);
   tVoid delObsoleteTouchEntries();
   
   I_dispvidctrl_tclInputHandler* m_poInputHandler;

};

#endif /* _dispvidctrl_TouchDataHandler_h_ */
