/************************************************************************
* FILE:         I_dispvidctrl_tclInputHandler.h
* PROJECT:
* SW-COMPONENT: DisplayVideoController
*----------------------------------------------------------------------
*
* DESCRIPTION: interface of Input event observer class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 24.02.2017| RBEI/ECV Deora     | init
*
*************************************************************************/

#ifndef I_dispvidctrl_InputHandler_H_
#define I_dispvidctrl_InputHandler_H_

/*******************************************************************************
                        Includes
*******************************************************************************/
#include "dispvidctrl_AppMain.h"
#include "dispvidctrl_TouchDataHandler.h"

// Defines
   enum tenControl_InputHandler
   {
      EN_INPUT_HANDLER__NONE  = 0,
      //------------------------------------------------------------------------
      EN_INPUT_HANDLER__TIMEOUT_INPUT_HANDLER_TIMER,
      EN_INPUT_HANDLER__TIMEOUT_FAP_I2C_MESSAGE_UPDATE_TIMER,
      EN_INPUT_HANDLER__FAP_VISUALISATION_OFF,
      EN_INPUT_HANDLER__FAP_VISUALISATION_ON
      //------------------------------------------------------------------------
   };

// Forward Declarations


class I_dispvidctrl_tclInputHandler : public dispvidctrl_tclBaseIf
{
public:
    // constructor
    I_dispvidctrl_tclInputHandler(tVoid);
    I_dispvidctrl_tclInputHandler(const dispvidctrl_tclAppMain* poMainAppl) : dispvidctrl_tclBaseIf(poMainAppl) {;};
    // destructor
    virtual ~I_dispvidctrl_tclInputHandler() {;};

    virtual const tChar* getIfName() const { return "I_dispvidctrl_tclInputHandler"; };
    virtual tVoid vTraceInfo() = 0;
    
    virtual tVoid vUpdateTouchInfo(const sTouchListElement* const poTouchData, const tU8 u8Slot) const = 0;

    virtual tVoid vHandleControl(tenControl_InputHandler enControl, tU32 u32Value = 0) = 0;
};

#endif // I_dispvidctrl_InputHandler_H_
