/************************************************************************
* FILE:        dispvidctrl_tclSecondDisp.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: definition of Second Screen Handler.
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 06.03.2017| RBEI/ECV Sandeep Gupta | init
*
*************************************************************************/

#ifndef dispvidctrl_tclSecondDisp_H_
#define dispvidctrl_tclSecondDisp_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "I_dispvidctrl_tclSecondDispIf.h"
#include "I_dispvidctrl_ClientDiaglogIf.h"

//Forward Declarations
class I_dispvidctrl_tclClientDimming;
class Idispvidctrl_tclServiceDimmingIf;
class Idispvidctrl_tclClientDiaglogIf;


class dispvidctrl_tclSecondDisp : public I_dispvidctrl_tclSecondDispIf
{
private:
	I_dispvidctrl_tclClientDimming* _poDimmIncClientIf;
	Idispvidctrl_tclServiceDimmingIf* _poDImmCCASrvIf;
	Idispvidctrl_tclClientDiaglogIf*  m_poClientDiaglogIf;
public:
    // constructors and destructors
    //dispvidctrl_tclSecondDisp(tVoid);
    dispvidctrl_tclSecondDisp(const dispvidctrl_tclAppMain* poMainAppl);
	virtual ~dispvidctrl_tclSecondDisp();

	virtual const tChar* getName() const { return "dispvidctrl_tclSecondDisp"; };

	virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
	virtual tVoid vHandleTraceMessage(const tUChar* puchData);
	virtual tVoid vGetReferences();
	virtual tVoid vStartCommunication();
	virtual tVoid vTraceInfo();

	//Business Logic Interfaces to Send Incoming V850 updates to HMI
	virtual void update_HWVersionInfo(tU32 HWVersion);
    virtual void update_SWVersionInfo(tU32 SWVersion);
	virtual void update_DisplayParam(tU16 u16FunctionId, tU16 u16ParameterValue, tU8 u8ErrorCode);
	virtual void update_AllDisplayParam(tU8 u8BlackLevel, tU8 u8Brightness, tU8 u8Color, tU8 u8Contrast, tU8 u8Tint, tU16 u8GammaLevel);
	virtual void update_DisplayState(tU8 u8DisplayState, tU8 u8ErrorCode);
	virtual void update_SelfDiagResult(tU16 u16SelfDiagResult );

	//Interfaces to Request V850 via INC messages from CCA HMI client for dimming operations
	virtual void requestV850_HWVersionInfo();
	virtual void requestV850_SWVersionInfo();
	virtual void requestV850_setDisplayParam(tU16 u16FunctionId, tU16 u16ParameterValue);
	virtual void requestV850_AllDisplayParam();
	virtual void requestV850_setDisplayState(tU8 u8DisplayState);
	virtual void requestV850_SelfDiagResult();

	virtual tVoid sendITC_SelfDiagResult(tU16 u16SelfDiagResult);
};

#endif /* dispvidctrl_tclEarlyIf_H_ */
