/************************************************************************
* FILE:        I_dispvidctrl_tclSecondDispIf.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: interface of configuration manager class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 06.03.2017| RBEI/ECV3 Sandeep Gupta| init
*
*************************************************************************/

#ifndef I_dispvidctrl_tclSecondDispIf_H_
#define I_dispvidctrl_tclSecondDispIf_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "dispvidctrl_AppMain.h"

class I_dispvidctrl_tclSecondDispIf : public dispvidctrl_tclBaseIf
{
public:
	// constructor
        //I_dispvidctrl_tclSecondDispIf(tVoid);
        I_dispvidctrl_tclSecondDispIf(const dispvidctrl_tclAppMain* poMainAppl) : dispvidctrl_tclBaseIf(poMainAppl) {;};
   // destructor
        virtual ~I_dispvidctrl_tclSecondDispIf(){};
        virtual const tChar* getIfName() const { return "I_dispvidctrl_tclSecondDispIf"; };

   //Business Logic Interfaces to Send Incoming V850 updates to HMI
    	virtual void update_HWVersionInfo(tU32 HWVersion) = 0;
    	virtual void update_SWVersionInfo(tU32 SWVersion) = 0;
    	virtual void update_DisplayParam(tU16 u16FunctionId, tU16 u16ParameterValue, tU8 u8ErrorCode) = 0;
    	virtual void update_AllDisplayParam(tU8 u8BlackLevel, tU8 u8Brightness, tU8 u8Color, tU8 u8Contrast, tU8 u8Tint, tU16 u8GammaLevel) = 0;
    	virtual void update_DisplayState(tU8 u8DisplayState, tU8 u8ErrorCode) = 0;
    	virtual void update_SelfDiagResult(tU16 u16SelfDiagResult ) = 0;

   //Interfaces to Request V850 via INC messages from CCA HMI client for dimming operations
    	virtual void requestV850_HWVersionInfo() = 0;
    	virtual void requestV850_SWVersionInfo() = 0;
    	virtual void requestV850_setDisplayParam(tU16 u16FunctionId, tU16 u16ParameterValue) = 0;
    	virtual void requestV850_AllDisplayParam() = 0;
    	virtual void requestV850_setDisplayState(tU8 u8DisplayState) = 0;
    	virtual void requestV850_SelfDiagResult() = 0;

    	virtual void sendITC_SelfDiagResult(tU16 u16SelfDiagResult) = 0;
};

#endif /* I_dispvidctrl_tclSecondDispIf_H_ */
