/*
 * dispvidctrl_tclEarlyIf.cpp
 *
 *  Created on: Aug 24, 2015
 *      Author: kol2hi
 */
/************************************************************************
* FILE:        dispvidctrl_tclEarlyIf.cpp
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: implementation of configuration manager class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 20.08.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

/*******************************************************************************
| set own module id
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| includes: needed interfaces from external components
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| includes: internal and external interfaces from this component
|-----------------------------------------------------------------------------*/

#include "dispvidctrl_tclEarlyIf.h"
#include "dispvidctrl_AppMain.h"
#include "I_dispvidctrl_ClientDimmingIncAdaptor.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_tclEarlyIf.cpp.trc.h"
#endif

/*******************************************************************************
| defines and macros (scope: module-local)
|-----------------------------------------------------------------------------*/
#define DISPVIDCTRL_EVENT_VIDEO_WAIT  "ERALY_VIDEO_READY"
#define DISPVIDCTRL_EVENT_VIDEO_REQ   0x00000001

/*******************************************************************************
| typedefs (scope: module-local)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| variable definition (scope: global)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------------*/
dispvidctrl_tclEarlyIf* dispvidctrl_tclEarlyIf::_poMyStaticRef = NULL;

/*******************************************************************************
| function prototype (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function implementation (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
*
* FUNCTION:    dispvidctrl_tclEarlyIf()
*
* DESCRIPTION: constructor
*
* PARAMETER:   const dispvidctrl_tclAppMain*
*
* RETURNVALUE: none
*
*******************************************************************************/
dispvidctrl_tclEarlyIf::dispvidctrl_tclEarlyIf(const dispvidctrl_tclAppMain* poMainAppl)
: I_dispvidctrl_tclEarlyIf(poMainAppl)
{
   _poMyStaticRef = this;

   ETG_TRACE_USR4(("dispvidctrl_tclEarlyIf() entered."));

   _hEvVideoReady = OSAL_C_INVALID_HANDLE;
   if (OSAL_s32EventCreate(DISPVIDCTRL_EVENT_VIDEO_WAIT, &_hEvVideoReady) == OSAL_ERROR){
      //ETG_TRACE_USR1(("Creation of SPM shutdown event failed"));
       ETG_TRACE_FATAL( ( "dispvidctrl_tclEarlyIf::dispvidctrl_tclEarlyIf(): Failed to create event" ) );
   }

   //now start early part
   //vStartVdEarly();

   //and wait for video ready
   //vWaitForVideoReady(2000);
}

/*******************************************************************************
*
* FUNCTION:    ~dispvidctrl_tclEarlyIf()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
dispvidctrl_tclEarlyIf::~dispvidctrl_tclEarlyIf()
{
   ETG_TRACE_USR4(("~dispvidctrl_tclEarlyIf() entered."));

   if (OSAL_C_INVALID_HANDLE != _hEvVideoReady) {
      (tVoid) OSAL_s32EventClose(_hEvVideoReady);
      (tVoid) OSAL_s32EventDelete(DISPVIDCTRL_EVENT_VIDEO_WAIT);
      _hEvVideoReady = OSAL_C_INVALID_HANDLE;
   }
}

/*******************************************************************************
*
* FUNCTION:    vHandleMessage()
*
* DESCRIPTION: handle internal message
*
* PARAMETER:   dispvidctrl_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: none
*
*******************************************************************************/
tVoid dispvidctrl_tclEarlyIf::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
    pMsg = pMsg; // Not used
}

/*******************************************************************************
*
* FUNCTION: 	vHandleTraceMessage()
*
* DESCRIPTION: 	handler for trace command
*
* PARAMETER:   	const tUChar* puchData: reference of received message
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid dispvidctrl_tclEarlyIf::vHandleTraceMessage(const tUChar* puchData)
{
	ETG_TRACE_USR4(("vHandleTraceMessage() entered (data: 0x%08x).", puchData ));
}

/*******************************************************************************
*
* FUNCTION: 	vGetReferences(tVoid)
*
* DESCRIPTION: 	Function to get all reference needed by this class.
* 				A reference should always be the Interface class of the object
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid dispvidctrl_tclEarlyIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vGetReferences() entered."));
}

/*******************************************************************************
*
* FUNCTION: 	tVoid vStartCommunication()
*
* DESCRIPTION: 	Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid dispvidctrl_tclEarlyIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vStartCommunication() entered."));
}

/*******************************************************************************
*
* FUNCTION: 	vTraceInfo()
*
* DESCRIPTION: 	Trace information
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid dispvidctrl_tclEarlyIf::vTraceInfo()
{
	ETG_TRACE_USR4(("vTraceInfo() entered."));
}

tVoid dispvidctrl_tclEarlyIf::vStartVdEarly() {
   OSAL_trThreadAttribute rAttr;
   tC8                    szThreadName[] = "SpmVdEarly";

   rAttr.szName       = szThreadName;
   rAttr.s32StackSize = 2048;
   rAttr.u32Priority  = 100;
   rAttr.pfEntry      = (OSAL_tpfThreadEntry)dispvidctrl_tclEarlyIf::vVdEarlyThread;
   rAttr.pvArg        = ( tPVoid ) NULL;

   OSAL_tThreadID hThreadId = OSAL_ThreadSpawn(&rAttr);

   if ( hThreadId == OSAL_ERROR ){
       ETG_TRACE_ERR( ( "PROCBASEEARLY: vStartVdEarly(): Failed to spawn thread!" ) );
   }
}

tVoid dispvidctrl_tclEarlyIf::vVdEarlyThread(tVoid *pvArg) {
    // just call VD early function --> will never return
    //vEnterVDEarlyProc();
    pvArg = pvArg; //Not used
}

tVoid dispvidctrl_tclEarlyIf::vWaitForVideoReady(tU32 u32Timeout) {
   OSAL_tEventMask hEvRequest  = DISPVIDCTRL_EVENT_VIDEO_REQ;

   OSAL_s32EventWait(_hEvVideoReady, hEvRequest, OSAL_EN_EVENTMASK_OR, u32Timeout, &hEvRequest);
}

tVoid dispvidctrl_tclEarlyIf::vStartAnimationSequence(){
    //vStartAnimation();
}

tVoid dispvidctrl_tclEarlyIf::vStopAnimationSequence() {
}

tVoid dispvidctrl_tclEarlyIf::vVideoReady(){
    if (OSAL_s32EventPost(_poMyStaticRef->_hEvVideoReady, DISPVIDCTRL_EVENT_VIDEO_REQ, OSAL_EN_EVENTMASK_OR) == OSAL_OK){
        ETG_TRACE_FATAL( ( "dispvidctrl_tclEarlyIf::vVideoReady(): !!!!!! Error detected !!!!!!" ) );
    }
}

tVoid dispvidctrl_tclEarlyIf::vSwitchBacklight(tBool bActive) {
   I_dispvidctrl_tclClientDimmingIncAdaptor* _poDimInc = dynamic_cast<I_dispvidctrl_tclClientDimmingIncAdaptor*>(_poMyStaticRef->_cpoMain->getHandler("I_dispvidctrl_tclClientDimmingIncAdaptor"));
   if (_poDimInc != NULL) {
       _poDimInc->sendDISPLAY_READY(::dimming_inc_fi::eLCD_READY);
       if (bActive) {
           _poDimInc->sendDISPLAY_REQ(::dimming_inc_fi::eACTIVATE_DISPLAY);
       } else {
           _poDimInc->sendDISPLAY_REQ(::dimming_inc_fi::eDEACTIVATE_DISPLAY);
       }
   }
}