/************************************************************************
* FILE:        I_dispvidctrl_tclConfigMgr.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: interface of configuration manager class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 20.08.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef I_DISPVIDCTRL_TCLCONFIGMGR_H_
#define I_DISPVIDCTRL_TCLCONFIGMGR_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "dispvidctrl_AppMain.h"

namespace dispvidctrl_ConfigMgr {
	enum EBrightnessCalibrationMode
	{
		EBrightnessCalib_None = 0x00,
		EBrightnessCalib_DIAG = 0x01,
		EBrightnessCalib_USER = 0x02
	};
}


class I_dispvidctrl_tclConfigMgr : public dispvidctrl_tclBaseIf
{
public:
	// constructor
	I_dispvidctrl_tclConfigMgr(tVoid);
	I_dispvidctrl_tclConfigMgr(const dispvidctrl_tclAppMain* poMainAppl) : dispvidctrl_tclBaseIf(poMainAppl) {;};
   // destructor
   virtual ~I_dispvidctrl_tclConfigMgr(){};

   virtual const tChar* getIfName() const { return "I_dispvidctrl_tclConfigMgr"; };

   virtual tVoid vOnLoadSettings(tVoid) = 0;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   virtual tVoid vGetKeyIllumMatrixValues(tU16* u16Array, tU8 length) = 0;
   virtual tVoid vSetKeyIllumMatrixValues(tU16* u16Array, tU8 length) = 0;
   virtual tVoid vSetT4VSKeyIllumDataPool(tU16 u16Day_Day1, tU16 u16Day_night1, tU16 u16Night_Night1)=0;
   virtual tVoid vGetT4VSKeyIllumDataPool(tU16 (&u16Array)[3]) = 0;
   virtual tVoid vUpdateDimmINCBrightnessMatrix()=0;

   virtual tVoid vReset_DispRenaultDatapool() = 0;
#endif
};

#endif /* I_DISPVIDCTRL_TCLCONFIGMGR_H_ */
