/*
 * ThreadAdministration.cpp
 *
 *  Created on: 14.11.2013
 *      Author: mor2hi
 */

#include "dispvidctrl_LvdsThreadHandler.h"

#include "dispvidctrl_AppMain.h"

LvdsThreadHandler::LvdsThreadHandler()
: terminateObserverThread(FALSE)
, ObserverThread (0)
{
}

LvdsThreadHandler::~LvdsThreadHandler()
{
   terminateObserverThread = FALSE;
   ObserverThread = 0;
}

int LvdsThreadHandler::createThread(pthread_t *Thread, void *(*pMessageReceiver)(void *), void* Data)
{
   return (pthread_create(Thread, NULL, pMessageReceiver, Data));
}

int LvdsThreadHandler::createObserverThread(void *(*pMessageReceiver)(void *), void* Data=NULL)
{
   ObserverThread = 0;
   return (createThread(&ObserverThread, pMessageReceiver, Data));
}

int LvdsThreadHandler::waitObserverThreadEnd()
{
   return( waitThreadEnd(ObserverThread) );
}

int LvdsThreadHandler::detachObserverThread()
{
   return( detachThread(ObserverThread) );
}

int LvdsThreadHandler::exitMainThread()
{
   ObserverThread = 0;
   pthread_exit((void *) pthread_self());
   return 0;
}

// Private Functions
int LvdsThreadHandler::waitThreadEnd(pthread_t Thread)
{
   // wait for end of thread
   return (pthread_join(Thread, NULL));
}

int LvdsThreadHandler::detachThread(pthread_t Thread)
{
   // wait for end of thread
   return (pthread_detach(Thread));
}
