/*
 * dispvidctrl_tcldispvidctrl_LvdsObserver.cpp
 *
 *  Created on: Sep 5, 2017
 *      Author: mav4abt
 */


#include "dispvidctrl_LvdsObserver.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DISPVIDCTRL_APPLICATION
#include "trcGenProj/Header/dispvidctrl_LvdsObserver.cpp.trc.h"
#endif

tBool dispvidctrl_tclLvdsObserver::bIsObserverActive = FALSE;
tBool dispvidctrl_tclLvdsObserver::bIsTouchMonitorActive = FALSE;
dispvidctrl_tclLvdsObserver* dispvidctrl_tclLvdsObserver::m_poLvdsObserver = NULL;
std::vector<std::string> dispvidctrl_tclLvdsObserver::dispvidctrl_tclLvdsObserver::m_FileDescList;
std::vector<std::string> dispvidctrl_tclLvdsObserver::dispvidctrl_tclLvdsObserver::m_TouchCtrlList;

dispvidctrl_tclLvdsObserver::dispvidctrl_tclLvdsObserver(dispvidctrl_tclAppMain* poMainAppl)
: dispvidctrl_tclBaseIf(poMainAppl)
, _u8StartStopRecording(0)
, m_poLvdsMonitor(NULL)
{
   dispvidctrl_tclLvdsObserver::m_poLvdsObserver = this;
   dispvidctrl_tclLvdsObserver::m_FileDescList.clear();
   dispvidctrl_tclLvdsObserver::m_FileDescList.reserve(MAX_SCREEN_SIZE);
   dispvidctrl_tclLvdsObserver::m_TouchCtrlList.clear();
   dispvidctrl_tclLvdsObserver::m_TouchCtrlList.reserve(MAX_SCREEN_SIZE);

   
   ETG_TRACE_USR4(("dispvidctrl_tclLvdsObserver::dispvidctrl_tclLvdsObserver() Initialized"));
}

dispvidctrl_tclLvdsObserver::~dispvidctrl_tclLvdsObserver()
{
   removeFilesToMonitor();
   dispvidctrl_tclLvdsObserver::m_poLvdsObserver = NULL;
   dispvidctrl_tclLvdsObserver::bIsObserverActive = FALSE;
   dispvidctrl_tclLvdsObserver::bIsTouchMonitorActive = FALSE;
   _oLvdsThreadHandler.waitObserverThreadEnd();
   _oLvdsThreadHandler.exitMainThread();
}

/******************************************************************************/
/* FUNCTION     vGetReferences                                                */
/******************************************************************************/
/**
*  \brief       Function to get all reference needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclLvdsObserver::vGetReferences(tVoid)
{
    ETG_TRACE_USR4(("[%d ms] dispvidctrl_tclLvdsObserver::vGetReferences() entered.", OSAL_ClockGetElapsedTime()));
    m_poLvdsMonitor = dynamic_cast<dispvidctrl_tclLvdsMonitor*>(_cpoMain->getHandler("dispvidctrl_tclLvdsMonitor"));
    DISPVIDCTRL_NULL_POINTER_CHECK(m_poLvdsMonitor);
}

/******************************************************************************/
/* FUNCTION     vStartCommunication                                           */
/******************************************************************************/
/**
*  \brief       Function to start all dynamic objects e.g. threads, ...
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclLvdsObserver::vStartCommunication(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclLvdsObserver::vStartCommunication() entered.", OSAL_ClockGetElapsedTime()));
}

/******************************************************************************/
/* FUNCTION     vGetReferences                                                */
/******************************************************************************/
/**
*  \brief       Function to get all reference needed by this class.
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclLvdsObserver::vGetReferencesEarly(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclLvdsObserver::vGetReferencesEarly() entered.", OSAL_ClockGetElapsedTime()));
}

/******************************************************************************/
/* FUNCTION     vStartCommunication                                           */
/******************************************************************************/
/**
*  \brief       Function to start all dynamic objects e.g. threads, ...
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclLvdsObserver::vStartCommunicationEarly(tVoid)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclLvdsObserver::vStartCommunicationEarly() entered.", OSAL_ClockGetElapsedTime()));
}

/******************************************************************************/
/* FUNCTION     vHandleMessage(TMsg* pMsg)                                    */
/******************************************************************************/
/**
*  \brief       Handle worker events.
*
*  \param       message pointer
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclLvdsObserver::vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_FATAL(("[%d ms] dispvidctrl_tclLvdsObserver::vHandleMessage() entered %u -> data: %d.", \
                     OSAL_ClockGetElapsedTime(), ETG_CENUM(dispvidctrl_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));

   //Debug
   //   dispvidctrl_tclLvdsObserver::bIsObserverActive == TRUE;  // eis2hi: has no effect, and "DEBUG" comments suggest that is has in fact *not* been meant to be an assignment; but Coverity complains about it
   //Debug END
   switch (pMsg->eCmd)
   {
      default:
         break;
   }   
}

/******************************************************************************/
/* FUNCTION     vHandleTraceMessage                                           */
/******************************************************************************/
/**
*  \brief       handle TTFis commands
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclLvdsObserver::vHandleTraceMessage(const tUChar* puchData)
{
   DISPVIDCTRL_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   vTraceInfo();
}

/******************************************************************************/
/* FUNCTION     vTraceInfo()                                                  */
/******************************************************************************/
/**
*  \brief       trace information
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclLvdsObserver::vTraceInfo()
{
   ETG_TRACE_USR4(("dispvidctrl_tclLvdsObserver::vTraceInfo() entered."));
   ETG_TRACE_USR4(("dispvidctrl_tclLvdsObserver::bIsObserverActive.............. %d", dispvidctrl_tclLvdsObserver::bIsObserverActive));
}

/******************************************************************************/
/* FUNCTION     vGetConfiguration()                                           */
/******************************************************************************/
/**
*  \brief       trace information
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid dispvidctrl_tclLvdsObserver::vGetConfiguration(const TConfiguration* pStConfigurationValues)
{
   ETG_TRACE_USR4(("dispvidctrl_tclLvdsObserver::vGetConfiguration() entered."));
}

//*********************************************************************************************************************************
//    Public Methods
//*********************************************************************************************************************************

tS32 dispvidctrl_tclLvdsObserver::startObserver()
{
   int status = -1;

   if ( FALSE == dispvidctrl_tclLvdsObserver::bIsObserverActive )
   {
      dispvidctrl_tclLvdsObserver::bIsObserverActive = TRUE;

      if ( 0 == dispvidctrl_tclLvdsObserver::m_FileDescList.size())
      {
         ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::startObserver() list is empty!"));
         return status;
      }

      //Now Create Observer Thread to Monitor the Devices
      status = _oLvdsThreadHandler.createObserverThread(&(dispvidctrl_tclLvdsObserver::EvObserverCallback), NULL);
      if(status == -1)
      {
         ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::startObserver() createObserverThread FAILED"));
      }
      else
      {
         ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::startObserver() createObserverThread SUCCESS!.. Devices[%d]", dispvidctrl_tclLvdsObserver::m_FileDescList.size()));
         ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::startObserver() THREAD_ID = %d",_oLvdsThreadHandler.ObserverThread));
      }
   }
   else
   {
      ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::startObserver()->Already Started"));
      status = 0;
   }

   return status;
}

tS32 dispvidctrl_tclLvdsObserver::startMonitorThread()
{
   int status = -1;

   if ( FALSE == dispvidctrl_tclLvdsObserver::bIsTouchMonitorActive )
   {
	   dispvidctrl_tclLvdsObserver::bIsTouchMonitorActive = TRUE;

      if ( 0 == dispvidctrl_tclLvdsObserver::m_TouchCtrlList.size())
      {
         ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::startMonitorThread() list is empty!"));
         return status;
      }

      //Now Create Observer Thread to Monitor the Devices
      status = _oLvdsThreadHandler.createObserverThread(&(dispvidctrl_tclLvdsObserver::TouchControllerCallback), NULL);
      if(status == -1)
      {
         ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::startMonitorThread() createObserverThread FAILED"));
      }
      else
      {
         ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::startMonitorThread() createObserverThread SUCCESS!.. Devices[%d]", dispvidctrl_tclLvdsObserver::m_TouchCtrlList.size()));
         ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::startMonitorThread() THREAD_ID = %d",_oLvdsThreadHandler.ObserverThread));
      }
   }
   else
   {
      ETG_TRACE_USR4(("dispvidctrl_tclLvdsObserver::startMonitorThread()->Already Started"));
      status = 0;
   }

   return status;
}

tVoid dispvidctrl_tclLvdsObserver::stopObserver()
{
   if( TRUE == dispvidctrl_tclLvdsObserver::bIsObserverActive )
   {
      dispvidctrl_tclLvdsObserver::bIsObserverActive = FALSE;
      _oLvdsThreadHandler.waitObserverThreadEnd();
      removeFilesToMonitor();
      ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::stopObserver()->Observer Thread is Ended"));
   }
}

//**********************************************************************************************************************************
// EvObserver Thread Call Back Static Function
//**********************************************************************************************************************************

tVoid* dispvidctrl_tclLvdsObserver::EvObserverCallback(tVoid* pData)
{
  (tVoid) pData;
  if (m_poLvdsObserver)
  {
      while(dispvidctrl_tclLvdsObserver::bIsObserverActive == TRUE)
      {
          int iLength = 0;
          int iCurLength = 0;
          int iFileDescriptor;
          int iWatchDescriptorPrimary;
          int iWatchDescriptorSecondary;
          char cBuffer[BUFFER_MAX];

          iFileDescriptor = inotify_init();
          if ( iFileDescriptor == -1 ) {
             //Break in case file descriptor is not set correctly
          } else {

             std::vector<std::string>::iterator iter = dispvidctrl_tclLvdsObserver::m_FileDescList.begin();
             while (iter != dispvidctrl_tclLvdsObserver::m_FileDescList.end())
             {
            	 inotify_add_watch(iFileDescriptor, (*iter).c_str(), IN_MODIFY | IN_ACCESS );
                ++iter;
             }

             iLength = read(iFileDescriptor, cBuffer, BUFFER_MAX);
             if ( iLength == -1 ) {
                //Break? Read Failed
            	 ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::EvObserverCallback() Length = -1"));
             } else {

                while (iCurLength < iLength) {
                   struct inotify_event *event = ( struct inotify_event * ) &cBuffer[ iCurLength ];
                   if (event->len) {
                      if (event->mask & IN_ACCESS) {
                            m_poLvdsObserver->handleEvent();
                      }
                   }
                   iCurLength += EVENT_SIZE + event->len;
                }
                
             }  // else-branch of  if ( iLength < 0 )
          }  // else-branch of  if ( iFileDescriptor < 0 )
       }
   }
   return (tVoid*)(NULL); //to solve Lint warning
}

tVoid* dispvidctrl_tclLvdsObserver::TouchControllerCallback(tVoid* pData)
{
  (tVoid) pData;

  while(1)
  {
	  tBool bTouchResult[MAX_SCREEN_SIZE] = {FALSE};	//For Touch Controller Status
      int iCounter = 0;
      std::vector<std::string>::iterator iter = dispvidctrl_tclLvdsObserver::m_TouchCtrlList.begin();
	  while (iter != dispvidctrl_tclLvdsObserver::m_TouchCtrlList.end())
	     {
	         //Section for Touch Controller Status Read Start
		  	 if(m_poLvdsObserver && (m_poLvdsObserver->m_poLvdsMonitor->isRenaultLandscapeDetachedType() == TRUE))
		  	 {
				 std::string filepath = (*iter) + TOUCH_DEVICE_ACTV;
				 std::ifstream myFile(filepath.c_str());
				 if(myFile.is_open())
				 {
					 myFile.seekg(0);

					 tS32 touch_status = -1, period;
					 myFile >>touch_status >> period;
					 myFile.close();
					 ETG_TRACE_USR4(("dispvidctrl_tclLvdsObserver::TouchControllerCallback(): Touch_status=(%d) , Vector Size = (%d)",touch_status,m_TouchCtrlList.size()));

					if(touch_status == 1)
					{
						bTouchResult[iCounter] = TRUE;
					}
					else if(touch_status == 0)
					{
						bTouchResult[iCounter] = FALSE;
					}
				 }
				 else
				 {
					 ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::TouchControllerCallback->File path is invalid...Could not open file"));
					 if(m_poLvdsObserver)
							  m_poLvdsObserver->m_poLvdsMonitor->_vEvaluateAndUpdateControllerITCStatus();
				 }
		  	 }
		  	 else
		  	 {
		  		 std::string filepath = (*iter) + TOUCH_DEV_STAT;
				 std::ifstream myFile(filepath.c_str());
				 if(myFile.is_open())
				 {
					 myFile.seekg(0);

					 tS32 touch_status = -1, period;
					 myFile >>touch_status >> period;
					 myFile.close();
					 ETG_TRACE_USR4(("dispvidctrl_tclLvdsObserver::TouchControllerCallback(): Touch_status=(%d) , Vector Size = (%d)",touch_status,m_TouchCtrlList.size()));

					if(touch_status == 1)
					{
						bTouchResult[iCounter] = TRUE;

					}
					else if(touch_status == 0)
					{
						bTouchResult[iCounter] = FALSE;

					}
				 }
				 else
				 {
					 ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::TouchControllerCallback->File path is invalid...Could not open file"));
					 if(m_poLvdsObserver)
					 		  m_poLvdsObserver->m_poLvdsMonitor->_vEvaluateAndUpdateControllerITCStatus();
				 }
		  	 }
	         //Section for Touch Controller Status Read End
	         iCounter++;
	         ++iter;
	     }
	  if(m_poLvdsObserver)
		  m_poLvdsObserver->m_poLvdsMonitor->_vUpdateTouchValues(bTouchResult);
	  sleep(2);
  }
   return (tVoid*)(NULL); //to solve Lint warning
}

//*******************************************************************************************************************************
// Private Functions
//*******************************************************************************************************************************

tVoid dispvidctrl_tclLvdsObserver::addFileToMonitor(char cstrPathToDirectory[], tS32 type)
{
    ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::addFileToMonitor() entered"));
    if(type == 0)
    {
    	 dispvidctrl_tclLvdsObserver::m_FileDescList.push_back(cstrPathToDirectory);
		//Init values
		handleEvent();
    }
    else
    {
    	 dispvidctrl_tclLvdsObserver::m_TouchCtrlList.push_back(cstrPathToDirectory);
		//Init values
    	 //handleTouchCtrlEvent();
    }

}


tVoid dispvidctrl_tclLvdsObserver::handleEvent()
{
	ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::handleEvent(): entered!"));
    tBool bResult[MAX_SCREEN_SIZE] = {FALSE};
    int iCounter = 0;
    std::vector<std::string>::iterator iter = dispvidctrl_tclLvdsObserver::m_FileDescList.begin();
    while (iter != dispvidctrl_tclLvdsObserver::m_FileDescList.end())
    {
        std::string tmp = (*iter) + FPD_LINK;
        std::ifstream fCurrentFile(tmp.c_str());
        std::string strContent;
        while (std::getline(fCurrentFile, strContent))
        {
            if (0 == strcmp(strContent.c_str(), RIN_LOCKED)) {
                bResult[iCounter] = TRUE;
            }
        }
        iCounter++;
        ++iter;
    }
    if (m_poLvdsMonitor) {
    	ETG_TRACE_FATAL(("dispvidctrl_tclLvdsObserver::handleEvent(): Calling _vUpdateValues of LvdsMonitor."));
        m_poLvdsMonitor-> _vUpdateValues(bResult);
    }
}

tVoid dispvidctrl_tclLvdsObserver::removeFilesToMonitor()
{
    dispvidctrl_tclLvdsObserver::m_FileDescList.clear();
    dispvidctrl_tclLvdsObserver::m_TouchCtrlList.clear();
}
