/************************************************************************
* FILE:        dispvidctrl_tclTypes.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: common types
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 18.08.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef DISPVIDCTRL_TCLTYPES_H_
#define DISPVIDCTRL_TCLTYPES_H_

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

/*******************************************************************************
| general dimming defines
|-----------------------------------------------------------------------------*/
#define DISPVIDCTRL_C_U16_ARRAYELEMENTS(a)        (tU16)(sizeof(a)/sizeof(a[0]))

/*******************************************************************************
| dimming mode config defines
|-----------------------------------------------------------------------------*/
#define DISPVIDCTRL_U8_DIMMODECONFIG_INVALID                                    (0x00)
#define DISPVIDCTRL_U8_DIMMODECONFIG_DAY                                        (0x01)
#define DISPVIDCTRL_U8_DIMMODECONFIG_NIGHT                                      (0x02)
#define DISPVIDCTRL_U8_DIMMODECONFIG_AUTO                                       (0x03)

/*******************************************************************************
| dimming mode car defines
|-----------------------------------------------------------------------------*/
#define DISPVIDCTRL_U8_DIMMODECAR_INVALID                                       (0x00)
#define DISPVIDCTRL_U8_DIMMODECAR_DAY                                           (0x01)
#define DISPVIDCTRL_U8_DIMMODECAR_NIGHT                                         (0x02)

/*******************************************************************************
| dimming mode status defines
|-----------------------------------------------------------------------------*/
#define DISPVIDCTRL_U8_DIMMODESTATUS_INVALID                                    (0x00)
#define DISPVIDCTRL_U8_DIMMODESTATUS_DAY                                        (0x01)
#define DISPVIDCTRL_U8_DIMMODESTATUS_NIGHT                                      (0x02)
#define DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_DAY                                   (0x03)
#define DISPVIDCTRL_U8_DIMMODESTATUS_AUTO_NIGHT                                 (0x04)

/*******************************************************************************
| emulation mode defines
|-----------------------------------------------------------------------------*/
#define DISPVIDCTRL_C_U8_EMULATIONMODE_OFF                                      (0x00)
#define DISPVIDCTRL_C_U8_EMULATIONMODE_KEYBFREEZE                               (0x01)
#define DISPVIDCTRL_C_U8_EMULATIONMODE_DISPFREEZE                               (0x02)
#define DISPVIDCTRL_C_U8_EMULATIONMODE_SETUP                                    (0x03)
#define DISPVIDCTRL_C_U8_EMULATIONMODE_VERIFY                                   (0x04)

/*******************************************************************************
| level defines
|-----------------------------------------------------------------------------*/
#define DISPVIDCTRL_C_U8_LEVEL_MIN                                           (0)
#define DISPVIDCTRL_C_U8_LEVEL_MAX                                          (20)

/*******************************************************************************
| back light states
|-----------------------------------------------------------------------------*/
typedef enum {
	eBackLight_None             = 0x00000000,
	// requested back light state depending of SPM
	eBackLight_Spm_On			= 0x00000001,
	eBackLight_Spm_Off			= 0x00000002,
	eBackLight_Spm_Mask			= 0x0000000F,
	// requested back light sate depending of CVM
	eBackLight_Cvm_On			= 0x00000010,
	eBackLight_Cvm_Off			= 0x00000020,
	eBackLight_Cvm_Auto			= 0x00000030,
	eBackLight_Cvm_Mask			= 0x000000F0,
	// requested back light sate depending of HMI
	eBackLight_Hmi_On			= 0x00000100,
	eBackLight_Hmi_Off			= 0x00000200,
	eBackLight_Hmi_Auto			= 0x00000300,
	eBackLight_Hmi_Mask			= 0x00000F00,
	// requested back light sate depending of back light error detection
	eBackLight_BERR_On			= 0x00001000,
	eBackLight_BERR_Off			= 0x00002000,
	eBackLight_BERR_Auto		= 0x00003000,
	eBackLight_BERR_Mask		= 0x0000F000,
	// requested back light sate depending of Heatctrl
	eBackLight_HC_On			= 0x00010000,
	eBackLight_HC_Off			= 0x00020000,
	eBackLight_HC_Auto			= 0x00030000,
	eBackLight_HC_Mask			= 0x000F0000,
   // requested back light state depending of RearViewCamera-System
   eBackLight_RVC_On          = 0x00100000,
   eBackLight_RVC_Off         = 0x00200000,
   eBackLight_RVC_Auto        = 0x00300000,
   eBackLight_RVC_Mask        = 0x00F00000
} tenBackLightState;


typedef enum
{
	 eMeterMaster = 0x00,
	 eHeadUnitMaster = 0x01
}tenDimmingStrategy;


#endif /* DISPVIDCTRL_TCLTYPES_H_ */
