/************************************************************************
* FILE:        dispvidctrl_tclLvdsMonitor.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: interface class for touch driver control
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 04.07.2017| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef DIMMING_COMMON_DISPVIDCTRL_TCLLvdsMonitor_H_
#define DIMMING_COMMON_DISPVIDCTRL_TCLLvdsMonitor_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "I_dispvidctrl_tclLvdsMonitor.h"
#include "I_dispvidctrl_ClientDiaglogIf.h"

class dispvidctrl_tclLvdsObserver;
class Idispvidctrl_tclClientDiaglogIf;
/*******************************************************************************
| class definition
|-----------------------------------------------------------------------------*/
class dispvidctrl_tclLvdsMonitor : public I_dispvidctrl_tclLvdsMonitor
{
public:
    // constructors and destructors
	dispvidctrl_tclLvdsMonitor(tVoid);
	dispvidctrl_tclLvdsMonitor(const dispvidctrl_tclAppMain* poMainAppl);
	virtual ~dispvidctrl_tclLvdsMonitor();

	virtual const tChar* getName() const { return "dispvidctrl_tclLvdsMonitor"; };

	virtual tVoid vHandleMessage(dispvidctrl_tclBaseIf::TMsg* pMsg);
	virtual tVoid vHandleTraceMessage(const tUChar* puchData);
	virtual tVoid vGetReferences();
	virtual tVoid vStartCommunication();
	virtual tVoid vTraceInfo();
	virtual tVoid vStartStopObserver(tVoid);
    tVoid _vUpdateValues(tBool bResult[]);
    tVoid _vUpdateTouchValues(tBool bResult[]);
    tBool isRenaultLandscapeDetachedType();
    tVoid _vEvaluateAndUpdateControllerITCStatus();			//In case path is invalid call this
private:
	tVoid _vUpdateITCStatus(eDISPLAY_STATE displayType, tenITC_ID enITC_ID, tU8 itcResult);
	tVoid _vUpdateControllerITCStatus(eDISPLAY_STATE displayType, tenITC_ID enITC_ID, tU8 itcResult);
	tVoid _vEvaluateAndUpdateITCStatus();
	//tVoid _vEvaluateAndUpdateControllerITCStatus();
    tBool m_ObserverReady;
    tBool m_bObserverRunning;
    tBool bPrimaryScreen;
    tBool bSecondaryScreen;
    tBool bPrim_status;
    tBool bSec_status;
    static OSAL_tpfCallback _pfCallbackTimer_EventObserverInit(tVoid* pArg);
    OSAL_tTimerHandle  m_hTimerHandle_EventObserverInit;
    static dispvidctrl_tclLvdsObserver* m_poLvdsObserver;
	dispvidctrl_tclLvdsObserver* m_poEventObserver;
	eDEVICE_ID m_deviceId;
	tU8 m_dispState[eDISPLAY_MAX + 1];
	tU8 m_TouchControllerState[eDISPLAY_MAX + 1];
	tU8 OrientationType;
	tU8 DisplayOutputType;
	const Variant* m_variant;
	eDEVICE_ID _setDeviceId();
	tVoid _vRegisterFiles(eDEVICE_ID pDisplayId);
	tU8 getDisplayOrientationType();
	tU8 getDisplayOutputType();
    Idispvidctrl_tclClientDiaglogIf*  m_poClientDiaglogIf;

};

#endif /* DIMMING_COMMON_DISPVIDCTRL_TCLLvdsMonitor_H_ */
