/************************************************************************
* FILE:        I_dispvidctrl_tclTouchDriverControl.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: interface class for touch driver control
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 04.07.2017| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef DIMMING_COMMON_I_DISPVIDCTRL_TCLTOUCHDRIVERCONTROL_H_
#define DIMMING_COMMON_I_DISPVIDCTRL_TCLTOUCHDRIVERCONTROL_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "dispvidctrl_AppMain.h"
#ifndef DISPVIDCTRL_TCLTYPES_H_
#include "dispvidctrl_tclTypes.h"
#endif //#ifndef DISPVIDCTRL_TCLTYPES_H_

#define EARLY_CONFIG_TOUCHDRIVER_MAX_CMD_LENGHT                             2048
#define EARLY_CONFIG_TOUCHDRIVER_CMD_SYSTEMMODPROB              "/sbin/modprobe"
#define EARLY_CONFIG_TOUCHDRIVER_FIRST                                         1
#define EARLY_CONFIG_TOUCHDRIVER_SECOND                                        2
#define EARLY_CONFIG_TOUCHDRIVER_MAX       (EARLY_CONFIG_TOUCHDRIVER_SECOND + 1)
#define EARLY_CONFIG_TOUCHDRIVER_ALL                                         255
#define EARLY_CONFIG_TOUCHDRIVER_ACTION_STOP                                   1
#define EARLY_CONFIG_TOUCHDRIVER_ACTION_START                                  2
#define EARLY_CONFIG_TOUCHDRIVER_ACTION_RESTART                                3
#define EARLY_CONFIG_TOUCHDRIVER_ACTION_STATUS                               255

typedef enum {
	enTOUCH_DRV_UNDEF = 0,
	enTOUCH_DRV_STOPPED,
	enTOUCH_DRV_STARTED,
	enTOUCH_DRV_MAX
} tenTOUCH_DRV_STATE;

class I_dispvidctrl_tclTouchDriverControl : public dispvidctrl_tclBaseIf
{
public:
	// constructor
	I_dispvidctrl_tclTouchDriverControl(tVoid);
	I_dispvidctrl_tclTouchDriverControl(const dispvidctrl_tclAppMain* poMainAppl) : dispvidctrl_tclBaseIf(poMainAppl) {;};
   // destructor
   virtual ~I_dispvidctrl_tclTouchDriverControl(){};

   virtual const tChar* getIfName() const { return "I_dispvidctrl_tclTouchDriverControl"; };

   virtual tS32 s32StartDriver(const tU8 u8Index) = 0;
   virtual tS32 s32StopDriver(const tU8 u8Index) = 0;
   virtual tS32 s32RestartDriver(const tU8 u8Index) = 0;
   virtual const char* cstrGetDriverName(const tU8 u8Index) const = 0;
};

#endif /* DIMMING_COMMON_I_DISPVIDCTRL_TCLTOUCHDRIVERCONTROL_H_ */
