/************************************************************************
* FILE:        I_dispvidctrl_tclLvdsMonitor.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: interface class for touch driver control
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 04.07.2017| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef DIMMING_COMMON_I_DISPVIDCTRL_TCLLvdsMonitor_H_
#define DIMMING_COMMON_I_DISPVIDCTRL_TCLLvdsMonitor_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "dispvidctrl_AppMain.h"
#ifndef DISPVIDCTRL_TCLTYPES_H_

#include "dispvidctrl_tclTypes.h"
#endif //#ifndef DISPVIDCTRL_TCLTYPES_H_

#define LVDS_MONITOR_AIVI_DISPLAY_SERIALIZER_NODE               "/sys/devices/soc0/soc.0/2100000.aips-bus/21a4000.i2c/i2c-1/1-000c/"
#define LVDS_MONITOR_PIVI_PRIMARY_DISPLAY_SERIALIZER_NODE 	    "/sys/devices/soc0/soc.0/2100000.aips-bus/21a0000.i2c/i2c-0/0-000c/"
#define LVDS_MONITOR_PIVI_SECONDARY_DISPLAY_SERIALIZER_NODE 	"/sys/devices/soc0/soc.0/2100000.aips-bus/21a4000.i2c/i2c-1/1-000c/"
#define TOUCH_CONTROLLER_STATUS_AIVI_PATH						"/sys/devices/soc0/soc.0/2100000.aips-bus/21a0000.i2c/i2c-0/0-004a/"
#define TOUCH_CONTROLLER_STATUS_PIVI_PRIMARY_PATH				"/sys/devices/soc0/soc.0/2100000.aips-bus/21a4000.i2c/i2c-1/1-0064/"
#define TOUCH_CONTROLLER_STATUS_PIVI_SECONDARY_PATH				"/sys/devices/soc0/soc.0/2100000.aips-bus/21a0000.i2c/i2c-0/0-0064/"
#define TOUCH_CONTROLLER_STATUS_RENAULT_LANDSCAPE_DETACHED_PATH "/sys/devices/soc0/soc.0/2100000.aips-bus/21a4000.i2c/i2c-1/1-0060/"

typedef enum {
	eDEVICE_UNKNOWN,
	eDEVICE_AIVI,
	eDEVICE_PIVI,
	eDEVICE_MAX = eDEVICE_PIVI
} eDEVICE_ID;


typedef enum {
	eDISPLAY_PRIMARY,
	eDISPLAY_SECONDARY,
	eDISPLAY_MAX = eDISPLAY_SECONDARY
} eDISPLAY_STATE;


class Variant {
public:
	static const Variant PIVI;
	static const Variant AIVI;

public:
	bool secDisp;

private:
	Variant(bool secDisp) {
		this->secDisp = secDisp;
	}
};




class I_dispvidctrl_tclLvdsMonitor : public dispvidctrl_tclBaseIf
{
public:
	// constructor
	I_dispvidctrl_tclLvdsMonitor(tVoid);
	I_dispvidctrl_tclLvdsMonitor(const dispvidctrl_tclAppMain* poMainAppl) : dispvidctrl_tclBaseIf(poMainAppl) {;};
   // destructor
   virtual ~I_dispvidctrl_tclLvdsMonitor(){};

   virtual const tChar* getIfName() const { return "I_dispvidctrl_tclLvdsMonitor"; };

};

#endif /* DIMMING_COMMON_I_DISPVIDCTRL_TCLLvdsMonitor_H_ */
