/************************************************************************
* FILE:        dispvidctrl_tclGstAudioPipeline.h
* PROJECT:
* SW-COMPONENT:vd_dimming
*----------------------------------------------------------------------
*
* DESCRIPTION: interface of configuration manager class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 20.08.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef _dispvidctrl_tclGstAudioPipeline_H_
#define _dispvidctrl_tclGstAudioPipeline_H_

#include <glib.h>
#include <glib-unix.h>
#include <gst/gst.h>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


class dispvidctrl_tclGstAudioPipeline
{
protected:
    GMainLoop   *_pGstMainLoop;

    GstElement  *_pGstPipeline;
    GstElement  *_pGstSource;
    GstElement  *_pGstAudioSink;
    GstElement  *_pGstAudioParse;
    GstElement  *_pGstAudioDecoder;
    GstElement  *_pGstAudioConverter;
    GstBus      *_pGstBus;
    
    GstState    gst_state;

public:
    // constructor
    dispvidctrl_tclGstAudioPipeline(tVoid);

    // destructor
    virtual ~dispvidctrl_tclGstAudioPipeline();

    virtual tBool bInit(GMainLoop *pGstMainLoop) = 0;
    virtual tVoid vStart() = 0;
    virtual tVoid vPause() = 0;
    virtual tVoid vStop() = 0;
};

#endif /* _dispvidctrl_tclGstAudioPipeline_H_ */