/************************************************************************
* FILE:        I_dispvidctrl_tclAudioPlayer.h
* PROJECT:
* SW-COMPONENT:Display Video Controller
*----------------------------------------------------------------------
*
* DESCRIPTION: interface of Audio player module
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 19.11.2017| RBEI/ECV4 deo2kor  | init
*
*************************************************************************/

#ifndef I_dispvidctrl_tclAudioPlayer_H_
#define I_dispvidctrl_tclAudioPlayer_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "dispvidctrl_AppMain.h"

/*******************************************************************************
                        Defines
*******************************************************************************/

class I_dispvidctrl_tclAudioPlayer : public dispvidctrl_tclBaseIf
{
public:
    // constructor
    I_dispvidctrl_tclAudioPlayer(tVoid);
    I_dispvidctrl_tclAudioPlayer(const dispvidctrl_tclAppMain* poMainAppl) : dispvidctrl_tclBaseIf(poMainAppl) {;};
    // destructor
    virtual ~I_dispvidctrl_tclAudioPlayer(){};

    virtual const tChar* getIfName() const { return "I_dispvidctrl_tclAudioPlayer"; };
    
    virtual tVoid vGetConfiguration(const TConfiguration* pStConfigurationValues) = 0;
    
    virtual tVoid vSetAlsaDeviceName(const tChar* cDevName) = 0;

    // Ipa interface
    virtual tVoid vPrepareIpaRequest(const tU8 u8RequestId) = 0;
    virtual tVoid vActivateIpaAudio(tBool bActivate) = 0;
    virtual tVoid vPauseIpaAudio() = 0;
    virtual tVoid vResumeIpaAudio() = 0;
};

#endif /* I_dispvidctrl_tclAudioPlayer */
