//**************************************************************************************************
//* defines CSM wide (Generated code - do NOT change manually !!!)
//**************************************************************************************************
// Temporary Wakeup used in CSM_lSignalWrite() for all NON-VW projects
#if (CSM_S_BUS_WAKE_TEMP == CSM_C_F_ON)
#define CSM_C_WAKE_TEMP_TIME    11000              // keep awake time = 11s
#endif

#define CSM_LCTR_C_MAX_USER           5              // Number of local control users (LCM,SPM for VCAN and MCAN, IGN for VCAN, on iMX for symmetry only)
#define CSM_CBR_MAX_USER              2             // Number of cbr users (only VCAN is for CBR)
#define CSM_C_MAX_ERROR_IND_USER     10              // Number of error indication user
#define CSM_APL_MAX_CONFIG_SLOTS     1              // Max. Number of configuration slots
#define CSM_APL_INVALID_CONFIG_SLOT  0xFF            // in case of error (reading from NVM)

#define CSM_C_CAN_CONFIG_SLOT_0      0x00            // slot 0


#define CSM_APL_C_READ_SLOT          0x00            // trace subcmd to trigger a slot read
#define CSM_APL_C_READ_EARLYNOR_SLOT 0x00            // subcmd to Read Slot from Early Nor
#define CSM_APL_C_INIT_DATAPOOL      0x01            // trace subcmd to trigger a re-init of the datapool after KDS writing
#define CSM_APL_C_CHECK_INC_COM      0x02            // trace subcmd to check if INC connection to CCS is active
#define CSM_APL_C_SET_DP_ITEM        0x03            // trace subcmd to set a certain datapool item
#define CSM_APL_C_SET_DLT_LOGLEVEL   0x04            // trace subcmd to set a certain loglevel for a certain module on v850
#define CSM_APL_C_SET_ISOTP_BS       0x05            // trace subcmd to set the blocksize for ISO-TP on v850



// ##################################################
// _CSM_SECTION_HISTORY: user specific code start
// ##################################################

/*****************************************************************************/
/* CSM_STACK (down/up stream task) */
/*****************************************************************************/
#define CSM_M_UPSTREAM_TASK_LOCK()                CSM_iInterruptsDisable()
#define CSM_M_UPSTREAM_TASK_UNLOCK(iIsrStat)      CSM_vInterruptsRestore(iIsrStat)
#define CSM_M_DOWNSTREAM_TASK_LOCK()              CSM_iInterruptsDisable()
#define CSM_M_DOWNSTREAM_TASK_UNLOCK(iIsrStat)    CSM_vInterruptsRestore(iIsrStat)
// CSM_C_DOWN_REASON_...    List of all used triggers for the Downstream Task

#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_OSEK_NM == CSM_C_F_ON)
#define CSM_C_DOWN_REASON_OSEK_TIMEOUT              0x00000400ul
#endif /* CSM_S_OSEK_NM */
#endif /* CSM_S_CNM_AVAILABLE */

// CSM_C_DOWN_REASON_...    List of all used triggers for the Downstream Task
#define CSM_C_DOWN_REASON_CSM_BUS_STATE_CHANGED         0x00000000ul
#define CSM_C_DOWN_REASON_CSM_COMMUNICATION_REQ         0x00000040ul
#define CSM_C_DOWN_REASON_CBR_SEND                      0x00000080ul
#define CSM_C_DOWN_REASON_CBR_TIMEOUT                   0x00000100ul
#define CSM_C_DOWN_REASON_CBR_COMMUNICATION_REQ         0x00000200ul
#define CSM_C_DOWN_REASON_CNM_OSEKI_COMMUNICATION_REQ   0x00000400ul
//#define CSM_C_DOWN_REASON_ITP_DATA_REQ                  0x00000800ul
#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_OSEK_NM == CSM_C_F_ON)
#define CSM_C_DOWN_REASON_OSEK_TIMEOUT              0x00000800ul
#endif /* CSM_S_OSEK_NM */
#endif /* CSM_S_CNM_AVAILABLE */
#define CSM_C_DOWN_REASON_CNP_ITP_COMMUNICATION_REQ     0x00001000ul
#define CSM_C_DOWN_REASON_IPC_LOCAL_BR_REQ_TX           0x00002000ul
#define CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX         0x01000000uL       // NP (TP) data from INC available
#define CSM_C_DOWN_REASON_IPC_REMOTE_NET_DATA_RX        0x02000000uL       // NET data from INC available
#define CSM_C_DOWN_REASON_IPC_REMOTE_BR_DATA_RX         0x04000000uL       // BR data from INC available
#define CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ         0x08000000uL
#define CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ         0x10000000uL
#define CSM_C_DOWN_REASON_CSM_IND_RADIOSTATUSCHANGED    0x20000000uL
#define CSM_C_DOWN_REASON_IPC_PROXY_TX_TIMEOUT          0x40000000uL       // OSAL timeout LINUX, TX to INC for BR, NET, NP
#define CSM_C_DOWN_REASON_IPC_LOCAL_NET_REQ_TX          0x80000000uL

// CSM_C_IND_REASON_...   List of all used triggers for the Upstream Task
// CSM_C_IND_REASON_...   List of all used triggers for the Upstream Task
#if (CSM_S_CSM_LOCAL_CTRL == CSM_C_F_ON)
#define CSM_C_IND_REASON_CSM_COMMUNICATION_CON          0x00000001ul
#define CSM_C_IND_REASON_CSM_COMMUNICATION_IND          0x00000002ul
#endif /* CSM_S_CSM_LOCAL_CTRL */
#define CSM_C_IND_REASON_CBR_SIGNAL_IND                 0x00000004ul
#define CSM_C_IND_REASON_CBR_COMMUNICATION_IND          0x00000008ul
#define CSM_C_IND_REASON_CBR_COMMUNICATION_CON          0x00000010ul
//#define CSM_C_IND_REASON_CSM_MPDT_DATA_IND              0x00000020ul
//#define CSM_C_IND_REASON_CSM_MPDT_DATA_CON              0x00000040ul
//#define CSM_C_IND_REASON_CSM_MPDT_COMMUNICATION_IND     0x00000080ul
//#define CSM_C_IND_REASON_CSM_MPDT_COMMUNICATION_CON     0x00000100ul
#define CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_IND      0x00000200ul
#define CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_CON      0x00000400ul
//#define CSM_C_IND_REASON_ITP_DATA_CON                   0x00000800ul       // give an ISO-TP data confirmation (TX done or Timeout)
//#define CSM_C_IND_REASON_ITP_DATA_IND                   0x00001000ul       // give an ISO-TP data indication (upstream)
#define CSM_C_IND_REASON_BUS_ERROR                      0x00080000ul
#define CSM_C_IND_REASON_CSM_OSEKI_NM_STATE_CHANGED     0x00100000ul


//**************************************************************************************************
//* defines for CBR (Generated code - do NOT change manually !!!)
//**************************************************************************************************
// define the amount of CBR broadcast messages (TX and RX) here

#define CBR_RX_MAX_NUMBER_SLOT0       (12)  // #ToDo: This was automatically corrected from 0 to 1
#define CBR_TX_MAX_NUMBER_SLOT0       (1)
#define CBR_RX_ABSOLUT_MAX_NUMBER     (12)
#define CBR_TX_ABSOLUT_MAX_NUMBER     (1)
#define CBR_RX_MAX_NUMBER             bCbrRxMaxNumber            // replace define by var in code
#define CBR_TX_MAX_NUMBER             bCbrTxMaxNumber            // replace define by var in code

/*****************************************************************************/
/* CSM CAN identifyer */
/*****************************************************************************/

/* CAN1/VCAN */
/*TX*/
#define CSM_C_TX_ID_ITM_State                0x5d8 /* 0x0L */

/*RX*/
#define CSM_C_RX_ID_MFD_PrivacyReset         0x406 /* 0x0L */
#define CSM_C_RX_ID_GW_SpeedData             0x58d /* 0x0L */
#define CSM_C_RX_ID_GW_Chassis_Data2         0x58c /* 0x0L */
#define CSM_C_RX_ID_GW_RearCamInfo           0x5a8 /* 0x0L */
#define CSM_C_RX_ID_GW_PositionInfo          0x548 /* 0x0L */
#define CSM_C_RX_ID_RADIO_State              0x5b8 /* 0x0L */
#define CSM_C_RX_ID_GW_DiagInfo              0x578 /* 0x0L */
#define CSM_C_RX_ID_GW_RadioInfo             0x568 /* 0x0L */
#define CSM_C_RX_ID_GW_MMI_Info1             0x558 /* 0x0L */
#define CSM_C_RX_ID_GW_SEND                  0x58f /* 0x0L */
#define CSM_C_RX_ID_GW_Chassis_Data3         0x590 /* 0x0L */
#define CSM_C_RX_ID_GW_MMI_Info3             0x560 /* 0x0L */

//**************************************************************************************************
//* CSM Timer configuration (Generated code - do NOT change manually !!!)
//**************************************************************************************************
// The timer configuration of the Proxy is totally different from the real CSM !!!
enum
{
  // ATTENTION: adapting the amount of timers here requires further adaptions at other places
  CSM_TIMER_DUMMY = 0,                            // is always needed to have at least 1 entry
  CSM_TIMER_NET_LCTRL,                            // net ctrl
  CSM_TIMER_NET_LCTRL_USER_0,                     // net ctrl user 0 from LCTRL config
  CSM_TIMER_NET_LCTRL_USER_1,                     // net ctrl user 1 from LCTRL config
  CSM_TIMER_NET_OSEKI,                            // net OSEKI
  CSM_TIMER_BRSIGNAL,                             // broadcast
  CSM_TIMER_NP1_COM,                              // np1  -> chn. index 0
  CSM_TIMER_NP1_TX,                            // np1  -> chn. index 0
  CSM_TIMER_NP1_RX,                            // np1  -> chn. index 0
  CSM_TIMER_NP2_COM,                              // np2  -> chn. index 1
  CSM_TIMER_NP2_TX,                            // np2  -> chn. index 1
  CSM_TIMER_NP2_RX,                            // np2  -> chn. index 1
  CSM_TIMER_NP3_COM,                              // np3  -> chn. index 2
  CSM_TIMER_NP3_TX,                            // np3  -> chn. index 2
  CSM_TIMER_NP3_RX,                            // np3  -> chn. index 2
  CSM_TIMER_NP4_COM,                              // np4  -> chn. index 3
  CSM_TIMER_NP4_TX,                            // np4  -> chn. index 3
  CSM_TIMER_NP4_RX,                            // np4  -> chn. index 3
  CSM_TIMER_NP5_COM,                              // np5  -> chn. index 4
  CSM_TIMER_NP5_TX,                            // np5  -> chn. index 4
  CSM_TIMER_NP5_RX,                            // np5  -> chn. index 4
  CSM_TIMER_NP6_COM,                              // np6  -> chn. index 5
  CSM_TIMER_NP6_TX,                            // np6  -> chn. index 5
  CSM_TIMER_NP6_RX,                            // np6  -> chn. index 5
  CSM_TIMER_NP7_COM,                              // np7  -> chn. index 6
  CSM_TIMER_NP7_TX,                            // np7  -> chn. index 6
  CSM_TIMER_NP7_RX,                            // np7  -> chn. index 6
  CSM_TIMER_NP8_COM,                              // np8  -> chn. index 7
  CSM_TIMER_NP8_TX,                            // np8  -> chn. index 7
  CSM_TIMER_NP8_RX,                            // np8  -> chn. index 7
  CSM_TIMER_NP9_COM,                              // np9  -> chn. index 8
  CSM_TIMER_NP9_TX,                            // np9  -> chn. index 8
  CSM_TIMER_NP9_RX,                            // np9  -> chn. index 8
  CSM_TIMER_NP10_COM,                             // np10 -> chn. index 9
  CSM_TIMER_NP10_TX,                           // np10 -> chn. index 9
  CSM_TIMER_NP10_RX,                           // np10 -> chn. index 9
  CSM_TIMER_NP11_COM,                             // np11 -> chn. index 10
  CSM_TIMER_NP11_TX,                           // np11 -> chn. index 10
  CSM_TIMER_NP11_RX,                           // np11 -> chn. index 10
  CSM_MAX_TIMER
};
#define CSM_C_MAX_TIMER    CSM_MAX_TIMER          // make define from enum


/*****************************************************************************/
/* CBR */
/*****************************************************************************/
#if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
#define CBR_M_INIT_VARS()  /**< empty */

#define CBR_MAX_APPL_ID  3

/* DLC for CAN1/VCAN Messages*/
/*TX*/
#define CSM_C_DLC_ITM_State                8  /**< data length*/

/*RX*/
#define CSM_C_DLC_MFD_PrivacyReset         1  /**< data length*/
#define CSM_C_DLC_GW_SpeedData             8  /**< data length*/
#define CSM_C_DLC_GW_Chassis_Data2         7  /**< data length*/
#define CSM_C_DLC_GW_RearCamInfo           7  /**< data length*/
#define CSM_C_DLC_GW_PositionInfo          5  /**< data length*/
#define CSM_C_DLC_RADIO_State              4  /**< data length*/
#define CSM_C_DLC_GW_DiagInfo              5  /**< data length*/
#define CSM_C_DLC_GW_RadioInfo             6  /**< data length*/
#define CSM_C_DLC_GW_MMI_Info1             8  /**< data length*/
#define CSM_C_DLC_GW_SEND                  5  /**< data length*/
#define CSM_C_DLC_GW_Chassis_Data3         8  /**< data length*/
#define CSM_C_DLC_GW_MMI_Info3             2  /**< data length*/

#define CSM_M_GET_SIGNAL_ID_FROM_VIRTUAL_SIGNAL_ID(a) a   /* in case no virtual signals are used.. */
#define CSM_M_CHECK_FOR_VALID_SIGNAL_ID(a)            1   /* in case no virtual signals are used.. */

#endif /* CSM_S_CBR_AVAILABLE */


/*****************************************************************************/
/* CNM_OSEK */
/*****************************************************************************/
#define CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN      2  // max. value of RX monitors
#define NO_OF_ACTIVE_RX_MONITORS_VCAN              2  // configured nr. of RX monitors (refer to cnm_oseki_mp.h)
#define CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN      2

#define CNM_OSEKI_NR_OF_RX_NODE_MONITORS_MCAN      2  // max. value of RX monitors MCAN
#define NO_OF_ACTIVE_RX_MONITORS_MCAN              2  // configured nr. of RX monitors (refer to cnm_oseki_mp.h)
#define CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN      2

#define NO_OF_ACTIVE_BUSOFF_MONITORS               2
#define CSM_NWM_C_MAX_COMMAND_USER                 2   // amount of users using CommunicationReq on OSEKI NM

/* this define is important for the configuration table csm_arNWMCfg[]       */
/* DO NOT change this group -> only change single defines above              */
#define CSM_NWM_C_MAX_USER     ( NO_OF_ACTIVE_RX_MONITORS_VCAN +  \
                                 CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN +  \
                 NO_OF_ACTIVE_RX_MONITORS_MCAN +\
                 CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN +\
                                 NO_OF_ACTIVE_BUSOFF_MONITORS          +  \
                                 CSM_NWM_C_MAX_COMMAND_USER )

//**************************************************************************************************
//* for CSM_STACK_[OS]  (Generated code - do NOT change manually !!!)
//**************************************************************************************************
// CSM Timer OS dependent configuration
#ifdef CSM_STACK_ENV_SELF   // map the following definitions in csm_stack_[OS].c

// Timer Timeout-Callback prototypes
#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_OSEKI_NM == CSM_C_F_ON)
// empty
#endif
#endif

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_MPDT == CSM_C_F_ON)
// empty
#endif
#endif

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_ISO_TP == CSM_C_F_ON)
void CNP_ITP_vTxTimerExpired(DWORD dwValue);
void CNP_ITP_vRxTimerExpired(DWORD dwValue);
#endif
#endif

#if (CSM_S_REMOTE_STACK == CSM_C_F_ON)
  extern void  CSM_PROXY_vTimeout( DWORD wTimerId);
#endif
// ########################################
// _CSM_SECTION2: user specific code start
// ########################################

// #######################################
// _CSM_SECTION2: user specific code end
// #######################################
//**************************************************************************************************
//* CSM Timer instances (Generated code - do NOT change manually !!!)
//**************************************************************************************************
// array with callbacks for timer system
const tCSM_TIMER csm_arTimer[ CSM_MAX_TIMER] =
{
  {NULL, 0}, /* CSM_TIMER_DUMMY */
  {CSM_PROXY_vTimeout,  1},                         // CSM_TIMER_NET_LCTRL
  {CSM_PROXY_vTimeout,  2},                         // CSM_TIMER_NET_LCTRL USER 0 from LCTRL config
  {CSM_PROXY_vTimeout,  3},                         // CSM_TIMER_NET_LCTRL USER 1 from LCTRL config
  {CSM_PROXY_vTimeout,  4},                         // CSM_TIMER_NET_OSEKI
  {CSM_PROXY_vTimeout,  5},                         // CSM_TIMER_BRSIGNAL
  {CSM_PROXY_vTimeout,  6},                         // np1  -> chn. index 0
  {CSM_PROXY_vTimeout,  7},                         // np1  -> chn. index 0
  {CSM_PROXY_vTimeout,  8},                         // np1  -> chn. index 0
  {CSM_PROXY_vTimeout,  9},                         // np2  -> chn. index 1
  {CSM_PROXY_vTimeout, 10},                         // np2  -> chn. index 1
  {CSM_PROXY_vTimeout, 11},                         // np2  -> chn. index 1
  {CSM_PROXY_vTimeout, 12},                         // np3  -> chn. index 2
  {CSM_PROXY_vTimeout, 13},                         // np3  -> chn. index 2
  {CSM_PROXY_vTimeout, 14},                         // np3  -> chn. index 2
  {CSM_PROXY_vTimeout, 15},                         // np4  -> chn. index 3
  {CSM_PROXY_vTimeout, 16},                         // np4  -> chn. index 3
  {CSM_PROXY_vTimeout, 17},                         // np4  -> chn. index 3
  {CSM_PROXY_vTimeout, 18},                         // np5  -> chn. index 4
  {CSM_PROXY_vTimeout, 19},                         // np5  -> chn. index 4
  {CSM_PROXY_vTimeout, 20},                         // np5  -> chn. index 4
  {CSM_PROXY_vTimeout, 21},                         // np6  -> chn. index 5
  {CSM_PROXY_vTimeout, 22},                         // np6  -> chn. index 5
  {CSM_PROXY_vTimeout, 23},                         // np6  -> chn. index 5
  {CSM_PROXY_vTimeout, 24},                         // np7  -> chn. index 6
  {CSM_PROXY_vTimeout, 25},                         // np7  -> chn. index 6
  {CSM_PROXY_vTimeout, 26},                         // np7  -> chn. index 6
  {CSM_PROXY_vTimeout, 27},                         // np8  -> chn. index 7
  {CSM_PROXY_vTimeout, 28},                         // np8  -> chn. index 7
  {CSM_PROXY_vTimeout, 29},                         // np8  -> chn. index 7
  {CSM_PROXY_vTimeout, 30},                         // np9  -> chn. index 8
  {CSM_PROXY_vTimeout, 31},                         // np9  -> chn. index 8
  {CSM_PROXY_vTimeout, 32},                         // np9  -> chn. index 8
  {CSM_PROXY_vTimeout, 33},                         // np10 -> chn. index 9
  {CSM_PROXY_vTimeout, 34},                         // np10 -> chn. index 9
  {CSM_PROXY_vTimeout, 35},                         // np10 -> chn. index 9
  {CSM_PROXY_vTimeout, 36},                         // np11 -> chn. index 10
  {CSM_PROXY_vTimeout, 37},                         // np11 -> chn. index 10
  {CSM_PROXY_vTimeout, 38},                         // np11 -> chn. index 10
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
#if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
  {CBR_vTransmitTimeout, 0},
    #if (CSM_S_CBR_MIN_DELAY == CSM_C_F_ON)
  {CBR_vTransmitMinDelayTimeout, 0},
    #endif // CSM_S_CBR_MIN_DELAY
  {CBR_vReceiveTimeout, 0},
  {CBR_vReceiveTimeout, 1},
  {CBR_vReceiveTimeout, 2},
  {CBR_vReceiveTimeout, 3},
  {CBR_vReceiveTimeout, 4},
  {CBR_vReceiveTimeout, 5},
  {CBR_vReceiveTimeout, 6},
  {CBR_vReceiveTimeout, 7},
  {CBR_vReceiveTimeout, 8},
  {CBR_vReceiveTimeout, 9},
  {CBR_vReceiveTimeout, 10},
  {CBR_vReceiveTimeout, 11},
#endif /* CSM_S_CBR_AVAILABLE */
#endif /* CSM_S_REMOTE_STACK */
#if (CSM_S_BUS_WAKE_TEMP == CSM_C_F_ON)
  {csm_vWakeTempTimeout, 0},
#endif /* CSM_S_BUS_WAKE_TEMP */

#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_OSEK_NM == CSM_C_F_ON)
  {CSM_vCNMBusoffReinitTimerExpired, 0},
  {CNM_OSEK_vTimer, 0},
#endif /* CSM_S_OSEK_NM */
#endif /* CSM_S_CNM_AVAILABLE */

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_ISO_TP == CSM_C_F_ON)
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CNP_ITP_vTxTimerExpired, 0}, /*CSM_TIMER_ITP_TX_CH0X*/
  {CNP_ITP_vTxTimerExpired, 1}, /*CSM_TIMER_ITP_TX_CH1X*/
  {CNP_ITP_vTxTimerExpired, 2}, /*CSM_TIMER_ITP_TX_CH2X*/

  {CNP_ITP_vRxTimerExpired, 0}, /*CSM_TIMER_ITP_RX_CH0X*/
  {CNP_ITP_vRxTimerExpired, 1}, /*CSM_TIMER_ITP_RX_CH1X*/
  {CNP_ITP_vRxTimerExpired, 2}, /*CSM_TIMER_ITP_RX_CH2X*/
  #endif
#endif /* CSM_S_ISO_TP */
#endif /* CSM_S_CNP_AVAILABLE */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CSM_APL_vUpdateUserData, 0},
#endif /* CSM_S_CNP_AVAILABLE */
};
#endif // CSM_STACK_ENV_SELF



#ifdef CBR_SELF
/*
    SS    SSSSS   S    S    SSSS
   S  S   S       S    S    S   S
   S      S       SS   S    S    S
    S     SSS     SSS  S    S    S
     S    S       S  SSS    S    S
      S   S       S   SS    S    S
   S  S   S       S    S    S   S
    SS    SSSSS   S    S    SSSS
*/
/********************************************/
/* TX Data */
/********************************************/
/*CAN1/VCAN*/
BYTE cbr_aubTX_ITM_State_TelData[ CSM_C_DLC_ITM_State];


/*****************************************************************************/
/* TX_ITM_State */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_ITM_StateSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7, 64),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* ITM_State */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  2,  1),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* PrivacyResetAck */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 31, 10),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* AccurateVehicleAutonomy_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  1,  1),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* ActivityEvent */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  0,  1),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* ONOFF_Request */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 11,  1),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* TimeFormat_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 10, 11),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* LocalTime_MM */
};
const BYTE cbr_aubTX_ITM_State_DefaultData[] = {0,0x07,0xFF,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubTX_ITM_State =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_ITM_StateSignals),
/* prSignals */                 cbr_aubTX_ITM_StateSignals,
/* pvTeleGramDefaultData */     cbr_aubTX_ITM_State_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};


/*
    RRR    RRRRR    RRRR   RRRRR    R    R     R   RRRRR
    R  R   R       R       R             R     R   R
    R   R  R       R       R        R     R   R    R
    R   R  RRR     R       RRR      R     R   R    RR
    RRRR   R       R       R        R      R R     R
    R  R   R       R       R        R      R R     R
    R   R  R       R       R        R       R      R
    R   R  RRRRR    RRRR   RRRRR   RRR      R      RRRRR
*/

/********************************************/
/* RX Data */
/********************************************/
BYTE cbr_aubRX_MFD_PrivacyReset_TelData[ CSM_C_DLC_MFD_PrivacyReset];
BYTE cbr_aubRX_GW_SpeedData_TelData[ CSM_C_DLC_GW_SpeedData];
BYTE cbr_aubRX_GW_Chassis_Data2_TelData[ CSM_C_DLC_GW_Chassis_Data2];
BYTE cbr_aubRX_GW_RearCamInfo_TelData[ CSM_C_DLC_GW_RearCamInfo];
BYTE cbr_aubRX_GW_PositionInfo_TelData[ CSM_C_DLC_GW_PositionInfo];
BYTE cbr_aubRX_RADIO_State_TelData[ CSM_C_DLC_RADIO_State];
BYTE cbr_aubRX_GW_DiagInfo_TelData[ CSM_C_DLC_GW_DiagInfo];
BYTE cbr_aubRX_GW_RadioInfo_TelData[ CSM_C_DLC_GW_RadioInfo];
BYTE cbr_aubRX_GW_MMI_Info1_TelData[ CSM_C_DLC_GW_MMI_Info1];
BYTE cbr_aubRX_GW_SEND_TelData[ CSM_C_DLC_GW_SEND];
BYTE cbr_aubRX_GW_Chassis_Data3_TelData[ CSM_C_DLC_GW_Chassis_Data3];
BYTE cbr_aubRX_GW_MMI_Info3_TelData[ CSM_C_DLC_GW_MMI_Info3];

/*****************************************************************************/
/* RX_MFD_PrivacyReset */
/*****************************************************************************/
#define CBR_C_SIG_RX_MFD_PrivacyReset_NUM_CALLBACK                    3
#define CBR_C_SIG_RX_MFD_PrivacyReset_PrivacyResetReq_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_MFD_PrivacyReset[ CBR_C_SIG_RX_MFD_PrivacyReset_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL,NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_MFD_PrivacyReset_PrivacyResetReq[ CBR_C_SIG_RX_MFD_PrivacyReset_PrivacyResetReq_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_MFD_PrivacyReset[ CBR_C_SIG_RX_MFD_PrivacyReset_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_MFD_PrivacyReset_PrivacyResetReq[ CBR_C_SIG_RX_MFD_PrivacyReset_PrivacyResetReq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_MFD_PrivacyResetSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_MFD_PrivacyReset*8), CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MFD_PrivacyReset_NUM_CALLBACK, cbr_apfnSIG_RX_MFD_PrivacyReset}, /* MFD_PrivacyReset*/
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  0,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MFD_PrivacyReset_PrivacyResetReq_NUM_CALLBACK ,cbr_apfnSIG_RX_MFD_PrivacyReset_PrivacyResetReq }, /* PrivacyResetReq */
#else
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_MFD_PrivacyReset*8), CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MFD_PrivacyReset_NUM_CALLBACK, cbr_apfnSIG_RX_MFD_PrivacyReset}, /* MFD_PrivacyReset*/
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  0,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MFD_PrivacyReset_PrivacyResetReq_NUM_CALLBACK ,cbr_apfnSIG_RX_MFD_PrivacyReset_PrivacyResetReq }, /* PrivacyResetReq */
#endif
};
const BYTE cbr_aubRX_MFD_PrivacyReset_DefaultData[] = {0,0,0,0,0,0,0,0};
const BYTE cbr_aubRX_MFD_PrivacyReset_TimeoutData[] = {0,0,0,0,0,0,0,0};


/***********************/
const CSM_TELEGRAM cbr_aubRX_MFD_PrivacyReset =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_MFD_PrivacyResetSignals),
/* prSignals */                 cbr_aubRX_MFD_PrivacyResetSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_MFD_PrivacyReset_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_MFD_PrivacyReset_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_GW_SpeedData */
/*****************************************************************************/
#define CBR_C_SIG_RX_GW_SpeedData_NUM_CALLBACK                          3
#define CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_R_R_MM_NUM_CALLBACK    3
#define CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_R_L_MM_NUM_CALLBACK    3
#define CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_F_R_MM_NUM_CALLBACK    3
#define CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_F_L_MM_NUM_CALLBACK    3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SpeedData[ CBR_C_SIG_RX_GW_SpeedData_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL,NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_R_R_MM[ CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_R_R_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_R_L_MM[ CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_R_L_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_F_R_MM[ CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_F_R_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_F_L_MM[ CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_F_L_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SpeedData[ CBR_C_SIG_RX_GW_SpeedData_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_R_R_MM[ CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_R_R_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_R_L_MM[ CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_R_L_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_F_R_MM[ CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_F_R_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_F_L_MM[ CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_F_L_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_GW_SpeedDataSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_SpeedData*8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SpeedData_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SpeedData }, /* GW_SpeedData */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 39, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_R_R_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_R_R_MM }, /* Rst_WheelSpeed_R_R_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 55, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_R_L_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_R_L_MM }, /* Rst_WheelSpeed_R_L_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_F_R_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_F_R_MM }, /* Rst_WheelSpeed_F_R_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 23, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_F_L_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_F_L_MM }, /* Rst_WheelSpeed_F_L_MM */
#else
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_SpeedData*8), CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SpeedData_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SpeedData }, /* GW_SpeedData */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 39, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_R_R_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_R_R_MM }, /* Rst_WheelSpeed_R_R_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 55, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_R_L_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_R_L_MM }, /* Rst_WheelSpeed_R_L_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_F_R_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_F_R_MM }, /* Rst_WheelSpeed_F_R_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 23, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SpeedData_Rst_WheelSpeed_F_L_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SpeedData_Rst_WheelSpeed_F_L_MM }, /* Rst_WheelSpeed_F_L_MM */
#endif
};
const BYTE cbr_aubRX_GW_SpeedData_DefaultData[] = {0,0,0,0,0,0,0,0};
const BYTE cbr_aubRX_GW_SpeedData_TimeoutData[] = {0,0,0,0,0,0,0,0};

/***********************/
const CSM_TELEGRAM cbr_aubRX_GW_SpeedData =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_GW_SpeedDataSignals),
/* prSignals */                 cbr_aubRX_GW_SpeedDataSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_GW_SpeedData_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_GW_SpeedData_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_GW_Chassis_Data2 */
/*****************************************************************************/
#define CBR_C_SIG_RX_GW_Chassis_Data2_NUM_CALLBACK                                     3
#define CBR_C_SIG_RX_GW_Chassis_Data2_Rst_Yawrate_MM_NUM_CALLBACK                      3
#define CBR_C_SIG_RX_GW_Chassis_Data2_Rst_TransversalAcceleration_MM_NUM_CALLBACK      3
#define CBR_C_SIG_RX_GW_Chassis_Data2_Rst_SteeringWheelSpeed_MM_NUM_CALLBACK           3
#define CBR_C_SIG_RX_GW_Chassis_Data2_Rst_LongitudinalAcceleration_MM_NUM_CALLBACK     3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_Chassis_Data2[ CBR_C_SIG_RX_GW_Chassis_Data2_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL,NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_Yawrate_MM[ CBR_C_SIG_RX_GW_Chassis_Data2_Rst_Yawrate_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_TransversalAcceleration_MM[ CBR_C_SIG_RX_GW_Chassis_Data2_Rst_TransversalAcceleration_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_SteeringWheelSpeed_MM[ CBR_C_SIG_RX_GW_Chassis_Data2_Rst_SteeringWheelSpeed_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_LongitudinalAcceleration_MM[ CBR_C_SIG_RX_GW_Chassis_Data2_Rst_LongitudinalAcceleration_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_Chassis_Data2[ CBR_C_SIG_RX_GW_Chassis_Data2_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_Yawrate_MM[ CBR_C_SIG_RX_GW_Chassis_Data2_Rst_Yawrate_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_TransversalAcceleration_MM[ CBR_C_SIG_RX_GW_Chassis_Data2_Rst_TransversalAcceleration_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_SteeringWheelSpeed_MM[ CBR_C_SIG_RX_GW_Chassis_Data2_Rst_SteeringWheelSpeed_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_LongitudinalAcceleration_MM[ CBR_C_SIG_RX_GW_Chassis_Data2_Rst_LongitudinalAcceleration_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_GW_Chassis_Data2Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_Chassis_Data2*8), CBR_C_SIG_RX_GW_Chassis_Data2_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data2 }, /* GW_Chassis_Data2 */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 47, 12),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data2_Rst_Yawrate_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_Yawrate_MM }, /* Rst_Yawrate_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 15, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data2_Rst_TransversalAcceleration_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_TransversalAcceleration_MM }, /* Rst_TransversalAcceleration_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 31, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data2_Rst_SteeringWheelSpeed_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_SteeringWheelSpeed_MM }, /* Rst_SteeringWheelSpeed_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data2_Rst_LongitudinalAcceleration_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_LongitudinalAcceleration_MM }, /* Rst_LongitudinalAcceleration_MM */
#else
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_Chassis_Data2*8), CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data2_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data2 }, /* GW_Chassis_Data2 */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 47, 12),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data2_Rst_Yawrate_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_Yawrate_MM }, /* Rst_Yawrate_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 15, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data2_Rst_TransversalAcceleration_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_TransversalAcceleration_MM }, /* Rst_TransversalAcceleration_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 31, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data2_Rst_SteeringWheelSpeed_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_SteeringWheelSpeed_MM }, /* Rst_SteeringWheelSpeed_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data2_Rst_LongitudinalAcceleration_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data2_Rst_LongitudinalAcceleration_MM }, /* Rst_LongitudinalAcceleration_MM */
#endif
};

const BYTE cbr_aubRX_GW_Chassis_Data2_DefaultData[] = {0,0,0,0,0,0,0,0};
const BYTE cbr_aubRX_GW_Chassis_Data2_TimeoutData[] = {0,0,0,0,0,0,0,0};

/***********************/
const CSM_TELEGRAM cbr_aubRX_GW_Chassis_Data2 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_GW_Chassis_Data2Signals),
/* prSignals */                 cbr_aubRX_GW_Chassis_Data2Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_GW_Chassis_Data2_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_GW_Chassis_Data2_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_GW_RearCamInfo */
/*****************************************************************************/

#define CBR_C_SIG_RX_GW_RearCamInfo_NUM_CALLBACK                                   3
#define CBR_C_SIG_RX_GW_RearCamInfo_SteeringWheelAngle_Offset_MM_NUM_CALLBACK      3
#define CBR_C_SIG_RX_GW_RearCamInfo_SteeringWheelAngle_MM_NUM_CALLBACK             3
#define CBR_C_SIG_RX_GW_RearCamInfo_SwaSensorInternalStatus_MM_NUM_CALLBACK        3
#define CBR_C_SIG_RX_GW_RearCamInfo_RearGearEngaged_MM_NUM_CALLBACK                3
#define CBR_C_SIG_RX_GW_RearCamInfo_BootOpenWarning_MM_NUM_CALLBACK                3


#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_RearCamInfo[ CBR_C_SIG_RX_GW_RearCamInfo_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL,NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_RearCamInfo_SteeringWheelAngle_Offset_MM[ CBR_C_SIG_RX_GW_RearCamInfo_SteeringWheelAngle_Offset_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_RearCamInfo_SteeringWheelAngle_MM[ CBR_C_SIG_RX_GW_RearCamInfo_SteeringWheelAngle_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_RearCamInfo_SwaSensorInternalStatus_MM[ CBR_C_SIG_RX_GW_RearCamInfo_SwaSensorInternalStatus_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_RearCamInfo_RearGearEngaged_MM[ CBR_C_SIG_RX_GW_RearCamInfo_RearGearEngaged_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_RearCamInfo_BootOpenWarning_MM[ CBR_C_SIG_RX_GW_RearCamInfo_BootOpenWarning_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_RearCamInfo[ CBR_C_SIG_RX_GW_RearCamInfo_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_RearCamInfo_SteeringWheelAngle_Offset_MM[ CBR_C_SIG_RX_GW_RearCamInfo_SteeringWheelAngle_Offset_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_RearCamInfo_SteeringWheelAngle_MM[ CBR_C_SIG_RX_GW_RearCamInfo_SteeringWheelAngle_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_RearCamInfo_SwaSensorInternalStatus_MM[ CBR_C_SIG_RX_GW_RearCamInfo_SwaSensorInternalStatus_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_RearCamInfo_RearGearEngaged_MM[ CBR_C_SIG_RX_GW_RearCamInfo_RearGearEngaged_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_RearCamInfo_BootOpenWarning_MM[ CBR_C_SIG_RX_GW_RearCamInfo_BootOpenWarning_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif


const CSM_SIGNAL cbr_aubRX_GW_RearCamInfoSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_RearCamInfo*8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RearCamInfo_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RearCamInfo }, /* GW_RearCamInfo */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 31, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RearCamInfo_SteeringWheelAngle_Offset_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RearCamInfo_SteeringWheelAngle_Offset_MM }, /* SteeringWheelAngle_Offset_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 15, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RearCamInfo_SteeringWheelAngle_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RearCamInfo_SteeringWheelAngle_MM }, /* SteeringWheelAngle_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 42,  3),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RearCamInfo_SwaSensorInternalStatus_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RearCamInfo_SwaSensorInternalStatus_MM }, /* SwaSensorInternalStatus_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  1,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RearCamInfo_RearGearEngaged_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RearCamInfo_RearGearEngaged_MM }, /* RearGearEngaged_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  5,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RearCamInfo_BootOpenWarning_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RearCamInfo_BootOpenWarning_MM }, /* BootOpenWarning_MM */
#else
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_RearCamInfo*8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RearCamInfo_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RearCamInfo }, /* GW_RearCamInfo */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 31, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RearCamInfo_SteeringWheelAngle_Offset_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RearCamInfo_SteeringWheelAngle_Offset_MM }, /* SteeringWheelAngle_Offset_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 15, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RearCamInfo_SteeringWheelAngle_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RearCamInfo_SteeringWheelAngle_MM }, /* SteeringWheelAngle_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 42,  3),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RearCamInfo_SwaSensorInternalStatus_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RearCamInfo_SwaSensorInternalStatus_MM }, /* SwaSensorInternalStatus_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  1,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RearCamInfo_RearGearEngaged_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RearCamInfo_RearGearEngaged_MM }, /* RearGearEngaged_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  5,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RearCamInfo_BootOpenWarning_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RearCamInfo_BootOpenWarning_MM }, /* BootOpenWarning_MM */
#endif
};
const BYTE cbr_aubRX_GW_RearCamInfo_DefaultData[] = {0,0,0,0,0,0,0,0};
const BYTE cbr_aubRX_GW_RearCamInfo_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_GW_RearCamInfo =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_GW_RearCamInfoSignals),
/* prSignals */                 cbr_aubRX_GW_RearCamInfoSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_GW_RearCamInfo_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_GW_RearCamInfo_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};



/*****************************************************************************/
/* RX_GW_PositionInfo */
/*****************************************************************************/
#define CBR_C_SIG_RX_GW_PositionInfo_NUM_CALLBACK                          3
#define CBR_C_SIG_RX_GW_PositionInfo_RearGearEngaged_MM_NUM_CALLBACK       3
#define CBR_C_SIG_RX_GW_PositionInfo_VehicleSpeed_MM_NUM_CALLBACK          3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_PositionInfo[ CBR_C_SIG_RX_GW_PositionInfo_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL,NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_PositionInfo_RearGearEngaged_MM[ CBR_C_SIG_RX_GW_PositionInfo_RearGearEngaged_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_PositionInfo_VehicleSpeed_MM[ CBR_C_SIG_RX_GW_PositionInfo_VehicleSpeed_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_PositionInfo[ CBR_C_SIG_RX_GW_PositionInfo_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_PositionInfo_RearGearEngaged_MM[ CBR_C_SIG_RX_GW_PositionInfo_RearGearEngaged_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_PositionInfo_VehicleSpeed_MM[ CBR_C_SIG_RX_GW_PositionInfo_VehicleSpeed_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_GW_PositionInfoSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_PositionInfo*8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_PositionInfo_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_PositionInfo }, /* GW_PositionInfo */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 17,  2),  CSM_C_ALWAYS_IND, CBR_C_SIG_RX_GW_PositionInfo_RearGearEngaged_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_PositionInfo_RearGearEngaged_MM }, /* RearGearEngaged_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7, 16),  CSM_C_ALWAYS_IND, CBR_C_SIG_RX_GW_PositionInfo_VehicleSpeed_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_PositionInfo_VehicleSpeed_MM }, /* VehicleSpeed_MM */
#else
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_PositionInfo*8), CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_PositionInfo_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_PositionInfo }, /* GW_PositionInfo */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 17,  2),  CSM_C_ALWAYS_IND, CBR_C_SIG_RX_GW_PositionInfo_RearGearEngaged_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_PositionInfo_RearGearEngaged_MM }, /* RearGearEngaged_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7, 16),  CSM_C_ALWAYS_IND, CBR_C_SIG_RX_GW_PositionInfo_VehicleSpeed_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_PositionInfo_VehicleSpeed_MM }, /* VehicleSpeed_MM */
#endif
};
const BYTE cbr_aubRX_GW_PositionInfo_DefaultData[] = {0,0,0,0,0,0,0,0};
const BYTE cbr_aubRX_GW_PositionInfo_TimeoutData[] = {0,0,0,0,0,0,0,0};

/***********************/
const CSM_TELEGRAM cbr_aubRX_GW_PositionInfo =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_GW_PositionInfoSignals),
/* prSignals */                 cbr_aubRX_GW_PositionInfoSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_GW_PositionInfo_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_GW_PositionInfo_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_RADIO_State */
/*****************************************************************************/
#define CBR_C_SIG_RX_RADIO_State_NUM_CALLBACK                  3
#define CBR_C_SIG_RX_RADIO_State_RadioState_NUM_CALLBACK       3
#define CBR_C_SIG_RX_RADIO_State_ActivityEvent_NUM_CALLBACK    3


#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RADIO_State[ CBR_C_SIG_RX_RADIO_State_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL,NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RADIO_State_RadioState[ CBR_C_SIG_RX_RADIO_State_RadioState_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RADIO_State_ActivityEvent[ CBR_C_SIG_RX_RADIO_State_ActivityEvent_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RADIO_State[ CBR_C_SIG_RX_RADIO_State_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RADIO_State_RadioState[ CBR_C_SIG_RX_RADIO_State_RadioState_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RADIO_State_ActivityEvent[ CBR_C_SIG_RX_RADIO_State_ActivityEvent_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_RADIO_StateSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_RADIO_State*8), CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RADIO_State_NUM_CALLBACK ,cbr_apfnSIG_RX_RADIO_State }, /* RADIO_State */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 15,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RADIO_State_RadioState_NUM_CALLBACK ,cbr_apfnSIG_RX_RADIO_State_RadioState }, /* RadioState */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  0,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RADIO_State_ActivityEvent_NUM_CALLBACK ,cbr_apfnSIG_RX_RADIO_State_ActivityEvent }, /* ActivityEvent */
#else
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_RADIO_State*8), CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RADIO_State_NUM_CALLBACK ,cbr_apfnSIG_RX_RADIO_State }, /* RADIO_State */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 15,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RADIO_State_RadioState_NUM_CALLBACK ,cbr_apfnSIG_RX_RADIO_State_RadioState }, /* RadioState */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  0,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RADIO_State_ActivityEvent_NUM_CALLBACK ,cbr_apfnSIG_RX_RADIO_State_ActivityEvent }, /* ActivityEvent */
#endif
};

const BYTE cbr_aubRX_RADIO_State_DefaultData[] = {0,0,0,0,0,0,0,0};
const BYTE cbr_aubRX_RADIO_State_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_RADIO_State =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_RADIO_StateSignals),
/* prSignals */                 cbr_aubRX_RADIO_StateSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_RADIO_State_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_RADIO_State_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_GW_DiagInfo */
/*****************************************************************************/
#define CBR_C_SIG_RX_GW_DiagInfo_NUM_CALLBACK                            3
#define CBR_C_SIG_RX_GW_DiagInfo_DistanceTotalizer_MM_NUM_CALLBACK       3
#define CBR_C_SIG_RX_GW_DiagInfo_NetworkDiag_MM_NUM_CALLBACK             3
#define CBR_C_SIG_RX_GW_DiagInfo_ApplicationDiag_MM_NUM_CALLBACK         3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_DiagInfo[ CBR_C_SIG_RX_GW_DiagInfo_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL,NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_DiagInfo_DistanceTotalizer_MM[ CBR_C_SIG_RX_GW_DiagInfo_DistanceTotalizer_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_DiagInfo_NetworkDiag_MM[ CBR_C_SIG_RX_GW_DiagInfo_NetworkDiag_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_DiagInfo_ApplicationDiag_MM[ CBR_C_SIG_RX_GW_DiagInfo_ApplicationDiag_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_DiagInfo[ CBR_C_SIG_RX_GW_DiagInfo_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_DiagInfo_DistanceTotalizer_MM[ CBR_C_SIG_RX_GW_DiagInfo_DistanceTotalizer_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_DiagInfo_NetworkDiag_MM[ CBR_C_SIG_RX_GW_DiagInfo_NetworkDiag_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_DiagInfo_ApplicationDiag_MM[ CBR_C_SIG_RX_GW_DiagInfo_ApplicationDiag_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_GW_DiagInfoSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_DiagInfo*8), CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_DiagInfo_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_DiagInfo }, /* GW_DiagInfo */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7, 28),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_DiagInfo_DistanceTotalizer_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_DiagInfo_DistanceTotalizer_MM }, /* DistanceTotalizer_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 32,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_DiagInfo_NetworkDiag_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_DiagInfo_NetworkDiag_MM }, /* NetworkDiag_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 34,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_DiagInfo_ApplicationDiag_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_DiagInfo_ApplicationDiag_MM }, /* ApplicationDiag_MM */
#else
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_DiagInfo*8), CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_DiagInfo_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_DiagInfo }, /* GW_DiagInfo */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7, 28),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_DiagInfo_DistanceTotalizer_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_DiagInfo_DistanceTotalizer_MM }, /* DistanceTotalizer_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 32,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_DiagInfo_NetworkDiag_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_DiagInfo_NetworkDiag_MM }, /* NetworkDiag_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 34,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_DiagInfo_ApplicationDiag_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_DiagInfo_ApplicationDiag_MM }, /* ApplicationDiag_MM */
#endif
};
const BYTE cbr_aubRX_GW_DiagInfo_DefaultData[] = {0,0,0,0,0,0,0,0};
const BYTE cbr_aubRX_GW_DiagInfo_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_GW_DiagInfo =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_GW_DiagInfoSignals),
/* prSignals */                 cbr_aubRX_GW_DiagInfoSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_GW_DiagInfo_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_GW_DiagInfo_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};


/*****************************************************************************/
/* RX_GW_RadioInfo */
/*****************************************************************************/

#define CBR_C_SIG_RX_GW_RadioInfo_NUM_CALLBACK                             3
#define CBR_C_SIG_RX_GW_RadioInfo_VehicleID_MM_NUM_CALLBACK                3
#define CBR_C_SIG_RX_GW_RadioInfo_VehicleSpeed_MM_NUM_CALLBACK             3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_RadioInfo[ CBR_C_SIG_RX_GW_RadioInfo_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL,NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_RadioInfo_VehicleID_MM[ CBR_C_SIG_RX_GW_RadioInfo_VehicleID_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_RadioInfo_VehicleSpeed_MM[ CBR_C_SIG_RX_GW_RadioInfo_VehicleSpeed_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_RadioInfo[ CBR_C_SIG_RX_GW_RadioInfo_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_RadioInfo_VehicleID_MM[ CBR_C_SIG_RX_GW_RadioInfo_VehicleID_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_RadioInfo_VehicleSpeed_MM[ CBR_C_SIG_RX_GW_RadioInfo_VehicleSpeed_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_GW_RadioInfoSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_RadioInfo*8), CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RadioInfo_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RadioInfo }, /* GW_RadioInfo */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 23, 32),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RadioInfo_VehicleID_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RadioInfo_VehicleID_MM }, /* VehicleID_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RadioInfo_VehicleSpeed_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RadioInfo_VehicleSpeed_MM }, /* VehicleSpeed_MM */
#else
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_RadioInfo*8), CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RadioInfo_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RadioInfo }, /* GW_RadioInfo */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 23, 32),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RadioInfo_VehicleID_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RadioInfo_VehicleID_MM }, /* VehicleID_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_RadioInfo_VehicleSpeed_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_RadioInfo_VehicleSpeed_MM }, /* VehicleSpeed_MM */
#endif
};
const BYTE cbr_aubRX_GW_RadioInfo_DefaultData[] = {0,0,0,0,0,0,0,0};
const BYTE cbr_aubRX_GW_RadioInfo_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_GW_RadioInfo =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_GW_RadioInfoSignals),
/* prSignals */                 cbr_aubRX_GW_RadioInfoSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_GW_RadioInfo_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_GW_RadioInfo_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_GW_MMI_Info1 */
/*****************************************************************************/
#define CBR_C_SIG_RX_GW_MMI_Info1_NUM_CALLBACK                                     3
#define CBR_C_SIG_RX_GW_MMI_Info1_RoofOpenningState_MM_NUM_CALLBACK                3
#define CBR_C_SIG_RX_GW_MMI_Info1_HVBatteryLow_MM_NUM_CALLBACK                     3
#define CBR_C_SIG_RX_GW_MMI_Info1_SoundCommand_NUM_CALLBACK                        3
#define CBR_C_SIG_RX_GW_MMI_Info1_TemperatureUnit_NUM_CALLBACK                     3
#define CBR_C_SIG_RX_GW_MMI_Info1_SingleDoorOpeningActivationState_NUM_CALLBACK    3
#define CBR_C_SIG_RX_GW_MMI_Info1_RearLeftDoorOpenWarning_MM_NUM_CALLBACK          3
#define CBR_C_SIG_RX_GW_MMI_Info1_RearRightDoorOpenWarning_MM_NUM_CALLBACK         3
#define CBR_C_SIG_RX_GW_MMI_Info1_AutomaticLockUpActivationState_NUM_CALLBACK      3
#define CBR_C_SIG_RX_GW_MMI_Info1_RearWiperStatus_MM_NUM_CALLBACK                  3
#define CBR_C_SIG_RX_GW_MMI_Info1_FrontRightDoorOpenWarning_MM_NUM_CALLBACK        3
#define CBR_C_SIG_RX_GW_MMI_Info1_FrontLeftDoorOpenWarning_MM_NUM_CALLBACK         3
#define CBR_C_SIG_RX_GW_MMI_Info1_LowBatteryWarning_MM_NUM_CALLBACK                3
#define CBR_C_SIG_RX_GW_MMI_Info1_LightSensorStatus_MM_NUM_CALLBACK                3
#define CBR_C_SIG_RX_GW_MMI_Info1_DayNightStatus_MM_NUM_CALLBACK                   3
#define CBR_C_SIG_RX_GW_MMI_Info1_DisplayActivation_NUM_CALLBACK                   3
#define CBR_C_SIG_RX_GW_MMI_Info1_TemperatureValue_NUM_CALLBACK                    3
#define CBR_C_SIG_RX_GW_MMI_Info1_DimmingValue_NUM_CALLBACK                        3

#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1[ CBR_C_SIG_RX_GW_MMI_Info1_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL,NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_RoofOpenningState_MM[ CBR_C_SIG_RX_GW_MMI_Info1_RoofOpenningState_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_HVBatteryLow_MM[ CBR_C_SIG_RX_GW_MMI_Info1_HVBatteryLow_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_SoundCommand[ CBR_C_SIG_RX_GW_MMI_Info1_SoundCommand_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_TemperatureUnit[ CBR_C_SIG_RX_GW_MMI_Info1_TemperatureUnit_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_SingleDoorOpeningActivationState[ CBR_C_SIG_RX_GW_MMI_Info1_SingleDoorOpeningActivationState_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_RearLeftDoorOpenWarning_MM[ CBR_C_SIG_RX_GW_MMI_Info1_RearLeftDoorOpenWarning_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_RearRightDoorOpenWarning_MM[ CBR_C_SIG_RX_GW_MMI_Info1_RearRightDoorOpenWarning_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_AutomaticLockUpActivationState[ CBR_C_SIG_RX_GW_MMI_Info1_AutomaticLockUpActivationState_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_RearWiperStatus_MM[ CBR_C_SIG_RX_GW_MMI_Info1_RearWiperStatus_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_FrontRightDoorOpenWarning_MM[ CBR_C_SIG_RX_GW_MMI_Info1_FrontRightDoorOpenWarning_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_FrontLeftDoorOpenWarning_MM[ CBR_C_SIG_RX_GW_MMI_Info1_FrontLeftDoorOpenWarning_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_LowBatteryWarning_MM[ CBR_C_SIG_RX_GW_MMI_Info1_LowBatteryWarning_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_LightSensorStatus_MM[ CBR_C_SIG_RX_GW_MMI_Info1_LightSensorStatus_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_DayNightStatus_MM[ CBR_C_SIG_RX_GW_MMI_Info1_DayNightStatus_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_DisplayActivation[ CBR_C_SIG_RX_GW_MMI_Info1_DisplayActivation_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_TemperatureValue[ CBR_C_SIG_RX_GW_MMI_Info1_TemperatureValue_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info1_DimmingValue[ CBR_C_SIG_RX_GW_MMI_Info1_DimmingValue_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1[ CBR_C_SIG_RX_GW_MMI_Info1_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_RoofOpenningState_MM[ CBR_C_SIG_RX_GW_MMI_Info1_RoofOpenningState_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_HVBatteryLow_MM[ CBR_C_SIG_RX_GW_MMI_Info1_HVBatteryLow_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_SoundCommand[ CBR_C_SIG_RX_GW_MMI_Info1_SoundCommand_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_TemperatureUnit[ CBR_C_SIG_RX_GW_MMI_Info1_TemperatureUnit_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_SingleDoorOpeningActivationState[ CBR_C_SIG_RX_GW_MMI_Info1_SingleDoorOpeningActivationState_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_RearLeftDoorOpenWarning_MM[ CBR_C_SIG_RX_GW_MMI_Info1_RearLeftDoorOpenWarning_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_RearRightDoorOpenWarning_MM[ CBR_C_SIG_RX_GW_MMI_Info1_RearRightDoorOpenWarning_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_AutomaticLockUpActivationState[ CBR_C_SIG_RX_GW_MMI_Info1_AutomaticLockUpActivationState_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_RearWiperStatus_MM[ CBR_C_SIG_RX_GW_MMI_Info1_RearWiperStatus_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_FrontRightDoorOpenWarning_MM[ CBR_C_SIG_RX_GW_MMI_Info1_FrontRightDoorOpenWarning_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_FrontLeftDoorOpenWarning_MM[ CBR_C_SIG_RX_GW_MMI_Info1_FrontLeftDoorOpenWarning_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_LowBatteryWarning_MM[ CBR_C_SIG_RX_GW_MMI_Info1_LowBatteryWarning_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_LightSensorStatus_MM[ CBR_C_SIG_RX_GW_MMI_Info1_LightSensorStatus_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_DayNightStatus_MM[ CBR_C_SIG_RX_GW_MMI_Info1_DayNightStatus_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_DisplayActivation[ CBR_C_SIG_RX_GW_MMI_Info1_DisplayActivation_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_TemperatureValue[ CBR_C_SIG_RX_GW_MMI_Info1_TemperatureValue_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info1_DimmingValue[ CBR_C_SIG_RX_GW_MMI_Info1_DimmingValue_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_GW_MMI_Info1Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_MMI_Info1*8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1 }, /* GW_MMI_Info1 */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 49,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_RoofOpenningState_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_RoofOpenningState_MM }, /* RoofOpenningState_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 50,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_HVBatteryLow_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_HVBatteryLow_MM }, /* HVBatteryLow_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 42,  3),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_SoundCommand_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_SoundCommand }, /* SoundCommand */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 39,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_TemperatureUnit_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_TemperatureUnit }, /* TemperatureUnit */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 63,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_SingleDoorOpeningActivationState_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_SingleDoorOpeningActivationState }, /* SingleDoorOpeningActivationState */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 53,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_RearLeftDoorOpenWarning_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_RearLeftDoorOpenWarning_MM }, /* RearLeftDoorOpenWarning_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 55,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_RearRightDoorOpenWarning_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_RearRightDoorOpenWarning_MM }, /* RearRightDoorOpenWarning_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 44,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_AutomaticLockUpActivationState_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_AutomaticLockUpActivationState }, /* AutomaticLockUpActivationState */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 46,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_RearWiperStatus_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_RearWiperStatus_MM }, /* RearWiperStatus_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 30,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_FrontRightDoorOpenWarning_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_FrontRightDoorOpenWarning_MM }, /* FrontRightDoorOpenWarning_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 28,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_FrontLeftDoorOpenWarning_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_FrontLeftDoorOpenWarning_MM }, /* FrontLeftDoorOpenWarning_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 37,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_LowBatteryWarning_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_LowBatteryWarning_MM }, /* LowBatteryWarning_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  5,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_LightSensorStatus_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_LightSensorStatus_MM }, /* LightSensorStatus_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  3,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_DayNightStatus_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_DayNightStatus_MM }, /* DayNightStatus_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  1,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_DisplayActivation_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_DisplayActivation }, /* DisplayActivation */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 23,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_TemperatureValue_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_TemperatureValue }, /* TemperatureValue */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 15,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_DimmingValue_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_DimmingValue }, /* DimmingValue */
#else
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_MMI_Info1*8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1 }, /* GW_MMI_Info1 */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 49,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_RoofOpenningState_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_RoofOpenningState_MM }, /* RoofOpenningState_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 50,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_HVBatteryLow_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_HVBatteryLow_MM }, /* HVBatteryLow_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 42,  3),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_SoundCommand_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_SoundCommand }, /* SoundCommand */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 39,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_TemperatureUnit_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_TemperatureUnit }, /* TemperatureUnit */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 63,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_SingleDoorOpeningActivationState_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_SingleDoorOpeningActivationState }, /* SingleDoorOpeningActivationState */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 53,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_RearLeftDoorOpenWarning_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_RearLeftDoorOpenWarning_MM }, /* RearLeftDoorOpenWarning_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 55,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_RearRightDoorOpenWarning_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_RearRightDoorOpenWarning_MM }, /* RearRightDoorOpenWarning_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 44,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_AutomaticLockUpActivationState_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_AutomaticLockUpActivationState }, /* AutomaticLockUpActivationState */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 46,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_RearWiperStatus_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_RearWiperStatus_MM }, /* RearWiperStatus_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 30,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_FrontRightDoorOpenWarning_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_FrontRightDoorOpenWarning_MM }, /* FrontRightDoorOpenWarning_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 28,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_FrontLeftDoorOpenWarning_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_FrontLeftDoorOpenWarning_MM }, /* FrontLeftDoorOpenWarning_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 37,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_LowBatteryWarning_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_LowBatteryWarning_MM }, /* LowBatteryWarning_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  5,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_LightSensorStatus_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_LightSensorStatus_MM }, /* LightSensorStatus_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  3,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_DayNightStatus_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_DayNightStatus_MM }, /* DayNightStatus_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  1,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_DisplayActivation_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_DisplayActivation }, /* DisplayActivation */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 23,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_TemperatureValue_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_TemperatureValue }, /* TemperatureValue */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 15,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info1_DimmingValue_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info1_DimmingValue }, /* DimmingValue */
#endif
};
const BYTE cbr_aubRX_GW_MMI_Info1_DefaultData[] = {0,0,0,0,0,0,0,0};
const BYTE cbr_aubRX_GW_MMI_Info1_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_GW_MMI_Info1 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_GW_MMI_Info1Signals),
/* prSignals */                 cbr_aubRX_GW_MMI_Info1Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_GW_MMI_Info1_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_GW_MMI_Info1_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_GW_SEND */
/*****************************************************************************/
#define CBR_C_SIG_RX_GW_SEND_NUM_CALLBACK                                    3
#define CBR_C_SIG_RX_GW_SEND_VehicleOutsideLockedState_MM_NUM_CALLBACK       3
#define CBR_C_SIG_RX_GW_SEND_UnballastRequest_MM_NUM_CALLBACK                3
#define CBR_C_SIG_RX_GW_SEND_SelectiveWakeUpType_MM_NUM_CALLBACK             3
#define CBR_C_SIG_RX_GW_SEND_MM_WakeUpSleepCommand_NUM_CALLBACK              3
#define CBR_C_SIG_RX_GW_SEND_IgnitionSupplyConfirmation_NUM_CALLBACK         3
#define CBR_C_SIG_RX_GW_SEND_StopAutoState_MM_NUM_CALLBACK                   3
#define CBR_C_SIG_RX_GW_SEND_WakeUpType_MM_NUM_CALLBACK                      3
#define CBR_C_SIG_RX_GW_SEND_TechnicalWakeUpType_MM_NUM_CALLBACK             3
#define CBR_C_SIG_RX_GW_SEND_WelcomePhaseState_MM_NUM_CALLBACK               3
#define CBR_C_SIG_RX_GW_SEND_VehicleState_MM_NUM_CALLBACK                    3
#define CBR_C_SIG_RX_GW_SEND_Offset_NUM_CALLBACK                             3
#define CBR_C_SIG_RX_GW_SEND_CustomerDeparture_NUM_CALLBACK                  3
#define CBR_C_SIG_RX_GW_SEND_Opcode2_GW_SEND_NUM_CALLBACK                    3
#define CBR_C_SIG_RX_GW_SEND_Dir_NUM_CALLBACK                                3
#define CBR_C_SIG_RX_GW_SEND_SatKey_NUM_CALLBACK                             3
#define CBR_C_SIG_RX_GW_SEND_SatCont_NUM_CALLBACK                            3
#define CBR_C_SIG_RX_GW_SEND_SatLong_NUM_CALLBACK                            3
#define CBR_C_SIG_RX_GW_SEND_WakeUpContext_NUM_CALLBACK                      3
#define CBR_C_SIG_RX_GW_SEND_OnOffAction_NUM_CALLBACK                        3
#define CBR_C_SIG_RX_GW_SEND_Opcode_GW_SEND_NUM_CALLBACK                     3

#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND[ CBR_C_SIG_RX_GW_SEND_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL,NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_VehicleOutsideLockedState_MM[ CBR_C_SIG_RX_GW_SEND_VehicleOutsideLockedState_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_UnballastRequest_MM[ CBR_C_SIG_RX_GW_SEND_UnballastRequest_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_SelectiveWakeUpType_MM[ CBR_C_SIG_RX_GW_SEND_SelectiveWakeUpType_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_MM_WakeUpSleepCommand[ CBR_C_SIG_RX_GW_SEND_MM_WakeUpSleepCommand_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_IgnitionSupplyConfirmation[ CBR_C_SIG_RX_GW_SEND_IgnitionSupplyConfirmation_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_StopAutoState_MM[ CBR_C_SIG_RX_GW_SEND_StopAutoState_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_WakeUpType_MM[ CBR_C_SIG_RX_GW_SEND_WakeUpType_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_TechnicalWakeUpType_MM[ CBR_C_SIG_RX_GW_SEND_TechnicalWakeUpType_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_WelcomePhaseState_MM[ CBR_C_SIG_RX_GW_SEND_WelcomePhaseState_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_VehicleState_MM[ CBR_C_SIG_RX_GW_SEND_VehicleState_MM_NUM_CALLBACK] = { CSM_APL_vIgnitionChg, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_Offset[ CBR_C_SIG_RX_GW_SEND_Offset_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_CustomerDeparture[ CBR_C_SIG_RX_GW_SEND_CustomerDeparture_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_Opcode2_GW_SEND[ CBR_C_SIG_RX_GW_SEND_Opcode2_GW_SEND_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_Dir[ CBR_C_SIG_RX_GW_SEND_Dir_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_SatKey[ CBR_C_SIG_RX_GW_SEND_SatKey_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_SatCont[ CBR_C_SIG_RX_GW_SEND_SatCont_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_SatLong[ CBR_C_SIG_RX_GW_SEND_SatLong_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_WakeUpContext[ CBR_C_SIG_RX_GW_SEND_WakeUpContext_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_OnOffAction[ CBR_C_SIG_RX_GW_SEND_OnOffAction_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_SEND_Opcode_GW_SEND[ CBR_C_SIG_RX_GW_SEND_Opcode_GW_SEND_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND[ CBR_C_SIG_RX_GW_SEND_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_VehicleOutsideLockedState_MM[ CBR_C_SIG_RX_GW_SEND_VehicleOutsideLockedState_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_UnballastRequest_MM[ CBR_C_SIG_RX_GW_SEND_UnballastRequest_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_SelectiveWakeUpType_MM[ CBR_C_SIG_RX_GW_SEND_SelectiveWakeUpType_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_MM_WakeUpSleepCommand[ CBR_C_SIG_RX_GW_SEND_MM_WakeUpSleepCommand_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_IgnitionSupplyConfirmation[ CBR_C_SIG_RX_GW_SEND_IgnitionSupplyConfirmation_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_StopAutoState_MM[ CBR_C_SIG_RX_GW_SEND_StopAutoState_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_WakeUpType_MM[ CBR_C_SIG_RX_GW_SEND_WakeUpType_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_TechnicalWakeUpType_MM[ CBR_C_SIG_RX_GW_SEND_TechnicalWakeUpType_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_WelcomePhaseState_MM[ CBR_C_SIG_RX_GW_SEND_WelcomePhaseState_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_VehicleState_MM[ CBR_C_SIG_RX_GW_SEND_VehicleState_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_Offset[ CBR_C_SIG_RX_GW_SEND_Offset_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_CustomerDeparture[ CBR_C_SIG_RX_GW_SEND_CustomerDeparture_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_Opcode2_GW_SEND[ CBR_C_SIG_RX_GW_SEND_Opcode2_GW_SEND_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_Dir[ CBR_C_SIG_RX_GW_SEND_Dir_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_SatKey[ CBR_C_SIG_RX_GW_SEND_SatKey_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_SatCont[ CBR_C_SIG_RX_GW_SEND_SatCont_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_SatLong[ CBR_C_SIG_RX_GW_SEND_SatLong_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_WakeUpContext[ CBR_C_SIG_RX_GW_SEND_WakeUpContext_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_OnOffAction[ CBR_C_SIG_RX_GW_SEND_OnOffAction_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_SEND_Opcode_GW_SEND[ CBR_C_SIG_RX_GW_SEND_Opcode_GW_SEND_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_GW_SENDSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_SEND*8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND }, /* GW_SEND */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 36,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_VehicleOutsideLockedState_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_VehicleOutsideLockedState_MM }, /* VehicleOutsideLockedState_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 39,  3),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_UnballastRequest_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_UnballastRequest_MM }, /* UnballastRequest_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 29,  3),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_SelectiveWakeUpType_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_SelectiveWakeUpType_MM }, /* SelectiveWakeUpType_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 31,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_MM_WakeUpSleepCommand_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_MM_WakeUpSleepCommand }, /* MM_WakeUpSleepCommand */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 15,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_IgnitionSupplyConfirmation_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_IgnitionSupplyConfirmation }, /* IgnitionSupplyConfirmation */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 14,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_StopAutoState_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_StopAutoState_MM }, /* StopAutoState_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 23,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_WakeUpType_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_WakeUpType_MM }, /* WakeUpType_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 18,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_TechnicalWakeUpType_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_TechnicalWakeUpType_MM }, /* TechnicalWakeUpType_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 16,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_WelcomePhaseState_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_WelcomePhaseState_MM }, /* WelcomePhaseState_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 21,  3),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_VehicleState_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_VehicleState_MM }, /* VehicleState_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 21,  6),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_Offset_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_Offset }, /* Offset */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 12,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_CustomerDeparture_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_CustomerDeparture }, /* CustomerDeparture */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 15,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_Opcode2_GW_SEND_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_Opcode2_GW_SEND }, /* Opcode2_GW_SEND */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 22,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_Dir_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_Dir }, /* Dir */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 21,  6),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_SatKey_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_SatKey }, /* SatKey */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 22,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_SatCont_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_SatCont }, /* SatCont */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 23,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_SatLong_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_SatLong }, /* SatLong */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  9,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_WakeUpContext_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_WakeUpContext }, /* WakeUpContext */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 10,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_OnOffAction_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_OnOffAction }, /* OnOffAction */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_Opcode_GW_SEND_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_Opcode_GW_SEND }, /* Opcode_GW_SEND */
#else
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_SEND*8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND }, /* GW_SEND */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 36,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_VehicleOutsideLockedState_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_VehicleOutsideLockedState_MM }, /* VehicleOutsideLockedState_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 39,  3),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_UnballastRequest_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_UnballastRequest_MM }, /* UnballastRequest_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 29,  3),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_SelectiveWakeUpType_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_SelectiveWakeUpType_MM }, /* SelectiveWakeUpType_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 31,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_MM_WakeUpSleepCommand_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_MM_WakeUpSleepCommand }, /* MM_WakeUpSleepCommand */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 15,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_IgnitionSupplyConfirmation_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_IgnitionSupplyConfirmation }, /* IgnitionSupplyConfirmation */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 14,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_StopAutoState_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_StopAutoState_MM }, /* StopAutoState_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 23,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_WakeUpType_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_WakeUpType_MM }, /* WakeUpType_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 18,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_TechnicalWakeUpType_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_TechnicalWakeUpType_MM }, /* TechnicalWakeUpType_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 16,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_WelcomePhaseState_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_WelcomePhaseState_MM }, /* WelcomePhaseState_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 21,  3),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_VehicleState_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_VehicleState_MM }, /* VehicleState_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 21,  6),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_Offset_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_Offset }, /* Offset */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 12,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_CustomerDeparture_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_CustomerDeparture }, /* CustomerDeparture */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 15,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_Opcode2_GW_SEND_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_Opcode2_GW_SEND }, /* Opcode2_GW_SEND */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 22,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_Dir_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_Dir }, /* Dir */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 21,  6),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_SatKey_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_SatKey }, /* SatKey */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 22,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_SatCont_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_SatCont }, /* SatCont */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 23,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_SatLong_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_SatLong }, /* SatLong */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  9,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_WakeUpContext_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_WakeUpContext }, /* WakeUpContext */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 10,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_OnOffAction_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_OnOffAction }, /* OnOffAction */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_SEND_Opcode_GW_SEND_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_SEND_Opcode_GW_SEND }, /* Opcode_GW_SEND */
#endif
};
const BYTE cbr_aubRX_GW_SEND_DefaultData[] = {0,0,0,0,0,0,0,0};
const BYTE cbr_aubRX_GW_SEND_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_GW_SEND =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_GW_SENDSignals),
/* prSignals */                 cbr_aubRX_GW_SENDSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_GW_SEND_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_GW_SEND_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_GW_Chassis_Data3 */
/*****************************************************************************/
#define CBR_C_SIG_RX_GW_Chassis_Data3_NUM_CALLBACK                              3
#define CBR_C_SIG_RX_GW_Chassis_Data3_AccurateOdometer_MM_NUM_CALLBACK          3
#define CBR_C_SIG_RX_GW_Chassis_Data3_ClimateCoolingRequest_MM_NUM_CALLBACK     3
#define CBR_C_SIG_RX_GW_Chassis_Data3_GearLeverPosition_MM_NUM_CALLBACK         3
#define CBR_C_SIG_RX_GW_Chassis_Data3_EngineStatus_R_MM_NUM_CALLBACK            3
#define CBR_C_SIG_RX_GW_Chassis_Data3_ABSinRegulation_MM_NUM_CALLBACK           3
#define CBR_C_SIG_RX_GW_Chassis_Data3_EngineAirTemp_MM_NUM_CALLBACK             3
#define CBR_C_SIG_RX_GW_Chassis_Data3_EngineCoolantTemp_MM_NUM_CALLBACK         3
#define CBR_C_SIG_RX_GW_Chassis_Data3_BrakingPressure_MM_NUM_CALLBACK           3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_Chassis_Data3[ CBR_C_SIG_RX_GW_Chassis_Data3_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL,NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_Chassis_Data3_AccurateOdometer_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_AccurateOdometer_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_Chassis_Data3_ClimateCoolingRequest_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_ClimateCoolingRequest_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_Chassis_Data3_GearLeverPosition_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_GearLeverPosition_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_Chassis_Data3_EngineStatus_R_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_EngineStatus_R_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_Chassis_Data3_ABSinRegulation_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_ABSinRegulation_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_Chassis_Data3_EngineAirTemp_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_EngineAirTemp_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_Chassis_Data3_EngineCoolantTemp_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_EngineCoolantTemp_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_Chassis_Data3_BrakingPressure_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_BrakingPressure_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_Chassis_Data3[ CBR_C_SIG_RX_GW_Chassis_Data3_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_Chassis_Data3_AccurateOdometer_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_AccurateOdometer_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_Chassis_Data3_ClimateCoolingRequest_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_ClimateCoolingRequest_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_Chassis_Data3_GearLeverPosition_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_GearLeverPosition_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_Chassis_Data3_EngineStatus_R_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_EngineStatus_R_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_Chassis_Data3_ABSinRegulation_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_ABSinRegulation_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_Chassis_Data3_EngineAirTemp_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_EngineAirTemp_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_Chassis_Data3_EngineCoolantTemp_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_EngineCoolantTemp_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_Chassis_Data3_BrakingPressure_MM[ CBR_C_SIG_RX_GW_Chassis_Data3_BrakingPressure_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_GW_Chassis_Data3Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_Chassis_Data3*8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3 }, /* GW_Chassis_Data3 */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 24,  5),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_AccurateOdometer_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_AccurateOdometer_MM }, /* AccurateOdometer_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 25,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_ClimateCoolingRequest_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_ClimateCoolingRequest_MM }, /* ClimateCoolingRequest_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 29,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_GearLeverPosition_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_GearLeverPosition_MM }, /* GearLeverPosition_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 31,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_EngineStatus_R_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_EngineStatus_R_MM }, /* EngineStatus_R_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 16,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_ABSinRegulation_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_ABSinRegulation_MM }, /* ABSinRegulation_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 23,  7),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_EngineAirTemp_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_EngineAirTemp_MM }, /* EngineAirTemp_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 15,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_EngineCoolantTemp_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_EngineCoolantTemp_MM }, /* EngineCoolantTemp_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_BrakingPressure_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_BrakingPressure_MM }, /* BrakingPressure_MM */
#else
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  CSM_C_DLC_GW_Chassis_Data3*8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3 }, /* GW_Chassis_Data3 */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 24,  5),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_AccurateOdometer_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_AccurateOdometer_MM }, /* AccurateOdometer_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 25,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_ClimateCoolingRequest_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_ClimateCoolingRequest_MM }, /* ClimateCoolingRequest_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 29,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_GearLeverPosition_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_GearLeverPosition_MM }, /* GearLeverPosition_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 31,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_EngineStatus_R_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_EngineStatus_R_MM }, /* EngineStatus_R_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 16,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_ABSinRegulation_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_ABSinRegulation_MM }, /* ABSinRegulation_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 23,  7),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_EngineAirTemp_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_EngineAirTemp_MM }, /* EngineAirTemp_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL( 15,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_EngineCoolantTemp_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_EngineCoolantTemp_MM }, /* EngineCoolantTemp_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_Chassis_Data3_BrakingPressure_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_Chassis_Data3_BrakingPressure_MM }, /* BrakingPressure_MM */
#endif
};
const BYTE cbr_aubRX_GW_Chassis_Data3_DefaultData[] = {0,0,0,0,0,0,0,0};
const BYTE cbr_aubRX_GW_Chassis_Data3_TimeoutData[] = {0xFF,0xFF,0xFE,0x3D,0xF0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_GW_Chassis_Data3 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_GW_Chassis_Data3Signals),
/* prSignals */                 cbr_aubRX_GW_Chassis_Data3Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_GW_Chassis_Data3_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_GW_Chassis_Data3_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};


/* RX_GW_MMI_Info3 */
/*****************************************************************************/
#define CBR_C_SIG_RX_GW_MMI_Info3_NUM_CALLBACK                                  3
#define CBR_C_SIG_RX_GW_MMI_Info3_SteeringPushToTalkCommand_MM_NUM_CALLBACK     3
#define CBR_C_SIG_RX_GW_MMI_Info3_ExternalTempRaw_MM_NUM_CALLBACK               3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info3[ CBR_C_SIG_RX_GW_MMI_Info3_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL,NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info3_SteeringPushToTalkCommand_MM[ CBR_C_SIG_RX_GW_MMI_Info3_SteeringPushToTalkCommand_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_GW_MMI_Info3_ExternalTempRaw_MM[ CBR_C_SIG_RX_GW_MMI_Info3_ExternalTempRaw_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info3[ CBR_C_SIG_RX_GW_MMI_Info3_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info3_SteeringPushToTalkCommand_MM[ CBR_C_SIG_RX_GW_MMI_Info3_SteeringPushToTalkCommand_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_GW_MMI_Info3_ExternalTempRaw_MM[ CBR_C_SIG_RX_GW_MMI_Info3_ExternalTempRaw_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_GW_MMI_Info3Signals[] =
{
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7, CSM_C_DLC_GW_MMI_Info3*8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info3_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info3 }, /* GW_MMI_Info3 */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  8,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info3_SteeringPushToTalkCommand_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info3_SteeringPushToTalkCommand_MM }, /* SteeringPushToTalkCommand_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info3_ExternalTempRaw_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info3_ExternalTempRaw_MM }, /* ExternalTempRaw_MM */
#else
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7, CSM_C_DLC_GW_MMI_Info3*8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info3_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info3 }, /* GW_MMI_Info3 */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  8,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info3_SteeringPushToTalkCommand_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info3_SteeringPushToTalkCommand_MM }, /* SteeringPushToTalkCommand_MM */
  {CBR_CONVERT_VECTOR_DBC_BIG_SIGNAL(  7,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_GW_MMI_Info3_ExternalTempRaw_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_GW_MMI_Info3_ExternalTempRaw_MM }, /* ExternalTempRaw_MM */
#endif
};
const BYTE cbr_aubRX_GW_MMI_Info3_DefaultData[] = {0,0};
const BYTE cbr_aubRX_GW_MMI_Info3_TimeoutData[] = {0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_GW_MMI_Info3 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_GW_MMI_Info3Signals),
/* prSignals */                 cbr_aubRX_GW_MMI_Info3Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_GW_MMI_Info3_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_GW_MMI_Info3_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

const CSM_CBR_TX csm_arCbrTxTelegram_Slot0 [CBR_TX_MAX_NUMBER_SLOT0]=
{
/*
     bus,                  id ,                 dlc             pointer to data buffer,               message type,                   cycle time      number of repetitions      minimum distance  delay
*/
CSM_C_CAN_BUS_VCAN, MK_ID(0x5d8),  CSM_C_DLC_ITM_State,         cbr_aubTX_ITM_State_TelData,         CBR_TMSG_CYCLIC_AND_SPONTAN,         500,             0,                        50,              0,

} ;


/* ------------------------------------------------------------------------- */
const CSM_TELEGRAM* const cbr_arTxTelegramIndex_Slot0[CBR_TX_MAX_NUMBER_SLOT0] =
{
   &cbr_aubTX_ITM_State,
 };


const CSM_CBR_RX csm_arCbrRxTelegram_Slot0[CBR_RX_MAX_NUMBER_SLOT0] = {
/* The remote approach uses dlc and message type from this array, */
/* therefore correct IDs, message types and timeouts not necessary */

/*        Bus               ID               dlc,                          address of data buffer,                   message type,                       timeout time */
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x406), CSM_C_DLC_MFD_PrivacyReset,          &cbr_aubRX_MFD_PrivacyReset_TelData,       CBR_TMSG_CYCLIC_AND_SPONTAN,            2000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x58d), CSM_C_DLC_GW_SpeedData,              &cbr_aubRX_GW_SpeedData_TelData,           CBR_TMSG_CYCLIC,                        2000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x58c), CSM_C_DLC_GW_Chassis_Data2,          &cbr_aubRX_GW_Chassis_Data2_TelData,       CBR_TMSG_CYCLIC,                        2000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x5a8), CSM_C_DLC_GW_RearCamInfo,            &cbr_aubRX_GW_RearCamInfo_TelData,         CBR_TMSG_CYCLIC,                        2000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x548), CSM_C_DLC_GW_PositionInfo,           &cbr_aubRX_GW_PositionInfo_TelData,        CBR_TMSG_CYCLIC,                        2000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x5b8), CSM_C_DLC_RADIO_State,               &cbr_aubRX_RADIO_State_TelData,            CBR_TMSG_CYCLIC,                        2000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x578), CSM_C_DLC_GW_DiagInfo,               &cbr_aubRX_GW_DiagInfo_TelData,            CBR_TMSG_CYCLIC,                        2000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x568), CSM_C_DLC_GW_RadioInfo,              &cbr_aubRX_GW_RadioInfo_TelData,           CBR_TMSG_CYCLIC,                        2000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x558), CSM_C_DLC_GW_MMI_Info1,              &cbr_aubRX_GW_MMI_Info1_TelData,           CBR_TMSG_CYCLIC_AND_SPONTAN,            2000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x58f), CSM_C_DLC_GW_SEND,                   &cbr_aubRX_GW_SEND_TelData,                CBR_TMSG_CYCLIC_AND_SPONTAN,            2000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x590), CSM_C_DLC_GW_Chassis_Data3,          &cbr_aubRX_GW_Chassis_Data3_TelData,       CBR_TMSG_CYCLIC_AND_SPONTAN,            2000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x560), CSM_C_DLC_GW_MMI_Info3,              &cbr_aubRX_GW_MMI_Info3_TelData,           CBR_TMSG_CYCLIC_AND_SPONTAN,            2000 },
};


/* ------------------------------------------------------------------------- */
const CSM_TELEGRAM* const cbr_arRxTelegramIndex_Slot0[CBR_RX_MAX_NUMBER_SLOT0] =
{
  &cbr_aubRX_MFD_PrivacyReset,
  &cbr_aubRX_GW_SpeedData,
  &cbr_aubRX_GW_Chassis_Data2,
  &cbr_aubRX_GW_RearCamInfo,
  &cbr_aubRX_GW_PositionInfo,
  &cbr_aubRX_RADIO_State,
  &cbr_aubRX_GW_DiagInfo,
  &cbr_aubRX_GW_RadioInfo,
  &cbr_aubRX_GW_MMI_Info1,
  &cbr_aubRX_GW_SEND,
  &cbr_aubRX_GW_Chassis_Data3,
  &cbr_aubRX_GW_MMI_Info3,
};




#endif /* CBR_SELF */

/*****************************************************************************/
/* CNP_ITP */
/*****************************************************************************/
#if (CSM_S_ISO_TP == CSM_C_F_ON)

/*#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
extern const tCSM_ISO_TP_USDT_APPL_CALLBACK_ADMIN csm_itp_arCallbackFkt[ CSM_C_ISO_TP_MAX_CONNECTIONS];
#else
extern tCSM_ISO_TP_USDT_APPL_CALLBACK_ADMIN csm_itp_arCallbackFkt[ CSM_C_ISO_TP_MAX_CONNECTIONS];
#endif

#ifdef CSM_ITP_SELF

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)

const tCSM_ISO_TP_USDT_APPL_CALLBACK_ADMIN csm_itp_arCallbackFkt[ CSM_C_ISO_TP_MAX_CONNECTIONS] =
{
   {
      NULL, NULL, CCS_NP_vCSMMsgCon, CCS_NP_vCSMMsgReceived, CCS_NP_vCSMDataErrorInd
   },
   {
      NULL, NULL, NULL, NULL
   },
   {
      NULL, NULL, NULL, NULL
   }
};
#else
tCSM_ISO_TP_USDT_APPL_CALLBACK_ADMIN csm_itp_arCallbackFkt[ CSM_C_ISO_TP_MAX_CONNECTIONS];
#endif

#endif *//* CSM_ITP_SELF */


#endif /* CSM_S_ISO_TP */

#if (CSM_S_ISO_TP == CSM_C_F_ON)
#ifdef CNP_ITP_SELF
/* "malloc" RxAssembly and Tx buffer
 * Take care of channel number and length defined above */

BYTE cnp_abAssBufCh0[ CSM_C_USDT_ISO_INF4CV_USDT_ISO_EXTKI_MAX_RX_LENGTH];
BYTE cnp_abTxBufCh0[ CSM_C_USDT_ISO_INF4CV_USDT_ISO_EXTKI_MAX_TX_LENGTH];

BYTE cnp_abAssBufCh1[ CSM_C_USDT_ISO_DTCCT_USDT_ISO_DIAG_MAX_RX_LENGTH];
BYTE cnp_abTxBufCh1[ CSM_C_USDT_ISO_DTCCT_USDT_ISO_DIAG_MAX_TX_LENGTH];

BYTE cnp_abAssBufCh2[ CSM_C_USDT_ISO_INF4CV_USDT_ISO_EXTKI_MAX_RX_LENGTH];
BYTE cnp_abTxBufCh2[ CSM_C_USDT_ISO_INF4CV_USDT_ISO_EXTKI_MAX_TX_LENGTH];


    /* Macros to initialize the buffers (no way found to place CNP_rItpAssRxBuf[0] in ROM) */
#define CNP_M_INIT_ASS_BUF_ARRAY \
                 CNP_rItpAssRxBuf[0].rMsg.pbData=cnp_abAssBufCh0;\
                 CNP_rItpAssRxBuf[1].rMsg.pbData=cnp_abAssBufCh1;\
         CNP_rItpAssRxBuf[2].rMsg.pbData=cnp_abAssBufCh2;\


#define CNP_M_INIT_TX_BUF_ARRAY \
                 CNP_rItpTxBuf[0].rMsg.pbData=cnp_abTxBufCh0;\
                 CNP_rItpTxBuf[1].rMsg.pbData=cnp_abTxBufCh1;\
         CNP_rItpTxBuf[2].rMsg.pbData=cnp_abTxBufCh2;\


#endif /* CNP_ITP_SELF */
#endif /* CSM_S_ISO_TP */


//**************************************************************************************************
//* CBR configuration, variables (Generated code - do NOT change manually !!!)
//**************************************************************************************************
