//**************************************************************************************************
//* defines and macros (scope: CAN stack and application)
//**************************************************************************************************

#define CSM_C_PROJECT_EVOBUS
#define CSM_C_PROJECT_EVOBUSB2E

#define CSM_C_VERSION                                     0x88010001        /**< Verision number Diamler Projects->0x88 Variant->0x01 Version Number->0x0001*/


//**************************************************************************************************
//* PROC CSM Datapool
//**************************************************************************************************
#define CSM_C_ADDRESS_FIELD_DP_SLOT                   0x00
#define CSM_C_ADDRESS_FIELD_DP_STEERING_WHEEL_TYPE    0x01
#define CSM_C_ADDRESS_FIELD_DP_VOICE_REC              0x02
#define CSM_C_ADDRESS_FIELD_DP_FUEL_TYPE              0x03
#define CSM_C_ADDRESS_FIELD_DP_CAMERA_SYSTEM          0x04
#define CSM_C_ADDRESS_FIELD_DP_IPA_HFP                0x05
#define CSM_C_ADDRESS_FIELD_DP_SONAR                  0x06
#define CSM_C_ADDRESS_FIELD_DP_ANTI_THEFT             0x07
#define CSM_C_ADDRESS_FIELD_DP_ANTICIPATORY_LINE      0x08
#define CSM_C_ADDRESS_FIELD_DP_STEERING_MSG           0x09
#define CSM_C_ADDRESS_FIELD_DP_TRAFFIC_SIGN_REC       0x0A
#define CSM_C_ADDRESS_FIELD_DP_NAVI_FUNCTION          0x0B
#define CSM_C_ADDRESS_FIELD_DP_RCSTYPE                0x0C
#define CSM_C_ADDRESS_FIELD_DP_ITCOMMANDERTYPE        0x0D
#define CSM_C_ADDRESS_FIELD_DP_VCANMCAN_GATEWAY       0x0E
#define CSM_C_ADDRESS_FIELD_DP_FUEL_CONSUMPTION_INFO  0x0F
#define CSM_C_ADDRESS_FIELD_DP_TPMS                   0x10
#define CSM_C_ADDRESS_FIELD_DP_VDC                    0x11
#define CSM_C_ADDRESS_FIELD_DP_AD_FUNCTION            0x12
#define CSM_C_ADDRESS_FIELD_DP_VEHICLE_SETTING        0x13
#define CSM_C_ADDRESS_FIELD_DP_HUD_SETTING            0x14
#define CSM_C_ADDRESS_FIELD_DP_HVAC_TYPE              0x15
#define CSM_C_ADDRESS_FIELD_DP_DIGITAL_ASSI           0x16
#define CSM_C_ADDRESS_FIELD_DP_SEND_COUNTRY_INFO      0x17

#define CSM_C_ADDRESS_FIELD_DP_MAX_ITEMS              0x18                // max value used for indexed access in arrays


// ##################################################
// _CSM_SECTION_HISTORY: user specific code start
// ##################################################

/***************************************************************************************************
 * \doxydocu
 * \file          csm_stack_ip_g3inf4cv.h
 * \brief         Project specific part of the interface header(s) of the
 *                CAN stack.
 *
 * \see           CAN-SW Architektur, written by CM-DI
 *
 * \sw_component  CAN stack
 * \project       g3inf4cv
 * \path          /di_can/modules_swa/csm_stack/src/
 *
 * \ingroup       CSM_STACK
 *
 * \authors       Jayashree
 *
 * COPYRIGHT      (c) 2017 Bosch Car Multimedia RBEI
 *
 * \history_begin
 *
 * 05.10.17  \main\rn_aivi_proxy\2  A.Borck
 * - manually changed:
 *   -- Initial Version by porting tcc touch code
 *
 * 24.11.17  main\g3inf4cv_csm_proxy_in\1  Jayashree
 * - Initial version for INF4CV
 *
 **************************************************************************************************/
// ##################################################
// _CSM_SECTION_HISTORY: user specific code end
// ##################################################
