/* Description and history of csm_stack_datatypes.h at the end of the file.   */
#ifndef CSM_STACK_DATATYPES_HEADER
#define CSM_STACK_DATATYPES_HEADER

#include "csm_stack_p.h"   /* include of the basic configuration header (feature
                            * switches).
                            * No further includes allowed. */
#ifdef VASCO_OS_UCOS
  #include "system_types.h"
  #include "osc.h"
#endif

#ifdef WIN32
  #include <stdlib.h>      /* for data type __int64 */
#endif

/*******************************************************************************
 * defines and macros (scope: global)
 ******************************************************************************/

/* CSM API and callback functions modifier */
#if (CSM_S_WINDOWS_DLL == CSM_C_F_ON)
  /* DLL generation -> */
  #if defined (__cplusplus)
    #define DLL_EXPORT extern "C" __declspec (dllexport)  /* DLL Export definition for C++  */
  #else
    #define DLL_EXPORT extern __declspec (dllexport)      /* DLL Export definitions for C   */
  #endif
  #define CSM_API        DLL_EXPORT                       /* Functions are exported by DLL  */
  #define CSM_CALLBACK   __stdcall             /* DLL callback fct. modifier  (->CALLBACK)  */
#else
  /* No DLL generation -> */
  #define CSM_API                   /* Functions exported by standard C object or LIB files */
  #define CSM_CALLBACK                                     /* No specific callback modifier */
#endif

/* The following four macros work with unsigned and signed data types for
 * the parameters w=WORD/SHORT and dw=DWORD/LONG */
#define CSM_M_GET_HIBYTE(w)  ( (BYTE) (((WORD)(w) >> 8) & 0xFF) )  /* for signed values not all systems add 0-Bits */
#define CSM_M_GET_LOBYTE(w)  ( (BYTE) (((WORD)(w)) &  0xFF) )
#define CSM_M_GET_HIWORD(dw) ( (WORD) (((DWORD)(dw) >> 16) & 0xFFFF))  /* for signed values not all systems add 0-Bits */
#define CSM_M_GET_LOWORD(dw) ( (WORD) (((DWORD)(dw)) &  0xFFFF) )

/* The following two macros work with unsigned and signed data types for
 * the parameters HiByte,LoByte=BYTE/CHAR and HiWord,LoWord=WORD/SHORT   */
#define CSM_M_MAKE_WORD(HiByte,LoByte)   ( (WORD)  ( ((WORD) ((BYTE)(HiByte))) << 8  | ((BYTE)(LoByte)) ) )
#define CSM_M_MAKE_DWORD(HiWord,LoWord)  ( (DWORD) ( ((DWORD)((WORD)(HiWord))) << 16 | ((WORD)(LoWord)) ) )


#if (CSM_S_USE_STATIC == CSM_C_F_ON)
  /** "static" keyword for functions and variables enabled (default) */
  #define CSM_STATIC  static
#else
  /** "static" keyword for functions and variables disabled (e.g. for testing) */
  #define CSM_STATIC
#endif

/*******************************************************************************
 * typedefs (scope: global)
 ******************************************************************************/
/*
 * Windows type definitions, used in CAN SW-Architecture and V-Team
 * CAN stack implementation.
 */
#ifndef VASCO_OS_UCOS
typedef unsigned char    BOOLEAN; /*lint !e761 */
#endif
/*typedef unsigned char *  PBOOLEAN;*/

typedef int              BOOL;
/*typedef int *            PBOOL;*/

typedef char             CHAR; /*lint !e761 */
/*typedef char *    PCHAR;*/

typedef unsigned char    BYTE;
typedef unsigned char *  PBYTE;

typedef signed short     SHORT;
/*typedef signed short *   PSHORT;*/

typedef unsigned short int   WORD;
/*typedef unsigned short * PWORD;*/

typedef int              INT; /*lint !e761 */
/*typedef int *            PINT;*/

#ifdef VASCO_OS_NUCLEUS
  typedef int            LONG;
#else
  typedef signed long    LONG;
#endif


/*typedef signed long *    PLONG;*/

typedef unsigned int DWORD;
/*typedef unsigned long *  PDWORD;*/

#ifdef GLB_CAR_RADIO
  /* __int64 not available for GLB_CAR_RADIO */
#else
#if defined(__int64) || defined(WIN32)
  typedef           __int64  LONGLONG;
  typedef unsigned  __int64  ULONGLONG;
#else
  typedef           long long  LONGLONG;
  typedef unsigned  long long  ULONGLONG;

#endif
#endif

#define CONST const

/*lint -e760 -e547*/
#define VOID   void
#define tVoid  void
/*lint +e760 +e547*/

/*typedef void *           HANDLE;*/
//typedef void *           PVOID;
/* #define PVOID void*
* typedef void *PVOID; with typedef Greenhills compiler changes (const PVOID) to (void*)
 * instead of (const void*) */

/*
 * Additional definitions used in CAN SW-Architecture and V-Team
 * CAN stack implementation.
 */

/* These Bit field definitions provide at least the given number of bits
 * (strict ANSI implementation may vaste memory space!) */
#if (CSM_S_ANSI_BITFIELDS == CSM_C_F_ON)
  /* ANSI bit fields (potentially wasting RAM space) */
#define CSM_BITFIELD_TYPE_8    unsigned int
#define CSM_BITFIELD_TYPE_16   unsigned int
#define CSM_BITFIELD_TYPE_32   unsigned int  /* Only applicable for 32 bit systems! */
#else
  /* "Non-ANSI" bit fields (may save RAM space) */
#define CSM_BITFIELD_TYPE_8    BYTE
#define CSM_BITFIELD_TYPE_16   WORD
#define CSM_BITFIELD_TYPE_32   DWORD
#endif


/*
 * ELL type definitions, used additional besides V-Team CAN stack
 * implementation.
 */

/* -- Target-independent types ELL: -- */

#ifndef NULL
#ifdef __cplusplus
#define NULL            0
#else
#define NULL            ( (void*) 0 )
#endif
#endif

/* --FALSE and TRUE should have a type!! */

#ifndef FALSE
#define FALSE            (0) /*(1 == 0)*/
#endif

#ifndef TRUE
#define TRUE             (1) /* replaced (!FALSE) cause of lint warning 506 */
#endif

// __int64 not available for GLB_CAR_RADIO   typedef __int64             LONG64;  /* Vorschlag fr Prfix: l64  -> l64VariableXYZ */
// __int64 not available for GLB_CAR_RADIO   typedef unsigned __int64    ULONG64; /* Vorschlag fr Prfix: ul64  -> ul64VariableXYZ */


#ifdef TSI
  /*
   * UNICODE (Wide Character) types
   */
  typedef unsigned short WCHAR;    /* wc, 16-bit UNICODE character (Windows: wchar_t) */
  typedef WCHAR *PWCHAR;
  typedef WCHAR *LPWCH, *PWCH;
  typedef CONST WCHAR *LPCWCH, *PCWCH;
  typedef WCHAR *NWPSTR;
  typedef WCHAR *LPWSTR, *PWSTR;

  typedef CONST WCHAR *LPCWSTR, *PCWSTR;

  /*
   * ANSI (Multi-byte Character) types
   */
  typedef CHAR *LPCH, *PCH;

  typedef CONST CHAR *LPCCH, *PCCH;
  typedef CHAR *NPSTR;
  typedef CHAR *LPSTR, *PSTR;
  typedef CONST CHAR *LPCSTR, *PCSTR;

  /*
   * Neutral ANSI/UNICODE types and macros
   */
  #ifdef  UNICODE                     /* r_winnt */

    #ifndef _TCHAR_DEFINED
      typedef WCHAR TCHAR, *PTCHAR;
      typedef WCHAR TBYTE , *PTBYTE ;
      #define _TCHAR_DEFINED
    #endif /* !_TCHAR_DEFINED */

    typedef LPWSTR LPTCH, PTCH;
    typedef LPWSTR PTSTR, LPTSTR;
    typedef LPCWSTR LPCTSTR;
    typedef LPWSTR LP;
    #define __TEXT(quote) L##quote      /* r_winnt */

  #else   /* UNICODE */               /* r_winnt */

    #ifndef _TCHAR_DEFINED
      typedef signed char TCHAR, *PTCHAR;
      typedef unsigned char TBYTE , *PTBYTE ;
      #define _TCHAR_DEFINED
    #endif /* !_TCHAR_DEFINED */

    typedef LPSTR LPTCH, PTCH;
    typedef LPSTR PTSTR, LPTSTR;
    typedef LPCSTR LPCTSTR;
    #define __TEXT(quote) quote         /* r_winnt */

  #endif /* UNICODE */                /* r_winnt */
#endif  /* endif TSI */

#if (defined GLB_CAR_RADIO || defined VASCO_OS_UCOS /* ESD-FGS */)
/*
 * ESD type definitions, copy from globals.h
 */

#define irpt __interrupt void

/* csm_stack_esd.c and csm_apl.c include global.h etc.
 * These EAG defined types shall be used instead of the basic C types,
 * whenever a variable of 1..4 signed or unsigned byte(s) is required.
 * Reason :
 * The length of some basic C types is not strictly defined in ANSI C, thus
 * allowing different lengths in different implementations (= compilers).
 * In case of any future changes, only these EAM defined types will have to
 * be changed here, but all the already written C code can remain unchanged.*/
#ifdef CSM_CAN_STACK
#ifndef _GLB_TYPES_H       /* use only, if not already included by ESD file */
typedef unsigned char  bool;      /* 1 byte unsigned, type identifier: bl   */
typedef   signed char  sbyte;     /* 1 byte signed,   type identifier: sb   */
typedef unsigned char  ubyte;     /* 1 byte unsigned, type identifier: ub   */
typedef   signed short sword;     /* 2 byte signed,   type identifier: sw   */
typedef unsigned short uword;     /* 2 byte unsigned, type identifier: uw   */
typedef   signed long  slword;    /* 4 byte signed,   type identifier: slw  */
typedef unsigned long  ulword;    /* 4 byte unsigned, type identifier: ulw  */
#endif /* _GLB_TYPES_H */
/* The following type definitions are Ercosek specific and must not be used
 * for EAG2 Software development. */

/*
typedef unsigned char  bit8;
typedef unsigned short bit16;
typedef unsigned long  bit32;
typedef unsigned int   uint;
typedef signed int     sint;
typedef unsigned char  uint8;
typedef signed char    sint8;
typedef unsigned short uint16;
typedef signed short   sint16;
typedef unsigned long  uint32;
typedef signed long    sint32;
*/

#if (0)
#ifndef _GLB_TYPES_H       /* use only, if not already included by ESD file */
/* Union for Byte and Bit access of an area of 1 Byte length :              */
typedef union
        {
          ubyte bytes;            /* Byte access                            */
          struct                  /* structure (bitfield) for Bit access    */
          {
            #ifdef BITORDER_UP                /* depending on Bitorder      */
              CSM_BITFIELD_TYPE_8 bit0 : 1;         /* LSB first                  */
              CSM_BITFIELD_TYPE_8 bit1 : 1;
              CSM_BITFIELD_TYPE_8 bit2 : 1;
              CSM_BITFIELD_TYPE_8 bit3 : 1;
              CSM_BITFIELD_TYPE_8 bit4 : 1;
              CSM_BITFIELD_TYPE_8 bit5 : 1;
              CSM_BITFIELD_TYPE_8 bit6 : 1;
              CSM_BITFIELD_TYPE_8 bit7 : 1;         /* MSB last                   */
            #else                             /* or */
              CSM_BITFIELD_TYPE_8 bit7 : 1;         /* MSB first                  */
              CSM_BITFIELD_TYPE_8 bit6 : 1;
              CSM_BITFIELD_TYPE_8 bit5 : 1;
              CSM_BITFIELD_TYPE_8 bit4 : 1;
              CSM_BITFIELD_TYPE_8 bit3 : 1;
              CSM_BITFIELD_TYPE_8 bit2 : 1;
              CSM_BITFIELD_TYPE_8 bit1 : 1;
              CSM_BITFIELD_TYPE_8 bit0 : 1;         /* LSB last                   */
            #endif
          }
          bits;                   /* name of structure (bitfield)           */
        }
        breg;


/* Union for Word and Bit access of an area of two Byte length :            */
typedef union
        {
          uword x;                /* Word access                            */
          struct                  /* structure for Byte access              */
          {
            #ifdef BYTEORDER_UP   /* depending on Byteorder                 */
              breg  l;            /* Least significant Byte                 */
              breg  m;            /* Most significant Byte                  */
            #else                 /* or */
              breg  m;            /* Most significant Byte                  */
              breg  l;            /* Least significant Byte                 */
            #endif
          }
          h;                      /* name of structure (h = half)           */
        }
        dbreg;                    /* type name of union                     */



/* Union for Word and Byte access of an area of two Byte length :           */
typedef union
        {
          uword x;                /* Word access                            */
          struct                  /* structure for Byte access              */
          {
            #ifdef BYTEORDER_UP   /* depending on Byteorder                 */
              ubyte l;            /* Least significant Byte                 */
              ubyte m;            /* Most significant Byte                  */
            #else                 /* or */
              ubyte m;            /* Most significant Byte                  */
              ubyte l;            /* Least significant Byte                 */
            #endif
          }
          h;                      /* name of structure (h = half)           */
        }
        dbyte;                    /* type name of union                     */


/* Union for Long, Word and Byte access of an area of 4 Byte length :       */
typedef union
        {
          ulword lx;               /* long word access                      */
          struct                   /* structure for Byte access             */
          {
            #ifdef WORDORDER_UP   /* depending on Wordorder                 */
              dbyte ll;           /* Least significant Word                 */
              dbyte lm;           /* Most significant Word                  */
            #else                 /* or */
              dbyte lm;           /* Most significant Word                  */
              dbyte ll;           /* Least significant Word                 */
            #endif
          }
          lh;                     /* name of structure (h = half)           */
        }
        dword;                    /* type name of union                     */
#endif /* _GLB_TYPES_H */
#endif /* (0) */

#endif /* CSM_CAN_STACK */
#endif /* GLB_CAR_RADIO */

#else
#error csm_stack_datatypes.h included several times
#endif

/*******************************************************************************
 * \doxydocu
 * \file          csm_stack_datatypes.h
 * \brief         Data types for CAN stack.
 *
 *
 * \sw_component  CAN stack
 * \project       Trunc version, mandatory file for all projects.
 * \path          /di_can/modules_swa/csm_stack/src/
 * \ingroup       CSM
 * \ingroup       CSM_STACK
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2003 - 2004 Blaupunkt GmbH
 *
 * \history_begin
 *
 **************** can_datatypes.h
 *
 * 11.02.02  Rev. 0.1 CM-DI/EHS3-Pistoor
 * - Initial Version.
 *
 ****************** csm_datatypes.h
 *
 * 16.04.02  Rev. 1.0 CM-DI/EHS3-K"ohler
 * - Initial revision of csm_datatypes.h
 * - ESD types only #ifndef CSM_STACK_ESD_SELF
 *
 *****************  V-Team PVCS
 *
 * 28.11.03  Rev. 1.0 CM-DI/ESU3-Zurm"uhl, -K"ohler
 * - Initial revision of csm_stack_datatypes.h
 * - HANDLE and PVOID changed from define to typedef.
 * - Defines for DLLs added.
 * - Ifdef _NUCLEUS part removed.
 * - Defines On and OFF removed.
 * - ESD types only ifdef CSM_CAN_STACK.
 *
 * 23.02.04  Rev. 1.1 CM-DI/ESU3-Pr"ohl
 * - Adaptions to vasco os nucleus environment.
 *
 * 24.02.04  Rev. 1.2 CM-DI/ESU3-K"ohler
 * - Adaptions featured with VASCO_OS_NUCLEUS.
 *
 *****************  V-Team ClearCase csm_stack_datatypes.h
 *
 * 14.07.04  Rev. /main/2 CM-DI/ESU3-Zurmuehl
 * - New define CSM_STATIC (switched by CSM_S_USE_STATIC).
 * - Doxygen comments added.
 *
 * 27.07.04  Rev. /main/3 CM-DI/ESU3-Zurmuehl
 * - History comments re-arranged and truncated
 *
 * 09.02.05  /main/4 CM-DI/ESA3-Prhl
 * - tVoid removed.
 *
 * 14.03.05  /main/5 CM-DI/ESA3-Battis
 * - CPP comment deleted
 *
 * 04.05.05  /main/6 CM-DI/Bau400-Sklave
 * -
 *
 * 14.11.05  /main/7 CM-DI/ESA3-Prhl
 * - add switch VASCO_OS_NUCLEUS
 *
 * 29.06.06  /main/8 CM-DI/ESA3-Haffner
 * - __OS_CPU_H__ temp. used to detect FGS
 *  (beautify-ing comes later)
 *
 * ...
 *
 * 13.09.06  /main/12  CM-DI/ESA3-Khler
 * - PVOID now typedef again.
 *
 * 22.09.06  /main/13  CM-DI/ESA3-Haffner
 * - Check for VASCO_OS_UCOS.
 *
 * 13.10.06  /main/14  CM-DI/ESA3-Khler
 * - ELL types, most pointer types and some ESD types removed.
 *
 * 18.10.06  /main/15  CM-DI/ESA3-Khler
 * - PVOID removed.
 *
 * 15.05.07  /main/16  CM-DI/VTeam-Prhl
 * - spaces after # deleted
 *
 * 25.01.08  /main/17  CM-DI/VTeam-Prhl
 * - some lint warnings disabled
 *
 * 13.06.08  /main/18  CM-DI/VTeam-Zurmhl
 * - typedefs for LONGLONG and ULONGLONG added
 *
 * 21.08.08  /main/19  CM-DI/VTeam-Funke
 * - definition of TRUE replaced (!FALSE) by (1) cause of lint warning 506
 * \history_end
 *
 * 17.11.08  /main/20  CM-AI/VTeam-Zurmhl
 * - typedef modified (signed char) -> (char) for CHAR
 *
 * 13.08.09  /main/21  CM-AI/VTeam-Khler
 * - LONGLONG and ULONGLONG not available for GLB_CAR_RADIO.
 *
 * 11.11.09  /main/22  Borck
 * - extended by #include "stdlib.h" for WIN32 platforms to provide type __int64
 *
 * 17.11.11  /main/23  Borck
 * - type __int64 support extended
 *
 * 16.07.15  /main/rn_aivi_proxy/1  Borck
 * - type tU32 added to be able to compile (the SLOT extension)
 *
 * 21.07.15  /main/rn_aivi_proxy/2  Borck
 * - type tU32 removed again, solution in OSEKI by using DWORD instead of
 *
 *//**** END OF FILE *********************************************************/
