#ifndef CSM_STACK_CBR_IP_EVOBUS_HEADER
#define CSM_STACK_CBR_IP_EVOBUS_HEADER
/*****************************************************************************/
/* CBR */
/*****************************************************************************/
/* ------------------------------------------------------------------------- */
/* copy generated CBR defines here */

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
#ifdef CSM_PROXY_SELF
const BYTE csm_arCbrNumberOfRxTelegrams[ CSM_C_MAX_CAN_BUS] =
{
    CBR_RX_MAX_NUMBER  /* Rx telegrams for bus 0 (CAN), value coming from Vector generated il_cfg.h */
};

const BYTE csm_arCbrNumberOfTxTelegrams[ CSM_C_MAX_CAN_BUS] =
{
    CBR_TX_MAX_NUMBER  /* Tx telegrams for bus 0 (CAN) */
};
#else
extern const BYTE csm_arCbrNumberOfRxTelegrams[ CSM_C_MAX_CAN_BUS];
extern const BYTE csm_arCbrNumberOfTxTelegrams[ CSM_C_MAX_CAN_BUS];
#endif /* CSM_PROXY_SELF */
#endif /* CSM_S_REMOTE_STACK == CSM_C_F_ON */

#if (CSM_S_REMOTE_STACK == CSM_C_F_ON)
/* -----------------------------------------------------------------------------
    &&&~ TxSNA macros
 ----------------------------------------------------------------------------- */

#define dbkGetTxSnaActlTrackChr1_Stat        0xFFu
#define dbkGetTxSnaActlTrackChr2_Stat        0xFFu
#define dbkGetTxSnaActlTrackChr3_Stat        0xFFu
#define dbkGetTxSnaActlTrackChr4_Stat        0xFFu
#define dbkGetTxSnaActlTrackChr5_Stat        0xFFu
#define dbkGetTxSnaActlTrackChr6_Stat        0xFFu
#define dbkGetTxSnaActlTrackChr7_Stat        0xFFu
#define dbkGetTxSnaActlTrackChr8_Stat        0xFFu
#define dbkGetTxSnaActlTrack_Pkt             0x00
#define dbkGetTxSnaLatitude_Cval_TCC         0xFFFFFFFFu
#define dbkGetTxSnaLongitude_Cval_TCC        0xFFFFFFFFu
#define dbkGetTxSnaVP_TCC_Pkt                0x00
#define dbkGetTxSnaCompBear_Cval_TCC         0xFFFFu
#define dbkGetTxSnaNavBsdVehSpd_Cval_TCC     0xFFFFu
#define dbkGetTxSnaPitch_Cval_TCC            0xFFFFu
#define dbkGetTxSnaAltitude_Cval_TCC         0xFFFFu
#define dbkGetTxSnaVDS_TCC_Pkt               0x00
#define dbkGetTxSnaTCC_Buttons_Pressed       0xFFu
#define dbkGetTxSnaTCC_Buttons_Receiver      0xFu
#define dbkGetTxSnaTCC_Buttons_Pkt           0x00
#define dbkGetTxSnaPopupInCall_Rq            0x3u
#define dbkGetTxSnaPopupVol_Rq_TCC           0x3u
#define dbkGetTxSnaTCC_Popup_Pkt             0x00
#define dbkGetTxSnaVoiceCtrl_Stat            0x3u
#define dbkGetTxSnaTCC_VoiceCtr_Pkt          0x00
#define dbkGetTxSnaMute_Stat                 0x3u
#define dbkGetTxSnaSelAudSrc_Stat            0xFu
#define dbkGetTxSnaRadio_Stat_cv             0x3u
#define dbkGetTxSnaTCC_Aud_Pkt               0x00
#define dbkGetTxSnaDTC_PL_Stat_TCC           0x3u
#define dbkGetTxSnaDTC_AWL_Stat_TCC          0x3u
#define dbkGetTxSnaDTC_RSL_Stat_TCC          0x3u
#define dbkGetTxSnaDTC_MIL_Stat_TCC          0x3u
#define dbkGetTxSnaDTC_PL_Flash_Stat_TCC     0x3u
#define dbkGetTxSnaDTC_AWL_Flash_Stat_TCC    0x3u
#define dbkGetTxSnaDTC_RSL_Flash_Stat_TCC    0x3u
#define dbkGetTxSnaDTC_MIL_Flash_Stat_TCC    0x3u
#define dbkGetTxSnaDTC_Stat_TCC              0xFFFFFFu
#define dbkGetTxSnaDTC_OccCnt_TCC            0x7Fu
#define dbkGetTxSnaDTC_SPN_ConvMd_TCC        0x0u
#define dbkGetTxSnaDM1_Pkt_TCC               0x00


/* -----------------------------------------------------------------------------
    &&&~ RxSNA macros
 ----------------------------------------------------------------------------- */

#define dbkGetRxSnaSCA_C2Byte0                               0xFFu
#define dbkGetRxSnaSCA_C2Byte1                               0x00u
#define dbkGetRxSnaSCA_C2Byte2                               0x00u
#define dbkGetRxSnaSCA_C2Byte3                               0x00u
#define dbkGetRxSnaSCA_C2Byte4                               0xFFu
#define dbkGetRxSnaSCA_C2Byte5                               0xBFu
#define dbkGetRxSnaSCA_C2Byte6                               0xF0u
#define dbkGetRxSnaSCA_C2Byte7                               dbkGetRxSnaPanelLmpDim_Cval
#define dbkGetRxSnaCGW_VINByte0                              dbkGetRxSnaVIN_Cntr_Stat
#define dbkGetRxSnaCGW_VINByte1                              dbkGetRxSnaVIN_Seg
#define dbkGetRxSnaCGW_VINByte2                              dbkGetRxSnaVIN_Seg2
#define dbkGetRxSnaCGW_VINByte3                              dbkGetRxSnaVIN_Seg3
#define dbkGetRxSnaCGW_VINByte4                              dbkGetRxSnaVIN_Seg4
#define dbkGetRxSnaCGW_VINByte5                              dbkGetRxSnaVIN_Seg5
#define dbkGetRxSnaCGW_VINByte6                              dbkGetRxSnaVIN_Seg6
#define dbkGetRxSnaCGW_VINByte7                              dbkGetRxSnaVIN_Seg7
#define dbkGetRxSnaCGW_GVC8Byte0                             0xFFu
#define dbkGetRxSnaCGW_GVC8Byte1                             0xFFu
#define dbkGetRxSnaCGW_GVC8Byte2                             0xFFu
#define dbkGetRxSnaCGW_GVC8Byte3                             0xFFu
#define dbkGetRxSnaCGW_GVC8Byte4                             0xFFu
#define dbkGetRxSnaCGW_GVC8Byte5                             0xFFu
#define dbkGetRxSnaCGW_GVC8Byte6                             dbkGetRxSnaVMM_VersionYear_Cval
#define dbkGetRxSnaCGW_GVC8Byte7                             dbkGetRxSnaVMM_VersionWeek_Cval
#define dbkGetRxSnaCGW_GVC1Byte0                             0xFFu
#define dbkGetRxSnaCGW_C1Byte0                               dbkGetRxSnaOffboard_Tester_Stat
#define dbkGetRxSnaCGW_C1Byte1                               0xFFu
#define dbkGetRxSnaCGW_C1Byte2                               dbkGetRxSnaSelfHealing2_Stat
#define dbkGetRxSnaCGW_C1Byte3                               dbkGetRxSnaSelfHealing3_Stat
#define dbkGetRxSnaCGW_C1Byte4                               0xFFu
#define dbkGetRxSnaCGW_C1Byte5                               0xFFu
#define dbkGetRxSnaCGW_C1Byte6                               0xFFu
#define dbkGetRxSnaCGW_C1Byte7                               0xFFu
#define dbkGetRxSnaICUC_C1Byte0                              0xFFu
#define dbkGetRxSnaICUC_C1Byte1                              0xFFu
#define dbkGetRxSnaICUC_C1Byte2                              dbkGetRxSnaCurrLangChar_Cval
#define dbkGetRxSnaICUC_C1Byte3                              dbkGetRxSnaCurrLangChar2_Cval
#define dbkGetRxSnaICUC_C1Byte4                              0xFFu
#define dbkGetRxSnaICUC_C1Byte5                              0xFFu
#define dbkGetRxSnaICUC_C1Byte6                              0xFFu
#define dbkGetRxSnaICUC_C1Byte7                              0x3Fu
#define dbkGetRxSnaTD_ICUCByte0                              dbkGetRxSnaDateTmSecond_Cval_ICUC
#define dbkGetRxSnaTD_ICUCByte1                              dbkGetRxSnaDateTmMinute_Cval_ICUC
#define dbkGetRxSnaTD_ICUCByte2                              dbkGetRxSnaDateTmHour_Cval_ICUC
#define dbkGetRxSnaTD_ICUCByte3                              dbkGetRxSnaDateTmMonth_Cval_ICUC
#define dbkGetRxSnaTD_ICUCByte4                              dbkGetRxSnaDateTmDay_Cval_ICUC
#define dbkGetRxSnaTD_ICUCByte5                              dbkGetRxSnaDateTmYear_Cval_ICUC
#define dbkGetRxSnaTD_ICUCByte6                              dbkGetRxSnaLocalMinuteOffset_Cval_ICUC
#define dbkGetRxSnaTD_ICUCByte7                              dbkGetRxSnaLocalHourOffset_Cval_ICUC
#define dbkGetRxSnaEAM3_B34Byte0                             0xFFu
#define dbkGetRxSnaEAM3_B34Byte1                             0xFFu
#define dbkGetRxSnaEAM3_B34Byte2                             0xFFu
#define dbkGetRxSnaEAM3_B34Byte3                             0xFFu
#define dbkGetRxSnaEAM3_B34Byte4                             0xFFu
#define dbkGetRxSnaEAM3_B34Byte5                             0xFFu
#define dbkGetRxSnaEAM3_B34Byte6                             0xFFu
#define dbkGetRxSnaEAM3_B34Byte7                             0xFFu
#define dbkGetRxSnaEAM3_B33Byte0                             0xFFu
#define dbkGetRxSnaEAM3_B33Byte1                             0xFFu
#define dbkGetRxSnaEAM3_B33Byte2                             0xFFu
#define dbkGetRxSnaEAM3_B33Byte3                             0xFFu
#define dbkGetRxSnaEAM3_B33Byte4                             0xF0u
#define dbkGetRxSnaEAM3_B33Byte5                             0xFFu
#define dbkGetRxSnaEAM3_B33Byte6                             0xFFu
#define dbkGetRxSnaEAM3_B33Byte7                             0xFFu
#define dbkGetRxSnaEAM3_B30Byte0                             0xFFu
#define dbkGetRxSnaEAM3_B30Byte1                             0xFFu
#define dbkGetRxSnaEAM3_B30Byte2                             0xFFu
#define dbkGetRxSnaEAM3_B30Byte3                             0xFFu
#define dbkGetRxSnaEAM3_B30Byte4                             0xFFu
#define dbkGetRxSnaEAM3_B30Byte5                             0xF0u
#define dbkGetRxSnaEAM3_B30Byte6                             0xFFu
#define dbkGetRxSnaICUC_C2Byte0                              0xFFu
#define dbkGetRxSnaICUC_C2Byte1                              0xFFu
#define dbkGetRxSnaICUC_C2Byte2                              0xFCu
#define dbkGetRxSnaICUC_C2Byte3                              0x03u
#define dbkGetRxSnaICUC_C2Byte4                              0xFFu
#define dbkGetRxSnaICUC_C2Byte5                              0xFCu
#define dbkGetRxSnaEBC2_BSByte0                              0xFFu
#define dbkGetRxSnaEBC2_BSByte1                              0xFFu
#define dbkGetRxSnaEBC2_BSByte2                              0xFFu
#define dbkGetRxSnaEBC2_BSByte3                              0xFFu
#define dbkGetRxSnaEBC2_BSByte4                              0xFFu
#define dbkGetRxSnaEBC2_BSByte5                              0xFFu
#define dbkGetRxSnaEBC2_BSByte6                              0xFFu
#define dbkGetRxSnaEBC2_BSByte7                              0xFFu
#define dbkGetRxSnaDI_Shrt_TCOByte0                          dbkGetRxSnaTxCurrGr_Stat
#define dbkGetRxSnaDI_Shrt_TCOByte1                          dbkGetRxSnaTxCurrGr_Stat
#define dbkGetRxSnaDI_Shrt_TCOByte2                          dbkGetRxSnaTxCurrGr_Stat
#define dbkGetRxSnaDI_Shrt_TCOByte3                          0xFFu
#define dbkGetRxSnaDI_Shrt_TCOByte4                          dbkGetRxSnaTxCurrGr_Stat
#define dbkGetRxSnaDI_Shrt_TCOByte5                          dbkGetRxSnaTxCurrGr_Stat
#define dbkGetRxSnaDI_Shrt_TCOByte6                          dbkGetRxSnaTxCurrGr_Stat
#define dbkGetRxSnaDI_Shrt_TCOByte7                          dbkGetRxSnaTxCurrGr_Stat
#define dbkGetRxSnaCPC3_E6Byte0                              0x00u
#define dbkGetRxSnaCPC3_E6Byte1                              0x00u
#define dbkGetRxSnaCPC3_E6Byte2                              0x00u
#define dbkGetRxSnaCPC3_E6Byte3                              dbkGetRxSnaPrkBrk_Stat_PT
#define dbkGetRxSnaCPC3_E6Byte4                              0x00u
#define dbkGetRxSnaCPC3_E6Byte5                              0x00u
#define dbkGetRxSnaCPC3_E6Byte6                              0x00u
#define dbkGetRxSnaCPC3_E6Byte7                              0x00u
#define dbkGetRxSnaETC2_CPCByte0                             0xFFu
#define dbkGetRxSnaETC2_CPCByte1                             0xFFu
#define dbkGetRxSnaETC2_CPCByte2                             0xFFu
#define dbkGetRxSnaETC2_CPCByte3                             0xFFu
#define dbkGetRxSnaETC2_CPCByte4                             0xFFu
#define dbkGetRxSnaETC2_CPCByte5                             0xFFu
#define dbkGetRxSnaETC2_CPCByte6                             0xFFu
#define dbkGetRxSnaETC2_CPCByte7                             0xFFu
#define dbkGetRxSnaICUC_C10Byte0                             0xFFu
#define dbkGetRxSnaICUC_C10Byte1                             0xFFu
#define dbkGetRxSnaICUC_C10Byte2                             0xFFu
#define dbkGetRxSnaICUC_C10Byte3                             0xFFu
#define dbkGetRxSnaICUC_C10Byte4                             0xFFu
#define dbkGetRxSnaICUC_C10Byte5                             0xFFu
#define dbkGetRxSnaICUC_C10Byte6                             0xFFu
#define dbkGetRxSnaICUC_C10Byte7                             0xFFu
#define dbkGetRxSnaSCA_E1Byte0                               0xFFu
#define dbkGetRxSnaSCA_E1Byte1                               0xFFu
#define dbkGetRxSnaSCA_E1Byte2                               0xFFu
#define dbkGetRxSnaSCA_E1Byte3                               0xFFu
#define dbkGetRxSnaSCA_E1Byte4                               0xFFu
#define dbkGetRxSnaSCA_E1Byte5                               0xFFu
#define dbkGetRxSnaSCA_E1Byte6                               0xFFu
#define dbkGetRxSnaSCA_E1Byte7                               0xFFu
#define dbkGetRxSnaTCO1_ICUCByte0                            0xFFu
#define dbkGetRxSnaTCO1_ICUCByte1                            0xFFu
#define dbkGetRxSnaTCO1_ICUCByte2                            0xFFu
#define dbkGetRxSnaTCO1_ICUCByte3                            0xFFu
#define dbkGetRxSnaTCO1_ICUCByte4                            0xFFu
#define dbkGetRxSnaTCO1_ICUCByte5                            0xFFu
#define dbkGetRxSnaTCO1_ICUCByte6                            0xFFu
#define dbkGetRxSnaTCO1_ICUCByte7                            0xFFu
#define dbkGetRxSnaWMI_C02Byte0                              0xFFu
#define dbkGetRxSnaWMI_C02Byte1                              0xFFu
#define dbkGetRxSnaWMI_C02Byte2                              0xFFu
#define dbkGetRxSnaWMI_C02Byte3                              0xFFu
#define dbkGetRxSnaWMI_C02Byte4                              0xFFu
#define dbkGetRxSnaWMI_C02Byte5                              0xFFu
#define dbkGetRxSnaWMI_C02Byte6                              0xFFu
#define dbkGetRxSnaWMI_C02Byte7                              0xFFu
#endif


/* ------------------------------------------------------------------------- */

/*
    SS    SSSSS   S    S   SSSSS
   S  S   S       S    S    S   S
   S      S       SS   S    S    S
    S     SSS     S S  S    S    S
     S    S       S  SSS    S    S
      S   S       S   SS    S    S
   S  S   S       S    S    S   S
    SS    SSSSS   S    S   SSSSS


*/
/*************************************************************/
/* Handles of send objects                                   */
/*************************************************************/
/* VCAN */
#define CBR_C_RQST2TCO_TX_TEL_INDEX                          0
#define CBR_C_CMC_C01_AR_TX_TEL_INDEX                        1
#define CBR_C_NM_HUS_AR_TX_TEL_INDEX                         2
#define CBR_C_HUS_DM1_TX_TEL_INDEX                           3

/* MCAN */
#define CBR_C_KeyIllumination1_TX_TEL_INDEX                  4
#define CBR_C_KeyIllumination0_TX_TEL_INDEX                  5
#define CBR_C_KeyColour1_TX_TEL_INDEX                        6
#define CBR_C_KeyColour0_TX_TEL_INDEX                        7
#define CBR_C_Req_DeviceInformation_TX_TEL_INDEX             8

//**************************************************************************************************
// Signal Definitions Handled in broadcast TX telegrams
//**************************************************************************************************

/*****************************************************************************/
/* CBR_C_RQST2TCO_TX_TEL_INDEX */
#define CSM_C_DLC_RQST2TCO   3
#define CSM_C_SIG_TX_PGN_Rqst2TCO_RQST2TCO CSM_M_MAKE_SIGNAL_ID(CBR_C_RQST2TCO_TX_TEL_INDEX, 0)

/*****************************************************************************/
/* CBR_C_CMC_C01_AR_TX_TEL_INDEX */
#define CSM_C_DLC_CMC_C01_AR                                 8
#define CSM_C_SIG_TX_CMC_C01_AR                              CSM_M_MAKE_SIGNAL_ID(CBR_C_CMC_C01_AR_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Cam1_ManAct_Rq_CMC_C01_AR               CSM_M_MAKE_SIGNAL_ID(CBR_C_CMC_C01_AR_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_Cam2_ManAct_Rq_CMC_C01_AR               CSM_M_MAKE_SIGNAL_ID(CBR_C_CMC_C01_AR_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_Cam3_ManAct_Rq_CMC_C01_AR               CSM_M_MAKE_SIGNAL_ID(CBR_C_CMC_C01_AR_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_Cam4_ManAct_Rq_CMC_C01_AR               CSM_M_MAKE_SIGNAL_ID(CBR_C_CMC_C01_AR_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_Cam5_ManAct_Rq_CMC_C01_AR               CSM_M_MAKE_SIGNAL_ID(CBR_C_CMC_C01_AR_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_Cam6_ManAct_Rq_CMC_C01_AR               CSM_M_MAKE_SIGNAL_ID(CBR_C_CMC_C01_AR_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_Cam7_ManAct_Rq_CMC_C01_AR               CSM_M_MAKE_SIGNAL_ID(CBR_C_CMC_C01_AR_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_DispCamCls_Rq_CMC_C01_AR                CSM_M_MAKE_SIGNAL_ID(CBR_C_CMC_C01_AR_TX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_NM_HUS_AR_TX_TEL_INDEX */
#define CSM_C_DLC_NM_HUS_AR                                  8
#define CSM_C_SIG_TX_NM_HUS_AR                               CSM_M_MAKE_SIGNAL_ID(CBR_C_NM_HUS_AR_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_WakeupRsn_HUS_NM_HUS_AR                 CSM_M_MAKE_SIGNAL_ID(CBR_C_NM_HUS_AR_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_Awake_NwSt_NM_HUS_AR                    CSM_M_MAKE_SIGNAL_ID(CBR_C_NM_HUS_AR_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_Awake_Diag_Actv_NM_HUS_AR               CSM_M_MAKE_SIGNAL_ID(CBR_C_NM_HUS_AR_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_Awake_IgnOn_NM_HUS_AR                   CSM_M_MAKE_SIGNAL_ID(CBR_C_NM_HUS_AR_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_Awake_DispOn_Rq_NM_HUS_AR               CSM_M_MAKE_SIGNAL_ID(CBR_C_NM_HUS_AR_TX_TEL_INDEX, 5)


/*****************************************************************************/
/* CBR_C_HUS_DM1_TX_TEL_INDEX */
#define CSM_C_DLC_HUS_DM1                                    8
#define CSM_C_SIG_TX_HUS_DM1                                 CSM_M_MAKE_SIGNAL_ID(CBR_C_HUS_DM1_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_DTC_SPN_ConvMd_HUS_HUS_DM1              CSM_M_MAKE_SIGNAL_ID(CBR_C_HUS_DM1_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_DTC_OccCnt_HUS_HUS_DM1                  CSM_M_MAKE_SIGNAL_ID(CBR_C_HUS_DM1_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_DTC_Stat_HUS_HUS_DM1                    CSM_M_MAKE_SIGNAL_ID(CBR_C_HUS_DM1_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_DTC_MIL_Flash_Stat_HUS_HUS_DM1          CSM_M_MAKE_SIGNAL_ID(CBR_C_HUS_DM1_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_DTC_RSL_Flash_Stat_HUS_HUS_DM1          CSM_M_MAKE_SIGNAL_ID(CBR_C_HUS_DM1_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_DTC_AWL_Flash_Stat_HUS_HUS_DM1          CSM_M_MAKE_SIGNAL_ID(CBR_C_HUS_DM1_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_DTC_PL_Flash_Stat_HUS_HUS_DM1           CSM_M_MAKE_SIGNAL_ID(CBR_C_HUS_DM1_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_DTC_MIL_Stat_HUS_HUS_DM1                CSM_M_MAKE_SIGNAL_ID(CBR_C_HUS_DM1_TX_TEL_INDEX, 8)
#define CSM_C_SIG_TX_DTC_RSL_Stat_HUS_HUS_DM1                CSM_M_MAKE_SIGNAL_ID(CBR_C_HUS_DM1_TX_TEL_INDEX, 9)
#define CSM_C_SIG_TX_DTC_AWL_Stat_HUS_HUS_DM1                CSM_M_MAKE_SIGNAL_ID(CBR_C_HUS_DM1_TX_TEL_INDEX, 10)
#define CSM_C_SIG_TX_DTC_PL_Stat_HUS_HUS_DM1                 CSM_M_MAKE_SIGNAL_ID(CBR_C_HUS_DM1_TX_TEL_INDEX, 11)

/*****************************************************************************/
/*CAN2*/
/* CBR_C_KeyIllumination1_TX_TEL_INDEX */
#define CSM_C_DLC_KeyIllumination1                           8
#define CSM_C_SIG_TX_KeyIllumination1                        CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Reserved0_KeyIllumination1               CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_Reserved1_KeyIllumination1               CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_Encoder2_Illumination_KeyIllumination1  CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_Encoder1_Illumination_KeyIllumination1  CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_Key12_Illumination_KeyIllumination1     CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_Key11_Illumination_KeyIllumination1     CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_Key10_Illumination_KeyIllumination1     CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_Key9_Illumination_KeyIllumination1      CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_KeyIllumination0_TX_TEL_INDEX */
#define CSM_C_DLC_KeyIllumination0                           8
#define CSM_C_SIG_TX_KeyIllumination0                        CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Key8_Illumination_KeyIllumination0      CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_Key7_Illumination_KeyIllumination0      CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_Key6_Illumination_KeyIllumination0      CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_Key5_Illumination_KeyIllumination0      CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_Key4_Illumination_KeyIllumination0      CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_Key3_Illumination_KeyIllumination0      CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_Key2_Illumination_KeyIllumination0      CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_Key1_Illumination_KeyIllumination0      CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_KeyColour1_TX_TEL_INDEX */
#define CSM_C_DLC_KeyColour1                                 8
#define CSM_C_SIG_TX_KeyColour1                              CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Reserved0_KeyColour1                     CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_Reserved1_KeyColour1                     CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_Enconder2_Colour_KeyColour1             CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_Enconder1_Colour_KeyColour1             CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_Key12_Colour_KeyColour1                 CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_Key11_Colour_KeyColour1                 CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_Key9_Colour_KeyColour1                  CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_Key10_Colour_KeyColour1                 CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_KeyColour0_TX_TEL_INDEX */
#define CSM_C_DLC_KeyColour0                                 8
#define CSM_C_SIG_TX_KeyColour0                              CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Key8_Colour_KeyColour0                  CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_Key7_Colour_KeyColour0                  CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_Key6_Colour_KeyColour0                  CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_Key5_Colour_KeyColour0                  CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_Key4_Colour_KeyColour0                  CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_Key3_Colour_KeyColour0                  CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_Key2_Colour_KeyColour0                  CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_Key1_Colour_KeyColour0                  CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_Req_DeviceInformation_TX_TEL_INDEX */
#define CSM_C_DLC_Req_DeviceInformation                          1
#define CSM_C_SIG_TX_Req_DeviceInformation                       CSM_M_MAKE_SIGNAL_ID(CBR_C_Req_DeviceInformation_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Req_DeviceInformation_Req_DeviceInformation CSM_M_MAKE_SIGNAL_ID(CBR_C_Req_DeviceInformation_TX_TEL_INDEX, 1)

/*
   RRRR    RRRRR    RRRR   RRRRR    R    R     R   RRRRR
    R  R   R       R       R             R     R   R
    R   R  R       R       R        E     R   R    R
    R   R  RRR     R       RRR      R     R   R    RR
    RRRR   R       R       R        R      R R     R
    R  R   R       R       R        R      R R     R
    R   R  R       R       R        R       R      R
    R   R  RRRRR    RRRR   RRRRR   RRR      R      RRRRR
*/

/*************************************************************/
/* Handles of receive objects                               */
/*************************************************************/
#define CBR_C_SCH_E1_RX_TEL_INDEX   0
#define CBR_C_EAM3_B34_RX_TEL_INDEX   1
#define CBR_C_EAM3_B33_RX_TEL_INDEX   2
#define CBR_C_ICUC_C10_RX_TEL_INDEX   3
#define CBR_C_SCA_E1_RX_TEL_INDEX   4
#define CBR_C_WMI_C02_RX_TEL_INDEX   5
#define CBR_C_TPCM_TCO_RX_TEL_INDEX   6
#define CBR_C_TPDT_TCO_RX_TEL_INDEX   7
#define CBR_C_TCO1_ICUC_RX_TEL_INDEX   8
#define CBR_C_DI_Shrt_TCO_RX_TEL_INDEX   9
#define CBR_C_NM_APPL_NWT_AR_RX_TEL_INDEX   10
#define CBR_C_SCA_C2_RX_TEL_INDEX   11
#define CBR_C_ETC2_CPC_RX_TEL_INDEX   12
#define CBR_C_EBC2_BS_RX_TEL_INDEX   13
#define CBR_C_ICUC_C2_RX_TEL_INDEX   14
#define CBR_C_TD_ICUC_RX_TEL_INDEX   15
#define CBR_C_ICUC_C1_RX_TEL_INDEX   16
#define CBR_C_CGW_C1_RX_TEL_INDEX   17
#define CBR_C_CGW_GVC1_RX_TEL_INDEX   18
#define CBR_C_CGW_VIN_RX_TEL_INDEX   19
#define CBR_C_EAM3_B30_RX_TEL_INDEX   20
/*CAN2*/
#define CBR_C_Remotecontrol_RX_TEL_INDEX                     21
#define CBR_C_Resp_DeviceInformation2_RX_TEL_INDEX           22
#define CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX           23


/*************************************************************/
/* signal definitions in broadcast receive telegrams         */
/*************************************************************/
/*****************************************************************************/
/*****************************************************************************/
/* CBR_C_SCH_E1_RX_TEL_INDEX */
#define CSM_C_DLC_SCH_E1   8
#define CSM_C_SIG_RX_SCH_E1                CSM_M_MAKE_SIGNAL_ID(CBR_C_SCH_E1_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_PkBrk_Stat_SCH_SCH_E1 CSM_M_MAKE_SIGNAL_ID(CBR_C_SCH_E1_RX_TEL_INDEX, 1)

/*****************************************************************************/
/* CBR_C_EAM3_B34_RX_TEL_INDEX */
#define CSM_C_DLC_EAM3_B34                                   8
#define CSM_C_SIG_RX_EAM3_B34                                CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B34_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_CAM_SplitQuad_Stat_EAM3_B34             CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B34_RX_TEL_INDEX, 1)

/*****************************************************************************/
/* CBR_C_EAM3_B33_RX_TEL_INDEX */
#define CSM_C_DLC_EAM3_B33                                   8
#define CSM_C_SIG_RX_EAM3_B33                                CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B33_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_Cam1Txt_Rq_EAM3_B33                     CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B33_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_Cam2Txt_Rq_EAM3_B33                     CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B33_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_Cam3Txt_Rq_EAM3_B33                     CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B33_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_Cam4Txt_Rq_EAM3_B33                     CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B33_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_Cam5Txt_Rq_EAM3_B33                     CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B33_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_Cam6Txt_Rq_EAM3_B33                     CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B33_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_Cam7Txt_Rq_EAM3_B33                     CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B33_RX_TEL_INDEX, 7)

/*****************************************************************************/
/* CBR_C_ICUC_C10_RX_TEL_INDEX */
#define CSM_C_DLC_ICUC_C10                                   8
#define CSM_C_SIG_RX_ICUC_C10                                CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C10_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_StW_Sw07_Rq_ICUC_ICUC_C10               CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C10_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_StW_Sw08_Rq_ICUC_ICUC_C10               CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C10_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_StW_Sw15_Rq_ICUC_ICUC_C10               CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C10_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_StW_Sw16_Rq_ICUC_ICUC_C10               CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C10_RX_TEL_INDEX, 4)

/*****************************************************************************/
/* CBR_C_SCA_E1_RX_TEL_INDEX */
#define CSM_C_DLC_SCA_E1                                     8
#define CSM_C_SIG_RX_SCA_E1                                  CSM_M_MAKE_SIGNAL_ID(CBR_C_SCA_E1_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_PanelLmpDimChgTm_Cval_SCA_E1            CSM_M_MAKE_SIGNAL_ID(CBR_C_SCA_E1_RX_TEL_INDEX, 1)

/*****************************************************************************/
/* CBR_C_WMI_C02_RX_TEL_INDEX */
#define CSM_C_DLC_WMI_C02                                    8
#define CSM_C_SIG_RX_WMI_C02                                 CSM_M_MAKE_SIGNAL_ID(CBR_C_WMI_C02_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_FltbrdDrv_ID_1_WMI_WMI_C02              CSM_M_MAKE_SIGNAL_ID(CBR_C_WMI_C02_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_FltbrdDrv_ID_2_WMI_WMI_C02              CSM_M_MAKE_SIGNAL_ID(CBR_C_WMI_C02_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_FltbrdDrv_ID_3_WMI_WMI_C02              CSM_M_MAKE_SIGNAL_ID(CBR_C_WMI_C02_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_FltbrdDrv_ID_4_WMI_WMI_C02              CSM_M_MAKE_SIGNAL_ID(CBR_C_WMI_C02_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_FltbrdDrv_ID_5_WMI_WMI_C02              CSM_M_MAKE_SIGNAL_ID(CBR_C_WMI_C02_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_FltbrdDrv_ID_6_WMI_WMI_C02              CSM_M_MAKE_SIGNAL_ID(CBR_C_WMI_C02_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_FltbrdDrv_ID_7_WMI_WMI_C02              CSM_M_MAKE_SIGNAL_ID(CBR_C_WMI_C02_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_FltbrdDrv_ID_8_WMI_WMI_C02              CSM_M_MAKE_SIGNAL_ID(CBR_C_WMI_C02_RX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_TPCM_TCO_RX_TEL_INDEX */
#define CSM_C_DLC_TPCM_TCO                                   8
#define CSM_C_SIG_RX_TPCM_TCO                                CSM_M_MAKE_SIGNAL_ID(CBR_C_TPCM_TCO_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_CtrlByte_Stat_TCO_TPCM_TCO              CSM_M_MAKE_SIGNAL_ID(CBR_C_TPCM_TCO_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_TotalMsgSizeBAM_Cval_TCO_TPCM_TCO       CSM_M_MAKE_SIGNAL_ID(CBR_C_TPCM_TCO_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_TotalNumOfPktBAM_Cval_TCO_TPCM_TCO      CSM_M_MAKE_SIGNAL_ID(CBR_C_TPCM_TCO_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_PGN_Cval_TCO_TPCM_TCO                   CSM_M_MAKE_SIGNAL_ID(CBR_C_TPCM_TCO_RX_TEL_INDEX, 4)

/*****************************************************************************/
/* CBR_C_TPDT_TCO_RX_TEL_INDEX */
#define CSM_C_DLC_TPDT_TCO                                   8
#define CSM_C_SIG_RX_TPDT_TCO                                CSM_M_MAKE_SIGNAL_ID(CBR_C_TPDT_TCO_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_SequenceNum_Cval_TCO_TPDT_TCO           CSM_M_MAKE_SIGNAL_ID(CBR_C_TPDT_TCO_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_Data_Cval_TCO_TPDT_TCO                  CSM_M_MAKE_SIGNAL_ID(CBR_C_TPDT_TCO_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_Data2_Cval_TCO_TPDT_TCO                 CSM_M_MAKE_SIGNAL_ID(CBR_C_TPDT_TCO_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_Data3_Cval_TCO_TPDT_TCO                 CSM_M_MAKE_SIGNAL_ID(CBR_C_TPDT_TCO_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_Data4_Cval_TCO_TPDT_TCO                 CSM_M_MAKE_SIGNAL_ID(CBR_C_TPDT_TCO_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_Data5_Cval_TCO_TPDT_TCO                 CSM_M_MAKE_SIGNAL_ID(CBR_C_TPDT_TCO_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_Data6_Cval_TCO_TPDT_TCO                 CSM_M_MAKE_SIGNAL_ID(CBR_C_TPDT_TCO_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_Data7_Cval_TCO_TPDT_TCO                 CSM_M_MAKE_SIGNAL_ID(CBR_C_TPDT_TCO_RX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_TCO1_ICUC_RX_TEL_INDEX */
#define CSM_C_DLC_TCO1_ICUC                                  8
#define CSM_C_SIG_RX_TCO1_ICUC                               CSM_M_MAKE_SIGNAL_ID(CBR_C_TCO1_ICUC_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_D_Card_Stat_ICUC_TCO1_ICUC              CSM_M_MAKE_SIGNAL_ID(CBR_C_TCO1_ICUC_RX_TEL_INDEX, 1)

/*****************************************************************************/
/* CBR_C_DI_Shrt_TCO_RX_TEL_INDEX */
#define CSM_C_DLC_DI_Shrt_TCO                                8
#define CSM_C_SIG_RX_DI_DI_Shrt_TCO                          CSM_M_MAKE_SIGNAL_ID(CBR_C_DI_Shrt_TCO_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_DI_Char001_Cval_DI_Shrt_TCO             CSM_M_MAKE_SIGNAL_ID(CBR_C_DI_Shrt_TCO_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_DI_Char002_Cval_DI_Shrt_TCO             CSM_M_MAKE_SIGNAL_ID(CBR_C_DI_Shrt_TCO_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_DI_Char003_Cval_DI_Shrt_TCO             CSM_M_MAKE_SIGNAL_ID(CBR_C_DI_Shrt_TCO_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_DI_Char004_Cval_DI_Shrt_TCO             CSM_M_MAKE_SIGNAL_ID(CBR_C_DI_Shrt_TCO_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_DI_Char005_Cval_DI_Shrt_TCO             CSM_M_MAKE_SIGNAL_ID(CBR_C_DI_Shrt_TCO_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_DI_Char006_Cval_DI_Shrt_TCO             CSM_M_MAKE_SIGNAL_ID(CBR_C_DI_Shrt_TCO_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_DI_Char007_Cval_DI_Shrt_TCO             CSM_M_MAKE_SIGNAL_ID(CBR_C_DI_Shrt_TCO_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_DI_Char008_Cval_DI_Shrt_TCO             CSM_M_MAKE_SIGNAL_ID(CBR_C_DI_Shrt_TCO_RX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_NM_APPL_NWT_AR_RX_TEL_INDEX */
#define CSM_C_DLC_NM_APPL_NWT_AR                             8
#define CSM_C_SIG_RX_NM_APPL_NWT_AR                          CSM_M_MAKE_SIGNAL_ID(CBR_C_NM_APPL_NWT_AR_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_Awake_Diag_Actv_NM_APPL_NWT_AR          CSM_M_MAKE_SIGNAL_ID(CBR_C_NM_APPL_NWT_AR_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_Awake_IgnOn_NM_APPL_NWT_AR              CSM_M_MAKE_SIGNAL_ID(CBR_C_NM_APPL_NWT_AR_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_Awake_NwSt_NM_APPL_NWT_AR               CSM_M_MAKE_SIGNAL_ID(CBR_C_NM_APPL_NWT_AR_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_WakeupRsn_APPL_NWT_NM_APPL_NWT_AR       CSM_M_MAKE_SIGNAL_ID(CBR_C_NM_APPL_NWT_AR_RX_TEL_INDEX, 4)

/*****************************************************************************/
/* CBR_C_SCA_C2_RX_TEL_INDEX */
#define CSM_C_DLC_SCA_C2   8
#define CSM_C_SIG_RX_SCA_C2                                  CSM_M_MAKE_SIGNAL_ID(CBR_C_SCA_C2_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_IgnSw_Stat_SCA_SCA_C2                   CSM_M_MAKE_SIGNAL_ID(CBR_C_SCA_C2_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_SysVolt_Stat_SCA_C2                     CSM_M_MAKE_SIGNAL_ID(CBR_C_SCA_C2_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_EngCrk_Stat_SCA_C2                      CSM_M_MAKE_SIGNAL_ID(CBR_C_SCA_C2_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_PNM_Grp10_Stat_SCA_C2                   CSM_M_MAKE_SIGNAL_ID(CBR_C_SCA_C2_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_PanelLmp_Cmd_SCA_C2                     CSM_M_MAKE_SIGNAL_ID(CBR_C_SCA_C2_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_PanelLmpDim_Cval_SCA_C2                 CSM_M_MAKE_SIGNAL_ID(CBR_C_SCA_C2_RX_TEL_INDEX, 6)

/*****************************************************************************/
/* CBR_C_ETC2_CPC_RX_TEL_INDEX */
#define CSM_C_DLC_ETC2_CPC                                   8
#define CSM_C_SIG_RX_ETC2_CPC                                CSM_M_MAKE_SIGNAL_ID(CBR_C_ETC2_CPC_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_TxCurrGr_Stat_ETC2_CPC                  CSM_M_MAKE_SIGNAL_ID(CBR_C_ETC2_CPC_RX_TEL_INDEX, 1)

/*****************************************************************************/
/* CBR_C_EBC2_BS_RX_TEL_INDEX */
#define CSM_C_DLC_EBC2_BS                                    8
#define CSM_C_SIG_RX_EBC2_BS                                 CSM_M_MAKE_SIGNAL_ID(CBR_C_EBC2_BS_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_FA_Spd_Cval_EBC2_BS                     CSM_M_MAKE_SIGNAL_ID(CBR_C_EBC2_BS_RX_TEL_INDEX, 1)

/*****************************************************************************/
/* CBR_C_ICUC_C2_RX_TEL_INDEX */
#define CSM_C_DLC_ICUC_C2                                    8
#define CSM_C_SIG_RX_ICUC_C2                                 CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C2_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_MuteDev_Stat_ICUC_C2                    CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C2_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_Mute_Rq_ICUC_C2                         CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C2_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_DayNightMd_Stat_ICUC_C2                 CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C2_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_DispDateMd_Cval_ICUC_C2                 CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C2_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_DispTmMd_Cval_ICUC_C2                   CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C2_RX_TEL_INDEX, 5)

/*****************************************************************************/
/* CBR_C_TD_ICUC_RX_TEL_INDEX */
#define CSM_C_DLC_TD_ICUC                                    8
#define CSM_C_SIG_RX_TD_ICUC                                 CSM_M_MAKE_SIGNAL_ID(CBR_C_TD_ICUC_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_DateTmSecond_Cval_ICUC_TD_ICUC          CSM_M_MAKE_SIGNAL_ID(CBR_C_TD_ICUC_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_DateTmMinute_Cval_ICUC_TD_ICUC          CSM_M_MAKE_SIGNAL_ID(CBR_C_TD_ICUC_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_DateTmHour_Cval_ICUC_TD_ICUC            CSM_M_MAKE_SIGNAL_ID(CBR_C_TD_ICUC_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_DateTmMonth_Cval_ICUC_TD_ICUC           CSM_M_MAKE_SIGNAL_ID(CBR_C_TD_ICUC_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_DateTmDay_Cval_ICUC_TD_ICUC             CSM_M_MAKE_SIGNAL_ID(CBR_C_TD_ICUC_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_DateTmYear_Cval_ICUC_TD_ICUC            CSM_M_MAKE_SIGNAL_ID(CBR_C_TD_ICUC_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_LocalMinuteOffset_Cval_ICUC_TD_ICUC     CSM_M_MAKE_SIGNAL_ID(CBR_C_TD_ICUC_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_LocalHourOffset_Cval_ICUC_TD_ICUC       CSM_M_MAKE_SIGNAL_ID(CBR_C_TD_ICUC_RX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_ICUC_C1_RX_TEL_INDEX */
#define CSM_C_DLC_ICUC_C1                                     8
#define CSM_C_SIG_RX_ICUC_C1                                  CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C1_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_CurrLangChar_Cval_ICUC_C1                CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C1_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_CurrLangChar2_Cval_ICUC_C1               CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C1_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_DistUnit_Cval_ICUC_C1                    CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C1_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_TempUnit_Cval_ICUC_C1                    CSM_M_MAKE_SIGNAL_ID(CBR_C_ICUC_C1_RX_TEL_INDEX, 4)

/*****************************************************************************/
/* CBR_C_CGW_C1_RX_TEL_INDEX */
#define CSM_C_DLC_CGW_C1                                      8
#define CSM_C_SIG_RX_CGW_C1                                   CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_C1_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_Offboard_Tester_Stat_CGW_C1              CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_C1_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_SelfHealing2_Stat_CGW_C1                 CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_C1_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_SelfHealing3_Stat_CGW_C1                 CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_C1_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_TotalVehDist_Cval_DIAG_CGW_C1            CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_C1_RX_TEL_INDEX, 4)

/*****************************************************************************/
/* CBR_C_CGW_GVC1_RX_TEL_INDEX */
#define CSM_C_DLC_CGW_GVC1                                    8
#define CSM_C_SIG_RX_CGW_GVC1                                 CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_GVC1_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_GVC_VehModel_CGW_GVC1                    CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_GVC1_RX_TEL_INDEX, 1)

/*****************************************************************************/
/* CBR_C_CGW_VIN_RX_TEL_INDEX */
#define CSM_C_DLC_CGW_VIN                                     8
#define CSM_C_SIG_RX_CGW_VIN                                  CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_VIN_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_VIN_Cntr_Stat_CGW_VIN                    CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_VIN_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_VIN_Seg_CGW_VIN                          CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_VIN_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_VIN_Seg2_CGW_VIN                         CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_VIN_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_VIN_Seg3_CGW_VIN                         CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_VIN_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_VIN_Seg4_CGW_VIN                         CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_VIN_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_VIN_Seg5_CGW_VIN                         CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_VIN_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_VIN_Seg6_CGW_VIN                         CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_VIN_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_VIN_Seg7_CGW_VIN                         CSM_M_MAKE_SIGNAL_ID(CBR_C_CGW_VIN_RX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_EAM3_B30_RX_TEL_INDEX */
#define CSM_C_DLC_EAM3_B30                                    8
#define CSM_C_SIG_RX_EAM3_B30                                 CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B30_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_SwivMonAutoOpen_Rq_EAM3_B30              CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B30_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_ActCam1_Rq_EAM3_B30                      CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B30_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_ActCam2_Rq_EAM3_B30                      CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B30_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_ActCam3_Rq_EAM3_B30                      CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B30_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_ActCam4_Rq_EAM3_B30                      CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B30_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_ActCam5_Rq_EAM3_B30                      CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B30_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_ActCam6_Rq_EAM3_B30                      CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B30_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_ActCam7_Rq_EAM3_B30                      CSM_M_MAKE_SIGNAL_ID(CBR_C_EAM3_B30_RX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_Remotecontrol_RX_TEL_INDEX */
#define CSM_C_DLC_Remotecontrol                               8
#define CSM_C_SIG_RX_Remotecontrol                            CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_Encoder2_Steps_Remotecontrol             CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_Encoder1_Steps_Remotecontrol             CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_Encoder2_Button_Remotecontrol            CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_Encoder1_Button_Remotecontrol            CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_Key21_Status_Remotecontrol               CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_Key20_Status_Remotecontrol               CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_Key19_Status_Remotecontrol               CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_Key18_Status_Remotecontrol               CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 8)
#define CSM_C_SIG_RX_Key17_Status_Remotecontrol               CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 9)
#define CSM_C_SIG_RX_Key16_Status_Remotecontrol               CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 10)
#define CSM_C_SIG_RX_Key15_Status_Remotecontrol               CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 11)
#define CSM_C_SIG_RX_Key14_Status_Remotecontrol               CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 12)
#define CSM_C_SIG_RX_Key13_Status_Remotecontrol               CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 13)
#define CSM_C_SIG_RX_Key12_Status_Remotecontrol               CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 14)
#define CSM_C_SIG_RX_Key11_Status_Remotecontrol               CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 15)
#define CSM_C_SIG_RX_Key10_Status_Remotecontrol               CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 16)
#define CSM_C_SIG_RX_Key9_Status_Remotecontrol                CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 17)
#define CSM_C_SIG_RX_Key8_Status_Remotecontrol                CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 18)
#define CSM_C_SIG_RX_Key7_Status_Remotecontrol                CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 19)
#define CSM_C_SIG_RX_Key6_Status_Remotecontrol                CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 20)
#define CSM_C_SIG_RX_Key5_Status_Remotecontrol                CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 21)
#define CSM_C_SIG_RX_Key4_Status_Remotecontrol                CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 22)
#define CSM_C_SIG_RX_Key3_Status_Remotecontrol                CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 23)
#define CSM_C_SIG_RX_Key2_Status_Remotecontrol                CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 24)
#define CSM_C_SIG_RX_Key1_Status_Remotecontrol                CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 25)

/*****************************************************************************/
/* CBR_C_Resp_DeviceInformation2_RX_TEL_INDEX */
#define CSM_C_DLC_Resp_DeviceInformation2                     8
#define CSM_C_SIG_RX_Resp_DeviceInformation2                  CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation2_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_B_SW_Ver_MCP_Resp_DeviceInformation2     CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation2_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_B_HW_Ver_MCP_Resp_DeviceInformation2     CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation2_RX_TEL_INDEX, 2)

/*****************************************************************************/
/* CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX */
#define CSM_C_DLC_Resp_DeviceInformation1                     8
#define CSM_C_SIG_RX_Resp_DeviceInformation1                  CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_B_SW_YY_Resp_DeviceInformation1          CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_B_SW_MM_Resp_DeviceInformation1          CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_B_SW_DD_Resp_DeviceInformation1          CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_B_HW_YY_Resp_DeviceInformation1          CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_B_HW_MM_Resp_DeviceInformation1          CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_B_HW_DD_Resp_DeviceInformation1          CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX, 6)


/* ------------------------------------------------------------------------- */
/* end of copy generated CBR defines here */
/* ------------------------------------------------------------------------- */
#endif
