/* Description and history of csm_etg_trace_p.h at the end of the file.       */
#ifndef CSM_ETG_TRACE_P_HEADER
/** File name for preprozessor commands */
#define CSM_ETG_TRACE_P_HEADER

/* usually there are no further includes allowed/necessary                    */

typedef enum
{
  WARNING        = 0x01,
  ERROR          = 0x02,
  SEVERE_ERROR   = 0x03
} CSM_TRC_ERROR_GRADE;

typedef enum
{
  LOC_GLB          = 0x00,
  LOC_CSM          = 0x10,
  LOC_CNM          = 0x20,
  LOC_CNM_MCNET    = 0x21,
  LOC_CNM_OSEK     = 0x22,
  LOC_CNM_GMLAN    = 0x23,
  LOC_CNM_IVLAN    = 0x24,
  LOC_CNM_J1939    = 0x25,
  LOC_CNP          = 0x30,
  LOC_CNP_MCNET    = 0x31,
  LOC_CNP_ISO_TP   = 0x32,
  LOC_CNP_VW16_TP  = 0x33,
  LOC_CNP_VW20_TP  = 0x34,
  LOC_CNP_BAP      = 0x35,
  LOC_CNP_UUDT     = 0x36,
  LOC_CNP_MPDT     = 0x37,
  LOC_CNP_LIN_DIAG = 0x38,
  LOC_CNP_LCTR     = 0x39,
  LOC_CNP_J1939_TP = 0x3A,
  LOC_CNP_LIN_USDT = 0x3B,
  LOC_CBR          = 0x40,
  LOC_CDA          = 0x50,
  LOC_CDA_FCAN     = 0x51,
  LOC_CDA_TUAREG   = 0x52,
  LOC_CDA_ARION    = 0x53,
  LOC_CDA_AFCAN    = 0x54,
  LOC_CSM_STACK    = 0x60,
  LOC_CSM_APL      = 0x70,
  LOC_CSM_AL       = 0x80,
  LOC_CSM_AL_KRNL  = 0x81,
  LOC_CSM_AL_USR   = 0x82,
  LOC_CSM_TRACE    = 0x90
} CSM_TRC_ERROR_LOCATION;

typedef enum
{
  GENERAL_ERROR           = 0x0001,
  OS_ERROR                = 0x0002,
  I_O_DEVICE              = 0x0003,
  RESOURCE                = 0x0004,
  BUFFER_ERROR            = 0x0010,
  BUFFER_FULL             = 0x0011,
  RX_BUFFER_OVERRUN       = 0x0012,
  TX_BUFFER_OVERRUN       = 0x0013,
  TIMER_ERROR             = 0x0014,
  TIMER_ID_NOT_VALID      = 0x0015,
  TIMER_VALUE_NOT_VALID   = 0x0016,
  CONFIGURATION           = 0x0020,
  CONFIG_FILE             = 0x0021,
  NO_CONFIG_FILE          = 0x0022,
  INIT_WARNING            = 0x00FF,
  UNKNOWN_SRVC            = 0x0101,
  COMP_INACTIVE           = 0x0102,
  INVALID_PARA            = 0x0103,
  SRVC_UNAVAILABLE        = 0x0104,
  NULL_POINTER            = 0x0105,
  INVALID_PROTOCOL_TYPE   = 0x0106,
  DATA_LENGTH_EXCEEDED    = 0x0107,
  ITEM_NOT_FOUND          = 0x0108,
  INVALID_BUS_NUMBER      = 0x0110,
  INVALID_CHANNEL         = 0x0111,
  INVALID_ADDRESS         = 0x0112,
  INVALID_TARGET_ADDRESS  = 0x0113,
  INVALID_SOURCE_ADDRESS  = 0x0114,
  CSM_STATE_FORBIDS_CALL  = 0x0115,
  CALLBACK_MISSING        = 0x0116,
  NO_FREE_CALLBACK        = 0x0117,
  WRONG_BUS_STATE         = 0x0118,
  INVALID_CAN_DLC         = 0x0120,
  INVALID_PCI             = 0x0121,
  TX_QUEUE_OVERRUN        = 0x0128,
  RX_QUEUE_OVERRUN        = 0x0129,
  UNKNOWN_EVENT           = 0x0130,
  UNKNOWN_STATE           = 0x0131,
  INVALID_EVENT           = 0x0132,
  INVALID_STATE           = 0x0133,
  INVALID_SIG_INDEX       = 0x0141,
  INVALID_TEL_INDEX       = 0x0142,
  STACK_INACTIVE          = 0x0200,
  STACK_BUSY              = 0x0201,
  NO_CONNECTION           = 0x0202,
  BUS_OFF                 = 0x0204
} CSM_TRC_ERROR_CODE;

#else /* HEADER already defined */
  #error CSM_ETG_TRACE_P.H included several times
#endif

/*******************************************************************************
 * \doxydocu
 * \file          csm_etg_trace_p.h
 * \brief         Interface header for project specific ETG-trace enums.
 *
 * \see           CAN-SW Architecture, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/
 *
 * \ingroup       CSM_ETG_TRACE
 *
 * \authors       CM-AI/VTeam
 *
 * COPYRIGHT      (c) 2011 Robert Bosch Car Multimedia GmbH
 *
 * \history_begin
 *
 * 15.04.11  main\nissan_lcn2\1  Borck
 * - Initial revision.
 *
 * 23.05.11  main\nissan_lcn2\2  Borck
 * - taken over trace class and some basic enums from GM for first ETG tests
 *
 * 23.05.11  main\nissan_lcn2\3  Borck
 * - file corrected due to corruption caused by damned symbolic clearcase links
 *
 * 09.06.11  main\nissan_lcn2\4  Borck
 * - dedicated ETG trace class removed since not needed. standard TR_CLASS_FD_CSM should be used.
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
