/************************************************************************
 *FILE:           CSM_PROXY_I.H
 *SW-COMPONENT:   CAN Proxy Server module header
 *DESCRIPTION:    CAN header file for module
 *                external/internal used data/definitions
 *AUTHOR:         CM-DI/ESA3-Haffner
 *COPYRIGHT:      (c) 2006 Blaupunkt Werke GmbH
 *
 ************************************************************************/

#ifndef CSM_PROXY_I_HEADER
#define CSM_PROXY_I_HEADER

/*****************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------*/
#include "csm_proxy_ip.h"

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/
/* --none-- */

/*****************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------*/
/* --none-- */

/*****************************************************************
| variable declaration (scope: global)
|----------------------------------------------------------------*/
/* --none-- */

/*****************************************************************
| function prototypes (scope: global)
|----------------------------------------------------------------*/
LONG CSM_PROXY_lInit(const BYTE bInitMode);
LONG CSM_PROXY_lExit(const BYTE bExitMode);
BOOL CSM_PROXY_bIsActive(void);
// indirect Callbacks for LINUX INC RX threads (asynchronously called from downstream task)
// they handle INC messages coming from CCS (for example V850) on dedicated LUNs
void CSM_PROXY_vProcess_IPC_REMOTE_NetData(void);
void CSM_PROXY_vProcess_IPC_REMOTE_BrData(void);
void CSM_PROXY_vProcess_IPC_REMOTE_TpData(void);
// indirect Callback for LINUX Timer System (asynchronously called from downstream task)
// its handling INC TX timeouts (no response from v850)
void CSM_PROXY_vProcess_IPC_TX_ResponseTimeout(void);
// Manager to handle BR requests (ComReq, SignaWrite)
void CSM_PROXY_vProcess_IPC_LOCAL_BrRequests(void);
// Manager to handle NET requests (LCTRL, OSEKI: ComReq)
void CSM_PROXY_vProcess_IPC_LOCAL_NetRequests(void);
// Handle TP communication requests
void CSM_PROXY_vProcess_IPC_LOCAL_TpCommReq(void);
// Handle TP data requests
void CSM_PROXY_vProcess_IPC_LOCAL_TpDataReq(void);
void CSM_PROXY_vProcessPowerState(void);
void CSM_PROXY_vProcessTimeoutUpstream(void);
LONG CSM_PROXY_lCommunicationReq(BYTE bBus, DWORD dwProtocolType, const void* pvAddressField, BYTE  bAction, WORD wApplID);
LONG CSM_PROXY_lDataReq(DWORD dwProtocolType, const void* pvAddressField, const BYTE* pbData, WORD wDataLength);
LONG CSM_PROXY_lCbrSendTelegram(BYTE u8Bus, BYTE bTelegramType, BYTE bTelegramIndex, BYTE bTelegramTxType);

#if (CSM_S_VW_BAP_TP == CSM_C_F_ON)
LONG CSM_PROXY_lBapRawSendTelegram(BYTE u8Bus, WORD u16TelegramId, BYTE u8DataLength, BYTE* pu8TelDataBuffer);
BOOL CSM_PROXY_lBapRawIsReadyForTx(void);
#endif
/* ------------------------------------------------------------------------- */

/* OS-specific part: */
LONG CSM_lIpcInitAll(void);
LONG CSM_lIpcExitAll(void);
LONG CSM_lIpcDataGet(tIpcHdl tyIpcHandle, BYTE* pu8DataRx, DWORD u32MaxBufLengthRx, DWORD* pu32LengthRx);
LONG CSM_lIpcDataSend(tIpcHdl tyIpcHandle, BYTE* pu8DataTx, DWORD u32LengthTx);
BOOL CSM_lTimerIsExpired(WORD wTimerId);

#if (CSM_S_VW_BAP_TP == CSM_C_F_ON)
BOOL CSM_isBAPTxQueueLocked(void);
void CSM_setBAPTxQueueLocked(BOOL fLocked);
void CSM_BAP_vProcessBAPIpcTask( void);       //TODO MP: check if this place is okay
#endif

#else
  #error CSM_PROXY_I.H included several times
#endif // CSM_PROXY_I_HEADER

/*******************************************************************************
 * \doxydocu
 * \file          csm_proxy_i.h
 * \brief         Header file for Proxy external used function and defines.
 *
 *                Header file for CBR external used function and defines.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/csm/src/
 *
 * \ingroup       CSM
 *
 * \authors       V-Team
 *
 * COPYRIGHT:      (c) 2006 Blaupunkt GmbH
 *
 * \history_begin
 * 06.04.06   CM-DI/ESA3-Haffner
 * - Initial version.
 *
 * 20.07.13   \main\11  Prhl
 * -  CSM_BAP_vProcessBAPIpcTask() added.
 *
 * 12.09.13   \main\12  Feldhaus
 * - included bus number as parameter into CSM_PROXY_lBapRawSendTelegram
 *
 * 09.01.15   \main\13  Pistoor
 * - removed LINT warnings
 *
 * 01.06.15   \main\14  Borck
 * - BAP related code featured with BAP feature switch
 *
 * 19.06.15   \main\15  Borck
 * - some prototypes renamed
 *
 * 09.07.15   \main\16  Borck
 * - some prototypes renamed or removed
 *
 * 06.09.15   \main\17  Borck
 * - one prototype added for TTFis check function
 *
 * \history_end
 * *** END OF FILE ******************************************************* */
