// some legacy test case Geraffel
//#define MP_SIMPLE_TEST_CASE
//#define MP_SIMPLE_TEST_CASE_TP
//#define MP_SIMPLE_TEST_CASE_BAP
//#define MP_SIMPLE_TEST_CASE_CSM_CBR

/* Description and history of csm_p.c at the end of the file.                 */
/** File name for preprozessor commands */
#define CSM_P_SELF
/** csm_p.c is a file according V-team CAN-SW architecture implementation rules */
#define CSM_CAN_STACK

/*********************************************
 * if projectspecific necessary:
 *   1)system- and project- includes
 *   2)needed interfaces from external components
 *...3)internal and external interfaces from this component
 */


/*************** CSM and stack **************/
#include "csm_stack_i.h"
#include "csm_i.h"
#include "csm_stack_m.h"
#include "csm_m.h"


/*************** CNM **************/
#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
  /*#include "cnm_i.h"*/
  #if (CSM_S_OSEK_NM == CSM_C_F_ON)
    #include "cnm_osek_i.h"
  #endif /* CSM_S_OSEK_NM */

  #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
    #include "cnm_oseki_i.h"
  #endif /* CSM_S_OSEKI_NM */

  #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
    #include "cnm_vwhigh_i.h"
  #endif /* CSM_S_VWHIGH_NM */
#endif /* CSM_S_CNM_AVAILABLE */

/*************** CNP **************/
#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
  /*#include "cnp_i.h"*/
  #if (CSM_S_IVLAN_NM == CSM_C_F_ON)
    #include "cnm_ivlan_i.h"
  #endif
  #if (CSM_S_MCNET == CSM_C_F_ON)
    #include "csm_mcnet_i.h"
  #endif

  #if (CSM_S_ISO_TP == CSM_C_F_ON)
    #include "cnp_itp_i.h"
  #endif

  #if (CSM_S_MCNET == CSM_C_F_ON)
    #include "cnp_mcnet_i.h"
  #endif
  #if (CSM_S_VW_BAP_TP == CSM_C_F_ON)
    #include "csm_bap_i.h"
  #endif
#endif /* CSM_S_CNP_AVAILABLE */

/*************** CBR **************/
#if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
  #include "cbr_i.h"
#endif /* CSM_S_CBR_AVAILABLE == CSM_C_F_ON */

/*************** CDA **************/
#if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)
  #include "cda_i.h"
#endif /* CSM_S_CDA_AVAILABLE == CSM_C_F_ON */

/*************** ETG Tracing ******/
#if (CSM_S_TRACE == CSM_C_F_ON)
  #define ETRACE_S_IMPORT_INTERFACE_GENERIC
  #include "etrace_if.h"

  #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
  #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
    #include "csm_etg_trace.h"
    #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FD_CSM
    /* #define ETG_INLINE */
    #include "trcGenProj/Header/csm_p.c.trc.h"
  #endif
  #endif
#endif /* (CSM_S_TRACE == CSM_C_F_ON) */

/*******************************************************************************
 * defines and macros (scope: file local)
 ******************************************************************************/
/* -- none --*/

/*******************************************************************************
 * typedefs (scope: file local)
 ******************************************************************************/
/* -- none --*/

/*******************************************************************************
 * variable declaration (scope: file local)
 ******************************************************************************/
/* -- none --*/
#ifdef CSM_P_SELF /*this makes lint happy*/
#endif

/*******************************************************************************
 * variable definition (scope: file local)
 ******************************************************************************/
/*******************************************************************************
 * variable csm_fWakeupFlag
 *
 * comment: Flag that causes in the first csm_bCalculateBusState() call a bus
 *          state change.
 *          Initialization better in projectspecific Cold/WarmInit routine ?
 *
 * \see     csm_bCalculateBusState()
 *
 * range:   TRUE/FALSE
 *
 * access level (init), downstream task
 ******************************************************************************/
static BOOL csm_fWakeupFlag = TRUE;


/*******************************************************************************
 * function prototypes (scope: file local)
 ******************************************************************************/
/* -- none --*/

/*******************************************************************************
 * function prototypes (scope: operating system via function pointer)
 ******************************************************************************/
/* -- none --*/

/*******************************************************************************
 * variable definition (scope: CAN stack)
 ******************************************************************************/
/* -- none --*/


/*******************************************************************************
 * constants (scope: file local)
 ******************************************************************************/
/*-- none --*/

/* Feature switch is used only to control doxygen documentation */
#if (CSM_S_DOXYGEN_HIDE_NON_API_FCT == CSM_C_F_OFF)
/*******************************************************************************
 * function implementation (scope: file local = static)
 ******************************************************************************/
/*-- none --*/

/*******************************************************************************
 * function implementation (scope: CAN stack mannager module local)
 ******************************************************************************/

/*******************************************************************************
 * function    csm_fChangeDownListen
 * \doxydocu
 * \brief      The function contains the necessary actions for bus state
 *             transition from Down to Listen.
 *
 *             The function is called by the CAN stack manager state
 *             machine for transition from CAN bus Down to Listen.
 *             The states are described in the V-Team SW architecture.
 *             See also CSM_lBusStateChange(), csm_lExecStateMachine() and
 *             csm_lSwitchStateMachine().
 *
 * \param[in]  bBus
 *              Bus number
 *
 * \return     TRUE:  transition was successfull
 *             FALSE: transition failed
 *
 * \access     Downstream task
 * \reentrant  no
 *
 * \lastreview 01.07.08 VTeam-Zurmhl
 *
 * \history_begin
 * 02.03.04 CM-DI/ESU3-Khler
 * - Initial example version.
 * \history_end
 ******************************************************************************/
BOOLEAN csm_fChangeDownListen(BYTE bBus)
{
  BOOLEAN fReturnValue;

  #if (CSM_S_TRACE == CSM_C_F_ON)
  #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
  {
    #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
    ETG_TRACE_USR2(("CSM State Change - csm_fChangeDownListen - Bus:%X ",
                     ETG_CENUM(tCSM_BUS_NUMBER,               (tU8)  bBus)
                  ));
    #endif
  }
  #else // CSM_S_TRACE_ETG
  {
    BYTE abData[3];
    abData[0] = bBus;
    abData[1] = CSM_C_STATE_BUS_DOWN;
    abData[2] = CSM_C_STATE_BUS_LISTEN;

    CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_CSM_CHANGE, abData, 3);
  }
  #endif // CSM_S_TRACE_ETG
  #endif // CSM_S_TRACE

  #if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)
  CDA_lActivate(bBus, CDA_C_LISTEN_ONLY);
  #endif

  #if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
    #if (CSM_S_IVLAN_NM == CSM_C_F_ON)
    CNM_IVLAN_lGotoMode(bBus, CNM_IVLAN_C_AWAKE);
    #endif // CSM_S_IVLAN_NM

    #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
    // CNM_OSEKI_lGotoMode(bBus, CNM_OSEKI_C_AWAKE); // not required on iMX site !!!
    #endif // CSM_S_OSEKI_NM

    #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
    CNM_VWHIGH_lGotoMode(bBus, CNM_VWHIGH_C_AWAKE);
    #endif // CSM_S_VWHIGH_NM
  #endif // CSM_S_CNM_AVAILABLE

  #if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
    CBR_lStartRx(bBus);
    CBR_lStartTx(bBus); // This is special for the remote stack. Transmitting must be always possible
  #endif // CSM_S_CBR_AVAILABLE

  #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
  #if (CSM_S_MCNET == CSM_C_F_ON)
    // Start MCNet slave NM instances
    #if (CSM_S_MCNET_SLAVE_NWM == CSM_C_F_ON)
    CSM_MCNET_lStartSlaveNM(bBus);
    #endif // CSM_S_MCNET_SLAVE_NWM
  #endif // CSM_S_MCNET
  #endif // CSM_S_CNP_AVAILABLE

  #ifdef GLB_CAR_RADIO
  CSM_vSYS_ActiveIndication(); // inform PWR management
  #endif

  #if (CSM_S_TEST == CSM_C_F_ON)
  CSM_vTestPrintf("Down->Listen\n");
  #endif

  fReturnValue = TRUE;
  return fReturnValue;
} /*lint !e715 PQM_authorized_multi_122. Reason: Variable is a preset by interface, but not used intentionally */

/*******************************************************************************
 * function    csm_fChangeListenStartup
 * \doxydocu
 * \brief      The function contains the necessary actions for bus state
 *             transition from Listen to Startup.
 *
 * \see        See function csm_fChangeDownListen().
 *
 * \param[in]  bBus
 *              Bus number
 *
 * \return     TRUE:  transition was successfull
 *             FALSE: transition failed
 *
 * \access     Downstream task
 * \reentrant  no
 *
 * \lastreview 01.07.08 VTeam-Zurmhl
 *
 * \history_begin
 * 02.03.04 CM-DI/ESU3-Khler
 * - Initial example version.
 * \history_end
 ******************************************************************************/
BOOLEAN csm_fChangeListenStartup(BYTE bBus)
{
  #if (CSM_S_TRACE == CSM_C_F_ON)
  #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
  {
    #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
    ETG_TRACE_USR2(("CSM State Change - csm_fChangeListenStartup - Bus:%X ",
                     ETG_CENUM(tCSM_BUS_NUMBER,               (tU8)  bBus)
                  ));
    #endif
  }
  #else // CSM_S_TRACE_ETG
  {
    BYTE abData[3];
    abData[0] = bBus;
    abData[1] = CSM_C_STATE_BUS_LISTEN;
    abData[2] = CSM_C_STATE_BUS_STARTUP;

    CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_CSM_CHANGE, abData, 3);
  }
  #endif // CSM_S_TRACE_ETG
  #endif // CSM_S_TRACE

  #if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)
  CDA_lActivate(bBus, CDA_C_LISTEN_AND_SEND);
  #endif

  #if (CSM_S_TEST == CSM_C_F_ON)
  CSM_vTestPrintf("Listen->Startup\n");
  #endif

  return TRUE;
} /*lint !e715 PQM_authorized_multi_122. Reason: Variable is a preset by interface, but not used intentionally */

/*******************************************************************************
 * function    csm_fChangeStartupUp
 * \doxydocu
 * \brief      The function contains the necessary actions for bus state
 *             transition from Startup to Up.
 *
 * \see        See function csm_fChangeListenStartup()
 *
 * \param[in]  bBus
 *              Bus number
 *
 * \return     TRUE:  transition was successfull
 *             FALSE: transition failed
 *
 * \access     Downstream task
 * \reentrant  no
 *
 * \lastreview 01.07.08 VTeam-Zurmhl
 *
 * \history_begin
 * 01.07.08 VTeam-Zurmhl
 * - CNM_OSEK_lInit(0, CNM_OSEK_C_NM_NORMAL) -> CNM_OSEK_lInit(bBus, CNM_OSEK_C_NM_NORMAL);
 *
 * 02.03.04 CM-DI/ESU3-Khler
 * - Initial example version.
 * \history_end
 ******************************************************************************/
BOOLEAN csm_fChangeStartupUp(BYTE bBus)
{
  #if (CSM_S_TRACE == CSM_C_F_ON)
  #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
  {
    #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
    ETG_TRACE_USR2(("CSM State Change - csm_fChangeStartupUp - Bus:%X ",
                     ETG_CENUM(tCSM_BUS_NUMBER,               (tU8)  bBus)
                  ));
    #endif
  }
  #else // CSM_S_TRACE_ETG
  {
    BYTE abData[3];
    abData[0] = bBus;
    abData[1] = CSM_C_STATE_BUS_STARTUP;
    abData[2] = CSM_C_STATE_BUS_UP;

    CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_CSM_CHANGE, abData, 3);
  }
  #endif // CSM_S_TRACE_ETG
  #endif // CSM_S_TRACE

  #if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)
  CDA_lActivate(bBus, CDA_C_LISTEN_AND_SEND);
  #endif

  #if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
  {
    #if (CSM_S_IVLAN_NM == CSM_C_F_ON)
    CNM_IVLAN_lGotoMode(bBus, CNM_IVLAN_C_UP);
    #endif

    // start NM frames
    #if (CSM_S_OSEK_NM == CSM_C_F_ON)
    CNM_OSEK_lInit(bBus, CNM_OSEK_C_NM_NORMAL);
    #endif // CSM_S_OSEK_NM

    #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
    // place your tasks here
    #endif // CSM_S_OSEKI_NM

    #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
    CNM_VWHIGH_lGotoMode(bBus, CNM_VWHIGH_C_AWAKE);
    #endif // CSM_S_VWHIGH_NM
  }
  #endif // CSM_S_CNM_AVAILABLE

  #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
    #if (CSM_S_ISO_TP == CSM_C_F_ON)
    {
      // CommunicationIndication for "regular" ITP connections
    }
    #endif /* CSM_S_ISO_TP */

    #if (CSM_S_MCNET == CSM_C_F_ON) /* && feature automatic ConnectRequest on startup */
    {
      #if (CSM_S_MCNET_MASTER_NWM == CSM_C_F_ON)
      CSM_MCNET_lStartMasterNM(bBus);
      #endif // CSM_S_MCNET_MASTER_NWM
      // CNP_MCNET_lConnectReq()
    }
    #endif // CSM_S_MCNET

    #if (CSM_S_VW_BAP_TP == CSM_C_F_ON)
    CSM_BAP_StackActivated();
    #endif
  #endif // CSM_S_CNP_AVAILABLE

  #if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
  CBR_lStartTx(bBus);
  #endif // CSM_S_CBR_AVAILABLE

  #ifdef GLB_CAR_RADIO
  CSM_vSYS_NormalIndication();
  #endif

  #if (CSM_S_TEST == CSM_C_F_ON)
  CSM_vTestPrintf("Startup->Up\n");
  #endif

  return TRUE;
} /*lint !e715 PQM_authorized_multi_122. Reason: Variable is a preset by interface, but not used intentionally */

/*******************************************************************************
 * function    csm_fChangeStartupListen
 * \doxydocu
 * \brief      The function contains the necessary actions for bus state
 *             transition from Startup to Listen.
 *
 * \see        See function csm_fChangeDownListen().
 *
 * \param[in]  bBus
 *              Bus number
 *
 * \return     TRUE:  transition was successfull
 *             FALSE: transition failed
 *
 * \access     Downstream task
 * \reentrant  no
 *
 * \lastreview 01.07.08 VTeam-Zurmhl
 *
 * \history_begin
 * 02.03.04 CM-DI/ESU3-Khler
 * - Initial example version.
 * \history_end
 ******************************************************************************/
BOOLEAN csm_fChangeStartupListen(BYTE bBus)
{
  #if (CSM_S_TRACE == CSM_C_F_ON)
  #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
  {
    #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
    ETG_TRACE_USR2(("CSM State Change - csm_fChangeStartupListen - Bus:%X ",
                     ETG_CENUM(tCSM_BUS_NUMBER,               (tU8)  bBus)
                  ));
    #endif
  }
  #else // CSM_S_TRACE_ETG
  {
    BYTE abData[3];
    abData[0] = bBus;
    abData[1] = CSM_C_STATE_BUS_STARTUP;
    abData[2] = CSM_C_STATE_BUS_LISTEN;

    CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_CSM_CHANGE, abData, 3);
  }
  #endif // CSM_S_TRACE_ETG
  #endif // CSM_S_TRACE

  #if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
  // CBR_lStopTx(bBus); // This is special for the remote stack. Transmitting must be always possible
  #endif

  #if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
    #if ( CSM_S_OSEK_NM == CSM_C_F_ON )
      #if ( CNM_OSEK_S_VW_PAYLOAD == CSM_C_F_ON )
      CNM_OSEK_lSetPayload( bBus, CNM_OSEK_C_NMINFO_WAKEUP_UNKNOWN);
      #endif // CNM_OSEK_S_VW_PAYLOAD
    #endif // CSM_S_OSEK_NM

    #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
    // place your tasks here
    #endif // CSM_S_OSEKI_NM

    #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
    // place your tasks here
    #endif // CSM_S_VWHIGH_NM
  #endif // CSM_S_CNM_AVAILABLE

  #if (CSM_S_TEST == CSM_C_F_ON)
  CSM_vTestPrintf("Startup->Listen\n");
  #endif

  return TRUE;
} /*lint !e715 PQM_authorized_multi_122. Reason: Variable is a preset by interface, but not used intentionally */

/*******************************************************************************
 * function    csm_fChangeUpShutdown
 * \doxydocu
 * \brief      The function contains the necessary actions for bus state
 *             transition from Up to Shutdown.
 *
 * \see        See function csm_fShutdownUp().
 *
 * \param[in]  bBus
 *              Bus number
 *
 * \return     TRUE:  transition was successfull
 *             FALSE: transition failed
 *
 * \access     Downstream task
 * \reentrant  no
 *
 * \lastreview 01.07.08 VTeam-Zurmhl
 *
 * \history_begin
 * 01.07.08 VTeam-Zurmhl
 * - CNM_OSEK_lGotoMode(0,CNM_OSEK_C_BUS_SLEEP) -> CNM_OSEK_lGotoMode(bBus, CNM_OSEK_C_BUS_SLEEP)
 *
 * 02.03.04 CM-DI/ESU3-Khler
 * - Initial example version.
 * \history_end
 ******************************************************************************/
BOOLEAN csm_fChangeUpShutdown(BYTE bBus)
{
  #if (CSM_S_TRACE == CSM_C_F_ON)
  #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
  {
    #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
    ETG_TRACE_USR2(("CSM State Change - csm_fChangeUpShutdown - Bus:%X ",
                     ETG_CENUM(tCSM_BUS_NUMBER,               (tU8)  bBus)
                  ));
    #endif
  }
  #else // CSM_S_TRACE_ETG
  {
    BYTE abData[3];
    abData[0] = bBus;
    abData[1] = CSM_C_STATE_BUS_UP;
    abData[2] = CSM_C_STATE_BUS_SHUTDOWN;

    CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_CSM_CHANGE, abData, 3);
  }
  #endif // CSM_S_TRACE_ETG
  #endif // CSM_S_TRACE

  #if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
  {
    #if (CSM_S_IVLAN_NM == CSM_C_F_ON)
    CNM_IVLAN_lGotoMode(bBus, CNM_IVLAN_C_SHUTDOWN);
    #endif

    #if (CSM_S_OSEK_NM == CSM_C_F_ON)
    CNM_OSEK_lGotoMode(bBus, CNM_OSEK_C_BUS_SLEEP);
    #endif // CSM_S_OSEK_NM

    #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
    // place your tasks here
    #endif // CSM_S_OSEKI_NM

    #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
    // place your tasks here
    #endif // CSM_S_VWHIGH_NM
  }
  #endif // CSM_S_CNM_AVAILABLE

  #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
  #if (CSM_S_MCNET == CSM_C_F_ON)
    #if (CSM_S_MCNET_MASTER_NWM == CSM_C_F_ON)
    CSM_MCNET_lStopMasterNM(bBus);
    #endif // CSM_S_MCNET_MASTER_NWM
  #endif // CSM_S_MCNET
  #endif // CSM_S_CNP_AVAILABLE

  #ifdef GLB_CAR_RADIO
  CSM_vSYS_ActiveIndication();  // transition normal -> active
  #endif

  #if (CSM_S_TEST == CSM_C_F_ON)
  CSM_vTestPrintf("Up->Shutdown\n");
  #endif

  return TRUE;
} //*lint !e715 PQM_authorized_multi_122. Reason: Variable is a preset by interface, but not used intentionally */

/*******************************************************************************
 * function    csm_fChangeShutdownUp
 * \doxydocu
 * \brief      The function contains the necessary actions for bus state
 *             transition from Shutdown to Up.
 *
 * \see        See function csm_fChangeUpShutdown()
 *
 * \param[in]  bBus
 *              Bus number
 *
 * \return     TRUE:  transition was successfull
 *             FALSE: transition failed
 *
 * \access     Downstream task
 * \reentrant  no
 *
 * \lastreview 01.07.08 VTeam-Zurmhl
 *
 * \history_begin
 * 01.07.08 VTeam-Zurmhl
 * - CNM_OSEK_lGotoMode(0,CNM_OSEK_C_AWAKE) -> CNM_OSEK_lGotoMode(bBus, CNM_OSEK_C_AWAKE);
 *
 * 02.03.04 CM-DI/ESU3-Khler
 * - Initial example version.
 * \history_end
 ******************************************************************************/
BOOLEAN csm_fChangeShutdownUp(BYTE bBus)
{
  #if (CSM_S_TRACE == CSM_C_F_ON)
  #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
  {
    #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
    ETG_TRACE_USR2(("CSM State Change - csm_fChangeShutdownUp - Bus:%X ",
                     ETG_CENUM(tCSM_BUS_NUMBER,               (tU8)  bBus)
                  ));
    #endif
  }
  #else // CSM_S_TRACE_ETG
  {
    BYTE abData[3];
    abData[0] = bBus;
    abData[1] = CSM_C_STATE_BUS_SHUTDOWN;
    abData[2] = CSM_C_STATE_BUS_UP;

    CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_CSM_CHANGE, abData, 3);
  }
  #endif // CSM_S_TRACE_ETG
  #endif // CSM_S_TRACE

  #if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
  {
    #if (CSM_S_IVLAN_NM == CSM_C_F_ON)
    CNM_IVLAN_lGotoMode(bBus, CNM_IVLAN_C_UP);
    #endif

    // e.g. clear sleep indication bit for OSEK NM
    #if (CSM_S_OSEK_NM == CSM_C_F_ON)
    CNM_OSEK_lGotoMode(bBus, CNM_OSEK_C_AWAKE);
    #endif // CSM_S_OSEK_NM

    #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
    // place your tasks here
    #endif // CSM_S_OSEKI_NM

    #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
    // place your tasks here
    #endif // CSM_S_VWHIGH_NM
  }
  #endif // CSM_S_CNM_AVAILABLE

  #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
    #if (CSM_S_MCNET == CSM_C_F_ON) // && feature automatic ConnectRequest on startup
    {
      // (Re-)Start MCNet Master NM services
      #if (CSM_S_MCNET_MASTER_NWM == CSM_C_F_ON)
      CSM_MCNET_lStartMasterNM(bBus); // U.Z.(6): Auswertung von bBus noch zu klaeren.
      #endif // CSM_S_MCNET_MASTER_NWM
    }
    #endif // CSM_S_MCNET

    #if (CSM_S_VW_BAP_TP == CSM_C_F_ON)
    CSM_BAP_StackActivated();
    #endif
  #endif // CSM_S_CNP_AVAILABLE

  #ifdef GLB_CAR_RADIO
  CSM_vSYS_NormalIndication();
  #endif

  #if (CSM_S_TEST == CSM_C_F_ON)
  CSM_vTestPrintf("Shutdown->Up\n");
  #endif

  return TRUE;
} /*lint !e715 PQM_authorized_multi_122. Reason: Variable is a preset by interface, but not used intentionally */

/*******************************************************************************
 *  function    csm_fChangeShutdownListen
 * \doxydocu
 * \brief      The function contains the necessary actions for bus state
 *             transition from Shutdown to Listen.
 *
 * \see        See function csm_fStartupListen().
 *
 * \param[in]  bBus
 *              Bus number
 *
 * \return     TRUE:  transition was successfull
 *             FALSE: transition failed
 *
 * \access     Downstream task
 * \reentrant  no
 *
 * \lastreview 01.07.08 VTeam-Zurmhl
 *
 * \history_begin
 * 02.03.04 CM-DI/ESU3-Khler
 * - Initial example version.
 * \history_end
 ******************************************************************************/
BOOLEAN csm_fChangeShutdownListen(BYTE bBus)
{
  #if (CSM_S_TRACE == CSM_C_F_ON)
  #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
  {
    #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
    ETG_TRACE_USR2(("CSM State Change - csm_fChangeShutdownListen - Bus:%X ",
                     ETG_CENUM(tCSM_BUS_NUMBER,               (tU8)  bBus)
                  ));
    #endif
  }
  #else // CSM_S_TRACE_ETG
  {
    BYTE abData[3];
    abData[0] = bBus;
    abData[1] = CSM_C_STATE_BUS_SHUTDOWN;
    abData[2] = CSM_C_STATE_BUS_LISTEN;

    CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_CSM_CHANGE, abData, 3);
  }
  #endif // CSM_S_TRACE_ETG
  #endif // CSM_S_TRACE

  #if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
  {
    #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
    // place your tasks here
    #endif // CSM_S_OSEKI_NM

    #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
    // place your tasks here
    #endif // CSM_S_VWHIGH_NM
  }
  #endif // CSM_S_CNM_AVAILABLE

  #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
  // disconnection of channels ??
  #endif // CSM_S_CNP_AVAILABLE

  #if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
  // CBR_lStopTx(bBus);
  #endif // CSM_S_CBR_AVAILABLE

  #if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)
  CDA_lActivate(bBus, CDA_C_LISTEN_ONLY);
  #endif // CSM_S_CDA_AVAILABLE

  #if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
  #if ( CSM_S_OSEK_NM == CSM_C_F_ON )
    #if ( CNM_OSEK_S_VW_PAYLOAD == CSM_C_F_ON )
      CNM_OSEK_lSetPayload( bBus, CNM_OSEK_C_NMINFO_WAKEUP_UNKNOWN);
    #endif // CNM_OSEK_S_VW_PAYLOAD
  #endif // CSM_S_OSEK_NM
  #endif // CSM_S_CNM_AVAILABLE

  #if (CSM_S_TEST == CSM_C_F_ON)
  CSM_vTestPrintf("Shutdown->Listen\n");
  #endif

  return TRUE;
} /*lint !e715 PQM_authorized_multi_122. Reason: Variable is a preset by interface, but not used intentionally */

/*******************************************************************************
 * function    csm_fChangeListenDown
 * \doxydocu
 * \brief      The function contains the necessary actions for bus state
 *             transition from Listen to Down.
 *
 * \see        See function csm_fChangeDownListen().
 *
 * \param[in]  bBus
 *              Bus number
 *
 * \return     TRUE:  transition was successfull
 *             FALSE: transition failed
 *
 * \access     Downstream task
 * \reentrant  no
 *
 * \lastreview 01.07.08 VTeam-Zurmhl
 *
 * \history_begin
 * 01.07.08 VTeam-Zurmhl
 * - CDA_lDeActivate(CSM_C_CAN_1,..) -> CDA_lDeActivate(bBus,..);
 *
 * 02.03.04 CM-DI/ESU3-Khler
 * - Initial example version.
 * \history_end
 ******************************************************************************/
BOOLEAN csm_fChangeListenDown(BYTE bBus)
{
  BOOLEAN fReturnValue = TRUE;

  #if (CSM_S_TRACE == CSM_C_F_ON)
  #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
  {
    #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
    ETG_TRACE_USR2(("CSM State Change - csm_fChangeListenDown - Bus:%X ",
                     ETG_CENUM(tCSM_BUS_NUMBER,               (tU8)  bBus)
                  ));
    #endif
  }
  #else // CSM_S_TRACE_ETG
  {
    BYTE abData[3];
    abData[0] = bBus;
    abData[1] = CSM_C_STATE_BUS_LISTEN;
    abData[2] = CSM_C_STATE_BUS_DOWN;

    CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_CSM_CHANGE, abData, 3);
  }
  #endif // CSM_S_TRACE_ETG
  #endif // CSM_S_TRACE

  #if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
  {
    #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
    // place your tasks here
    #endif // CSM_S_OSEKI_NM

    #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
    // place your tasks here
    #endif // CSM_S_VWHIGH_NM
  }
  #endif // CSM_S_CNM_AVAILABLE

  if (fReturnValue == TRUE) /*lint !e774 */
  {
    #if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
    // CBR_lStopRx(bBus);
    #endif // CSM_S_CBR_AVAILABLE

    #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
    #if (CSM_S_MCNET == CSM_C_F_ON)
      // Stop MCNet slave NM instances
      #if (CSM_S_MCNET_SLAVE_NWM == CSM_C_F_ON)
      CSM_MCNET_lStopSlaveNM(bBus);
      #endif // CSM_S_MCNET_SLAVE_NWM
    #endif // CSM_S_MCNET
    #endif // CSM_S_CNP_AVAILABLE

    #if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)
    CDA_lDeActivate(bBus, CDA_C_SLEEP, CDA_C_SLEEP);
    #endif // CSM_S_CDA_AVAILABLE

    #ifdef GLB_CAR_RADIO
    CSM_vSYS_SleepConfirmation();
    #endif
  }

  #if (CSM_S_TEST == CSM_C_F_ON)
  CSM_vTestPrintf("Listen->Down\n");
  #endif

  return fReturnValue;
} /*lint !e715 PQM_authorized_multi_122. Reason: Variable is a preset by interface, but not used intentionally */

/*******************************************************************************
 * function    csm_bCalculateBusState
 * \doxydocu
 * \brief
 *             MP: Vorschlag zur Abstimmung
 *             Hier ist eine neue Busstate Behandlung entstanden.
 *             Es gibt nur noch eine Zentrale Stelle wo der Busstate gesetzt
 *             wird.
 *             Called by CSM_bCalcBusState() (Downstream Task)

 * \param[in]  bBus
 *              Bus number
 *
 * \return     New Bus state
 *
 * \access     Downstream task
 * \reentrant  no
 *
 * \lastreview 01.07.08 VTeam-Zurmhl
 *
 * \history_begin
 * 09.02.05 VTeam-Prhl
 * - Initial version.
 * \history_end
 ******************************************************************************/
BYTE csm_bCalculateBusState(BYTE bBus)
{
  BYTE bNewBusState = CSM_C_STATE_BUS_DOWN;

  // MP: nur zum Test. Es muss noch gekrt werden wie der Anfangs Zustand sein soll und was passieren soll, wenn der Busgeweckt wird
  if( csm_fWakeupFlag == TRUE)
  {
    csm_fWakeupFlag = FALSE;
    //bNewBusState = CSM_C_STATE_BUS_DOWN;
    bNewBusState = CSM_C_STATE_BUS_LISTEN;
    //bNewBusState = CSM_C_STATE_BUS_SHUTDOWN;
    //bNewBusState = CSM_C_STATE_BUS_SHUTDOWN;
    //bNewBusState = CSM_C_STATE_BUS_UP;
    #if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
    #if (CSM_S_IVLAN_NM == CSM_C_F_ON)
    bNewBusState = CSM_C_STATE_BUS_LISTEN;
    #endif
    #if (CSM_S_OSEK_NM == CSM_C_F_ON)
    bNewBusState = CSM_C_STATE_BUS_SHUTDOWN;
    #endif // CSM_S_OSEK_NM
    #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
    bNewBusState = CSM_C_STATE_BUS_LISTEN;
    #endif // CSM_S_OSEKI_NM
    #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
    bNewBusState = CSM_C_STATE_BUS_SHUTDOWN;
    #endif // CSM_S_VWHIGH_NM
    #endif // CSM_S_CNM_AVAILABLE
  }
  // hier knnte eine Auswertung der Weckgrnde stehen
  return( CSM_C_STATE_BUS_UP/*bNewBusState*/);//TODO:MP Der CSM muss up sein, damit der CBR luft.
}/*lint !e715 PQM_authorized_multi_122. Reason: Variable is a preset by interface, but not used intentionally */

/***************************************************************************************************
 * function    CSM_vStackActivated
 * \doxydocu
 * \brief      this function is called at the end of CSM_lInit(START)
 *             to do some project specific post initialization work
 *
 * \see        CAN-SW Architecture, written by CM-DI/ESA3
 *
 * \param      void
 *
 * \return     void
 *
 * \access     Init
 * \reentrant  ?
 *
 * \lastreview 02.07.08 VTeam-Zurmhl
 *
 * \history_begin
 * 14.09.04 CM-DI/ESA3-Battis
 * - Initial template version.
 * \history_end
 **************************************************************************************************/
extern BOOL csm_fPowerCtrlOn;
void CSM_vStackActivated(void)
{
  // switch ON the proxy indirectly -> force a processing of the new power state
  // SM will be triggered later on with POW_ON event
  csm_fPowerCtrlOn = TRUE;                               //TODO: Check if there is a better solution
  csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_CSM_IND_RADIOSTATUSCHANGED);

  // some legacy testing with VW MIB signals
  #ifdef MP_SIMPLE_TEST_CASE
  LONG lReturnValue = CSM_lSignalCallbackInit(NULL, CSM_C_SIG_RX_ACC_Status_Anzeige_ACC_02, csm_apl_vCSMSignalInd_BS3_Klemme_S_mBSG_3);
  #endif // MP_SIMPLE_TEST_CASE

  // some legacy testing with VW ISO TP
  #ifdef MP_SIMPLE_TEST_CASE_TP
  {
    BYTE abAddr1[2] = { CSM_C_ADDRESS_FIELD_VW_USDT_ISO_ZR_Entry, CSM_C_ADDRESS_FIELD_VW_USDT_ISO_0};
    BYTE abAddr2[2] = { CSM_C_ADDRESS_FIELD_VW_USDT_ISO_ZR_Entry, CSM_C_ADDRESS_FIELD_VW_USDT_ISO_1};
    CSM_lApplCallbackInit( NULL,CSM_C_CAN_BUS_INFO, CSM_C_PTYPE_VW_USDT_ISO, abAddr1, &rCallback);
    CSM_lApplCallbackInit( NULL,CSM_C_CAN_BUS_INFO, CSM_C_PTYPE_VW_USDT_ISO, abAddr2, &rCallback);
  }
  #endif // MP_SIMPLE_TEST_CASE_TP

  // some legacy testing with VW BAP
  #ifdef MP_SIMPLE_TEST_CASE_BAP
  {
    BYTE abAddr1[2] = { CSM_C_ADDRESS_FIELD_VW_BAP_LSG_01, 0};
    BYTE abAddr2[2] = { CSM_C_ADDRESS_FIELD_VW_BAP_LSG_02, 0};
    CSM_lApplCallbackInit( NULL,CSM_C_CAN_BUS_INFO, CSM_C_PTYPE_VW_BAP, abAddr1, &rCallbackBap);
    CSM_lApplCallbackInit( NULL,CSM_C_CAN_BUS_INFO, CSM_C_PTYPE_VW_BAP, abAddr2, &rCallbackBap);
  }
  #endif // MP_SIMPLE_TEST_CASE_BAP

  // some legacy testing with VW BR
  #ifdef MP_SIMPLE_TEST_CASE_CSM_CBR
  {
    BYTE abAddr1[2] = { CSM_C_ADDRESS_FIELD_VW_BR_MAS, CSM_C_ADDRESS_FIELD_VW_BR_UNDEF};
    //BYTE abAddr2[2] = { CSM_C_ADDRESS_FIELD_VW_BR_MAS, CSM_C_ADDRESS_FIELD_VW_BR_UNDEF};
    CSM_lApplCallbackInit( NULL,CSM_C_CAN_BUS_INFO, CSM_C_PTYPE_VW_BR_SIGNAL, abAddr1, &rCallbackCSM_CBR);
    //CSM_lApplCallbackInit( NULL,CSM_C_CAN_BUS_INFO, CSM_C_PTYPE_VW_BR_SIGNAL, abAddr2, &rCallbackBap);
  }
  #endif // MP_SIMPLE_TEST_CASE_CSM_CBR
}

/*******************************************************************************
 * function implementation (scope: CAN stack and operating system)
 *******************************************************************************/

/*******************************************************************************
 * function    CSM_vCDAWakeupInd
 * \doxydocu
 * \brief      Startup CSM, when message is received while CDA is not activated.
 *
 * \see        CAN-SW Architecture, written by CM-DI/ESA3
 *
 * \param[in]  bBus
 *              CAN bus number
 *
 * \return     void
 *
 * \access     interrupt
 * \reentrant  no
 *
 * \lastreview 01.07.08 VTeam-Zurmhl
 *
 * \history_begin
 * 14.11.05 CM-DI/ESA3-Prhl
 * first implementation
 *
 * \history_end
 ******************************************************************************/
VOID CSM_vCDAWakeupInd(BYTE bBus)
{
  if (CSM_C_STATE_ACTIVE == csm_bCsmState)
  {
    if ((CSM_C_STATE_BUS_DOWN   == csm_abCsmSubState[bBus]) ||
        (CSM_C_STATE_BUS_LISTEN == csm_abCsmSubState[bBus]))
    {
      #if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
        #if ( CSM_S_OSEK_NM == CSM_C_F_ON )
          #if ( CNM_OSEK_S_VW_PAYLOAD == CSM_C_F_ON )
          CNM_OSEK_lSetPayload( bBus, CNM_OSEK_C_NMINFO_WAKEUP_CAN);
          #endif /* CNM_OSEK_S_VW_PAYLOAD == CSM_C_F_ON */
        #endif /* CSM_S_OSEK_NM == CSM_C_F_ON */

        #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
        /* place your tasks here */
        #endif /* CSM_S_OSEKI_NM */
        #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
        /* place your tasks here */
        #endif /* CSM_S_VWHIGH_NM */
      #endif /* CSM_S_CNM_AVAILABLE */
      csm_fWakeupFlag = TRUE;
      csm_vTriggerCsmDownstreamTaskFromIrq( CSM_C_DOWN_REASON_CSM_BUS_STATE_CHANGED);
    }
    /* else CAN alrady actice. Wakeup indication is an error */
  }
  /*else
  {
    * CAN wakeup indication before CAN stack is initialized =>
    * wakeup reason stored above for later evaluation.
    }*/
} /* end CSM_vCDAWakeupInd() */

#endif /* CSM_S_DOXYGEN_HIDE_NON_API_FCT */

/***************************************************************************************************
/* legacy test case Geraffel
/**************************************************************************************************/
#ifdef MP_SIMPLE_TEST_CASE
typedef struct
{
  BYTE bKlemmeS;
  BOOL fValidKlemmeS;
  BOOL fNewTrigger;
}tBS3_Klemme_S_mBSG_3_State;
static tBS3_Klemme_S_mBSG_3_State         rBS3_Klemme_S_mBSG_3_State;

static void csm_apl_vReadSignalBS3_Klemme_S_mBSG_3(void)
{
  DWORD dwSignalReadStatus = 0;
  LONG lRetCode = CSM_C_NO_ERROR;

  BYTE bKlemmeS;
  /* --- if we are interested in the signal value ---------------------- */
  lRetCode = CSM_lSignalRead( CSM_C_SIG_RX_ACC_Status_Anzeige_ACC_02,
                              &bKlemmeS,
                              sizeof(bKlemmeS),
                              &dwSignalReadStatus);

  /* if CSM_lSignalRead was successful: */
  if (lRetCode >= CSM_C_NO_ERROR)
  {
    /* if data buffer contains valid data: */
    if ( ((dwSignalReadStatus & CSM_C_SIGNAL_DATA_INVALID) == 0) &&
         ((dwSignalReadStatus & CSM_C_SIGNAL_TIMEOUT) == 0) )
    {
      /* Wir haben gltige Daten gelesen */
      rBS3_Klemme_S_mBSG_3_State.bKlemmeS = bKlemmeS;              //copy data
      rBS3_Klemme_S_mBSG_3_State.fValidKlemmeS = TRUE;
    } /* if data buffer contains valid data */
    else
    {
      /* Es wurden keine gltigen Datem gelesen */
      rBS3_Klemme_S_mBSG_3_State.fValidKlemmeS = FALSE;
    } /* else data buffer contains valid data */
  } /* else CSM_lSignalRead has failed */
  else
  {
    /*CSM_lSignalRead was not successful */
    rBS3_Klemme_S_mBSG_3_State.fValidKlemmeS = FALSE;
  } /* if CSM_lSignalRead was successful */

  /* ------------------------------------------------------------------- */
}

static void csm_apl_vCSMSignalInd_BS3_Klemme_S_mBSG_3(void * pvHandle, DWORD dwSignalID, DWORD dwSignalIndStatus)
{
  csm_apl_vReadSignalBS3_Klemme_S_mBSG_3();
}
#endif // MP_SIMPLE_TEST_CASE

#ifdef MP_SIMPLE_TEST_CASE_TP
void XXX_vCSMCommunicationCon(void * pvHandle, BYTE ubBus, DWORD ulwProtocolType,
                              const void* pvAddressField,
                              BYTE ubConnectState,WORD uwApplID)
{
  ETG_TRACE_USR1(("CSM:XXX_vCSMCommunicationCon()"));
}

void XXX_vCSMCommunicationInd(void * pvHandle ,BYTE ubBus, DWORD ulwProtocolType,
                                 const void* pvAddressField,
                                 BYTE ubConnectState,WORD uwApplID)
{
  ETG_TRACE_USR1(("CSM:XXX_vCSMCommunicationInd()"));
}

void XXX_vCSMMsgCon(void * pvHandle, DWORD ulwProtocolType, const void *pvAddressField,
                    BYTE ubTransferResult)
{
  ETG_TRACE_USR1(("CSM:XXX_vCSMMsgCon()"));
}

void XXX_vCSMMsgReceived(void * pvHandle, DWORD ulwProtocolType, const void *pvAddressField,
                         BYTE *pubData, WORD uwDataLength)
{
  ETG_TRACE_USR1(("CSM:XXX_vCSMMsgReceived()"));
  CSM_lDataReq( ulwProtocolType,  pvAddressField, pubData, 7/*uwDataLength*/);
}

static const tCSM_ISO_TP_USDT_APPL_CALLBACK  rCallback =
{
  XXX_vCSMCommunicationCon,
  XXX_vCSMCommunicationInd,
  XXX_vCSMMsgCon,
  XXX_vCSMMsgReceived
};
#endif // MP_SIMPLE_TEST_CASE_TP

#ifdef MP_SIMPLE_TEST_CASE_BAP
void BAP_vCSMCommunicationCon(void * pvHandle, BYTE ubBus, DWORD ulwProtocolType,
                              const void* pvAddressField,
                              BYTE ubConnectState,WORD uwApplID)
{
  ETG_TRACE_USR1(("CSM:BAP_vCSMCommunicationCon()"));
}

void BAP_vCSMCommunicationInd(void * pvHandle ,BYTE ubBus, DWORD ulwProtocolType,
                              const void* pvAddressField,
                              BYTE ubConnectState,WORD uwApplID)
{
  ETG_TRACE_USR1(("CSM:BAP_vCSMCommunicationInd()"));
}

void BAP_vCSMDataCon(void * pvHandle, DWORD ulwProtocolType, const void *pvAddressField,
                     BYTE ubTransferResult)
{
  ETG_TRACE_USR1(("CSM:BAP_vCSMDataCon()"));
}

void BAP_vCSMDataInd(void * pvHandle, DWORD ulwProtocolType, const void *pvAddressField,
                     BYTE *pubData, WORD uwDataLength)
{
  ETG_TRACE_USR1(("CSM:BAP_vCSMDataInd()"));
}

static const tCSM_VW_BAP_APPL_CALLBACK  rCallbackBap =
{
  BAP_vCSMCommunicationCon,
  BAP_vCSMCommunicationInd,
  BAP_vCSMDataCon,
  BAP_vCSMDataInd
};
#endif // MP_SIMPLE_TEST_CASE_BAP

#ifdef MP_SIMPLE_TEST_CASE_CSM_CBR
void XXX_vCSMCommunicationCon(void * pvHandle, BYTE ubBus, DWORD ulwProtocolType,
                              const void* pvAddressField,
                              BYTE ubConnectState,WORD uwApplID)
{
  ETG_TRACE_USR1(("CSM:XXX_vCSMCommunicationCon()"));
}
void XXX_vCSMCommunicationInd(void * pvHandle ,BYTE ubBus, DWORD ulwProtocolType,
                              const void* pvAddressField,
                              BYTE ubConnectState,WORD uwApplID)
{
  ETG_TRACE_USR1(("CSM:XXX_vCSMCommunicationInd()"));
}

static const tCSM_BR_SIGNAL_APPL_CALLBACK  rCallbackCSM_CBR =
{
  CSM_C_APPL_ID_VW_BR_XXX,
  XXX_vCSMCommunicationCon,
  XXX_vCSMCommunicationInd,
};
#endif // MP_SIMPLE_TEST_CASE_CSM_CBR

/*******************************************************************************
 * function implementation (scope: CAN stack #1 API)
 ******************************************************************************/
// none

#undef CSM_P_SELF
#undef CSM_CAN_STACK
/*******************************************************************************
 * \doxydocu
 * \file          csm_p.c
 * \brief         Project specific part of the CAN stack manager module
 *
 * \see           CAN-SW Architecture, written by VTeam
 *
 * \sw_component  CAN stack
 * \project       VM MIB2 Entry
 * \path          \di_can\modules_swa\csm\src\
 *
 * \ingroup       CSM
 * \ingroup       CSM_IF
 *
 * \authors       VTeam
 *
 * COPYRIGHT      (c) 2015 Bosch Car Multimedia GmbH
 *
 * \history_begin
 *
 * 18.12.2013 \main\vw_mib2_mqb_proxy\11 Prhl
 * - test code added and disabled.
 *
 * 20.05.2015 \main\rn_aivi_proxy\1 Prhl
 * - merge from \main\vw_mib2_mqb_proxy\11
 *
 * 01.06.2015 \main\rn_aivi_proxy\2 M. Prhl
 * - call of CNM_OSEKI_lGotoMode() removed from csm_fChangeDownListen().
 *
 * 10.09.2015 \main\rn_aivi_proxy\3 M. Prhl
 * - CBR transmit and receive will not be stop if the bus state is changing.
 *   This will be handled on the V850. The i.MX can transfer the data always.
 *
 * 13.10.2015 \main\rn_aivi_proxy\4 M. Prhl
 * - add CBR_lStartTx() to csm_fChangeDownListen().
 *   CBR transmit and receive will always started.
 *   Start and Stop CBR will be handled on the V850. The iMX can transfer the data always.
 *
 * 16.02.2016 \main\rn_aivi_proxy\5 Borck
 * - review and cleanup (unused, VW project stuff removed or moved to end of file)
 *
 * 01.11.2016 \main\rn_aivi_proxy\6 Borck
 * - added ETG tracing for sections that are used by the project (so that old trace output is disabled)
 *
 * \history_end
 *//**** END OF FILE **********************************************************/

