/* Description and history of csm_m.h at the end of the file.                 */
#ifndef CSM_M_HEADER
/** File name for preprozessor commands */
#define CSM_M_HEADER

/*******************************************************************************
 * includes:  no further includes allowed
 ******************************************************************************/
#include "csm_mp.h"

/*******************************************************************************
 * defines and macros (scope: csm module local)
 ******************************************************************************/

/* Define the number of bus off detections in sequence until
 * indication.
 */
#define CSM_VW_C_NUM_OF_BUS_OFF_UNTIL_IND          2

#define CSM_M_MAKE_CSM_ERROR(SecurityLevel,ErrorCode) \
            CSM_M_MAKE_ERROR(SecurityLevel,CSM_C_ERR_LOC_CSM,ErrorCode)


/** -------------------------------------------------------------
 defines for CSM specific error codes (error location ERR_LOC_CSM)
    available code region: 0x1000 - 0xFFFF
-----------------------------------------------------------------*/
#define CSM_E_ERROR_STATE_WHILE_INIT               0x1001
#define CSM_E_ERROR_STATE_WHILE_WARM_INIT          0x1002
#define CSM_E_ERROR_STATE_WHILE_START              0x1003
#define CSM_E_ERROR_STATE_WHILE_BUS_UP_REQ         0x1004
#define CSM_E_ERROR_STATE_WHILE_STOP               0x1005
#define CSM_E_ERROR_STATE_WHILE_OFF                0x1006
#define CSM_E_ERROR_STATE_WHILE_EXIT               0x1007
#define CSM_E_ERROR_STATE_WHILE_DATA_REQ           0x1008
#define CSM_E_ERROR_STATE_WHILE_DATA_READ          0x1009

#define CSM_E_STATE_NO_VALID_ENTRY_IN_STATEMACHINE 0x1010
#define CSM_E_STATE_IS_NOT_ACTIVE                  0x1011
#define CSM_E_REENTRANT_CALL_OF_STATEMACHINE       0x1012
#define CSM_E_UNKNOWN_STATE_CHANGE_COMMAND         0x1013



/* function parameter event for CSM_lBusStateChange() and csm_lSwitchStateMachine() */
/* attention: values can be different from values for CSM_lBusStateChange in csm_ip.h */

#define CSM_C_EVENT_BUS_DOWN                    0x00
#define CSM_C_EVENT_BUS_LISTEN                  0x01
#define CSM_C_EVENT_BUS_UP                      0x02
#define CSM_C_EVENT_BUS_STARTUP                 0x03
#define CSM_C_EVENT_BUS_SHUTDOWN                0x04

/* defines for global states of can stack manager statemachine */
#define CSM_C_STATE_UNDEFINED                   0x00
#define CSM_C_STATE_OFF                         0x01
#define CSM_C_STATE_INITIALIZED                 0x02
#define CSM_C_STATE_ACTIVE                      0x03

/******************************************************************************/
#if (CSM_S_CAN_WAKEUP_FUNCTIONS_VIA_CSM == CSM_C_F_ON)
/* Makros to check wakeup reason */
#define CSM_M_SET_CAN_WAKEUP_REASON(bBus)    (CSM_bCanWasWakeupReason |=  (0x01U << bBus))
#define CSM_M_CLEAR_CAN_WAKEUP_REASON(bBus)  (CSM_bCanWasWakeupReason &= ~(0x01U << bBus))
#define CSM_M_IS_CAN_WAKEUP_REASON_SET(bBus) ((CSM_bCanWasWakeupReason & (0x01U << bBus)) ? TRUE : FALSE)

#if CSM_C_MAX_CAN_BUS > 8
#error "change type of CSM_bCanWasWakeupReason"
#endif
#endif /* CSM_S_CAN_WAKEUP_FUNCTIONS_VIA_CSM */

/*******************************************************************************
 * typedefs (scope: csm module local)
 ******************************************************************************/

typedef struct
{                                   /* state table line format */
  DWORD    dwEntryState;
  BYTE     bEvent;
  BOOLEAN  (*pvFunctionCall)(BYTE bBus);
  BOOLEAN  fReachedState;
  DWORD    dwExitStateIfFuncTrue;
  DWORD    dwExitStateIfFuncFalse;
} tCSM_STATE_MACHINE_ENTRY;


typedef struct
{
  BOOLEAN   fEntryIndication;
  BOOLEAN   fRecoveryIndication;
  BOOLEAN   fState;
} tBusOffState;

/*******************************************************************************
 * variable definition (scope: csm module local)
 ******************************************************************************/

/*****************************************************************
| variable csm_abCsmSubState[]
|
| comment: sub states of the stack manager for each CAN bus
|          used for BusStateIndication via Upstream task.
| range:   0..(2^8 - 1)
|
| access level (loop / interrupt): main loop level
|----------------------------------------------------------------*/

extern BYTE csm_bCsmState;
extern BYTE csm_abCsmSubState[CSM_C_MAX_CAN_BUS];

#if (CSM_S_CAN_WAKEUP_FUNCTIONS_VIA_CSM == CSM_C_F_ON)
/*******************************************************************************
 * variable CSM_bCanWasWakeupReason
* comment: Bitfield to set a flag x if CANx was wakeup reason.
*          Flag is set in interrupt service routine and cleared when wakeup
*          interrupts are enabled (and when flag was read in CSM_lInit(start)).
*          Use set/clear and read makros.
*
* range: 0..255 used as bitbield (bit 0 = CAN 0, ...)
*
* access level (loop / interrupt): usage of macros allowed only!
*                                  set flag on interrupt level,
*                                  clear and read on all levels
*                                  Wakeup interrupts are disabled when CAN tasks
*                                  and mainloop run so no DI/EI is used.
*******************************************************************************/
#ifdef CSM_STACK_ENV_SELF
BYTE CSM_bCanWasWakeupReason;  /* [bBus] */
#else
extern BYTE CSM_bCanWasWakeupReason;
#endif
#endif /* CSM_S_CAN_WAKEUP_FUNCTIONS_VIA_CSM */

#if (CSM_S_DEACTIVATE_COMMUNICATION_REQUESTS == CSM_C_F_ON)
  /*****************************************************************
  | variable csm_fIgnoreCommReq
  |
  | comment: flag to set all networks asleep with disregard to actual
  |          communication requests
  |
  | range:   TRUE: bus set asleep, without regard to CommReq's
  |          FALSE: normal operation
  |
  | access level (loop / interrupt): init / user
  |----------------------------------------------------------------*/
  extern BOOL csm_fIgnoreCommReq;
#else
  #define csm_fIgnoreCommReq FALSE
#endif /* (CSM_S_DEACTIVATE_COMMUNICATION_REQUESTS == CSM_C_F_ON) */

/*******************************************************************************
 * function prototypes (scope: csm module local)
 ******************************************************************************/

#ifdef CSM_SELF
#if (CSM_S_STATE_MASCHINE == CSM_C_F_ON)
static BOOLEAN csm_fChangeDummy(BYTE bBus);
#endif /* CSM_S_STATE_MASCHINE */
#endif

BOOLEAN csm_fChangeDownListen(BYTE bBus);
BOOLEAN csm_fChangeListenStartup(BYTE bBus);
BOOLEAN csm_fChangeListenDown(BYTE bBus);
BOOLEAN csm_fChangeStartupUp(BYTE bBus);
BOOLEAN csm_fChangeStartupListen(BYTE bBus);
BOOLEAN csm_fChangeUpShutdown(BYTE bBus);
BOOLEAN csm_fChangeShutdownListen(BYTE bBus);
BOOLEAN csm_fChangeShutdownUp(BYTE bBus);

VOID CSM_vStackActivated(VOID);

BYTE csm_bCalculateBusState( BYTE bBus);

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)

  #if (CSM_S_MCNET == CSM_C_F_ON)
    LONG CSM_lMCNet_Init(BYTE bInitMode);
    LONG CSM_lMCNet_Exit(BYTE bExitMode);
  #endif /* CSM_S_MCNET */

#endif /* CSM_S_CNP_AVAILABLE */

LONG CSM_lInitEnv(BYTE bInitMode);

/*LONG CSM_lInitApl(BYTE bInitMode); prototype or macro in csm_apl.h */

#if (CSM_S_VARIANTS_MANAGEMENT == CSM_C_F_ON)
LONG CSM_lInitVariants(BYTE bInitMode);
#endif

LONG CSM_lExitEnv(BYTE bExitMode);

/* LONG CSM_lExitApl(BYTE bExitMode); prototype or macro in csm_apl.h */

void csm_vIndicateCSMState(BYTE bBus);

VOID CSM_vSYS_BusStateInd(BYTE bBus, BYTE bActState);
void csm_vIndicateBusState(BYTE bBus);


BYTE csm_bGetBusState(BYTE bBus);

void csm_vSetBusState(BYTE bBus,BYTE bState);

void CSM_vProcessBusStateChange(BYTE bBus);

#if (CSM_S_ENABLE_INDICATE_BUSERROR == CSM_C_F_ON)
  void CSM_vProcessErrorInd( void);
#endif  /* #if (CSM_S_ENABLE_INDICATE_BUSERROR == CSM_C_F_ON) */

#ifdef CSM_C_DOWN_REASON_CSM_POST_INIT_START
/* CSM internal or CSM_STACK ? */
VOID CSM_vPostInitStart(BYTE bBus); /* Project specific function in csm_p.c */
#endif

/* ------------------------------------------------------------------------- */
/* Configuration table for the stack manager statemachine
 * (at the end of the header because prototypes are are necessary) */
#if (CSM_S_STATE_MASCHINE == CSM_C_F_ON)
#ifndef CSM_SELF
extern const tCSM_STATE_MACHINE_ENTRY csm_arStateMachineTable[];
#else
const tCSM_STATE_MACHINE_ENTRY csm_arStateMachineTable[] =
{ /* EntryState               bEvent                   pvFunctionCall              fReachedState
                              bStateOnExitIfFuncTrue   bStateOnExitIfFuncFalse */
  /* state bus down */
  {  CSM_C_STATE_BUS_DOWN,    CSM_C_EVENT_BUS_LISTEN,  csm_fChangeDownListen,      TRUE,
                              CSM_C_STATE_BUS_LISTEN,  CSM_C_STATE_BUS_DOWN  },
  {  CSM_C_STATE_BUS_DOWN,    CSM_C_EVENT_BUS_STARTUP, csm_fChangeDownListen,      FALSE,
                              CSM_C_STATE_BUS_LISTEN,  CSM_C_STATE_BUS_DOWN  },
  {  CSM_C_STATE_BUS_DOWN,    CSM_C_EVENT_BUS_UP,      csm_fChangeDownListen,      FALSE,
                              CSM_C_STATE_BUS_LISTEN,  CSM_C_STATE_BUS_DOWN  },
  {  CSM_C_STATE_BUS_DOWN,    CSM_C_EVENT_BUS_SHUTDOWN,csm_fChangeDownListen,      FALSE,
                              CSM_C_STATE_BUS_LISTEN,  CSM_C_STATE_BUS_DOWN  },
  {  CSM_C_STATE_BUS_DOWN,    CSM_C_EVENT_BUS_DOWN,    csm_fChangeDummy,           TRUE,
                              CSM_C_STATE_BUS_DOWN,    CSM_C_STATE_BUS_DOWN  },
  /* state bus listen */
  {  CSM_C_STATE_BUS_LISTEN,  CSM_C_EVENT_BUS_LISTEN,  csm_fChangeDummy,           TRUE,
                              CSM_C_STATE_BUS_LISTEN,  CSM_C_STATE_BUS_LISTEN  },
  {  CSM_C_STATE_BUS_LISTEN,  CSM_C_EVENT_BUS_STARTUP, csm_fChangeListenStartup,   TRUE,
                              CSM_C_STATE_BUS_STARTUP, CSM_C_STATE_BUS_LISTEN  },
  {  CSM_C_STATE_BUS_LISTEN,  CSM_C_EVENT_BUS_UP,      csm_fChangeListenStartup,   FALSE,
                              CSM_C_STATE_BUS_STARTUP, CSM_C_STATE_BUS_LISTEN  },
  {  CSM_C_STATE_BUS_LISTEN,  CSM_C_EVENT_BUS_SHUTDOWN,csm_fChangeListenStartup,   FALSE,
                              CSM_C_STATE_BUS_STARTUP, CSM_C_STATE_BUS_LISTEN  },
  {  CSM_C_STATE_BUS_LISTEN,  CSM_C_EVENT_BUS_DOWN,    csm_fChangeListenDown,      TRUE,
                              CSM_C_STATE_BUS_DOWN,    CSM_C_STATE_BUS_LISTEN  },
  /* state bus startup */
  {  CSM_C_STATE_BUS_STARTUP, CSM_C_EVENT_BUS_LISTEN,  csm_fChangeStartupListen,   TRUE,
                              CSM_C_STATE_BUS_LISTEN,  CSM_C_STATE_BUS_STARTUP  },
  {  CSM_C_STATE_BUS_STARTUP, CSM_C_EVENT_BUS_STARTUP, csm_fChangeDummy,           TRUE,
                              CSM_C_STATE_BUS_STARTUP, CSM_C_STATE_BUS_STARTUP  },
  {  CSM_C_STATE_BUS_STARTUP, CSM_C_EVENT_BUS_UP,      csm_fChangeStartupUp,       TRUE,
                              CSM_C_STATE_BUS_UP,      CSM_C_STATE_BUS_STARTUP  },
  {  CSM_C_STATE_BUS_STARTUP, CSM_C_EVENT_BUS_SHUTDOWN,csm_fChangeStartupUp,       FALSE,
                              CSM_C_STATE_BUS_UP,      CSM_C_STATE_BUS_STARTUP  },
  {  CSM_C_STATE_BUS_STARTUP, CSM_C_EVENT_BUS_DOWN,    csm_fChangeStartupListen,   FALSE,
                              CSM_C_STATE_BUS_LISTEN,  CSM_C_STATE_BUS_STARTUP  },
  /* state bus up */
  {  CSM_C_STATE_BUS_UP,      CSM_C_EVENT_BUS_LISTEN,  csm_fChangeUpShutdown,      FALSE,
                              CSM_C_STATE_BUS_SHUTDOWN,CSM_C_STATE_BUS_UP  },
  {  CSM_C_STATE_BUS_UP,      CSM_C_EVENT_BUS_STARTUP, csm_fChangeUpShutdown,      FALSE,
                              CSM_C_STATE_BUS_SHUTDOWN,CSM_C_STATE_BUS_UP  },
  {  CSM_C_STATE_BUS_UP,      CSM_C_EVENT_BUS_UP,      csm_fChangeDummy,           TRUE,
                              CSM_C_STATE_BUS_UP,      CSM_C_STATE_BUS_UP  },
  {  CSM_C_STATE_BUS_UP,      CSM_C_EVENT_BUS_SHUTDOWN,csm_fChangeUpShutdown,      TRUE,
                              CSM_C_STATE_BUS_SHUTDOWN,CSM_C_STATE_BUS_UP  },
  {  CSM_C_STATE_BUS_UP,      CSM_C_EVENT_BUS_DOWN,    csm_fChangeUpShutdown,      FALSE,
                              CSM_C_STATE_BUS_SHUTDOWN,CSM_C_STATE_BUS_UP  },
  /* state bus shutdown */
  {  CSM_C_STATE_BUS_SHUTDOWN,CSM_C_EVENT_BUS_LISTEN,  csm_fChangeShutdownListen,  TRUE,
                              CSM_C_STATE_BUS_LISTEN,  CSM_C_STATE_BUS_SHUTDOWN  },
  {  CSM_C_STATE_BUS_SHUTDOWN,CSM_C_EVENT_BUS_STARTUP, csm_fChangeShutdownListen,  FALSE,
                              CSM_C_STATE_BUS_LISTEN,  CSM_C_STATE_BUS_SHUTDOWN  },
  {  CSM_C_STATE_BUS_SHUTDOWN,CSM_C_EVENT_BUS_UP,      csm_fChangeShutdownUp,      TRUE,
                              CSM_C_STATE_BUS_UP,      CSM_C_STATE_BUS_SHUTDOWN  },
  {  CSM_C_STATE_BUS_SHUTDOWN,CSM_C_EVENT_BUS_SHUTDOWN,csm_fChangeDummy,           TRUE,
                              CSM_C_STATE_BUS_SHUTDOWN,CSM_C_STATE_BUS_SHUTDOWN  },
  {  CSM_C_STATE_BUS_SHUTDOWN,CSM_C_EVENT_BUS_DOWN,    csm_fChangeShutdownListen,  FALSE,
                              CSM_C_STATE_BUS_LISTEN,  CSM_C_STATE_BUS_SHUTDOWN  }
};
#endif
#endif /* CSM_S_STATE_MASCHINE */

#else
  #error CSM_M.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          csm_m.h
 * \brief         CAN stack manager header file for module internal defines and
 *                declarations.
 *
 * \see           CAN-SW Architecture, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/csm/src/
 *
 * \ingroup       CSM
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2004 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 02.03.04  Rev. main\3  CM-DI/ESU3-K"ohler
 * - All csm_fChangeXY functions except csm_fChangeDummy and csm_fChangeBusOff
 *   moved from csm.c to project files => static removed.
 *
 * 28.06.04  Rev. main\4  CM-DI/ESU3-Prhl
 * - warnings removed
 *
 * 03.09.04  Rev. main\5  CM-DI/ESA3-Battis
 * - feature switches aligend
 *
 * 03.09.04  Rev. main\6  CM-DI/ESA3-Prhl
 * - CSM_vProcessBusStateChange() added
 *
 * 30.09.04  Rev. main\7  CM-DI/ESA3-Battis
 * - csm_vPostInitStart() added
 *
 * 18.10.04  Rev. main\8  CM-DI/ESA3-K"ohler
 * - Struct CSM_CAN_TX_TEL added.
 * - Doxygen comments added.
 *
 * 01.11.04 Rev. main\9  CM-DI/ESA3-Battis
 * - csm_bCalculateBusState() prototype added
 *
 * 22.11.04 Rev. main\10 CM-DI/ESA3-Battis
 * - old CBR function headers removed
 *
 * 02.12.04 Rev. main\11 CM-DI/ESA3-Battis
 * - function header CSM_lExitApl() added
 *
 * 25.01.05  main\12  CM-DI/ESA3-K"ohler
 * - Prototype csm_vGetItpAdrParameter() removed because it is declared
 *   in csm_itp_m.h.
 *
 * 09.02.05  main\13  CM-DI/ESA3-Prhl
 * - CSM_STACK_ESD_SELF replaced by CSM_STACK_ENV_SELF
 *
 * 16.02.05  main\14  CM-DI/ESA3-Prhl
 * - function prototypes added
 *   LONG CSM_lExitEnv(BYTE bInitMode);
 *   void CSM_vLocalCtrlProcessCommunicationCon( void);
 *   void CSM_vLocalCtrlProcessCommunicationInd( void);
 *   void CSM_vLocalCtrlProcessCommunicationReg( void);
 *
 * 08.03.05  main\15  CM-DI/ESA3-Battis
 * - function prototypes added
 *   LONG CSM_lInitVariants(BYTE bInitMode);
 *
 * 09.05.05  main\16  CM-DI/ESA3-K"ohler
 * - csm_vPostInitStart() featured with switch
 *   CSM_C_DOWN_REASON_CSM_POST_INIT_START.
 *
 * 09.05.05  main\17  CM-CR/ESD4-Tuschik
 * - add VW-Features
 *
 * 09.05.05  main\18  CM-DI/ESA3-Battis
 * - changes to make MISRA happy
 *
 * 25.05.05  main\19  CM-DI/ESA3-K"ohler
 * - Prototypes CSM_lInitApl() and CSM_lExitApl() moved to csm_apl.h.
 *
 * 14.06.05  main\20  CM-DI/ESA3-K"ohler
 * - Prototype pbDataPtr of csm_lEnqueApplTelRxData changed to const BYTE *.
 *
 * 05.07.05  main\23  CM-DI/ESA3-Zurmhl
 * - Error codes revised
 *
 * 07.10.05  main\24  CM-DI/ESA3-Battis
 * - event CSM_C_EVENT_BUS_OFF and all transitions removed
 *
 * 14.11.05  main\25  CM-DI/ESA3-Prhl
 * - "extern BYTE csm_bCsmState" added
 *
 * 17.11.05  main\26  CM-DI/ESA3-Battis
 * - function header csm_vPostInitStart() removed.
 * - function header CSM_vStackActivated() added.
 *
 * 22.11.05  main\27  CM-DI/ESA3-Battis
 * - tBusOffState introduced for multichannel busoff handling
 *
 * 03.04.06  main\28  CM-DI/ESA3-Battis
 * - error location CSM_E_ERROR_STATE_WHILE_DATA_READ added
 *
 * 02.11.06  main\29  CM-DI/ESA3-Prhl
 * - move csm_vGetItpAdrParameter() to csm_stack_m.h
 *
 * 10.11.06  main\30  CM-DI/ESA3-Prhl
 * - merge from \main\gm_ge09_vr55\3 (switch CSM_S_STATE_MASCHINE  added)
 *
 * 12.01.07  main\31  CM-DI/ESA3-Battis
 * - csm_abActBusError array instead of separate variables for bus and error
 *
 * 21.03.07  main\32  CM-DI/ERM13-Battis
 * - one feature usage switch corrected.
 *
 * 21.03.07  main\33  CM-DI/ERM13-Battis
 * - feature usage switch corrected.
 *
 * 22.03.07  main\34  VTeam-Battis
 * - old OPEL feature switch removed
 *
 * 15.05.07  main\35  CM-DI/VTeam-Prhl
 * - spaces after # deleted
 *
 * 26.05.07  main\36  CM-DI/VTeam-Prhl
 * - error indication handling added.
 *
 * 05.07.07  main\37  CM-DI/VTeam-Battis
 * - code cleaned up
 *
 * 24.01.08  main\38  VTeam-Zurmhl
 * - module history comment block enhanced (doxygen \ingroup tag)
 *
 * 25.02.08  main\39  VTeam-Funke
 * - added csm_abActBusError and csm_lActStaticError
 *
 * 26.02.08  main\40  VTeam-Funke
 * - removed the last changes.
 *
 * 17.07.09  main\41  Prhl
 * - CSM_vLocalCtrlProcessCommunicationCon(), CSM_vLocalCtrlProcessCommunicationInd() and CSM_vLocalCtrlProcessCommunicationReq() removed.
 *
 * 22.09.09  main\42  VTeam-Franke
 * - new feature: CSM_C_ACTIVATE/DEACTIVATE_COMMUNICATION_REQUESTS
 *
 * 21.05.10  main\43  VTeam-Franke
 * - csm_fIgnoreCommReq definition moved to csm_lctr.c
 *
 * 22.10.10  main\44  VTeam-Pistoor
 * - new feature: CSM_C_DOWN_REASON_CSM_POST_INIT_START
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
